/*
 * Decompiled with CFR 0.152.
 */
package data;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Hashtable;

public class LocalizationSupport {
    private static final String _MESSAGES_BUNDLE = "/data/messages.properties";
    private static final String _INIT_LOCALIZATION_ERROR_MSG = "Error when initializing localization support, reason: {0}";
    private static final String _DEFAULT_STRING = "???";
    private static final String _KEY_VALUE_SEPARATORS = "=: \t\r\n\f";
    private static final String _STRICT_KEY_VALUE_SEPARTORS = "=:";
    private static final String _WHITESPACE_CHARS = " \t\r\n\f";
    private static Hashtable _messageTable;
    private static String _localizationErrorMessage;

    public static boolean initLocalizationSupport() {
        return LocalizationSupport.initLocalizationSupport(System.getProperty("microedition.locale"));
    }

    public static boolean initLocalizationSupport(String string) {
        InputStream inputStream = null;
        Class<?> clazz = Runtime.getRuntime().getClass();
        try {
            if (string != null && string.length() > 1) {
                int n = _MESSAGES_BUNDLE.lastIndexOf(46);
                String string2 = _MESSAGES_BUNDLE.substring(0, n);
                String string3 = _MESSAGES_BUNDLE.substring(n);
                string = string.replace('-', '_');
                inputStream = clazz.getResourceAsStream(string2 + "_" + string + string3);
                if (inputStream == null) {
                    inputStream = clazz.getResourceAsStream(string2 + "_" + string.substring(0, 2) + string3);
                }
            }
            if (inputStream == null) {
                inputStream = clazz.getResourceAsStream(_MESSAGES_BUNDLE);
            }
            if (inputStream != null) {
                _messageTable = new Hashtable();
                LocalizationSupport._loadMessages(inputStream);
                return true;
            }
            _localizationErrorMessage = LocalizationSupport._processPattern(_INIT_LOCALIZATION_ERROR_MSG, new Object[]{"No messages found"});
        }
        catch (Exception exception) {
            _localizationErrorMessage = LocalizationSupport._processPattern(_INIT_LOCALIZATION_ERROR_MSG, new Object[]{exception.getMessage()});
        }
        return false;
    }

    public static String getErrorMessage() {
        return _localizationErrorMessage;
    }

    public static final String getMessage(String string) {
        return LocalizationSupport.getMessage(string, null);
    }

    public static final String getMessage(String string, Object[] objectArray) {
        if (_messageTable == null && !LocalizationSupport.initLocalizationSupport()) {
            return _DEFAULT_STRING;
        }
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = (String)_messageTable.get(string);
        if (string2 == null) {
            return _DEFAULT_STRING;
        }
        int n = string2.length();
        int n2 = 0;
        int n3 = -1;
        int n4 = 0;
        for (int i = 0; i < n; ++i) {
            if (string2.charAt(i) == '{' && ++n2 == 1) {
                n3 = i;
                stringBuffer.append(string2.substring(n4, i));
                n4 = i;
            }
            if (string2.charAt(i) != '}') continue;
            if (n2 == 1) {
                stringBuffer.append(LocalizationSupport._processPattern(string2.substring(n3 + 1, i), objectArray));
                n3 = -1;
                n4 = i + 1;
            }
            --n2;
        }
        if (n2 > 0) {
            stringBuffer.append(LocalizationSupport._processPattern(string2.substring(n3 + 1), objectArray));
        } else {
            stringBuffer.append(string2.substring(n4));
        }
        return stringBuffer.toString();
    }

    private static synchronized void _loadMessages(InputStream inputStream) throws IOException {
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        String string;
        while ((string = LocalizationSupport._readLine(inputStreamReader)) != null) {
            int n;
            int n2;
            char c;
            int n3;
            if (string.length() <= 0) continue;
            int n4 = string.length();
            for (n3 = 0; n3 < n4 && _WHITESPACE_CHARS.indexOf(string.charAt(n3)) != -1; ++n3) {
            }
            if (n3 == n4 || (c = string.charAt(n3)) == '#' || c == '!') continue;
            while (LocalizationSupport._continueLine(string)) {
                int n5;
                String string2 = LocalizationSupport._readLine(inputStreamReader);
                if (string2 == null) {
                    string2 = "";
                }
                String string3 = string.substring(0, n4 - 1);
                for (n5 = 0; n5 < string2.length() && _WHITESPACE_CHARS.indexOf(string2.charAt(n5)) != -1; ++n5) {
                }
                string2 = string2.substring(n5, string2.length());
                string = new String(string3 + string2);
                n4 = string.length();
            }
            for (n2 = n3; n2 < n4; ++n2) {
                char c2 = string.charAt(n2);
                if (c2 == '\\') {
                    ++n2;
                    continue;
                }
                if (_KEY_VALUE_SEPARATORS.indexOf(c2) != -1) break;
            }
            for (n = n2; n < n4 && _WHITESPACE_CHARS.indexOf(string.charAt(n)) != -1; ++n) {
            }
            if (n < n4 && _STRICT_KEY_VALUE_SEPARTORS.indexOf(string.charAt(n)) != -1) {
                ++n;
            }
            while (n < n4 && _WHITESPACE_CHARS.indexOf(string.charAt(n)) != -1) {
                ++n;
            }
            String string4 = string.substring(n3, n2);
            String string5 = n2 < n4 ? string.substring(n, n4) : "";
            string4 = LocalizationSupport._convertString(string4);
            string5 = LocalizationSupport._convertString(string5);
            _messageTable.put(string4, string5);
        }
        return;
    }

    private static String _readLine(InputStreamReader inputStreamReader) throws IOException {
        int n;
        StringBuffer stringBuffer = new StringBuffer("");
        while ((n = inputStreamReader.read()) != -1) {
            if ((char)n == '\r' || (char)n == '\n') {
                return stringBuffer.toString();
            }
            stringBuffer.append((char)n);
        }
        return stringBuffer.length() > 0 ? stringBuffer.toString() : null;
    }

    private static boolean _continueLine(String string) {
        int n = 0;
        int n2 = string.length() - 1;
        while (n2 >= 0 && string.charAt(n2--) == '\\') {
            ++n;
        }
        return n % 2 == 1;
    }

    private static String _convertString(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        int n2 = 0;
        while (n2 < n) {
            int n3;
            if ((n3 = string.charAt(n2++)) == 92) {
                if ((n3 = string.charAt(n2++)) == 117) {
                    int n4 = 0;
                    block6: for (int i = 0; i < 4; ++i) {
                        n3 = string.charAt(n2++);
                        switch (n3) {
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                n4 = (n4 << 4) + n3 - 48;
                                continue block6;
                            }
                            case 97: 
                            case 98: 
                            case 99: 
                            case 100: 
                            case 101: 
                            case 102: {
                                n4 = (n4 << 4) + 10 + n3 - 97;
                                continue block6;
                            }
                            case 65: 
                            case 66: 
                            case 67: 
                            case 68: 
                            case 69: 
                            case 70: {
                                n4 = (n4 << 4) + 10 + n3 - 65;
                                continue block6;
                            }
                            default: {
                                return _DEFAULT_STRING;
                            }
                        }
                    }
                    stringBuffer.append((char)n4);
                    continue;
                }
                if (n3 == 116) {
                    n3 = 9;
                } else if (n3 == 114) {
                    n3 = 13;
                } else if (n3 == 110) {
                    n3 = 10;
                } else if (n3 == 102) {
                    n3 = 12;
                }
                stringBuffer.append((char)n3);
                continue;
            }
            stringBuffer.append((char)n3);
        }
        return stringBuffer.toString();
    }

    private static String _processPattern(String string, Object[] objectArray) {
        try {
            int n = Integer.parseInt(string);
            if (objectArray != null && n >= 0 && n < objectArray.length && objectArray[n] != null) {
                return objectArray[n].toString();
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return _DEFAULT_STRING;
    }

    static {
        _localizationErrorMessage = null;
    }
}

