/*
 * Decompiled with CFR 0.152.
 */
package ui;

import TorrentEngine.MTBitfield;
import TorrentEngine.MTStringFormatter;
import TorrentEngine.MTTorrent;
import data.LocalizationSupport;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import ui.MTUIManager;

public class MTCanvasDownloadState
extends Canvas
implements CommandListener {
    public static final int ScreenID = 3;
    private final Font SMALL = Font.getFont((int)64, (int)0, (int)8);
    private final int borderMargin;
    private final int bottomMargin;
    private final int startTextHeight;
    private final int downloadBoxY = 3 + 5 * (this.SMALL.getHeight() + 3) + 2;
    private int downloadBoxHeight = 0;
    private int downloadBoxWidth = 0;
    private int downloadBoxX = 0;
    private int pieceBoxSize = 0;
    private int boxNumPerRow = 0;
    private int boxNumPerCol = 0;
    private int boxNum = 0;
    private int[] pixelPieceArray;
    private int[] pieceColorArray;
    private int pieceCount = 0;
    private MTUIManager uiManager = null;
    private MTTorrent torrent = null;
    private MTBitfield bitField = null;
    private String torrentname = "";
    private String size = "";
    private String downloadpercent = "";
    private Command command_Back;
    private String speed = "";
    private String conn = "";
    private String seedLeech = "";

    public MTCanvasDownloadState(String string, MTUIManager mTUIManager) {
        this.borderMargin = 5;
        this.bottomMargin = 10;
        this.startTextHeight = 3;
        this.setTitle(string);
        this.uiManager = mTUIManager;
        this.setFullScreenMode(false);
        this.command_Back = new Command(LocalizationSupport.getMessage("command_back"), 2, 0);
        this.addCommand(this.command_Back);
        this.setCommandListener(this);
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.command_Back) {
            this.uiManager.showScreen(1);
        }
    }

    public void updateDownloadPercent(double d) {
        this.downloadpercent = MTStringFormatter.getFormattedPercent(d);
        this.repaint();
    }

    public void updateDownloadSpeed(double d, double d2) {
        this.speed = LocalizationSupport.getMessage("text_down") + ": " + MTStringFormatter.getFormattedFileLength((long)d) + "/" + LocalizationSupport.getMessage("text_sec") + " " + LocalizationSupport.getMessage("text_up") + ": " + MTStringFormatter.getFormattedFileLength((long)d2) + "/" + LocalizationSupport.getMessage("text_sec");
        this.repaint();
    }

    public void updateConnections(int n, int n2) {
        this.conn = "" + n + " (" + this.torrent.getAllPeersNum() + ")" + " " + LocalizationSupport.getMessage("text_in") + ": " + n2;
        this.repaint();
    }

    public void updateSeederLeecher() {
        int n = 0;
        int n2 = 0;
        if (this.torrent != null) {
            n = this.torrent.getSeedersNumber();
            n2 = this.torrent.getLeechersNumber();
        }
        this.seedLeech = "Seeders/Leechers: " + n + "/" + n2;
    }

    public void updatePieceDownload() {
        this.calculatePieceColorArray();
        this.repaint();
    }

    public void initialize(MTTorrent mTTorrent) {
        this.torrent = mTTorrent;
        this.torrentname = this.torrent.getTorrentNameWithoutPath();
        this.size = MTStringFormatter.getFormattedFileLength(this.torrent.size());
        this.downloadpercent = MTStringFormatter.getFormattedPercent(this.torrent.getDownloadPercent());
        this.speed = LocalizationSupport.getMessage("text_down") + ": " + MTStringFormatter.getFormattedFileLength((long)mTTorrent.getAvarageBytesPerSecond()) + "/" + LocalizationSupport.getMessage("text_sec") + " " + LocalizationSupport.getMessage("text_up") + ": " + MTStringFormatter.getFormattedFileLength((long)mTTorrent.getAvarageUploadedBytesPerSecond()) + "/" + LocalizationSupport.getMessage("text_sec");
        this.conn = "" + this.torrent.getPeerWireConnectionCount() + " (" + this.torrent.getAllPeersNum() + ")" + " " + LocalizationSupport.getMessage("text_in") + ": " + this.torrent.getIncomingConnectionsNum();
        this.pieceCount = this.torrent.pieceCount();
        this.bitField = this.torrent.getBitField();
        this.initializeDownloadBox();
        this.calculatePixelPieceArray();
        this.calculatePieceColorArray();
    }

    private void initializeDownloadBox() {
        int n = 6;
        boolean bl = true;
        int n2 = this.getWidth() - 10;
        int n3 = this.getHeight() - this.downloadBoxY - 10;
        while (bl) {
            if (n2 / n > 35 || n < 12) {
                ++n;
                continue;
            }
            bl = false;
        }
        this.pieceBoxSize = n;
        this.boxNumPerRow = n2 / this.pieceBoxSize;
        this.downloadBoxWidth = this.boxNumPerRow * this.pieceBoxSize + 1;
        this.boxNumPerCol = n3 / this.pieceBoxSize;
        this.downloadBoxHeight = this.boxNumPerCol * this.pieceBoxSize + 1;
        this.boxNum = this.boxNumPerCol * this.boxNumPerRow;
        this.downloadBoxX = this.getWidth() / 2 - this.downloadBoxWidth / 2;
    }

    private void calculatePixelPieceArray() {
        int n;
        this.pixelPieceArray = null;
        this.pieceColorArray = null;
        this.pixelPieceArray = new int[this.boxNum];
        this.pieceColorArray = new int[this.boxNum];
        for (n = 0; n < this.boxNum; ++n) {
            this.pieceColorArray[n] = -1;
        }
        int n2 = 0;
        if (this.pieceCount <= this.boxNum) {
            int n3 = 0;
            for (n = 0; n < this.boxNum; ++n) {
                if ((n2 += this.pieceCount) > this.boxNum) {
                    n2 -= this.boxNum;
                }
                this.pixelPieceArray[n] = ++n3;
            }
        } else {
            for (n = 0; n < this.boxNum; ++n) {
                this.pixelPieceArray[n] = ((n + 1) * this.pieceCount - n2) / this.boxNum;
                n2 += this.boxNum * this.pixelPieceArray[n];
            }
        }
    }

    private void calculatePieceColorArray() {
        int n;
        for (n = 0; n < this.boxNum; ++n) {
            this.pieceColorArray[n] = -1;
        }
        if (this.pieceCount <= this.boxNum) {
            for (n = 0; n < this.pieceCount; ++n) {
                if (!this.bitField.isBitSet(n)) continue;
                for (int i = 0; i < this.boxNum; ++i) {
                    if (this.pixelPieceArray[i] != n) continue;
                    this.pieceColorArray[i] = 1000;
                }
            }
        } else {
            n = 0;
            int n2 = 0;
            int n3 = 0;
            boolean bl = true;
            for (int i = 0; i < this.boxNum; ++i) {
                bl = true;
                n2 = 195 / this.pixelPieceArray[i];
                n3 = 255;
                for (int j = 0; j < this.pixelPieceArray[i]; ++j) {
                    if (this.bitField.isBitSet(n + j)) {
                        this.pieceColorArray[i] = n3;
                        n3 -= n2;
                    }
                    bl = bl && this.bitField.isBitSet(n + j);
                }
                if (bl) {
                    this.pieceColorArray[i] = 1000;
                }
                n += this.pixelPieceArray[i];
            }
        }
    }

    public void paint(Graphics graphics) {
        graphics.setFont(this.SMALL);
        graphics.setColor(14090224);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        graphics.setColor(0x333333);
        graphics.drawString(LocalizationSupport.getMessage("label_size") + " " + this.size, 5, 3, 20);
        if (this.torrent.isEndGame()) {
            graphics.drawString(LocalizationSupport.getMessage("label_downloadpercent") + " " + this.downloadpercent + " - eg     ", 5, 3 + this.SMALL.getHeight() + 3, 20);
        } else {
            graphics.drawString(LocalizationSupport.getMessage("label_downloadpercent") + " " + this.downloadpercent + "     ", 5, 3 + this.SMALL.getHeight() + 3, 20);
        }
        graphics.drawString(this.speed, 5, 3 + 2 * (this.SMALL.getHeight() + 3), 20);
        graphics.drawString(LocalizationSupport.getMessage("label_activeconnections") + " " + this.conn, 5, 3 + 3 * (this.SMALL.getHeight() + 3), 20);
        this.updateSeederLeecher();
        graphics.drawString(this.seedLeech, 5, 3 + 4 * (this.SMALL.getHeight() + 3), 20);
        graphics.setColor(0, 0, 0);
        graphics.drawRect(this.downloadBoxX, this.downloadBoxY, this.downloadBoxWidth, this.downloadBoxHeight);
        for (int i = 0; i < this.boxNum; ++i) {
            if (this.pieceColorArray[i] < 0) continue;
            if (this.pieceColorArray[i] > 255) {
                graphics.setColor(0, 180, 0);
            } else {
                graphics.setColor(this.pieceColorArray[i], 0, 0);
            }
            int n = this.downloadBoxX + 1 + i % this.boxNumPerRow * this.pieceBoxSize;
            int n2 = this.downloadBoxY + 1 + i / this.boxNumPerRow * this.pieceBoxSize;
            graphics.fillRect(n, n2, this.pieceBoxSize, this.pieceBoxSize);
        }
    }
}

