/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.List;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.midlet.MIDlet;

public class PipeworksCanvas
extends Canvas
implements CommandListener,
Runnable {
    public static final short FLOW_SCORE = 40;
    public static final short CROSS_FLOW_SCORE = 100;
    public static final short REPLACE_SCORE = -50;
    public static final byte LEVEL_X_ON_BANNER = 70;
    public static final byte LEVEL_Y_ON_BANNER = 9;
    public static final byte SCORE_X = 90;
    public static final byte SCORE_Y = 15;
    public static final int REMAINING_PIPE_X = 183;
    public static final byte REMAINING_PIPE_Y = 15;
    public static final byte WHEEL_OFFSET_X = 1;
    public static final byte WHEEL_OFFSET_Y = 3;
    public static final byte WATER_GAUGE_X = 4;
    public static final short WATER_GAUGE_Y = 238;
    public static final byte WATER_GAUGE_WIDTH = 44;
    public static final byte WATER_GAUGE_HEIGHT = 52;
    public static final byte PREVIEW_PIPES_X = 13;
    public static final byte PREVIEW_PIPES_Y = 7;
    public static final byte PREVIEW_PIPES_PAD = 10;
    public static final byte PREVIEW_PIPES_SCROLL_SPEED = 4;
    public static final byte NEW_NEXT_PIPE_OFFSET_Y = -3;
    public static final byte NEXT_PIPE_X = 13;
    public static final short NEXT_PIPE_Y = 156;
    public static final byte NEXT_PIPE_FLY_SPEED = 4;
    public static final byte READYING = 0;
    public static final byte PLAYING = 1;
    public static final byte GAMEOVER = 2;
    public static final byte LEVELCOMPLETED = 3;
    public static final byte PAUSE = 4;
    public static final byte DOWNLEFT = 0;
    public static final byte DOWNRIGHT = 1;
    public static final byte LEFTRIGHT = 2;
    public static final byte LEFTRIGHT_SLOW = 3;
    public static final byte UPDOWN = 4;
    public static final byte UPDOWN_SLOW = 5;
    public static final byte CROSS = 6;
    public static final byte UPLEFT = 7;
    public static final byte UPRIGHT = 8;
    public static final byte START = 9;
    public static final byte END = 10;
    public static final byte EMPTY = 11;
    public static final byte NUM_TILES = 10;
    public static final byte NUM_PIPES = 11;
    public static final byte CELL_WIDTH = 24;
    public static final byte CELL_HEIGHT = 24;
    public static final byte HALF_CELL_WIDTH = 12;
    public static final byte HALF_CELL_HEIGHT = 12;
    public static final byte NUM_PREVIEW_PIPES = 4;
    public static final byte GUY_PANEL_X = 14;
    public static final short GUY_PANEL_Y = 202;
    public static final int GUY_TIME_TO_SLEEP = 10000;
    public static final byte GUY_IDLE_1 = 0;
    public static final byte GUY_IDLE_2 = 1;
    public static final byte GUY_SLEEP = 2;
    public static final byte GUY_WIN = 3;
    public static final byte GUY_LOSE = 4;
    public static final byte[][] GUY_FRAMES = new byte[][]{{0, 1}, {6, 7}, {8, 9}, {2, 3}, {4, 5}};
    public byte curGuyFramesIndex;
    public static final short BITMAP_CHAR_WIDTH = 14;
    public static final short BITMAP_CHAR_HEIGHT = 14;
    public static final short BITMAP_CHAR_FIRST_INDEX = 43;
    public static final short BITMAP_CHAR_LAST_INDEX = 57;
    public static final short NUM0_BITMAP_INDEX = 0;
    public static final short PLUS_BITMAP_INDEX = 11;
    public static final short MINUS_BITMAP_INDEX = 10;
    private DeviceImage[] charImages;
    public static boolean vibrateON = false;
    public static boolean vibrateEnabled = false;
    public static boolean soundEnabled = true;
    public static boolean musicEnabled = false;
    public final byte numCellsX = (byte)8;
    public final byte numCellsY = (byte)8;
    private short canvasWidth;
    private short canvasHeight;
    private short viewWidth;
    private short viewHeight;
    private short halfViewWidth;
    private short halfViewHeight;
    private short viewStartX;
    private short viewStartY;
    private short boardWidth;
    private short boardHeight;
    private short boardStartX;
    private short boardStartY;
    private short boardEndX;
    private short boardEndY;
    private short hudEndX;
    private short hudStartY;
    private short hudWidth;
    private short hudHeight;
    private short sidePanelX;
    private short sidePanelY;
    private Random rand = new Random();
    private Font messageFont;
    private DeviceImage[] pipeImages;
    private DeviceImage[] tileImages;
    private Image sidePanelImage;
    private Image topPanelImage;
    private Image waterGaugeImage;
    private Image levelBannerImage;
    private Image goBannerImage;
    private Image levelCompleteBannerImage;
    private Image gameOverBannerImage;
    private Graphics waterGaugeImageGraphics;
    private Image boardImage;
    private Graphics boardImageGraphics;
    private DeviceSprite wheelSprite;
    private DeviceSprite guySprite;
    private DeviceSprite cursorSprite;
    private PipeworksMidlet pipeworksMidlet;
    public Command backCommand = new Command(Local.get(12), 2, 1);
    private boolean showGameMenuList = true;
    public static final byte OPEN_NONE = 0;
    public static final byte OPEN_LEFT = 1;
    public static final byte OPEN_RIGHT = 2;
    public static final byte OPEN_UP = 3;
    public static final byte OPEN_DOWN = 4;
    public static final byte[] openingMatchMap = new byte[]{0, 2, 1, 4, 3};
    public static final byte[][] pipeOpenings = new byte[][]{{1, 4}, {2, 4}, {1, 2}, {1, 2}, {3, 4}, {3, 4}, {3, 4}, {1, 3}, {2, 3}, {0, 2}, {1, 0}, {0, 0}};
    public static final byte[][] waterGaugeFillMap = new byte[][]{{4, 48, 36, 48}, {4, 47, 36, 47}, {4, 46, 36, 46}, {4, 45, 36, 45}, {4, 44, 36, 44}, {4, 43, 36, 43}, {4, 42, 36, 42}, {4, 41, 36, 41}, {4, 40, 36, 40}, {4, 39, 36, 39}, {4, 38, 36, 38}, {4, 37, 36, 37}, {4, 36, 36, 36}, {4, 35, 36, 35}, {4, 34, 36, 34}, {4, 33, 36, 33}, {4, 32, 36, 32}, {4, 31, 36, 31}, {4, 30, 36, 30}, {4, 29, 36, 29}, {4, 28, 36, 28}, {4, 27, 36, 27}, {4, 26, 36, 26}, {4, 25, 36, 25}, {4, 24, 36, 24}, {4, 23, 36, 23}, {4, 22, 36, 22}, {4, 21, 36, 21}, {4, 20, 36, 20}, {4, 19, 36, 19}, {4, 18, 36, 18}, {4, 17, 36, 17}, {4, 16, 36, 16}, {4, 15, 36, 15}, {4, 14, 36, 14}, {4, 13, 36, 13}, {4, 12, 36, 12}, {4, 11, 36, 11}, {4, 10, 36, 10}, {4, 9, 36, 9}, {4, 8, 36, 8}, {4, 7, 37, 7}, {4, 6, 43, 6}, {5, 5, 43, 5}};
    public static final byte[] waterGaugeFillStepMaps = new byte[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
    public static final byte[][][] pipeFillMaps = new byte[][][]{new byte[][]{{0, 8, 0, 15}, {1, 8, 1, 15}, {2, 10, 2, 13}, {3, 10, 3, 13}, {4, 10, 4, 13}, {16, 9, 16, 13}, {16, 9, 17, 13}, {16, 9, 18, 12}, {16, 9, 18, 11}, {16, 9, 19, 10}, {16, 9, 19, 9}, {16, 8, 19, 8}, {16, 8, 19, 7}, {16, 8, 18, 6}, {16, 8, 18, 5}, {16, 8, 17, 4}, {16, 8, 16, 4}, {15, 7, 15, 3}, {14, 7, 14, 3}, {13, 7, 13, 3}, {12, 7, 12, 4}, {12, 7, 11, 4}, {12, 7, 10, 5}, {12, 7, 9, 6}, {12, 7, 9, 7}, {12, 8, 8, 8}, {11, 9, 8, 9}, {11, 10, 8, 10}, {11, 11, 8, 11}, {11, 12, 8, 12}, {11, 13, 8, 13}, {11, 14, 8, 14}, {11, 15, 8, 15}, {12, 16, 9, 16}, {12, 17, 9, 17}, {12, 18, 9, 18}, {13, 19, 10, 19}, {13, 20, 10, 20}, {13, 21, 10, 21}, {15, 22, 8, 22}, {15, 23, 8, 23}}, new byte[][]{{23, 8, 23, 15}, {22, 8, 22, 15}, {21, 10, 21, 13}, {20, 10, 20, 13}, {19, 10, 19, 13}, {7, 9, 7, 13}, {7, 9, 6, 13}, {7, 9, 5, 12}, {7, 9, 5, 11}, {7, 9, 4, 10}, {7, 9, 4, 9}, {7, 8, 4, 8}, {7, 8, 4, 7}, {7, 8, 5, 6}, {7, 8, 5, 5}, {7, 7, 6, 4}, {7, 7, 7, 4}, {8, 7, 8, 3}, {9, 7, 9, 3}, {10, 7, 10, 3}, {11, 7, 11, 4}, {11, 7, 12, 4}, {11, 7, 13, 5}, {11, 7, 14, 6}, {11, 7, 14, 7}, {11, 8, 15, 8}, {12, 9, 15, 9}, {12, 10, 15, 10}, {12, 11, 15, 11}, {12, 12, 15, 12}, {12, 13, 15, 13}, {12, 14, 15, 14}, {12, 15, 15, 15}, {11, 16, 14, 16}, {11, 17, 14, 17}, {11, 18, 14, 18}, {10, 19, 13, 19}, {10, 20, 13, 20}, {10, 21, 13, 21}, {8, 22, 15, 22}, {8, 23, 15, 23}}, new byte[][]{{0, 8, 0, 15}, {1, 8, 1, 15}, {2, 10, 2, 13}, {3, 10, 3, 13}, {4, 10, 4, 13}, {5, 10, 5, 13}, {6, 10, 6, 13}, {7, 10, 7, 13}, {8, 10, 8, 13}, {9, 10, 9, 13}, {10, 10, 10, 13}, {11, 10, 11, 13}, {12, 10, 12, 13}, {13, 10, 13, 13}, {14, 10, 14, 13}, {15, 10, 15, 13}, {16, 10, 16, 13}, {17, 10, 17, 13}, {18, 10, 18, 13}, {19, 10, 19, 13}, {20, 10, 20, 13}, {21, 10, 21, 13}, {22, 8, 22, 15}, {23, 8, 23, 15}}, new byte[][]{{0, 8, 0, 15}, {1, 8, 1, 15}, {2, 10, 2, 13}, {3, 10, 3, 13}, {4, 10, 4, 13}, {5, 10, 5, 13}, {6, 9, 6, 14}, {7, 8, 7, 15}, {8, 8, 8, 15}, {9, 8, 9, 15}, {10, 7, 10, 16}, {11, 7, 11, 16}, {12, 7, 12, 16}, {13, 7, 13, 16}, {14, 8, 14, 15}, {15, 8, 15, 15}, {16, 8, 16, 15}, {17, 9, 17, 14}, {18, 10, 18, 13}, {19, 10, 19, 13}, {20, 10, 20, 13}, {21, 10, 21, 13}, {22, 8, 22, 15}, {23, 8, 23, 15}}, new byte[][]{{8, 0, 15, 0}, {8, 1, 15, 1}, {10, 2, 13, 2}, {10, 3, 13, 3}, {10, 4, 13, 4}, {10, 5, 13, 5}, {10, 6, 13, 6}, {10, 7, 13, 7}, {10, 8, 13, 8}, {10, 9, 13, 9}, {10, 10, 13, 10}, {10, 11, 13, 11}, {10, 12, 13, 12}, {10, 13, 13, 13}, {10, 14, 13, 14}, {10, 15, 13, 15}, {10, 16, 13, 16}, {10, 17, 13, 17}, {10, 18, 13, 18}, {10, 19, 13, 19}, {10, 20, 13, 20}, {10, 21, 13, 21}, {8, 22, 15, 22}, {8, 23, 15, 23}}, new byte[][]{{8, 0, 15, 0}, {8, 1, 15, 1}, {10, 2, 13, 2}, {10, 3, 13, 3}, {10, 4, 13, 4}, {10, 5, 13, 5}, {9, 6, 14, 6}, {8, 7, 15, 7}, {8, 8, 15, 8}, {8, 9, 15, 9}, {7, 10, 16, 10}, {7, 11, 16, 11}, {7, 12, 16, 12}, {7, 13, 16, 13}, {8, 14, 15, 14}, {8, 15, 15, 15}, {8, 16, 15, 16}, {9, 17, 14, 17}, {10, 18, 13, 18}, {10, 19, 13, 19}, {10, 20, 13, 20}, {10, 21, 13, 21}, {8, 22, 15, 22}, {8, 23, 15, 23}}, new byte[][]{{8, 0, 15, 0}, {8, 1, 15, 1}, {10, 2, 13, 2}, {10, 3, 13, 3}, {10, 4, 13, 4}, {10, 5, 13, 5}, {10, 18, 13, 18}, {10, 19, 13, 19}, {10, 20, 13, 20}, {10, 21, 13, 21}, {8, 22, 15, 22}, {8, 23, 15, 23}}, new byte[][]{{0, 8, 0, 15}, {1, 8, 1, 15}, {2, 10, 2, 13}, {3, 10, 3, 13}, {4, 10, 4, 13}, {16, 10, 16, 14}, {17, 10, 16, 14}, {18, 11, 16, 14}, {18, 12, 16, 14}, {19, 13, 16, 14}, {19, 14, 16, 14}, {19, 15, 16, 15}, {19, 16, 16, 15}, {18, 17, 16, 15}, {18, 18, 16, 15}, {17, 19, 16, 15}, {16, 19, 16, 15}, {15, 20, 15, 16}, {14, 20, 14, 16}, {13, 20, 13, 16}, {12, 19, 12, 16}, {11, 19, 12, 16}, {10, 18, 12, 16}, {9, 17, 12, 16}, {9, 16, 12, 16}, {8, 15, 12, 15}, {8, 14, 11, 14}, {8, 13, 11, 13}, {8, 12, 11, 12}, {8, 11, 11, 11}, {8, 10, 11, 10}, {8, 9, 11, 9}, {8, 8, 11, 8}, {9, 7, 12, 7}, {9, 6, 12, 6}, {9, 5, 12, 5}, {10, 4, 13, 4}, {10, 3, 13, 3}, {10, 2, 13, 2}, {8, 1, 15, 1}, {8, 0, 15, 0}}, new byte[][]{{23, 15, 23, 8}, {22, 15, 22, 8}, {21, 13, 21, 10}, {20, 13, 20, 10}, {19, 13, 19, 10}, {7, 14, 7, 10}, {7, 14, 6, 10}, {7, 14, 5, 11}, {7, 14, 5, 12}, {7, 14, 4, 13}, {7, 14, 4, 14}, {7, 15, 4, 15}, {7, 16, 4, 16}, {7, 16, 5, 17}, {7, 16, 5, 18}, {7, 16, 6, 19}, {7, 16, 7, 19}, {8, 16, 8, 20}, {9, 16, 9, 20}, {10, 16, 10, 20}, {11, 15, 11, 19}, {12, 15, 12, 19}, {12, 15, 13, 18}, {12, 15, 14, 17}, {12, 15, 14, 16}, {12, 15, 15, 15}, {12, 14, 15, 14}, {12, 13, 15, 13}, {12, 12, 15, 12}, {12, 11, 15, 11}, {12, 10, 15, 10}, {12, 9, 15, 9}, {12, 8, 15, 8}, {11, 7, 14, 7}, {11, 6, 14, 6}, {11, 5, 14, 5}, {10, 4, 13, 4}, {10, 3, 13, 3}, {10, 2, 13, 2}, {8, 1, 15, 1}, {8, 0, 15, 0}}, new byte[][]{{15, 10, 15, 12}, {16, 10, 16, 12}, {17, 10, 17, 12}, {18, 10, 18, 12}, {19, 10, 19, 12}, {20, 10, 20, 12}, {21, 8, 21, 13}, {22, 8, 22, 13}, {23, 8, 23, 13}}, new byte[][]{{15, 10, 15, 12}, {16, 10, 16, 12}, {17, 10, 17, 12}, {18, 10, 18, 12}, {19, 10, 19, 12}, {20, 10, 20, 12}, {21, 8, 21, 13}, {22, 8, 22, 13}, {23, 8, 23, 13}}};
    public static final byte[][] pipeFillStepMaps = new byte[][]{{1, 1, 1, 1, 1, 11, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 11, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 12, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 11, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 11, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1}};
    private byte[] previewPipes = new byte[4];
    private byte nextPipe;
    private byte[][] currentPipeMap;
    private boolean[][] currentFlowMap;
    public byte currentGameState;
    public int currentScore = 0;
    public int currentLevel = 0;
    private int remainingPipes;
    private int inputBuffer;
    private int previewPipesOffsetY = 0;
    private int nextPipeOffsetY = 0;
    public long curGameTime;
    public long lastEventTime = 0L;
    private FlyingPipe flyingPipe = null;
    private short selectedCellX;
    private short selectedCellY;
    public long lastSelectionBoxDrawTime;
    public long lastWheelAnimeTime;
    public long lastGuyAnimeTime;
    public long lastGuyFramesChangeTime;
    public long lastPlayerActionTime;
    public long lastBannerShownTime;
    public long lastCursorMoveTime;
    private int waterGaugeLevel;
    private int waterFlowSpeed;
    private int waterFlowDirection;
    private short curWaterCellX;
    private short curWaterCellY;
    private short startPipeCellX;
    private short startPipeCellY;
    private short endPipeCellX;
    private short endPipeCellY;
    public boolean waterGaugeFull = false;
    public int curWaterFillColour = -6908161;
    public byte[][] curWaterFillMap;
    public byte[] curWaterFillStepMap;
    public short curWaterFillX;
    public short curWaterFillY;
    public short curWaterFillIndex;
    public short curWaterFillStep;
    public byte flowDirection;
    public Vector popupStrings = new Vector();
    public Display theDisplay;
    public Command actionCommand;
    public Displayable actionDisplayable;
    public boolean doChangeDisplay = false;
    public boolean running = true;
    public byte readyingStep;
    public Image shownBannerImage;
    public int shownBannerX;
    public int shownBannerY;
    public int startPipeBoardX;
    public int startPipeBoardY;
    public int endPipeBoardX;
    public int endPipeBoardY;
    public boolean paintLevelNumber;
    private boolean hasProcessedHighScore;
    private byte colourStep = 0;
    public static final int KEY_SOFTKEY1 = -6;
    public int keyBuffer = 0;
    public int releaseBuffer;
    public static final byte NUM_SOUNDS = 5;
    public static final byte LAY_PIPE = 0;
    public static final byte COMPLETE_REQUIREMENT = 1;
    public static final byte FINISH_LEVEL = 2;
    public static final byte DIE = 3;
    public static final byte THEME = 4;
    public static String[] SOUND_NAMES = new String[]{"lay_pipe", "requirement_complete", "finish_level", "die", "pipeworks_theme"};
    public static Player[] soundPlayers = new Player[5];
    public static Player activeSoundPlayer;
    public static int curSoundIndex;

    public PipeworksCanvas(PipeworksMidlet pipeworksMidlet) throws Exception {
        this.setFullScreenMode(true);
        this.pipeworksMidlet = pipeworksMidlet;
        this.theDisplay = Display.getDisplay((MIDlet)this.pipeworksMidlet);
        this.canvasWidth = (short)this.getWidth();
        this.canvasHeight = (short)320;
        this.messageFont = Font.getFont((int)0, (int)0, (int)8);
        PipeworksSplash.helpForm.setCommandListener((CommandListener)this);
        PipeworksSplash.settingsForm.setCommandListener((CommandListener)this);
        PipeworksSplash.aboutForm.setCommandListener((CommandListener)this);
        PipeworksSplash.menuList.setCommandListener((CommandListener)this);
    }

    public void init() throws Exception {
        int n;
        Image image = Image.createImage((String)"/images/pipetiles.png");
        this.pipeImages = new DeviceImage[11];
        for (n = 0; n < 11; ++n) {
            this.pipeImages[n] = new DeviceImage(image, n, 0, 24, 24);
        }
        image = null;
        image = Image.createImage((String)"/images/bgtiles.png");
        this.tileImages = new DeviceImage[10];
        for (n = 0; n < 10; ++n) {
            this.tileImages[n] = new DeviceImage(image, n, 0, 24, 24);
        }
        image = null;
        this.wheelSprite = new DeviceSprite("wheel");
        this.sidePanelImage = Image.createImage((String)"/images/sidepanel.png");
        this.topPanelImage = Image.createImage((String)"/images/toppanel.png");
        this.levelBannerImage = Image.createImage((String)"/images/level.png");
        this.goBannerImage = Image.createImage((String)"/images/go.png");
        this.levelCompleteBannerImage = Image.createImage((String)"/images/levelcomplete.png");
        this.gameOverBannerImage = Image.createImage((String)"/images/gameover.png");
        Image image2 = Image.createImage((String)"/images/numbers.png");
        int n2 = 15;
        this.charImages = new DeviceImage[n2];
        for (int i = 0; i < 10; ++i) {
            this.charImages[5 + i] = new DeviceImage(image2, 0 + i, 0, 14, 14);
        }
        this.charImages[0] = new DeviceImage(image2, 11, 0, 14, 14);
        this.charImages[2] = new DeviceImage(image2, 10, 0, 14, 14);
        image2 = null;
        this.sidePanelX = (short)this.topPanelImage.getWidth();
        this.guySprite = new DeviceSprite("guy");
        this.guySprite.setPosition(this.sidePanelX + 14, 202);
        this.cursorSprite = new DeviceSprite("cursor");
        this.boardWidth = (short)192;
        this.boardHeight = (short)192;
        this.hudWidth = this.boardWidth;
        this.hudHeight = (short)this.messageFont.getHeight();
        this.viewWidth = this.sidePanelX;
        this.viewHeight = (short)(this.sidePanelImage.getHeight() - this.topPanelImage.getHeight());
        if (this.viewWidth > this.boardWidth) {
            this.viewStartX = (short)((this.viewWidth - this.boardWidth) / 2);
            this.viewWidth = this.boardWidth;
        } else {
            this.viewStartX = 0;
        }
        if (this.viewHeight > this.boardHeight) {
            this.viewStartY = (short)((this.viewHeight - this.boardHeight) / 2 + this.topPanelImage.getHeight());
            this.viewHeight = this.boardHeight;
        } else {
            this.viewStartY = (short)this.topPanelImage.getHeight();
        }
        this.halfViewWidth = (short)(this.viewWidth / 2);
        this.halfViewHeight = (short)(this.viewHeight / 2);
        this.hudEndX = (short)(this.viewStartX + this.hudWidth);
        this.hudStartY = (short)(this.viewStartY + this.viewHeight);
        this.boardImage = Image.createImage((int)this.boardWidth, (int)this.boardHeight);
        this.boardImageGraphics = this.boardImage.getGraphics();
        this.waterGaugeImage = Image.createImage((int)44, (int)52);
        this.waterGaugeImageGraphics = this.waterGaugeImage.getGraphics();
        this.currentPipeMap = new byte[8][8];
        this.currentFlowMap = new boolean[8][8];
        this.resetGame();
        this.showGameMenuList = true;
    }

    public void addScore(int n, int n2, int n3) {
        this.currentScore += n;
        String string = "";
        if (n > 0) {
            string = "+";
        }
        string = string + n;
        this.popupStrings.addElement(new PopupString(string, n2, n3));
    }

    public void drawBitmapString(Graphics graphics, String string, int n, int n2) {
        int n3 = string.length();
        int n4 = 0;
        int n5 = n;
        for (int i = 0; i < n3; ++i) {
            DeviceImage deviceImage = this.charImages[string.charAt(n4) - 43];
            if (deviceImage != null) {
                this.charImages[string.charAt(n4) - 43].drawImage(graphics, n5, n2);
            }
            n5 += 14;
            ++n4;
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        this.actionCommand = command;
        this.actionDisplayable = displayable;
    }

    public void processCommandAction(Command command, Displayable displayable) {
        if (command == PipeworksSplash.backCommand) {
            Display.getDisplay((MIDlet)this.pipeworksMidlet).setCurrent((Displayable)PipeworksSplash.menuList);
        } else if (command == this.backCommand) {
            this.theDisplay.setCurrent((Displayable)this);
            this.lastEventTime = this.curGameTime;
        } else if (command == PipeworksSplash.saveSettingsCommand) {
            PipeworksSplash.saveSettings();
            Display.getDisplay((MIDlet)this.pipeworksMidlet).setCurrent((Displayable)PipeworksSplash.menuList);
        }
        if (command == List.SELECT_COMMAND) {
            String string = PipeworksSplash.menuList.getString(PipeworksSplash.menuList.getSelectedIndex());
            if (string.equals(Local.get(7))) {
                PipeworksMidlet.quit();
            } else if (string.equals(Local.get(1))) {
                Display.getDisplay((MIDlet)this.pipeworksMidlet).setCurrent((Displayable)this);
                this.currentScore = 0;
                this.currentLevel = 0;
                this.resetGame();
            } else if (string.equals(Local.get(2))) {
                PipeworksMidlet.highScore.displayHighScore((byte)0, (Displayable)PipeworksSplash.menuList);
            } else if (string.equals(Local.get(3))) {
                PipeworksMidlet.highScore.displayHighScore((byte)1, (Displayable)PipeworksSplash.menuList);
            } else if (string.equals(Local.get(5))) {
                Display.getDisplay((MIDlet)this.pipeworksMidlet).setCurrent((Displayable)PipeworksSplash.helpForm);
            } else if (string.equals(Local.get(4))) {
                Display.getDisplay((MIDlet)this.pipeworksMidlet).setCurrent((Displayable)PipeworksSplash.settingsForm);
            } else if (string.equals(Local.get(6))) {
                Display.getDisplay((MIDlet)this.pipeworksMidlet).setCurrent((Displayable)PipeworksSplash.aboutForm);
            }
        }
    }

    public void showNotify() {
        this.inputBuffer = -1;
        this.doChangeDisplay = false;
        this.lastEventTime = this.curGameTime;
    }

    public void hideNotify() {
        this.inputBuffer = -1;
        if (!this.doChangeDisplay) {
            Display.getDisplay((MIDlet)this.pipeworksMidlet).setCurrent((Displayable)PipeworksSplash.menuList);
            this.inputBuffer = -1;
        }
        this.doChangeDisplay = false;
    }

    public short boardToScreenX(int n) {
        return (short)(n + this.viewStartX + this.boardStartX);
    }

    public short boardToScreenY(int n) {
        return (short)(n + this.viewStartY + this.boardStartY);
    }

    public void resetGame() {
        int n;
        int n2;
        PipeworksSplash.menuList.addCommand(this.backCommand);
        this.curGameTime = 0L;
        this.lastSelectionBoxDrawTime = 0L;
        this.lastWheelAnimeTime = 0L;
        this.lastGuyAnimeTime = 0L;
        this.lastGuyFramesChangeTime = 0L;
        this.lastPlayerActionTime = 0L;
        this.lastBannerShownTime = 0L;
        this.lastCursorMoveTime = 0L;
        this.lastSelectionBoxDrawTime = 0L;
        this.popupStrings.removeAllElements();
        for (n2 = 0; n2 < 8; n2 = (int)((byte)(n2 + 1))) {
            for (n = 0; n < 8; n = (int)((byte)(n + 1))) {
                this.currentPipeMap[n2][n] = 11;
                this.currentFlowMap[n2][n] = false;
            }
        }
        this.startPipeCellX = (short)3;
        this.startPipeCellY = (short)3;
        this.curWaterCellX = this.startPipeCellX;
        this.curWaterCellY = this.startPipeCellY;
        this.currentPipeMap[this.curWaterCellX][this.curWaterCellY] = 9;
        this.currentFlowMap[this.curWaterCellX][this.curWaterCellY] = true;
        do {
            this.endPipeCellX = (short)(1 + Math.abs(this.rand.nextInt()) % 7);
            this.endPipeCellY = (short)(Math.abs(this.rand.nextInt()) % 8);
        } while (this.endPipeCellX == this.curWaterCellX && this.endPipeCellY == this.curWaterCellY || this.endPipeCellX == this.curWaterCellX + 1 && this.endPipeCellY == this.curWaterCellY || this.endPipeCellX == this.curWaterCellX + 2 && this.endPipeCellY == this.curWaterCellY);
        this.currentPipeMap[this.endPipeCellX][this.endPipeCellY] = 10;
        this.currentFlowMap[this.endPipeCellX][this.endPipeCellY] = true;
        this.wheelSprite.setPosition(this.curWaterCellX * 24 + 1, this.curWaterCellY * 24 + 3);
        for (n2 = 0; n2 < 4; n2 = (int)((byte)(n2 + 1))) {
            this.getFirstPreviewPipe();
        }
        this.nextPipe = this.getFirstPreviewPipe();
        this.remainingPipes = 5 + this.currentLevel * 2;
        if (this.remainingPipes > 62) {
            this.remainingPipes = 62;
        }
        this.waterFlowSpeed = 360 - this.currentLevel * 30;
        if (this.waterFlowSpeed < 30) {
            this.waterFlowSpeed = 30;
        }
        this.waterFlowDirection = 5;
        this.waterGaugeLevel = 0;
        this.inputBuffer = -1;
        this.flyingPipe = null;
        this.waterGaugeFull = false;
        this.curWaterFillMap = waterGaugeFillMap;
        this.curWaterFillStepMap = waterGaugeFillStepMaps;
        this.curWaterFillX = (short)4;
        this.curWaterFillY = (short)238;
        this.curWaterFillIndex = 0;
        this.flowDirection = pipeOpenings[9][1];
        this.waterGaugeImageGraphics.drawImage(this.sidePanelImage, -4, -238, 20);
        this.selectedCellX = this.endPipeCellX;
        this.selectedCellY = this.endPipeCellY;
        this.cursorSprite.setPosition(this.selectedCellX * 24, this.selectedCellY * 24);
        this.boardStartX = (short)(this.halfViewWidth - this.cursorSprite.getX() - 12);
        if (this.boardStartX > 0) {
            this.boardStartX = 0;
        } else if (this.boardStartX < this.viewWidth - this.boardWidth) {
            this.boardStartX = (short)(this.viewWidth - this.boardWidth);
        }
        this.boardStartY = (short)(this.halfViewHeight - this.cursorSprite.getY() - 12);
        if (this.boardStartY > 0) {
            this.boardStartY = 0;
        } else if (this.boardStartY < this.viewHeight - this.boardHeight) {
            this.boardStartY = (short)(this.viewHeight - this.boardHeight);
        }
        this.boardEndX = (short)(this.boardStartX + this.boardWidth);
        this.boardEndY = (short)(this.boardStartY + this.boardHeight);
        int n3 = 0;
        int n4 = 0;
        for (n2 = 0; n2 < 8; n2 = (int)((byte)(n2 + 1))) {
            n4 = 0;
            for (n = 0; n < 8; n = (int)((byte)(n + 1))) {
                this.drawBackgroundTile(this.boardImageGraphics, n2, n, n3, n4);
                if (this.currentPipeMap[n2][n] != 11) {
                    this.pipeImages[this.currentPipeMap[n2][n]].drawImage(this.boardImageGraphics, n3, n4);
                }
                n4 += 24;
            }
            n3 += 24;
        }
        this.initReadying();
        this.lastEventTime = this.curGameTime;
    }

    private void drawBackgroundTile(Graphics graphics, int n, int n2, int n3, int n4) {
        if (n % 2 == 0) {
            this.tileImages[this.currentLevel * 2 % 10 + n2 % 2].drawImage(this.boardImageGraphics, n3, n4);
        } else {
            this.tileImages[this.currentLevel * 2 % 10 + (n2 + 1) % 2].drawImage(this.boardImageGraphics, n3, n4);
        }
    }

    public byte getFirstPreviewPipe() {
        int n;
        byte by = this.previewPipes[0];
        for (n = 1; n < 4; n = (int)((byte)(n + 1))) {
            this.previewPipes[n - 1] = this.previewPipes[n];
        }
        this.previewPipes[3] = (byte)(Math.abs(this.rand.nextInt()) % 9);
        n = -136;
        this.previewPipesOffsetY -= 34;
        if (this.previewPipesOffsetY < n) {
            this.previewPipesOffsetY = n;
        }
        return by;
    }

    public void run() {
        try {
            this.init();
            this.theDisplay.setCurrent((Displayable)this);
            while (this.running) {
                long l = System.currentTimeMillis();
                this.tick();
                long l2 = System.currentTimeMillis() - l;
                if (l2 >= 50L) continue;
                try {
                    Thread.sleep(50L - l2);
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void tick() {
        if (this.actionCommand != null) {
            this.processCommandAction(this.actionCommand, this.actionDisplayable);
            this.actionCommand = null;
            this.actionDisplayable = null;
            return;
        }
        if (!this.isShown()) {
            return;
        }
        this.curGameTime += 50L;
        switch (this.currentGameState) {
            case 0: {
                this.tickReadying();
                break;
            }
            case 1: {
                this.tickPlaying();
                break;
            }
            case 3: {
                this.tickLevelComplete();
                break;
            }
            case 2: {
                this.tickGameOver();
            }
        }
    }

    public void initReadying() {
        this.readyingStep = 0;
        this.shownBannerImage = null;
        this.paintLevelNumber = false;
        if (this.currentLevel == 0) {
            this.curGuyFramesIndex = 0;
            this.guySprite.setFrameSequence(GUY_FRAMES[0]);
        }
        this.startPipeBoardX = (short)(this.halfViewWidth - this.startPipeCellX * 24 - 12);
        if (this.startPipeBoardX > 0) {
            this.startPipeBoardX = 0;
        } else if (this.startPipeBoardX < this.viewWidth - this.boardWidth) {
            this.startPipeBoardX = (short)(this.viewWidth - this.boardWidth);
        }
        this.startPipeBoardY = (short)(this.halfViewHeight - this.startPipeCellY * 24 - 12);
        if (this.startPipeBoardY > 0) {
            this.startPipeBoardY = 0;
        } else if (this.startPipeBoardY < this.viewHeight - this.boardHeight) {
            this.startPipeBoardY = (short)(this.viewHeight - this.boardHeight);
        }
        this.currentGameState = 0;
        this.lastBannerShownTime = this.curGameTime;
    }

    public void tickReadying() {
        this.tickGuy();
        if (this.curGameTime - this.lastSelectionBoxDrawTime >= 300L) {
            this.cursorSprite.nextFrame();
            this.lastSelectionBoxDrawTime = this.curGameTime;
        }
        switch (this.readyingStep) {
            case 0: {
                if (this.curGameTime - this.lastBannerShownTime < 800L) break;
                this.selectedCellX = this.startPipeCellX;
                this.selectedCellY = this.startPipeCellY;
                this.cursorSprite.setPosition(this.startPipeCellX * 24, this.startPipeCellY * 24);
                this.readyingStep = (byte)(this.readyingStep + 1);
                this.lastBannerShownTime = this.curGameTime;
                break;
            }
            case 1: {
                this.tickCamera();
                if (this.boardStartX != this.startPipeBoardX || this.boardStartY != this.startPipeBoardY) break;
                this.shownBannerImage = this.levelBannerImage;
                this.shownBannerX = this.viewStartX + (this.viewWidth - this.shownBannerImage.getWidth()) / 2;
                this.shownBannerY = (this.canvasHeight - this.shownBannerImage.getHeight()) / 2;
                this.paintLevelNumber = true;
                this.readyingStep = (byte)(this.readyingStep + 1);
                this.lastBannerShownTime = this.curGameTime;
                break;
            }
            default: {
                if (this.curGameTime - this.lastBannerShownTime < 1000L) break;
                if (this.readyingStep == 2) {
                    this.shownBannerImage = this.goBannerImage;
                    this.shownBannerX = this.viewStartX + (this.viewWidth - this.shownBannerImage.getWidth()) / 2;
                    this.shownBannerY = (this.canvasHeight - this.shownBannerImage.getHeight()) / 2;
                    this.paintLevelNumber = false;
                } else {
                    this.shownBannerImage = null;
                    this.curGuyFramesIndex = 0;
                    this.guySprite.setFrameSequence(GUY_FRAMES[0]);
                    this.currentGameState = 1;
                }
                this.readyingStep = (byte)(this.readyingStep + 1);
                this.lastBannerShownTime = this.curGameTime;
            }
        }
        this.repaint();
        this.serviceRepaints();
    }

    public void initGameOver() {
        PipeworksSplash.menuList.removeCommand(this.backCommand);
        this.curGuyFramesIndex = (byte)4;
        this.guySprite.setFrameSequence(GUY_FRAMES[4]);
        this.currentGameState = (byte)2;
        this.hasProcessedHighScore = false;
        this.shownBannerImage = this.gameOverBannerImage;
        this.shownBannerX = this.viewStartX + (this.viewWidth - this.shownBannerImage.getWidth()) / 2;
        this.shownBannerY = (this.canvasHeight - this.shownBannerImage.getHeight()) / 2;
        PipeworksCanvas.playTone(3, 1);
        this.vibrate(200);
        this.inputBuffer = -1;
        this.lastEventTime = this.curGameTime;
    }

    public void tickGameOver() {
        this.tickGuy();
        if (this.inputBuffer != -1 || this.curGameTime - this.lastEventTime >= 2000L) {
            this.inputBuffer = -1;
            if (!this.hasProcessedHighScore) {
                this.hasProcessedHighScore = true;
                this.doChangeDisplay = true;
                if (!PipeworksMidlet.highScore.processNewScore(this.currentScore, (Displayable)PipeworksSplash.menuList)) {
                    this.theDisplay.setCurrent((Displayable)PipeworksSplash.menuList);
                    return;
                }
            } else {
                this.doChangeDisplay = true;
                this.theDisplay.setCurrent((Displayable)PipeworksSplash.menuList);
                return;
            }
        }
        this.repaint();
        this.serviceRepaints();
    }

    public void initLevelComplete() {
        this.currentGameState = (byte)3;
        this.curGuyFramesIndex = (byte)3;
        this.guySprite.setFrameSequence(GUY_FRAMES[3]);
        this.shownBannerImage = this.levelCompleteBannerImage;
        this.shownBannerX = this.viewStartX + (this.viewWidth - this.shownBannerImage.getWidth()) / 2;
        this.shownBannerY = (this.canvasHeight - this.shownBannerImage.getHeight()) / 2;
        PipeworksCanvas.playTone(2, 1);
        this.lastEventTime = this.curGameTime;
    }

    public void tickLevelComplete() {
        this.tickGuy();
        if (this.curGameTime - this.lastEventTime > 2000L) {
            ++this.currentLevel;
            this.resetGame();
            return;
        }
        this.repaint();
        this.serviceRepaints();
    }

    public void updateWaterFillColour() {
        switch (this.colourStep) {
            case 0: {
                this.curWaterFillColour -= -16777211;
                this.curWaterFillColour += -16775936;
                if ((this.curWaterFillColour & 0xFF00FF00) != -16711936) break;
                this.colourStep = 1;
                break;
            }
            case 1: {
                this.curWaterFillColour -= -16775936;
                this.curWaterFillColour += -16777211;
                if ((this.curWaterFillColour & 0xFF0000FF) != -16776961) break;
                this.colourStep = 0;
            }
        }
    }

    public void tickPlaying() {
        if (this.inputBuffer == -6) {
            this.doChangeDisplay = true;
            Display.getDisplay((MIDlet)this.pipeworksMidlet).setCurrent((Displayable)PipeworksSplash.menuList);
            this.inputBuffer = -1;
            return;
        }
        if (this.inputBuffer != -1) {
            this.cursorSprite.setFrame(0);
            this.lastSelectionBoxDrawTime = this.curGameTime;
            this.lastPlayerActionTime = this.curGameTime;
        } else if (this.curGameTime - this.lastSelectionBoxDrawTime >= 300L) {
            this.cursorSprite.nextFrame();
            this.lastSelectionBoxDrawTime = this.curGameTime;
        }
        this.tickGuy();
        if (this.cursorSprite.getX() % 24 == 0 && this.cursorSprite.getY() % 24 == 0) {
            switch (this.inputBuffer) {
                case 1: {
                    if (this.selectedCellY <= 0) break;
                    this.lastCursorMoveTime = this.curGameTime;
                    this.selectedCellY = (short)(this.selectedCellY - 1);
                    this.inputBuffer = -1;
                    break;
                }
                case 6: {
                    if (this.selectedCellY >= 7) break;
                    this.lastCursorMoveTime = this.curGameTime;
                    this.selectedCellY = (short)(this.selectedCellY + 1);
                    this.inputBuffer = -1;
                    break;
                }
                case 2: {
                    if (this.selectedCellX <= 0) break;
                    this.lastCursorMoveTime = this.curGameTime;
                    this.selectedCellX = (short)(this.selectedCellX - 1);
                    this.inputBuffer = -1;
                    break;
                }
                case 5: {
                    if (this.selectedCellX >= 7) break;
                    this.lastCursorMoveTime = this.curGameTime;
                    this.selectedCellX = (short)(this.selectedCellX + 1);
                    this.inputBuffer = -1;
                }
            }
            if (this.inputBuffer == 8) {
                if (!this.currentFlowMap[this.selectedCellX][this.selectedCellY] && this.flyingPipe == null) {
                    this.flyingPipe = new FlyingPipe(this.nextPipe, (short)(13 + this.sidePanelX), (short)(156 + this.sidePanelY), (short)(this.selectedCellX * 24 + this.boardStartX + this.viewStartX), (short)(this.selectedCellY * 24 + this.boardStartY + this.viewStartY), this.selectedCellX, this.selectedCellY, 1);
                    PipeworksCanvas.playTone(0, 1);
                    this.nextPipe = (byte)-1;
                }
                this.inputBuffer = -1;
            }
        }
        if (this.waterGaugeFull && this.currentPipeMap[this.curWaterCellX][this.curWaterCellY] == 9 && this.curGameTime - this.lastWheelAnimeTime >= 150L) {
            this.wheelSprite.nextFrame();
            this.wheelSprite.paint(this.boardImageGraphics, 0, 0);
            this.lastWheelAnimeTime = this.curGameTime;
        }
        if (this.inputBuffer == 9 || this.curGameTime - this.lastEventTime >= (long)this.waterFlowSpeed) {
            if (!this.moveWater()) {
                this.initGameOver();
                return;
            }
            this.updateWaterFillColour();
            this.lastEventTime = this.curGameTime;
        }
        int n = 0;
        int n2 = this.popupStrings.size();
        while (n < n2) {
            PopupString popupString = (PopupString)this.popupStrings.elementAt(n);
            popupString.tick();
            if (!popupString.isAlive()) {
                this.popupStrings.removeElement(popupString);
                --n2;
                continue;
            }
            ++n;
        }
        n = this.selectedCellX * 24;
        n2 = this.selectedCellY * 24;
        int n3 = this.cursorSprite.getX();
        int n4 = this.cursorSprite.getY();
        if (n > n3) {
            n3 += 8;
        } else if (n < n3) {
            n3 -= 8;
        }
        if (n2 > n4) {
            n4 += 8;
        } else if (n2 < n4) {
            n4 -= 8;
        }
        this.cursorSprite.setPosition(n3, n4);
        if (this.flyingPipe == null) {
            this.tickCamera();
        }
        if (this.previewPipesOffsetY < 0) {
            this.previewPipesOffsetY += 4;
            if (this.previewPipesOffsetY > 0) {
                this.previewPipesOffsetY = 0;
            }
        }
        if (this.nextPipeOffsetY < 0) {
            this.nextPipeOffsetY += 4;
            if (this.nextPipeOffsetY >= 0) {
                this.nextPipeOffsetY = 0;
            }
        }
        if (this.nextPipe == -1) {
            this.nextPipe = this.getFirstPreviewPipe();
            this.nextPipeOffsetY = -3 + this.previewPipesOffsetY;
        }
        if (this.flyingPipe != null) {
            this.flyingPipe.updatePosition();
            if (this.flyingPipe.hasReachedDest()) {
                this.drawBackgroundTile(this.boardImageGraphics, this.flyingPipe.destCellX, this.flyingPipe.destCellY, this.flyingPipe.destCellX * 24, this.flyingPipe.destCellY * 24);
                int n5 = this.flyingPipe.destCellX * 24;
                int n6 = this.flyingPipe.destCellY * 24;
                if (this.currentPipeMap[this.flyingPipe.destCellX][this.flyingPipe.destCellY] != 11) {
                    this.addScore(-50, this.boardToScreenX(n5), this.boardToScreenY(n6));
                }
                this.currentPipeMap[this.flyingPipe.destCellX][this.flyingPipe.destCellY] = this.flyingPipe.pipeType;
                this.pipeImages[this.flyingPipe.pipeType].drawImage(this.boardImageGraphics, n5, n6);
                this.flyingPipe = null;
            }
        }
        this.repaint();
        this.serviceRepaints();
    }

    public void tickCamera() {
        int n = this.selectedCellX * 24 + 12;
        int n2 = this.selectedCellY * 24 + 12;
        if (this.boardEndY > this.viewHeight && n2 + this.boardStartY > this.halfViewHeight) {
            this.boardStartY = (short)(this.boardStartY - 2);
            if (this.boardStartY <= this.viewHeight - this.boardHeight) {
                this.boardStartY = (short)(this.viewHeight - this.boardHeight);
            }
            if (n2 + this.boardStartY < this.halfViewHeight) {
                this.boardStartY = (short)(this.halfViewHeight - n2);
            }
            this.boardEndY = (short)(this.boardStartY + this.boardHeight);
        } else if (this.boardStartY < 0 && n2 + this.boardStartY < this.halfViewHeight) {
            this.boardStartY = (short)(this.boardStartY + 2);
            if (this.boardStartY > 0) {
                this.boardStartY = 0;
            }
            if (n2 + this.boardStartY > this.halfViewHeight) {
                this.boardStartY = (short)(this.halfViewHeight - n2);
            }
            this.boardEndY = (short)(this.boardStartY + this.boardHeight);
        }
        if (this.boardEndX > this.viewWidth && n + this.boardStartX > this.halfViewWidth) {
            this.boardStartX = (short)(this.boardStartX - 2);
            if (this.boardStartX <= this.viewWidth - this.boardWidth) {
                this.boardStartX = (short)(this.viewWidth - this.boardWidth);
            }
            if (n + this.boardStartX < this.halfViewWidth) {
                this.boardStartX = (short)(this.halfViewWidth - n);
            }
            this.boardEndX = (short)(this.boardStartX + this.boardWidth);
        } else if (this.boardStartX < 0 && n + this.boardStartX < this.halfViewWidth) {
            this.boardStartX = (short)(this.boardStartX + 2);
            if (this.boardStartX > 0) {
                this.boardStartX = 0;
            }
            if (n + this.boardStartX > this.halfViewWidth) {
                this.boardStartX = (short)(this.halfViewWidth - n);
            }
            this.boardEndX = (short)(this.boardStartX + this.boardWidth);
        }
    }

    public void tickGuy() {
        byte by = this.curGuyFramesIndex;
        if (this.curGuyFramesIndex != 4 && this.curGuyFramesIndex != 3) {
            if (this.curGameTime - this.lastPlayerActionTime >= 10000L) {
                by = 2;
                this.lastPlayerActionTime = this.curGameTime;
            } else if ((this.inputBuffer != -1 || this.curGuyFramesIndex == 0 || this.curGuyFramesIndex == 1) && this.curGameTime - this.lastGuyFramesChangeTime >= 5000L) {
                by = (byte)(Math.abs(this.rand.nextInt()) % 2);
                this.lastGuyFramesChangeTime = this.curGameTime;
            }
        }
        if (by != this.curGuyFramesIndex) {
            this.curGuyFramesIndex = by;
            this.guySprite.setFrameSequence(GUY_FRAMES[this.curGuyFramesIndex]);
        } else if (this.curGameTime - this.lastGuyAnimeTime >= 300L) {
            this.guySprite.nextFrame();
            this.lastGuyAnimeTime = this.curGameTime;
        }
    }

    public void paint(Graphics graphics) {
        Object object;
        int n;
        graphics.setClip(0, 0, (int)this.canvasWidth, (int)this.canvasHeight);
        graphics.setColor(0, 84, 166);
        graphics.fillRect(0, 0, (int)this.canvasWidth, (int)this.canvasHeight);
        graphics.setClip(this.viewStartX - 1, this.viewStartY - 1, this.viewWidth + 2, this.viewHeight + 2);
        graphics.drawImage(this.boardImage, this.boardStartX + this.viewStartX, this.boardStartY + this.viewStartY, 20);
        graphics.setColor(-16777216);
        graphics.drawRect(this.viewStartX - 1, this.viewStartY - 1, this.viewWidth + 1, this.viewHeight + 1);
        graphics.setClip(0, 0, (int)this.canvasWidth, (int)this.canvasHeight);
        if (this.currentGameState == 1 || this.currentGameState == 0) {
            this.cursorSprite.paint(graphics, this.boardStartX + this.viewStartX - 1, this.boardStartY + this.viewStartY - 1);
        }
        graphics.drawImage(this.sidePanelImage, (int)this.sidePanelX, (int)this.sidePanelY, 20);
        graphics.drawImage(this.topPanelImage, 0, 0, 20);
        graphics.drawImage(this.waterGaugeImage, this.sidePanelX + 4, this.sidePanelY + 238, 20);
        graphics.drawImage(PipeworksSplash.arrowImage, 20, this.canvasHeight - PipeworksSplash.arrowImage.getHeight(), 17);
        String string = "" + this.currentScore;
        this.drawBitmapString(graphics, string, 90 - 14 * string.length(), 15);
        string = "" + this.remainingPipes;
        this.drawBitmapString(graphics, string, 183 - 14 * string.length(), 15);
        this.guySprite.paint(graphics, 0, 0);
        int n2 = this.previewPipesOffsetY + 7 + this.sidePanelY;
        for (n = 3; n >= 0; --n) {
            this.pipeImages[this.previewPipes[n]].drawImage(graphics, 13 + this.sidePanelX, n2);
            n2 += 34;
        }
        this.pipeImages[this.nextPipe].drawImage(graphics, 13 + this.sidePanelX, 156 + this.sidePanelY + this.nextPipeOffsetY);
        int n3 = this.popupStrings.size();
        for (n = 0; n < n3; ++n) {
            object = (PopupString)this.popupStrings.elementAt(n);
            this.drawBitmapString(graphics, ((PopupString)object).theString, ((PopupString)object).x, ((PopupString)object).y);
        }
        if (this.flyingPipe != null) {
            this.pipeImages[this.flyingPipe.pipeType].drawImage(graphics, this.flyingPipe.getX(), this.flyingPipe.getY());
        }
        if (this.shownBannerImage != null) {
            graphics.drawImage(this.shownBannerImage, this.shownBannerX, this.shownBannerY, 20);
            if (this.paintLevelNumber) {
                object = "" + (this.currentLevel + 1);
                if (this.currentLevel + 1 < 10) {
                    object = "0" + (String)object;
                }
                this.drawBitmapString(graphics, (String)object, this.shownBannerX + 70, this.shownBannerY + 9);
            }
        }
    }

    public boolean moveWater() {
        if (this.curWaterFillStep < this.curWaterFillStepMap[this.curWaterFillIndex]) {
            this.curWaterFillStep = (short)(this.curWaterFillStep + 1);
            return true;
        }
        this.curWaterFillStep = 1;
        if (this.waterGaugeFull) {
            this.boardImageGraphics.setColor(this.curWaterFillColour);
            this.boardImageGraphics.drawLine(this.curWaterFillX + this.curWaterFillMap[this.curWaterFillIndex][0], this.curWaterFillY + this.curWaterFillMap[this.curWaterFillIndex][1], this.curWaterFillX + this.curWaterFillMap[this.curWaterFillIndex][2], this.curWaterFillY + this.curWaterFillMap[this.curWaterFillIndex][3]);
        } else {
            this.waterGaugeImageGraphics.setColor(this.curWaterFillColour);
            this.waterGaugeImageGraphics.drawLine((int)waterGaugeFillMap[this.curWaterFillIndex][0], (int)waterGaugeFillMap[this.curWaterFillIndex][1], (int)waterGaugeFillMap[this.curWaterFillIndex][2], (int)waterGaugeFillMap[this.curWaterFillIndex][3]);
        }
        this.curWaterFillIndex = (short)(this.curWaterFillIndex + 1);
        if (this.curWaterFillIndex >= this.curWaterFillMap.length) {
            if (!this.waterGaugeFull) {
                this.waterGaugeFull = true;
                int n = 9;
                this.flowDirection = (byte)2;
                this.curWaterFillMap = pipeFillMaps[n];
                this.curWaterFillStepMap = pipeFillStepMaps[n];
                this.curWaterFillX = (short)(this.curWaterCellX * 24);
                this.curWaterFillY = (short)(this.curWaterCellY * 24);
                this.curWaterFillIndex = 0;
                this.currentFlowMap[this.curWaterCellX][this.curWaterCellY] = true;
            } else {
                int n;
                block26: {
                    switch (this.flowDirection) {
                        case 3: {
                            if (this.curWaterCellY <= 0) {
                                return false;
                            }
                            this.curWaterCellY = (short)(this.curWaterCellY - 1);
                            break;
                        }
                        case 4: {
                            if (this.curWaterCellY >= 7) {
                                return false;
                            }
                            this.curWaterCellY = (short)(this.curWaterCellY + 1);
                            break;
                        }
                        case 1: {
                            if (this.curWaterCellX <= 0) {
                                return false;
                            }
                            this.curWaterCellX = (short)(this.curWaterCellX - 1);
                            break;
                        }
                        case 2: {
                            if (this.curWaterCellX >= 7) {
                                return false;
                            }
                            this.curWaterCellX = (short)(this.curWaterCellX + 1);
                        }
                    }
                    n = this.currentPipeMap[this.curWaterCellX][this.curWaterCellY];
                    while (true) {
                        if (openingMatchMap[pipeOpenings[n][0]] == this.flowDirection) {
                            this.flowDirection = pipeOpenings[n][1];
                            this.curWaterFillMap = pipeFillMaps[n];
                            this.curWaterFillStepMap = pipeFillStepMaps[n];
                            break block26;
                        }
                        if (openingMatchMap[pipeOpenings[n][1]] == this.flowDirection) {
                            this.flowDirection = pipeOpenings[n][0];
                            this.curWaterFillMap = new byte[pipeFillMaps[n].length][];
                            this.curWaterFillStepMap = new byte[pipeFillStepMaps[n].length];
                            int n2 = pipeFillMaps[n].length;
                            for (int i = 0; i < n2; ++i) {
                                this.curWaterFillMap[i] = pipeFillMaps[n][n2 - i - 1];
                                this.curWaterFillStepMap[i] = pipeFillStepMaps[n][n2 - i - 1];
                            }
                            break block26;
                        }
                        if (n != 6) break;
                        n = 2;
                    }
                    return false;
                }
                if (n == 10) {
                    if (this.remainingPipes <= 0) {
                        this.initLevelComplete();
                        return true;
                    }
                    return false;
                }
                this.curWaterFillX = (short)(this.curWaterCellX * 24);
                this.curWaterFillY = (short)(this.curWaterCellY * 24);
                this.curWaterFillIndex = 0;
                if (this.currentFlowMap[this.curWaterCellX][this.curWaterCellY]) {
                    this.addScore(100, this.boardToScreenX(this.curWaterFillX), this.boardToScreenY(this.curWaterFillY));
                } else {
                    this.addScore(40, this.boardToScreenX(this.curWaterFillX), this.boardToScreenY(this.curWaterFillY));
                }
                this.currentFlowMap[this.curWaterCellX][this.curWaterCellY] = true;
                if (this.remainingPipes > 0) {
                    --this.remainingPipes;
                    if (this.remainingPipes == 0) {
                        PipeworksCanvas.playTone(1, 1);
                    }
                }
            }
        }
        return true;
    }

    public int getGameAction(int n) {
        switch (n) {
            case -7: 
            case -6: {
                return -6;
            }
            case 48: {
                return 9;
            }
        }
        return super.getGameAction(n);
    }

    protected void keyPressed(int n) {
        if (n == 55) {
            return;
        }
        if (this.inputBuffer == -1) {
            this.inputBuffer = this.getGameAction(n);
        }
        this.keyBuffer = this.inputBuffer;
    }

    protected void keyReleased(int n) {
        this.releaseBuffer = this.getGameAction(n);
        if (this.getGameAction(n) == this.inputBuffer) {
            this.inputBuffer = -1;
        }
    }

    protected void pointerPressed(int n, int n2) {
        byte by = (byte)((n - this.boardStartX) / 24);
        byte by2 = (byte)((n2 - this.boardStartY) / 24);
        if (by < 8 && by2 < 8) {
            this.selectedCellX = by;
            this.selectedCellY = by2;
            this.inputBuffer = 8;
        }
    }

    public void vibrate(int n) {
    }

    public static void initSound() {
        for (int i = 0; i < SOUND_NAMES.length; ++i) {
            try {
                InputStream inputStream = ((Object)((Object)PipeworksMidlet.instance)).getClass().getResourceAsStream("/" + SOUND_NAMES[i] + ".mid");
                PipeworksCanvas.soundPlayers[i] = Manager.createPlayer((InputStream)inputStream, (String)"audio/midi");
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void playTone(int n, int n2) {
        PipeworksMidlet.highScore.getClass();
        try {
            if (activeSoundPlayer != null) {
                activeSoundPlayer.stop();
                activeSoundPlayer.deallocate();
                activeSoundPlayer = null;
            }
            if (n == 4 && musicEnabled || n != 4 && soundEnabled) {
                activeSoundPlayer = soundPlayers[n];
                if (n2 == 0) {
                    activeSoundPlayer.setLoopCount(-1);
                } else {
                    activeSoundPlayer.setLoopCount(n2);
                }
                activeSoundPlayer.realize();
                activeSoundPlayer.prefetch();
                activeSoundPlayer.start();
                curSoundIndex = n;
            }
        }
        catch (Exception exception) {
            SplashAnimator.retry_playing = true;
        }
    }

    public static void stopTone(int n) {
        PipeworksMidlet.highScore.getClass();
        try {
            activeSoundPlayer.stop();
            activeSoundPlayer.deallocate();
            if (activeSoundPlayer == soundPlayers[n]) {
                activeSoundPlayer = null;
                curSoundIndex = -1;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void stopAllSounds() {
        PipeworksMidlet.highScore.getClass();
        try {
            if (activeSoundPlayer != null) {
                activeSoundPlayer.stop();
                activeSoundPlayer.deallocate();
                activeSoundPlayer = null;
                curSoundIndex = -1;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        curSoundIndex = -1;
    }
}

