/*
 * Decompiled with CFR 0.152.
 */
package com.lavastorm.astrosmash;

import com.lavastorm.astrosmash.AstrosmashMidlet;
import com.lavastorm.astrosmash.BackgroundManager;
import com.lavastorm.astrosmash.Collidable;
import com.lavastorm.astrosmash.Enemy;
import com.lavastorm.astrosmash.EnemyFactory;
import com.lavastorm.astrosmash.IDeathListener;
import com.lavastorm.astrosmash.IGameWorldListener;
import com.lavastorm.astrosmash.MunitionsFactory;
import com.lavastorm.astrosmash.PerformanceMeter;
import com.lavastorm.astrosmash.SwappableEnemy;
import com.lavastorm.astrosmash.Ufo;
import java.util.Stack;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public class GameWorld
implements IDeathListener {
    public static final int AUTOFIRE_DELAY_MS = 333;
    public static final int BULLET_VELOCITY_TIME = 40;
    public static final int INITIAL_LIVES = 4;
    public static final int SHIP_HIT_SCORE = -100;
    public static final int INITIAL_LEVEL = 1;
    public static final int INITIAL_DEMO_LEVEL = 2;
    public static final int INITIAL_SCORE = 0;
    public static final int MAX_LEVEL = 6;
    private static final int SWAP_INTERVAL = 500;
    private static final int UFO_FIRE_INTERVAL = 500;
    private static final int PULSER_FALLTIME_FACTOR = 2;
    private static final int UFO_BULLET_FALLTIME_FACTOR = 2;
    private static final int[] MIN_SCORES_OF_LEVEL = new int[]{0, Integer.MIN_VALUE, 1000, 5000, 20000, 50000, 100000};
    private static final int[] MAX_NUM_ENEMIES = new int[]{0, 3, 4, 5, 6, 7, 8};
    private static final int[] ENEMY_FALLTIMES = new int[]{0, 9000, 8000, 7000, 6000, 5000, 4000};
    private static final int[] ENEMY_FALLTIME_VARIANCES = new int[]{0, 4500, 4000, 3500, 3000, 2500, 2000};
    private boolean m_bSuspendEnemies = false;
    private PerformanceMeter m_perfMeter = null;
    private int m_nScreenWidth;
    private int m_nScreenHeight;
    private Enemy m_ship = null;
    private int m_nShipMoveDistance;
    private MunitionsFactory m_munitionsFactory = null;
    private Vector m_vecFlyingEnemies = null;
    private Vector m_vecFlyingBullets = null;
    private boolean m_bAutoFire;
    private EnemyFactory m_enemyFactory = null;
    private long m_nTimeSinceLastFire;
    private Stack m_EnemiesToRecycleStack = null;
    private Stack m_BulletsToRecycleStack = null;
    private BackgroundManager m_backgroundManager = null;
    private int m_groundHeight;
    private boolean m_bGameOver = false;
    private IGameWorldListener m_gameWorldListener = null;
    private int m_nInitialLevel = 2;
    private volatile int m_nLevel;
    private volatile int m_nLives;
    private volatile int m_nScore;
    private int m_nPeakScore;

    public GameWorld(int n, int n2, IGameWorldListener iGameWorldListener) {
        if (this.m_vecFlyingEnemies == null) {
            this.m_vecFlyingEnemies = new Vector();
        }
        if (this.m_vecFlyingBullets == null) {
            this.m_vecFlyingBullets = new Vector();
        }
        this.m_nScreenWidth = n;
        this.m_nScreenHeight = n2;
        this.m_gameWorldListener = iGameWorldListener;
        if (this.m_perfMeter == null) {
            this.m_perfMeter = new PerformanceMeter();
        }
        this.m_nShipMoveDistance = 7;
        int n3 = this.m_nScreenWidth / 2;
        if (this.m_munitionsFactory == null) {
            this.m_munitionsFactory = new MunitionsFactory(-this.m_nShipMoveDistance, 40L);
        }
        this.m_bAutoFire = true;
        if (this.m_backgroundManager == null) {
            this.m_backgroundManager = new BackgroundManager(this.m_nScreenWidth, this.m_nScreenHeight, this.m_nInitialLevel, 0, 4);
        }
        this.m_groundHeight = this.m_backgroundManager.getGroundLevel();
        if (this.m_enemyFactory == null) {
            this.m_enemyFactory = new EnemyFactory(this.m_nScreenWidth, this.m_nScreenHeight, this);
        }
        this.m_ship = this.m_enemyFactory.createShip(n3, this.m_groundHeight);
        this.m_nLives = 4;
        if (this.m_EnemiesToRecycleStack == null) {
            this.m_EnemiesToRecycleStack = new Stack();
        }
        if (this.m_BulletsToRecycleStack == null) {
            this.m_BulletsToRecycleStack = new Stack();
        }
        this.m_nScore = 0;
        this.m_nPeakScore = 0;
        this.setLevel(this.m_nInitialLevel);
    }

    public void tick(long l) {
        if (!this.m_ship.getCollided() && !this.m_bGameOver) {
            this.tickBullets(l);
            this.tickEnemies(l);
            if (this.m_bAutoFire && this.m_nTimeSinceLastFire > 333L) {
                this.fireBullet();
                this.m_nTimeSinceLastFire = 0L;
            } else {
                this.m_nTimeSinceLastFire += l;
            }
            this.checkLevel();
        }
    }

    public int getPeakScore() {
        return this.m_nPeakScore;
    }

    public void handleAction(int n) {
        if (!this.m_ship.getCollided() && !this.m_bGameOver) {
            switch (n) {
                case 2: {
                    int n2 = Math.max(this.m_ship.getX() - this.m_nShipMoveDistance, 0);
                    this.m_ship.setX(n2);
                    break;
                }
                case 5: {
                    int n3 = Math.min(this.m_ship.getX() + this.m_nShipMoveDistance, this.m_nScreenWidth - this.m_ship.getWidth());
                    this.m_ship.setX(n3);
                    break;
                }
                case 1: {
                    this.m_bAutoFire = !this.m_bAutoFire;
                    break;
                }
                case 6: {
                    this.hyperSpace();
                    break;
                }
                case 9: {
                    this.fireBullet();
                    break;
                }
            }
        }
    }

    public void paint(Graphics graphics) {
        this.m_backgroundManager.paint(graphics);
        this.m_ship.paint(graphics);
        this.paintFlyingBullets(graphics);
        this.paintEnemies(graphics);
    }

    public void reset() {
        int n;
        this.m_EnemiesToRecycleStack.removeAllElements();
        this.m_BulletsToRecycleStack.removeAllElements();
        this.m_nPeakScore = 0;
        this.m_backgroundManager.setPeakScore(0);
        this.m_bAutoFire = true;
        int n2 = this.m_vecFlyingEnemies.size();
        while (n2 > 0) {
            n = n2 - 1;
            Enemy enemy = (Enemy)this.m_vecFlyingEnemies.elementAt(n);
            this.m_vecFlyingEnemies.removeElementAt(n);
            this.m_enemyFactory.putEnemy(enemy);
            n2 = this.m_vecFlyingEnemies.size();
        }
        n2 = this.m_vecFlyingBullets.size();
        while (n2 > 0) {
            n = n2 - 1;
            Collidable collidable = (Collidable)this.m_vecFlyingBullets.elementAt(n);
            this.m_vecFlyingBullets.removeElementAt(n);
            this.m_munitionsFactory.putBullet(collidable);
            n2 = this.m_vecFlyingBullets.size();
        }
        this.m_backgroundManager.setGameLevel(this.m_nLevel);
        this.m_nLives = 4;
        this.m_backgroundManager.setLives(this.m_nLives);
        this.m_nScore = 0;
        this.m_nPeakScore = 0;
        this.m_backgroundManager.setScore(this.m_nScore);
        this.m_ship.reset();
        this.m_ship.setX(this.m_nScreenWidth / 2);
        this.m_bGameOver = false;
        this.m_bSuspendEnemies = false;
        this.m_backgroundManager.setGameOverMode(this.m_bGameOver);
        this.setLevel(this.m_nInitialLevel);
    }

    public Enemy getShip() {
        return this.m_ship;
    }

    protected void drawFPS(Graphics graphics) {
        int n = this.m_perfMeter.getTimesPerSecond();
        String string = Integer.toString(n);
        graphics.setColor(0xFFFFFF);
        graphics.drawString(string + " fps", 0, 0, 20);
    }

    protected void fireBullet() {
        Collidable collidable = this.m_munitionsFactory.getBullet();
        collidable.setPosition(this.m_ship.getCenterX() - collidable.getWidth() / 2, this.m_ship.getY() - collidable.getHeight());
        this.m_vecFlyingBullets.addElement(collidable);
    }

    protected void tickBullets(long l) {
        try {
            int n = 0;
            while (n < this.m_vecFlyingBullets.size()) {
                Collidable collidable = (Collidable)this.m_vecFlyingBullets.elementAt(n);
                collidable.tick(l, this);
                int n2 = collidable.getY() + collidable.getHeight();
                if (n2 <= 0) {
                    this.sendBulletToHell(collidable);
                }
                ++n;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            arrayIndexOutOfBoundsException.printStackTrace();
        }
    }

    protected void paintFlyingBullets(Graphics graphics) {
        try {
            int n = 0;
            while (n < this.m_vecFlyingBullets.size()) {
                Collidable collidable = (Collidable)this.m_vecFlyingBullets.elementAt(n);
                collidable.paint(graphics);
                ++n;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            arrayIndexOutOfBoundsException.printStackTrace();
        }
    }

    protected void hyperSpace() {
        this.m_ship.setX(AstrosmashMidlet.getAbsRandomInt() % (this.m_nScreenWidth - this.m_ship.getWidth()));
    }

    protected void tickEnemies(long l) {
        try {
            int n = 0;
            while (n < this.m_vecFlyingEnemies.size()) {
                Enemy enemy = (Enemy)this.m_vecFlyingEnemies.elementAt(n);
                enemy.tick(l, this);
                if (enemy.getY() + enemy.getHeight() >= this.m_groundHeight || enemy.getX() + enemy.getWidth() >= this.m_nScreenWidth || enemy.getY() < 0 || enemy.getX() < 0) {
                    if (enemy.getY() + enemy.getHeight() >= this.m_groundHeight || enemy.getY() < 0) {
                        this.updateScore(enemy.getGroundScore());
                    }
                    this.m_EnemiesToRecycleStack.push(enemy);
                    if (enemy.getEnemyTypeId() == 3 || enemy.getEnemyTypeId() == 4) {
                        this.m_ship.setCollided(true);
                        this.shipDestroyed();
                        this.updateScore(-100);
                        break;
                    }
                } else {
                    if (this.m_ship.intersects(enemy)) {
                        this.shipDestroyed();
                        this.updateScore(-100);
                        break;
                    }
                    int n2 = 0;
                    while (n2 < this.m_vecFlyingBullets.size()) {
                        Collidable collidable = (Collidable)this.m_vecFlyingBullets.elementAt(n2);
                        if (collidable.intersects(enemy, 1, 2)) {
                            this.updateScore(enemy.getHitScore());
                            this.sendBulletToHell(collidable);
                            break;
                        }
                        ++n2;
                    }
                }
                ++n;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            arrayIndexOutOfBoundsException.printStackTrace();
        }
        this.sendWaitingEnemiesToFactory();
        if (!this.m_bSuspendEnemies) {
            if (this.m_vecFlyingEnemies.size() < MAX_NUM_ENEMIES[this.m_nLevel]) {
                int n;
                Enemy enemy = this.m_enemyFactory.getRandomEnemy(this.m_nLevel, this.m_nScore);
                if (enemy.getEnemyTypeId() == 6) {
                    n = AstrosmashMidlet.getAbsRandomInt() % (this.m_nScreenHeight / 3);
                    enemy.setPosition(0, n);
                } else {
                    n = AstrosmashMidlet.getAbsRandomInt() % (this.m_nScreenWidth - enemy.getWidth());
                    enemy.setPosition(n, 0);
                }
                switch (enemy.getEnemyTypeId()) {
                    case 3: 
                    case 4: {
                        n = ENEMY_FALLTIMES[this.m_nLevel];
                        enemy.setVelocity(0, this.m_nScreenHeight, n);
                        ((SwappableEnemy)enemy).setSwapInterval(500);
                        break;
                    }
                    case 5: {
                        n = ENEMY_FALLTIMES[this.m_nLevel] / 2;
                        enemy.setVelocity(0, this.m_nScreenHeight, n);
                        ((SwappableEnemy)enemy).setSwapInterval(500);
                        break;
                    }
                    case 6: {
                        n = ENEMY_FALLTIMES[this.m_nLevel] + AstrosmashMidlet.getRandomInt() % ENEMY_FALLTIME_VARIANCES[this.m_nLevel];
                        enemy.setVelocity(this.m_nScreenWidth, 0, n);
                        ((Ufo)enemy).setFireInterval(500);
                        break;
                    }
                    default: {
                        n = ENEMY_FALLTIMES[this.m_nLevel] + AstrosmashMidlet.getRandomInt() % ENEMY_FALLTIME_VARIANCES[this.m_nLevel];
                        enemy.setVelocity(0, this.m_nScreenHeight, n);
                    }
                }
                this.m_vecFlyingEnemies.addElement(enemy);
            }
        } else if (this.m_vecFlyingEnemies.size() == 0) {
            this.m_bGameOver = true;
            this.m_backgroundManager.setGameOverMode(true);
            this.m_gameWorldListener.gameIsOver();
        }
    }

    public void fireUfoBullet(int n, int n2) {
        Enemy enemy = this.m_enemyFactory.getEnemy(7);
        enemy.setPosition(n, n2);
        int n3 = ENEMY_FALLTIMES[this.m_nLevel] / 2;
        int n4 = this.m_nScreenHeight;
        int n5 = 0;
        int n6 = this.m_ship.getCenterY() - n2;
        if (n6 != 0) {
            int n7 = this.m_ship.getCenterX() - n;
            long l = 1024L * (long)n7 / (long)n6;
            n5 = (int)(l * (long)n4 / 1024L);
        }
        enemy.setVelocity(n5, n4, n3);
        this.m_vecFlyingEnemies.addElement(enemy);
    }

    protected void sendDeadEnemyToHell(Enemy enemy) {
        boolean bl = this.m_vecFlyingEnemies.removeElement(enemy);
        this.m_enemyFactory.putEnemy(enemy);
    }

    protected void paintEnemies(Graphics graphics) {
        try {
            int n = 0;
            while (n < this.m_vecFlyingEnemies.size()) {
                Enemy enemy = (Enemy)this.m_vecFlyingEnemies.elementAt(n);
                enemy.paint(graphics);
                ++n;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            arrayIndexOutOfBoundsException.printStackTrace();
        }
    }

    protected void sendBulletToHell(Collidable collidable) {
        this.m_vecFlyingBullets.removeElement(collidable);
        this.m_munitionsFactory.putBullet(collidable);
    }

    protected void shipDestroyed() {
        Collidable collidable;
        try {
            int n = 0;
            while (n < this.m_vecFlyingEnemies.size()) {
                collidable = (Enemy)this.m_vecFlyingEnemies.elementAt(n);
                this.m_EnemiesToRecycleStack.push(collidable);
                ++n;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            arrayIndexOutOfBoundsException.printStackTrace();
        }
        this.sendWaitingEnemiesToFactory();
        try {
            int n = 0;
            while (n < this.m_vecFlyingBullets.size()) {
                collidable = (Collidable)this.m_vecFlyingBullets.elementAt(n);
                this.m_BulletsToRecycleStack.push(collidable);
                ++n;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            arrayIndexOutOfBoundsException.printStackTrace();
        }
        this.m_vecFlyingBullets.removeAllElements();
        while (!this.m_BulletsToRecycleStack.empty()) {
            Collidable collidable2 = (Collidable)this.m_BulletsToRecycleStack.pop();
            this.m_munitionsFactory.putBullet(collidable2);
        }
        --this.m_nLives;
        this.m_backgroundManager.setLives(this.m_nLives);
    }

    public void doneExploding(Enemy enemy) {
        int n = enemy.getHitReaction();
        switch (n) {
            case 1: {
                if (enemy.getEnemyTypeId() != -2) {
                    this.sendDeadEnemyToHell(enemy);
                    break;
                }
                if (this.m_nLives >= 0) {
                    enemy.reset();
                    enemy.setX(this.m_nScreenWidth / 2);
                    break;
                }
                if (this.m_bGameOver) break;
                this.m_bGameOver = true;
                this.m_backgroundManager.setGameOverMode(true);
                this.m_gameWorldListener.gameIsOver();
                break;
            }
            case 2: {
                this.handleOnHitSeparate(enemy);
                break;
            }
            default: {
                this.sendDeadEnemyToHell(enemy);
            }
        }
    }

    protected void sendWaitingEnemiesToFactory() {
        while (!this.m_EnemiesToRecycleStack.empty()) {
            Enemy enemy = (Enemy)this.m_EnemiesToRecycleStack.pop();
            this.sendDeadEnemyToHell(enemy);
        }
    }

    protected void handleOnHitSeparate(Enemy enemy) {
        int n = enemy.getX();
        int n2 = enemy.getY();
        Enemy enemy2 = this.m_enemyFactory.getEnemy(2);
        int n3 = enemy2.getWidth();
        enemy2.setPosition(n + n3, n2);
        enemy2.setVelocity(this.m_nScreenHeight, this.m_nScreenHeight, ENEMY_FALLTIMES[this.m_nLevel]);
        Enemy enemy3 = this.m_enemyFactory.getEnemy(2);
        enemy3.setPosition(n, n2);
        enemy3.setVelocity(-this.m_nScreenHeight, this.m_nScreenHeight, ENEMY_FALLTIMES[this.m_nLevel]);
        this.m_vecFlyingEnemies.addElement(enemy2);
        this.m_vecFlyingEnemies.addElement(enemy3);
        this.sendDeadEnemyToHell(enemy);
    }

    protected void setLevel(int n) {
        this.m_nLevel = n;
        this.m_backgroundManager.setGameLevel(n);
    }

    protected void checkLevel() {
        boolean bl = false;
        if (this.m_nLevel < 6 && this.m_nScore >= MIN_SCORES_OF_LEVEL[this.m_nLevel + 1]) {
            while (this.m_nLevel < 6 && this.m_nScore >= MIN_SCORES_OF_LEVEL[this.m_nLevel + 1]) {
                ++this.m_nLevel;
                bl = true;
            }
        } else if (this.m_nScore < MIN_SCORES_OF_LEVEL[this.m_nLevel]) {
            while (this.m_nLevel > this.m_nInitialLevel && this.m_nScore < MIN_SCORES_OF_LEVEL[this.m_nLevel]) {
                --this.m_nLevel;
                bl = true;
            }
        }
        if (bl) {
            this.setLevel(this.m_nLevel);
        }
    }

    protected void updateScore(int n) {
        this.m_nScore += n * this.m_nLevel;
        this.m_backgroundManager.setScore(this.m_nScore);
        if (this.m_nScore > this.m_nPeakScore) {
            int n2 = this.m_nPeakScore;
            this.m_nPeakScore = this.m_nScore;
            int n3 = this.m_nPeakScore / 1000;
            int n4 = n2 / 1000;
            if (n3 > n4) {
                ++this.m_nLives;
                this.m_backgroundManager.setLives(this.m_nLives);
            }
            this.m_backgroundManager.setPeakScore(this.m_nPeakScore);
        }
    }

    public void suspendEnemies() {
        this.m_bSuspendEnemies = true;
    }
}

