/*
 * Decompiled with CFR 0.152.
 */
package com.lavastorm.astrosmash;

import com.lavastorm.astrosmash.AstrosmashScreen;
import com.lavastorm.astrosmash.AstrosmashVersion;
import com.lavastorm.astrosmash.HiScoreDisplay;
import com.lavastorm.astrosmash.InfoStrings;
import com.lavastorm.astrosmash.MenuScreen;
import com.lavastorm.astrosmash.SplashCanvas;
import com.lavastorm.astrosmash.SplashForm;
import com.lavastorm.astrosmash.StatusCanvas;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Gauge;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.Item;
import javax.microedition.midlet.MIDlet;
import javax.microedition.midlet.MIDletStateChangeException;

public class AstrosmashMidlet
extends MIDlet
implements CommandListener {
    public static final int DIVISION_GRANULARITY = 1024;
    public static final String TITLE_SPLASH = "/splash_astro0.png";
    public static final String MENU_SPLASH = "/menu.png";
    public static final String HELP2_SPLASH = "/help2.png";
    public static final String PREGAME_SPLASH = "/splash_astro1.png";
    public static final String DEMOOVER_SPLASH = "/demo_complete.png";
    public static final String MENU_ARROW_IMAGE = "/menu_arrow.png";
    public static final int GAUGE_DURATION = 1000;
    public static final int INTRO_DURATION = 1000;
    public static final int DEMO_INTRO_DURATION = 4000;
    public static final int PREGAME_SPLASH_DURATION = 2000;
    public static final int LEFT_PRIORITY = 12;
    public static final int RIGHT_PRIORITY = 1;
    private boolean m_bGameStarted = false;
    private Display m_display = null;
    private AstrosmashScreen m_astroSmashScreen = null;
    private MenuScreen m_menuScreen = null;
    private HiScoreDisplay m_hiScoreDisplay = null;
    private Displayable m_gauge = null;
    private Gauge m_loadGauge = null;
    private Form m_loadForm = null;
    private Image m_titleImage = null;
    private Image m_menuImage = null;
    private Image m_pregameImage = null;
    private Image m_demooverImage = null;
    private Image m_menuArrowImage = null;
    private Command m_exit = null;
    private Command m_quit = null;
    private Command m_quitConfirm = null;
    private Command m_quitAbort = null;
    private Command m_pause = null;
    private Command m_resume = null;
    private Command m_restart = null;
    private Command m_next = null;
    private Command m_gaugenext = null;
    private Command m_back = null;
    private Command m_select = null;
    private Command m_blank = null;
    private Command m_creditmore1 = null;
    private Command m_creditmore2 = null;
    private Command m_done = null;
    private Command m_skip = null;
    private Command m_initialize = new Command("", 2, 12);
    private Timer m_timer = null;
    private static Random m_random;
    protected StatusCanvas m_statusCanvas;
    protected Command m_command1;
    protected Command m_command2;

    public AstrosmashMidlet() {
        m_random = new Random(System.currentTimeMillis());
        this.m_statusCanvas = null;
        this.m_command1 = null;
        this.m_command2 = null;
        this.m_display = Display.getDisplay((MIDlet)this);
        InfoStrings.initializeInfo();
        this.m_gauge = this.showGauge();
        this.m_timer = new Timer();
    }

    public void startApp() {
        if (this.m_bGameStarted) {
            this.startGame(false);
        } else {
            this.scheduleCommand(this.m_initialize, this.m_gauge, 0L);
        }
    }

    public void pauseApp() {
        this.m_astroSmashScreen.pause();
    }

    public void destroyApp(boolean bl) throws MIDletStateChangeException {
        this.m_astroSmashScreen.exit();
        this.m_timer.cancel();
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.m_next) {
            if (displayable instanceof AstrosmashScreen) {
                if (AstrosmashVersion.getDemoFlag()) {
                    this.showSplash(this.m_demooverImage, null, this.m_next, false);
                } else {
                    this.showHiScores(this.m_next, this.m_blank, true, false);
                }
            } else if (AstrosmashVersion.getDemoFlag()) {
                Displayable displayable2 = this.showSplash(this.m_pregameImage, null, null, false);
                this.showMenuScreen();
            } else {
                this.m_hiScoreDisplay.readHighScores();
                this.showMenuScreen();
            }
        } else if (command == this.m_initialize) {
            this.m_loadGauge.setValue(3);
            this.createResources();
            this.setupMenuScreen();
            this.m_loadGauge.setValue(5);
            this.setupAstroSmashScreen();
            this.m_loadGauge.setValue(7);
            this.scheduleCommand(this.m_gaugenext, this.m_gauge, 1000L);
            this.m_hiScoreDisplay = new HiScoreDisplay(this.m_display, this, this.m_skip);
            this.m_loadGauge.setValue(9);
        } else if (command == this.m_gaugenext) {
            this.m_loadGauge.setValue(10);
            Displayable displayable3 = this.showSplash(this.m_titleImage, null, null, false);
            if (AstrosmashVersion.getDemoFlag()) {
                this.scheduleCommand(this.m_next, displayable3, 4000L);
            } else {
                this.scheduleCommand(this.m_next, displayable3, 1000L);
            }
        } else if (command == this.m_back) {
            this.showMenuScreen();
        } else if (command == this.m_done) {
            this.showMenuScreen();
        } else if (command == this.m_skip) {
            this.showHiScores(this.m_back, this.m_blank, false, false);
        } else if (command == this.m_creditmore1) {
            this.showTextScreen(InfoStrings.TITLE_CREDITS, InfoStrings.getCredits2(), this.m_creditmore2, this.m_blank);
        } else if (command == this.m_creditmore2) {
            this.showTextScreen(InfoStrings.TITLE_CREDITS, InfoStrings.getCredits3(), this.m_done, this.m_blank);
        } else if (command == this.m_restart) {
            this.startGame(true);
        } else if (command == this.m_exit) {
            this.m_astroSmashScreen.exit();
            try {
                this.destroyApp(true);
                this.notifyDestroyed();
            }
            catch (MIDletStateChangeException mIDletStateChangeException) {}
        } else if (command == this.m_quit) {
            this.pauseApp();
            this.displayStatus(InfoStrings.STATUS_QUESTION, this.m_quitAbort, this.m_quitConfirm);
        } else if (command == this.m_quitConfirm) {
            this.m_astroSmashScreen.removeCommand(this.m_resume);
            this.m_astroSmashScreen.exit();
            if (AstrosmashVersion.getDemoFlag()) {
                this.showSplash(this.m_demooverImage, null, this.m_next, false);
            } else {
                this.showHiScores(null, this.m_next, true, true);
            }
        } else if (command == this.m_quitAbort) {
            this.m_astroSmashScreen.removeCommand(this.m_resume);
            this.m_astroSmashScreen.addCommand(this.m_pause);
            this.startGame(false);
        } else if (command == this.m_pause) {
            this.pauseApp();
            this.m_astroSmashScreen.removeCommand(this.m_pause);
            this.m_astroSmashScreen.addCommand(this.m_resume);
        } else if (command == this.m_resume) {
            this.m_astroSmashScreen.removeCommand(this.m_resume);
            this.m_astroSmashScreen.addCommand(this.m_pause);
            this.startGame(false);
        }
    }

    public void handleMenuChoice(int n) {
        switch (n) {
            case 0: {
                Displayable displayable = this.showSplash(this.m_pregameImage, null, null, false);
                this.scheduleCommand(this.m_restart, displayable, 2000L);
                break;
            }
            case 1: {
                this.showHiScores(this.m_back, this.m_blank, false, false);
                break;
            }
            case 2: {
                this.showTextScreen(InfoStrings.TITLE_HELP, InfoStrings.getHelp(), this.m_back, this.m_blank);
                break;
            }
            case 3: {
                this.showTextScreen(InfoStrings.TITLE_CREDITS, InfoStrings.getCredits1(), this.m_creditmore1, this.m_blank);
                break;
            }
        }
    }

    protected void createResources() {
        try {
            if (this.m_titleImage == null) {
                this.m_titleImage = Image.createImage((String)TITLE_SPLASH);
            }
            if (this.m_menuImage == null) {
                this.m_menuImage = Image.createImage((String)MENU_SPLASH);
            }
            if (this.m_pregameImage == null) {
                this.m_pregameImage = Image.createImage((String)PREGAME_SPLASH);
            }
            if (this.m_demooverImage == null) {
                this.m_demooverImage = Image.createImage((String)DEMOOVER_SPLASH);
            }
            if (this.m_menuArrowImage == null) {
                this.m_menuArrowImage = Image.createImage((String)MENU_ARROW_IMAGE);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (this.m_exit == null) {
            this.m_exit = new Command(InfoStrings.EXIT_LABEL, 2, 12);
        }
        if (this.m_quit == null) {
            this.m_quit = new Command(InfoStrings.QUIT_LABEL, 1, 12);
        }
        if (this.m_quitConfirm == null) {
            this.m_quitConfirm = new Command(InfoStrings.QUIT_CONFIRM_LABEL, 1, 1);
        }
        if (this.m_quitAbort == null) {
            this.m_quitAbort = new Command(InfoStrings.QUIT_ABORT_LABEL, 1, 12);
        }
        if (this.m_pause == null) {
            this.m_pause = new Command(InfoStrings.PAUSE_LABEL, 1, 1);
        }
        if (this.m_resume == null) {
            this.m_resume = new Command(InfoStrings.RESUME_LABEL, 1, 1);
        }
        if (this.m_restart == null) {
            this.m_restart = new Command(InfoStrings.RESTART_LABEL, 1, 1);
        }
        if (this.m_gaugenext == null) {
            this.m_gaugenext = new Command(InfoStrings.BLANK_LABEL, 4, 1);
        }
        if (this.m_next == null) {
            this.m_next = new Command(InfoStrings.NEXT_LABEL, 4, 1);
        }
        if (this.m_back == null) {
            this.m_back = new Command(InfoStrings.BACK_LABEL, 2, 12);
        }
        if (this.m_select == null) {
            this.m_select = new Command(InfoStrings.SELECT_LABEL, 4, 1);
        }
        if (this.m_blank == null) {
            this.m_blank = new Command(InfoStrings.BLANK_LABEL, 1, 1);
        }
        if (this.m_creditmore1 == null) {
            this.m_creditmore1 = new Command(InfoStrings.NEXT_LABEL, 1, 1);
        }
        if (this.m_creditmore2 == null) {
            this.m_creditmore2 = new Command(InfoStrings.NEXT_LABEL, 1, 1);
        }
        if (this.m_done == null) {
            this.m_done = new Command(InfoStrings.DONE_LABEL, 1, 1);
        }
        if (this.m_skip == null) {
            this.m_skip = new Command(InfoStrings.SKIP_LABEL, 2, 12);
        }
    }

    protected void setupMenuScreen() {
        if (this.m_menuScreen == null) {
            this.m_menuScreen = new MenuScreen(this.m_menuImage, this.m_menuArrowImage, this.m_exit, this.m_select, this);
        }
    }

    protected void setupAstroSmashScreen() {
        if (this.m_astroSmashScreen == null) {
            this.m_astroSmashScreen = new AstrosmashScreen(this.m_pause, this.m_next, this.m_quit, this.m_blank);
        }
        this.m_astroSmashScreen.setCommandListener(this);
    }

    protected Displayable showSplash(Image image, Command command, Command command2, boolean bl) {
        Object object;
        if (bl) {
            object = new SplashForm(image);
        } else {
            object = new SplashCanvas(image);
            ((SplashCanvas)((Object)object)).repaint();
            ((SplashCanvas)((Object)object)).serviceRepaints();
        }
        if (command != null) {
            object.addCommand(command);
        }
        if (command2 != null) {
            object.addCommand(command2);
        }
        object.setCommandListener(this);
        this.m_display.setCurrent((Displayable)object);
        return object;
    }

    protected Displayable showGauge() {
        this.m_loadGauge = new Gauge(InfoStrings.LOADING_TEXT + "...", false, 10, 0);
        this.m_loadForm = new Form("Astrosmash");
        this.m_loadGauge.setValue(1);
        this.m_loadForm.append("\n");
        this.m_loadForm.append((Item)this.m_loadGauge);
        this.m_loadForm.setCommandListener((CommandListener)this);
        this.m_display.setCurrent((Displayable)this.m_loadForm);
        return this.m_loadForm;
    }

    protected void showTextScreen(String string, String string2, Command command, Command command2) {
        Form form = new Form(string);
        form.append(string2);
        if (command != null) {
            form.addCommand(command);
        }
        if (command2 != null) {
            form.addCommand(command2);
        }
        this.m_display.setCurrent((Displayable)form);
        form.setCommandListener((CommandListener)this);
    }

    protected void showMenuScreen() {
        this.m_display.setCurrent((Displayable)this.m_menuScreen);
        this.m_menuScreen.repaint();
        this.m_menuScreen.serviceRepaints();
    }

    protected void showHiScores(Command command, Command command2, boolean bl, boolean bl2) {
        int n = this.m_astroSmashScreen.getPeakScore();
        this.m_hiScoreDisplay.setPeakScore(n);
        this.m_hiScoreDisplay.setCommands(command, command2);
        if (bl) {
            if (!this.m_hiScoreDisplay.enterHighScore(bl2)) {
                this.showMenuScreen();
            }
        } else {
            this.m_hiScoreDisplay.showHighScores();
        }
    }

    protected void startGame(boolean bl) {
        if (bl || !this.m_bGameStarted) {
            this.m_astroSmashScreen.resetStartTime();
            this.m_astroSmashScreen.restartGame();
            if (AstrosmashVersion.getDebugFlag()) {
                AstrosmashMidlet.printMemoryUsage("AstrosmashMidlet.startGame");
            }
        }
        this.m_display.setCurrent((Displayable)this.m_astroSmashScreen);
        this.m_astroSmashScreen.setCommandListener(this);
        this.m_astroSmashScreen.start();
        this.m_bGameStarted = true;
    }

    public static void printMemoryUsage(String string) {
        Runtime runtime = Runtime.getRuntime();
        long l = runtime.freeMemory();
        long l2 = runtime.totalMemory();
        System.out.println(string + ": " + l + " free bytes out of " + l2);
    }

    protected void scheduleCommand(Command command, Displayable displayable, long l) {
        this.m_timer.schedule((TimerTask)new CommandTimerTask(command, displayable), l);
    }

    public void displayStatus(String string, Command command, Command command2) {
        int n;
        if (this.m_statusCanvas == null) {
            this.m_statusCanvas = new StatusCanvas();
        }
        if (this.m_command1 != null) {
            this.m_statusCanvas.removeCommand(this.m_command1);
        }
        if (this.m_command2 != null) {
            this.m_statusCanvas.removeCommand(this.m_command2);
        }
        this.m_command1 = command;
        if (this.m_command1 != null) {
            this.m_statusCanvas.addCommand(this.m_command1);
        }
        this.m_command2 = command2;
        if (this.m_command2 != null) {
            this.m_statusCanvas.addCommand(this.m_command2);
        }
        if ((n = string.indexOf(10)) >= 0) {
            this.m_statusCanvas.setText(string.substring(0, n), string.substring(n + 1));
        } else {
            this.m_statusCanvas.setText(string);
        }
        this.m_display.setCurrent((Displayable)this.m_statusCanvas);
        this.m_statusCanvas.setCommandListener(this);
        this.m_statusCanvas.repaint();
        this.m_statusCanvas.serviceRepaints();
    }

    public static int getRandomInt() {
        m_random.setSeed(System.currentTimeMillis() + (long)m_random.nextInt());
        return m_random.nextInt();
    }

    public static int getAbsRandomInt() {
        m_random.setSeed(System.currentTimeMillis() + (long)m_random.nextInt());
        return Math.abs(m_random.nextInt());
    }

    protected class CommandTimerTask
    extends TimerTask {
        private Command m_command;
        private Displayable m_displayable;

        public CommandTimerTask(Command command, Displayable displayable) {
            this.m_command = command;
            this.m_displayable = displayable;
        }

        public void run() {
            AstrosmashMidlet.this.commandAction(this.m_command, this.m_displayable);
        }
    }
}

