/*
 * Decompiled with CFR 0.152.
 */
package com.lavastorm.astrosmash;

import com.lavastorm.astrosmash.AstrosmashMidlet;
import com.lavastorm.astrosmash.Enemy;
import com.lavastorm.astrosmash.GunShip;
import com.lavastorm.astrosmash.IDeathListener;
import com.lavastorm.astrosmash.Pulser;
import com.lavastorm.astrosmash.SwappableEnemy;
import com.lavastorm.astrosmash.Ufo;
import java.util.Stack;
import javax.microedition.lcdui.Image;

public class EnemyFactory {
    public static final String SMALLSHIPIMAGE = "/ship_small.png";
    public static final int INITIAL_NUM_ENEMIES = 3;
    public static final int ON_HIT_DO_NOTHING = 0;
    public static final int ON_HIT_EXPLODE = 1;
    public static final int ON_HIT_SEPARATE = 2;
    private static final String[] EXPLOSION_IMAGES = new String[]{"/explode1.png", "/explode2.png"};
    public static final int SHIP_ID = -2;
    public static final int BAD_ENEMY_ID = -1;
    public static final int BIG_ORANGE_ROCK_ID = 0;
    public static final int BIG_YELLOW_ROCK_ID = 1;
    public static final int BIG_BLUE_ROCK_ID = 2;
    public static final int BIG_GREEN_ROCK_ID = 3;
    public static final int SMALL_ORANGE_ROCK_ID = 4;
    public static final int SMALL_YELLOW_ROCK_ID = 5;
    public static final int SMALL_BLUE_ROCK_ID = 6;
    public static final int SMALL_GREEN_ROCK_ID = 7;
    public static final int BIG_SPINNER_ID = 8;
    public static final int SMALL_SPINNER_ID = 9;
    public static final int PULSER_ID = 10;
    public static final int UFO_ID = 11;
    public static final int UFO_BULLET_ID = 12;
    private static final EnemyData[] ENEMIES = new EnemyData[]{new EnemyData("/rock1.png", 10, -5, 2, null, 0), new EnemyData("/rock2.png", 10, -5, 2, null, 0), new EnemyData("/rock3.png", 10, -5, 2, null, 0), new EnemyData("/rock4.png", 10, -5, 2, null, 0), new EnemyData("/rock1_s.png", 20, -10, 1, null, 0), new EnemyData("/rock2_s.png", 20, -10, 1, null, 0), new EnemyData("/rock3_s.png", 20, -10, 1, null, 0), new EnemyData("/rock4_s.png", 20, -10, 1, null, 0), new EnemyData("/satellite_updown.png", 40, -100, 1, "/satellite_flat.png", 0), new EnemyData("/smallsat_updown.png", 80, -100, 1, "/smallsat_flat.png", 0), new EnemyData("/pulser.png", 80, -50, 1, "/pulser_small.png", 0), new EnemyData("/ufo.png", 100, 0, 1, null, 3), new EnemyData("/ufo_bullet.png", 10, 0, 1, null, 0)};
    private static final int[] ENEMY_PROBABILITIES = new int[]{1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 200, 200, 300, 400, 500, 600, 200, 200, 300, 400, 500, 600, 50, 50, 80, 100, 200, 400, 0, 0, 80, 100, 200, 400, 0, 0, 0, 0, 0, 0};
    private static int[] TOTAL_ENEMY_PROBABILITIES = new int[6];
    private Stack[] m_enemyStacks;
    private Image[] m_images;
    private Image[] m_swapImages;
    private Image[] m_xplosionImages;
    private int m_screenWidth;
    private int m_screenHeight;
    private IDeathListener m_deathListener;

    public EnemyFactory(int n, int n2, IDeathListener iDeathListener) {
        this.m_screenWidth = n;
        this.m_screenHeight = n2;
        this.m_deathListener = iDeathListener;
        this.loadImages();
        this.generateEnemies();
    }

    public Enemy getRandomEnemy(int n, int n2) {
        int n3 = 1;
        int n4 = AstrosmashMidlet.getAbsRandomInt() % TOTAL_ENEMY_PROBABILITIES[n - 1];
        int n5 = 0;
        int n6 = n - 1;
        int n7 = 0;
        while (n7 < ENEMIES.length) {
            if (n4 < (n5 += ENEMY_PROBABILITIES[n6])) {
                if (EnemyFactory.ENEMIES[n7].nMinLevel != 0 && n < EnemyFactory.ENEMIES[n7].nMinLevel) break;
                n3 = n7;
                break;
            }
            n6 += 6;
            ++n7;
        }
        return this.getEnemy(n3);
    }

    public Enemy getEnemy(int n) {
        Enemy enemy = null;
        enemy = !this.m_enemyStacks[n].isEmpty() ? (Enemy)this.m_enemyStacks[n].pop() : this.createEnemy(n);
        enemy.reset();
        enemy.setPosition(0, 0);
        return enemy;
    }

    public void putEnemy(Enemy enemy) {
        int n = enemy.getEnemyTypeId();
        this.m_enemyStacks[n].push(enemy);
    }

    protected void loadImages() {
        try {
            this.m_images = new Image[ENEMIES.length];
            this.m_swapImages = new Image[ENEMIES.length];
            this.m_xplosionImages = new Image[EXPLOSION_IMAGES.length];
            int n = 0;
            while (n < ENEMIES.length) {
                this.m_images[n] = Image.createImage((String)EnemyFactory.ENEMIES[n].sImageFileName);
                this.m_swapImages[n] = null != EnemyFactory.ENEMIES[n].sSwapImageName ? Image.createImage((String)EnemyFactory.ENEMIES[n].sSwapImageName) : null;
                ++n;
            }
            int n2 = 0;
            while (n2 < EXPLOSION_IMAGES.length) {
                this.m_xplosionImages[n2] = Image.createImage((String)EXPLOSION_IMAGES[n2]);
                ++n2;
            }
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            exception.printStackTrace();
        }
    }

    protected void generateEnemies() {
        this.m_enemyStacks = new Stack[ENEMIES.length];
        int n = 0;
        while (n < ENEMIES.length) {
            this.m_enemyStacks[n] = new Stack();
            int n2 = 0;
            while (n2 < 3) {
                Enemy enemy = this.createEnemy(n);
                this.m_enemyStacks[n].push(enemy);
                ++n2;
            }
            ++n;
        }
    }

    protected Enemy createEnemy(int n) {
        Enemy enemy;
        switch (n) {
            case 8: 
            case 9: {
                enemy = new SwappableEnemy();
                ((SwappableEnemy)enemy).setSwapImage(this.m_swapImages[n]);
                break;
            }
            case 10: {
                enemy = new Pulser();
                ((Pulser)enemy).setSwapImage(this.m_swapImages[n]);
                break;
            }
            case 11: {
                enemy = new Ufo();
                break;
            }
            default: {
                enemy = new Enemy();
            }
        }
        enemy.setEnemyTypeId(n);
        enemy.setHitScore(EnemyFactory.ENEMIES[n].nHitScore);
        enemy.setGroundScore(EnemyFactory.ENEMIES[n].nGroundScore);
        enemy.setImage(this.m_images[n]);
        enemy.setHitReaction(EnemyFactory.ENEMIES[n].nHitReaction);
        enemy.setDeathListener(this.m_deathListener);
        if (1 == EnemyFactory.ENEMIES[n].nHitReaction) {
            enemy.setExplosionImages(this.m_xplosionImages);
        }
        return enemy;
    }

    public Enemy createShip(int n, int n2) {
        GunShip gunShip = null;
        try {
            Image[] imageArray = new Image[]{Image.createImage((String)"/ship_explode1.png"), Image.createImage((String)"/ship_explode2.png"), Image.createImage((String)"/ship_explode3.png")};
            Image[] imageArray2 = new Image[]{imageArray[0], imageArray[0], imageArray[0], imageArray[1], imageArray[1], imageArray[1], imageArray[2], imageArray[2], imageArray[2]};
            gunShip = new GunShip();
            Image image = Image.createImage((String)SMALLSHIPIMAGE);
            gunShip.setImage(image);
            gunShip.setPosition(n, n2 - gunShip.getHeight());
            gunShip.setEnemyTypeId(-2);
            gunShip.setHitReaction(1);
            gunShip.setDeathListener(this.m_deathListener);
            gunShip.setExplosionImages(imageArray2);
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            exception.printStackTrace();
        }
        return gunShip;
    }

    static {
        int n = 0;
        while (n < 6) {
            EnemyFactory.TOTAL_ENEMY_PROBABILITIES[n] = 0;
            int n2 = 0;
            while (n2 < ENEMIES.length) {
                int n3 = n;
                TOTAL_ENEMY_PROBABILITIES[n3] = TOTAL_ENEMY_PROBABILITIES[n3] + ENEMY_PROBABILITIES[n2 * 6 + n];
                ++n2;
            }
            ++n;
        }
    }

    static class EnemyData {
        int nId;
        String sImageFileName;
        int nHitScore;
        int nGroundScore;
        int nHitReaction;
        String sSwapImageName;
        int nMinLevel;

        EnemyData(String string, int n, int n2, int n3, String string2, int n4) {
            this.sImageFileName = string;
            this.nHitScore = n;
            this.nGroundScore = n2;
            this.nHitReaction = n3;
            this.sSwapImageName = string2;
            this.nMinLevel = n4;
        }
    }
}

