/*
 * Decompiled with CFR 0.152.
 */
package com.lavastorm.astrosmash;

import com.lavastorm.astrosmash.AstrosmashVersion;

public class InfoStrings {
    public static final int LANGUAGE_ENGLISH = 0;
    public static final int LANGUAGE_FRENCH = 1;
    public static final int LANGUAGE_CHINESE = 2;
    public static final int LANGUAGE_SPANISH = 3;
    public static final int LANGUAGE_PORTUGESE = 4;
    public static int LANGUAGE_CURRENT = 0;
    public static String TITLE_CREDITS = "";
    public static String TITLE_HELP = "";
    public static String EXIT_LABEL = "";
    public static String QUIT_LABEL = "";
    public static String QUIT_CONFIRM_LABEL = "";
    public static String QUIT_ABORT_LABEL = "";
    public static String PAUSE_LABEL = "";
    public static String RESUME_LABEL = "";
    public static String RESTART_LABEL = "";
    public static String NEXT_LABEL = "";
    public static String BACK_LABEL = "";
    public static String SELECT_LABEL = "";
    public static String DONE_LABEL = "";
    public static String BLANK_LABEL = "";
    public static String SKIP_LABEL = "";
    public static String DEL_LABEL = "";
    public static String STATUS_QUESTION = "";
    public static String GAME_PAUSED_STRING = "";
    public static String GAME_OVER_STRING = "";
    public static String PEAK_SCORE_STRING = "";
    public static String HISCORE_TITLE = "";
    public static String HISCORE_ENTRY_TITLE = "";
    public static String HISCORE_ENTRY_TEXT1_SUFFIX = "";
    public static String HISCORE_ENTRY_NAME_FIELD = "";
    public static String HISCORE_ENTRY_TEXT2 = "";
    public static String HISCORE_ENTRY_TEXT2_ERROR = "";
    public static String HISCORE_PLAYER_STRING = "";
    public static String LOADING_TEXT = "";
    public static String SPLASH_IMAGE_ERROR = "Image Cannot be shown";
    public static final String ASTROSMASH_TITLE = "Astrosmash";

    public static void initializeInfo() {
        String string = System.getProperty("microedition.locale");
        if (string.startsWith("fr")) {
            LANGUAGE_CURRENT = 1;
            InfoStrings.initializeFrench();
        } else if (string.startsWith("zh")) {
            LANGUAGE_CURRENT = 2;
            InfoStrings.initializeChinese();
        } else {
            LANGUAGE_CURRENT = 0;
            InfoStrings.initializeEnglish();
        }
    }

    public static String getHelp() {
        switch (LANGUAGE_CURRENT) {
            case 0: {
                return InfoStrings.getHelpEnglish();
            }
            case 1: {
                return InfoStrings.getHelpFrench();
            }
            case 2: {
                return InfoStrings.getHelpChinese();
            }
        }
        return InfoStrings.getHelpEnglish();
    }

    public static String getCredits1() {
        switch (LANGUAGE_CURRENT) {
            case 0: {
                return InfoStrings.getCredits1English();
            }
            case 1: {
                return InfoStrings.getCredits1French();
            }
            case 2: {
                return InfoStrings.getCredits1Chinese();
            }
        }
        return InfoStrings.getCredits1English();
    }

    public static String getCredits2() {
        switch (LANGUAGE_CURRENT) {
            case 0: {
                return InfoStrings.getCredits2English();
            }
            case 1: {
                return InfoStrings.getCredits2French();
            }
            case 2: {
                return InfoStrings.getCredits2Chinese();
            }
        }
        return InfoStrings.getCredits2English();
    }

    public static String getCredits3() {
        switch (LANGUAGE_CURRENT) {
            case 0: {
                return InfoStrings.getCredits3English();
            }
            case 1: {
                return InfoStrings.getCredits3French();
            }
            case 2: {
                return InfoStrings.getCredits3Chinese();
            }
        }
        return InfoStrings.getCredits3English();
    }

    public static void initializeChinese() {
        TITLE_CREDITS = "\u5236\u4f5c\u5c0f\u7ec4";
        TITLE_HELP = "\u5e2e\u52a9";
        EXIT_LABEL = "\u9000\u51fa";
        QUIT_LABEL = "\u9000\u51fa";
        QUIT_CONFIRM_LABEL = "\u662f";
        QUIT_ABORT_LABEL = "\u5426";
        PAUSE_LABEL = "\u6682\u505c";
        RESUME_LABEL = "\u7ee7\u7eed\u6e38\u620f";
        RESTART_LABEL = "\u7ee7\u7eed\u6e38\u620f";
        NEXT_LABEL = "\u4e0b\u4e00\u6b65";
        BACK_LABEL = "\u540e\u9000";
        SELECT_LABEL = "\u9009\u5b9a";
        DONE_LABEL = "\u5236\u4f5c\u5c0f\u7ec4 ";
        BLANK_LABEL = "";
        SKIP_LABEL = "\u8df3\u8fc7";
        DEL_LABEL = "DEL";
        STATUS_QUESTION = "Are you sure you\nwant to quit?";
        GAME_PAUSED_STRING = "Game Paused";
        GAME_OVER_STRING = "\u6e38\u620f\u7ed3\u675f";
        PEAK_SCORE_STRING = "\u6700\u9ad8\u5206";
        HISCORE_TITLE = "High Scores";
        HISCORE_ENTRY_TITLE = "\u8fdb\u5165\u79ef\u5206\u699c";
        HISCORE_ENTRY_TEXT1_SUFFIX = "\u662f\u4e00\u4e2a\u5f88\u9ad8\u7684";
        HISCORE_ENTRY_NAME_FIELD = "\u8bf7\u8f93\u5165\u59d3\u540d :";
        HISCORE_ENTRY_TEXT2 = "Press DONE and wait...";
        HISCORE_ENTRY_TEXT2_ERROR = "Please enter valid characters\n";
        HISCORE_PLAYER_STRING = "Player";
        LOADING_TEXT = "Loading game";
    }

    public static String getHelpChinese() {
        StringBuffer stringBuffer = new StringBuffer("Your Mission\n");
        stringBuffer.append("------------\n");
        stringBuffer.append("Destroy all enemies from the sky! Don't let any spinning satellites hit the ground or you will be killed instantly! The more you hit, the more points you get! Any objects that hit the ground decrease your score!\n");
        stringBuffer.append("\n");
        stringBuffer.append("Controls\n");
        stringBuffer.append("--------\n");
        stringBuffer.append("Use the navigation key or the Alphanumeric keys to control your ship. Toggle auto-fire as needed, and use hyper-space to get out of close calls!\n");
        stringBuffer.append("up- Toggle Auto-fire\n");
        stringBuffer.append("left- Left\n");
        stringBuffer.append("right- Right\n");
        stringBuffer.append("down- Hyperspace\n");
        stringBuffer.append("\n");
        stringBuffer.append("Alphanumeric keys Controls\n");
        stringBuffer.append("--------------------------\n");
        stringBuffer.append("4- Move Left\n");
        stringBuffer.append("6- Move Right\n");
        stringBuffer.append("1- Fire\n");
        stringBuffer.append("3- Fire\n");
        stringBuffer.append("2- Toggle Auto-fire\n");
        stringBuffer.append("8- Hyperspace\n");
        return stringBuffer.toString();
    }

    public static String getCredits1Chinese() {
        StringBuffer stringBuffer = new StringBuffer("THQ Credits\n");
        stringBuffer.append("-----------\n");
        stringBuffer.append("Producer- Stuart Platt, Associate Producer- Colin Totman, VP Marketing- Peter Dille, Director of Creative Services- Howard Liebeskind, Production Manager- Chris Sturr\n");
        stringBuffer.append("\n");
        stringBuffer.append("THQ QA testing team credits\n");
        stringBuffer.append("---------------------------\n");
        stringBuffer.append("SENIOR TESTER - Scott Frazier TESTERS - Adam Affrunti, Brad Arnold, Shelley Franklin, Donald Sturkey\n");
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    public static String getCredits2Chinese() {
        StringBuffer stringBuffer = new StringBuffer("Lavastorm Credits\n-----------------\nProducer: Jason Loia Lead Coders: Albert So, Horace Lin, Veeramurthy Veeraprakash Artwork: Mark Keavney\n\nSpecial Thanks to\n-----------------\nJohn P. Sohl\n");
        return stringBuffer.toString();
    }

    public static String getCredits3Chinese() {
        StringBuffer stringBuffer = new StringBuffer("Astrosmash & Intellivision are trademarks of Intellivision Productions, Inc. Astrosmash game (C) 1981 Intellivision Productions, Inc. Used under exclusive license. Developed by Lavastorm, Inc. Game Implementation & Software (C) 2002 THQ Inc. THQ and logo are (R) of THQ Inc. All Rights Reserved.\n");
        stringBuffer.append(AstrosmashVersion.CREDITS_UPC_CODE + "\n");
        return stringBuffer.toString();
    }

    public static void initializeEnglish() {
        TITLE_CREDITS = "Credits";
        TITLE_HELP = "Help";
        EXIT_LABEL = "EXIT";
        QUIT_LABEL = "QUIT";
        QUIT_CONFIRM_LABEL = "YES";
        QUIT_ABORT_LABEL = "NO";
        PAUSE_LABEL = "PAUSE";
        RESUME_LABEL = "PLAY";
        RESTART_LABEL = "PLAY";
        NEXT_LABEL = "NEXT";
        BACK_LABEL = "BACK";
        SELECT_LABEL = "PICK";
        DONE_LABEL = "DONE";
        SKIP_LABEL = "SKIP";
        DEL_LABEL = "DEL";
        STATUS_QUESTION = "Are you sure you\nwant to quit?";
        GAME_PAUSED_STRING = "Game Paused";
        GAME_OVER_STRING = "GAME OVER";
        PEAK_SCORE_STRING = "Peak Score";
        HISCORE_TITLE = "High Scores";
        HISCORE_ENTRY_TITLE = "High Score Entry";
        HISCORE_ENTRY_TEXT1_SUFFIX = " is a high score.";
        HISCORE_ENTRY_NAME_FIELD = "Enter your name:";
        HISCORE_ENTRY_TEXT2 = "Press DONE and wait...";
        HISCORE_ENTRY_TEXT2_ERROR = "Please enter valid characters\n";
        HISCORE_PLAYER_STRING = "Player";
        LOADING_TEXT = "Loading game";
    }

    public static String getHelpEnglish() {
        StringBuffer stringBuffer = new StringBuffer("Your Mission\n");
        stringBuffer.append("------------\n");
        stringBuffer.append("Destroy all enemies from the sky! Don't let any spinning satellites hit the ground or you will be killed instantly! The more you hit, the more points you get! Any objects that hit the ground decrease your score!\n");
        stringBuffer.append("\n");
        stringBuffer.append("Controls\n");
        stringBuffer.append("--------\n");
        stringBuffer.append("Use the navigation key or the Alphanumeric keys to control your ship. Toggle auto-fire as needed, and use hyper-space to get out of close calls!\n");
        stringBuffer.append("up- Toggle Auto-fire\n");
        stringBuffer.append("left- Left\n");
        stringBuffer.append("right- Right\n");
        stringBuffer.append("down- Hyperspace\n");
        stringBuffer.append("\n");
        stringBuffer.append("Alphanumeric keys Controls\n");
        stringBuffer.append("--------------------------\n");
        stringBuffer.append("4- Move Left\n");
        stringBuffer.append("6- Move Right\n");
        stringBuffer.append("1- Fire\n");
        stringBuffer.append("3- Fire\n");
        stringBuffer.append("2- Toggle Auto-fire\n");
        stringBuffer.append("8- Hyperspace\n");
        return stringBuffer.toString();
    }

    public static String getCredits1English() {
        StringBuffer stringBuffer = new StringBuffer("THQ Credits\n");
        stringBuffer.append("-----------\n");
        stringBuffer.append("Producer- Stuart Platt, Associate Producer- Colin Totman, VP Marketing- Peter Dille, Director of Creative Services- Howard Liebeskind, Production Manager- Chris Sturr\n");
        stringBuffer.append("\n");
        stringBuffer.append("THQ QA testing team credits\n");
        stringBuffer.append("---------------------------\n");
        stringBuffer.append("SENIOR TESTER - Scott Frazier TESTERS - Adam Affrunti, Brad Arnold, Shelley Franklin, Donald Sturkey\n");
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    public static String getCredits2English() {
        StringBuffer stringBuffer = new StringBuffer("Lavastorm Credits\n-----------------\nProducer: Jason Loia Lead Coders: Albert So, Horace Lin, Veeramurthy Veeraprakash Artwork: Mark Keavney\n\nSpecial Thanks to\n-----------------\nJohn P. Sohl\n");
        return stringBuffer.toString();
    }

    public static String getCredits3English() {
        StringBuffer stringBuffer = new StringBuffer("Astrosmash & Intellivision are trademarks of Intellivision Productions, Inc. Astrosmash game (C) 1981 Intellivision Productions, Inc. Used under exclusive license. Developed by Lavastorm, Inc. Game Implementation & Software (C) 2002 THQ Inc. THQ and logo are (R) of THQ Inc. All Rights Reserved.\n");
        stringBuffer.append(AstrosmashVersion.CREDITS_UPC_CODE + "\n");
        return stringBuffer.toString();
    }

    public static void initializeFrench() {
        TITLE_CREDITS = "CREDITS";
        TITLE_HELP = "AIDE";
        EXIT_LABEL = "QUIT";
        QUIT_LABEL = "QUIT";
        QUIT_CONFIRM_LABEL = "OUI";
        QUIT_ABORT_LABEL = "NON";
        PAUSE_LABEL = "PAUSE";
        RESUME_LABEL = "PLAY";
        RESTART_LABEL = "PLAY";
        NEXT_LABEL = "SUIV.";
        BACK_LABEL = "PR\u00c9C.";
        SELECT_LABEL = "SELEC";
        DONE_LABEL = "FINI";
        SKIP_LABEL = "ANNUL";
        DEL_LABEL = "DEL";
        STATUS_QUESTION = "\u00cates-Vous S\u00fbr \nDe Vouloir Quitter?";
        GAME_PAUSED_STRING = "Pause";
        GAME_OVER_STRING = "GAME OVER";
        PEAK_SCORE_STRING = "MEILLEUR SCORE";
        HISCORE_TITLE = "Meilleurs Scores";
        HISCORE_ENTRY_TITLE = "Meilleurs Scores";
        HISCORE_ENTRY_TEXT1_SUFFIX = "Est un score \u00c9lev\u00c9";
        HISCORE_ENTRY_NAME_FIELD = "Saisissez Votre Nom:";
        HISCORE_ENTRY_TEXT2 = "Appuyer sur FINI et patienter...";
        HISCORE_ENTRY_TEXT2_ERROR = "Please enter valid characters\n";
        HISCORE_PLAYER_STRING = "Player";
        LOADING_TEXT = "Loading game";
    }

    public static String getHelpFrench() {
        StringBuffer stringBuffer = new StringBuffer("VOTRE MISSION\n");
        stringBuffer.append("------------\n");
        stringBuffer.append("DETRUIRE TOUS LES ENNEMIS! NE LAISSEZ AUCUN SATELLITE TOURNANT TOUCHER LE SOL OU VOUS SEREZ TUE INSTANTANEMENT ! PLUS VOUS DETRUISEZ D'ENNEMIS, PLUS VOUS MARQUEZ DE POINTS ! CHAQUE OBJET QUI TOUCHE LE SOL FAIT DESCENDRE VOTRE SCORE !\n");
        stringBuffer.append("\n");
        stringBuffer.append("CONTROLES\n");
        stringBuffer.append("--------\n");
        stringBuffer.append("APPUYEZ SUR LES TOUCHES DE NAVIGATION OU LE CLAVIER NUMERIQUE POUR CONTROLER VOTRE VAISSEAU. ACTIVEZ LE TIR AUTOMATIQUE COMME VOUS LE DESIREZ ET UTILISEZ L'HYPER-ESPACE POUR VOUS SORTIR DE SITUATIONS DIFFICILES\n");
        stringBuffer.append("HAUT - ACTIVER:DESACTIVER LE TIR AUTOMATIQUE\n");
        stringBuffer.append("GAUCHE - GAUCHE\n");
        stringBuffer.append("DROITE - DROITE\n");
        stringBuffer.append("BAS - HYPER-ESPACE\n");
        stringBuffer.append("\n");
        stringBuffer.append("COMMANDES DU CLAVIER\n");
        stringBuffer.append("--------------------------\n");
        stringBuffer.append("4- D\u00c9PLACEMENT VERS LA GAUCHE\n");
        stringBuffer.append("6- D\u00c9PLACEMENT VERS LA DROITE\n");
        stringBuffer.append("1- FEU\n");
        stringBuffer.append("3- FEU\n");
        stringBuffer.append("2- PASSER AU TIR AUTOMATIQUE\n");
        stringBuffer.append("8-HYPERESPACE\n");
        return stringBuffer.toString();
    }

    public static String getCredits1French() {
        StringBuffer stringBuffer = new StringBuffer("THQ CREDITS\n");
        stringBuffer.append("-----------\n");
        stringBuffer.append("PRODUCTEUR- Stuart Platt, PRODUCTEUR ASSOCIE- Colin Totman, VP MARKETING- Peter Dille, DIRECTEUR DU SERVICE CREATION- Howard Liebeskind, RESPONSABLE DE PRODUCTION- Chris Sturr\n");
        stringBuffer.append("\n");
        stringBuffer.append("CREDITS DE L'EQUIPE DE TEST DE THQ\n");
        stringBuffer.append("---------------------------\n");
        stringBuffer.append("TESTEUR SENIOR - Scott Frazier TESTEURS - Adam Affrunti, Brad Arnold, Shelley Franklin, Donald Sturkey\n");
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    public static String getCredits2French() {
        StringBuffer stringBuffer = new StringBuffer("CREDITS LAVASTORM\n-----------------\nPRODUCTEUR: Jason Loia PROGRAMMEURS: Albert So, Horace Lin, Veeramurthy Veeraprakash ARTISTIQUE: Mark Keavney\nREMERCIEMENTS A\n-----------------\nJohn P. Sohl\n");
        return stringBuffer.toString();
    }

    public static String getCredits3French() {
        StringBuffer stringBuffer = new StringBuffer("ASTROSMASH & INTELLIVISION ARE TRADEMARKS OF INTELLIVISION PRODUCTIONS, INC.\nASTROSMASH GAME \u00a9 1981 INTELLIVISION PRODUCTIONS, INC.\nUSED UNDER EXCLUSIVE LICENSE. DEVELOPED BY LAVASTORM, INC. GAME IMPLEMENTATION & SOFTWARE \u00a9 2001 THQ INC. THQ AND LOGO ARE \u00ae OF THQ INC.  ALL RIGHTS RESERVED.\n");
        stringBuffer.append(AstrosmashVersion.CREDITS_UPC_CODE + "\n");
        return stringBuffer.toString();
    }
}

