/*
 * Decompiled with CFR 0.152.
 */
package org.recompile.freej2me;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.net.URL;
import java.util.Timer;
import java.util.TimerTask;
import org.recompile.freej2me.Config;
import org.recompile.mobile.Mobile;
import org.recompile.mobile.MobilePlatform;

public class Libretro {
    private int lcdWidth = 240;
    private int lcdHeight = 320;
    private Runnable painter;
    private BufferedImage surface;
    private Graphics2D gc;
    private Config config;
    private boolean useNokiaControls = true;
    private boolean rotateDisplay = false;
    private int limitFPS = 0;
    private byte[] frameBuffer = new byte[1920000];
    private byte[] frameHeader = new byte[]{-2, 0, 0, 0, 0, 0};
    private int mousex;
    private int mousey;
    LibretroIO lio;

    public static void main(String[] args) {
        Libretro app = new Libretro();
    }

    public Libretro() {
        this.surface = new BufferedImage(this.lcdWidth, this.lcdHeight, 2);
        this.gc = (Graphics2D)this.surface.getGraphics();
        Mobile.setPlatform(new MobilePlatform(this.lcdWidth, this.lcdHeight));
        this.config = new Config();
        this.config.onChange = new Runnable(){

            @Override
            public void run() {
                Libretro.this.settingsChanged();
            }
        };
        this.lio = new LibretroIO();
        this.lio.start();
        this.painter = new Runnable(){

            @Override
            public void run() {
                try {
                    Libretro.this.gc.drawImage(Mobile.getPlatform().getLCD(), 0, 0, Libretro.this.lcdWidth, Libretro.this.lcdHeight, null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        Mobile.getPlatform().setPainter(this.painter);
        System.out.println("+READY");
        System.out.flush();
    }

    private void settingsChanged() {
        String rotate;
        String nokia;
        String sound;
        int w = Integer.parseInt(this.config.settings.get("width"));
        int h = Integer.parseInt(this.config.settings.get("height"));
        this.limitFPS = Integer.parseInt(this.config.settings.get("fps"));
        if (this.limitFPS > 0) {
            this.limitFPS = 1000 / this.limitFPS;
        }
        if ((sound = this.config.settings.get("sound")).equals("on")) {
            Mobile.getPlatform().sound = true;
        }
        if (sound.equals("off")) {
            Mobile.getPlatform().sound = false;
        }
        if ((nokia = this.config.settings.get("nokia")).equals("on")) {
            this.useNokiaControls = true;
        }
        if (nokia.equals("off")) {
            this.useNokiaControls = false;
        }
        if ((rotate = this.config.settings.get("rotate")).equals("on")) {
            this.rotateDisplay = true;
            this.frameHeader[5] = 1;
        }
        if (rotate.equals("off")) {
            this.rotateDisplay = false;
            this.frameHeader[5] = 0;
        }
        if (this.lcdWidth != w || this.lcdHeight != h) {
            this.lcdWidth = w;
            this.lcdHeight = h;
            Mobile.getPlatform().resizeLCD(w, h);
            this.surface = new BufferedImage(this.lcdWidth, this.lcdHeight, 2);
            this.gc = (Graphics2D)this.surface.getGraphics();
        }
    }

    private void keyDown(int key) {
        if (this.config.isRunning) {
            this.config.keyPressed(key);
        } else {
            Mobile.getPlatform().keyPressed(key);
        }
    }

    private void keyUp(int key) {
        if (!this.config.isRunning) {
            Mobile.getPlatform().keyReleased(key);
        }
    }

    private int getMobileKey(int keycode) {
        if (this.useNokiaControls) {
            switch (keycode) {
                case 273: {
                    return -1;
                }
                case 274: {
                    return -2;
                }
                case 276: {
                    return -3;
                }
                case 275: {
                    return -4;
                }
            }
        }
        switch (keycode) {
            case 48: {
                return 48;
            }
            case 49: {
                return 49;
            }
            case 50: {
                return 50;
            }
            case 51: {
                return 51;
            }
            case 52: {
                return 52;
            }
            case 53: {
                return 53;
            }
            case 54: {
                return 54;
            }
            case 55: {
                return 55;
            }
            case 56: {
                return 56;
            }
            case 57: {
                return 57;
            }
            case 42: {
                return 42;
            }
            case 35: {
                return 35;
            }
            case 273: {
                return 50;
            }
            case 274: {
                return 56;
            }
            case 276: {
                return 52;
            }
            case 275: {
                return 54;
            }
            case 256: {
                return 48;
            }
            case 257: {
                return 55;
            }
            case 258: {
                return 56;
            }
            case 259: {
                return 57;
            }
            case 260: {
                return 52;
            }
            case 261: {
                return 53;
            }
            case 262: {
                return 54;
            }
            case 263: {
                return 49;
            }
            case 264: {
                return 50;
            }
            case 265: {
                return 51;
            }
            case 13: {
                return 53;
            }
            case 113: {
                return -6;
            }
            case 119: {
                return -7;
            }
            case 101: {
                return 42;
            }
            case 114: {
                return 35;
            }
            case 91: {
                return -6;
            }
            case 93: {
                return -7;
            }
            case 27: {
                this.config.start();
            }
        }
        return keycode;
    }

    private int getMobileKeyJoy(int keycode) {
        if (this.useNokiaControls) {
            switch (keycode) {
                case 0: {
                    return -1;
                }
                case 1: {
                    return -2;
                }
                case 2: {
                    return -3;
                }
                case 3: {
                    return -4;
                }
            }
        }
        switch (keycode) {
            case 0: {
                return 50;
            }
            case 1: {
                return 56;
            }
            case 2: {
                return 52;
            }
            case 3: {
                return 54;
            }
            case 4: {
                return 57;
            }
            case 5: {
                return 55;
            }
            case 6: {
                return 48;
            }
            case 7: {
                return 53;
            }
            case 8: {
                return -7;
            }
            case 9: {
                return -6;
            }
            case 10: {
                return 49;
            }
            case 11: {
                return 51;
            }
            case 12: {
                return 42;
            }
            case 13: {
                return 35;
            }
        }
        return 53;
    }

    private class LibretroIO {
        private Timer keytimer;
        private TimerTask keytask;

        private LibretroIO() {
        }

        public void start() {
            this.keytimer = new Timer();
            this.keytask = new LibretroTimerTask();
            this.keytimer.schedule(this.keytask, 0L, 1L);
        }

        public void stop() {
            this.keytimer.cancel();
        }

        private class LibretroTimerTask
        extends TimerTask {
            private int bin;
            private int[] din = new int[5];
            private int count = 0;
            private int code;
            private StringBuilder path;
            private URL url;

            private LibretroTimerTask() {
            }

            @Override
            public void run() {
                try {
                    while (true) {
                        this.bin = System.in.read();
                        if (this.bin == -1) {
                            return;
                        }
                        this.din[this.count] = this.bin & 0xFF;
                        ++this.count;
                        if (this.count != 5) continue;
                        this.count = 0;
                        this.code = this.din[1] << 24 | this.din[2] << 16 | this.din[3] << 8 | this.din[4];
                        switch (this.din[0]) {
                            case 0: {
                                Libretro.this.keyUp(Libretro.this.getMobileKey(this.code));
                                break;
                            }
                            case 1: {
                                Libretro.this.keyDown(Libretro.this.getMobileKey(this.code));
                                break;
                            }
                            case 2: {
                                Libretro.this.keyUp(Libretro.this.getMobileKeyJoy(this.code));
                                break;
                            }
                            case 3: {
                                Libretro.this.keyDown(Libretro.this.getMobileKeyJoy(this.code));
                                break;
                            }
                            case 4: {
                                Libretro.this.mousex = this.din[1] << 8 | this.din[2];
                                Libretro.this.mousey = this.din[3] << 8 | this.din[4];
                                if (!Libretro.this.rotateDisplay) {
                                    Mobile.getPlatform().pointerReleased(Libretro.this.mousex, Libretro.this.mousey);
                                    break;
                                }
                                Mobile.getPlatform().pointerReleased(Libretro.this.mousey, Libretro.this.mousex);
                                break;
                            }
                            case 5: {
                                Libretro.this.mousex = this.din[1] << 8 | this.din[2];
                                Libretro.this.mousey = this.din[3] << 8 | this.din[4];
                                if (!Libretro.this.rotateDisplay) {
                                    Mobile.getPlatform().pointerPressed(Libretro.this.mousex, Libretro.this.mousey);
                                    break;
                                }
                                Mobile.getPlatform().pointerPressed(Libretro.this.mousey, Libretro.this.mousex);
                                break;
                            }
                            case 6: {
                                Libretro.this.mousex = this.din[1] << 8 | this.din[2];
                                Libretro.this.mousey = this.din[3] << 8 | this.din[4];
                                if (!Libretro.this.rotateDisplay) {
                                    Mobile.getPlatform().pointerDragged(Libretro.this.mousex, Libretro.this.mousey);
                                    break;
                                }
                                Mobile.getPlatform().pointerDragged(Libretro.this.mousey, Libretro.this.mousex);
                                break;
                            }
                            case 10: {
                                this.path = new StringBuilder();
                                for (int i = 0; i < this.code; ++i) {
                                    this.bin = System.in.read();
                                    this.path.append((char)this.bin);
                                }
                                this.url = new File(this.path.toString()).toURI().toURL();
                                if (Mobile.getPlatform().loadJar(this.url.toString())) {
                                    Libretro.this.config.init();
                                    Libretro.this.settingsChanged();
                                    Mobile.getPlatform().runJar();
                                    break;
                                }
                                System.out.println("Couldn't load jar...");
                                System.exit(0);
                                break;
                            }
                            case 11: {
                                this.path = new StringBuilder();
                                for (int i = 0; i < this.code; ++i) {
                                    this.bin = System.in.read();
                                    this.path.append((char)this.bin);
                                }
                                Mobile.getPlatform().dataPath = this.path.toString();
                                break;
                            }
                            case 15: {
                                try {
                                    int[] data;
                                    if (((Libretro)Libretro.this).config.isRunning) {
                                        data = Libretro.this.config.getLCD().getRGB(0, 0, Libretro.this.lcdWidth, Libretro.this.lcdHeight, null, 0, Libretro.this.lcdWidth);
                                    } else {
                                        data = Libretro.this.surface.getRGB(0, 0, Libretro.this.lcdWidth, Libretro.this.lcdHeight, null, 0, Libretro.this.lcdWidth);
                                        if (Libretro.this.limitFPS > 0) {
                                            Thread.sleep(Libretro.this.limitFPS);
                                        }
                                    }
                                    int bufferLength = data.length * 3;
                                    int cb = 0;
                                    for (int i = 0; i < data.length; ++i) {
                                        ((Libretro)Libretro.this).frameBuffer[cb] = (byte)(data[i] >> 16 & 0xFF);
                                        ((Libretro)Libretro.this).frameBuffer[cb + 1] = (byte)(data[i] >> 8 & 0xFF);
                                        ((Libretro)Libretro.this).frameBuffer[cb + 2] = (byte)(data[i] & 0xFF);
                                        cb += 3;
                                    }
                                    ((Libretro)Libretro.this).frameHeader[1] = (byte)(Libretro.this.lcdWidth >> 8 & 0xFF);
                                    ((Libretro)Libretro.this).frameHeader[2] = (byte)(Libretro.this.lcdWidth & 0xFF);
                                    ((Libretro)Libretro.this).frameHeader[3] = (byte)(Libretro.this.lcdHeight >> 8 & 0xFF);
                                    ((Libretro)Libretro.this).frameHeader[4] = (byte)(Libretro.this.lcdHeight & 0xFF);
                                    System.out.write(Libretro.this.frameHeader, 0, 6);
                                    System.out.write(Libretro.this.frameBuffer, 0, bufferLength);
                                    System.out.flush();
                                    break;
                                }
                                catch (Exception e) {
                                    System.out.print("Error sending frame: " + e.getMessage());
                                    System.exit(0);
                                }
                            }
                        }
                    }
                }
                catch (Exception e) {
                    System.exit(0);
                    return;
                }
            }
        }
    }
}

