/*
 * Decompiled with CFR 0.152.
 */
package org.recompile.mobile;

import java.awt.image.BufferedImage;
import java.net.URL;
import javax.microedition.lcdui.Image;
import javax.microedition.m3g.Graphics3D;
import org.recompile.mobile.MIDletLoader;
import org.recompile.mobile.Mobile;
import org.recompile.mobile.PlatformGraphics;
import org.recompile.mobile.PlatformImage;

public class MobilePlatform {
    private PlatformImage lcd;
    private PlatformGraphics gc;
    public int lcdWidth;
    public int lcdHeight;
    public MIDletLoader loader;
    public Runnable painter;
    public String dataPath = "";
    public boolean sound = true;
    public int keyState = 0;

    public MobilePlatform(int width, int height) {
        this.lcdWidth = width;
        this.lcdHeight = height;
        this.lcd = new PlatformImage(width, height);
        this.gc = this.lcd.getGraphics();
        Mobile.setGraphics3D(new Graphics3D());
        this.painter = new Runnable(){

            @Override
            public void run() {
            }
        };
    }

    public void resizeLCD(int width, int height) {
        this.lcdWidth = width;
        this.lcdHeight = height;
        this.lcd = new PlatformImage(width, height);
        this.gc = this.lcd.getGraphics();
    }

    public BufferedImage getLCD() {
        return this.lcd.getCanvas();
    }

    public void setPainter(Runnable r) {
        this.painter = r;
    }

    public void keyPressed(int keycode) {
        this.updateKeyState(keycode, 1);
        Mobile.getDisplay().getCurrent().keyPressed(keycode);
    }

    public void keyReleased(int keycode) {
        this.updateKeyState(keycode, 0);
        Mobile.getDisplay().getCurrent().keyReleased(keycode);
    }

    public void pointerDragged(int x, int y) {
        Mobile.getDisplay().getCurrent().pointerDragged(x, y);
    }

    public void pointerPressed(int x, int y) {
        Mobile.getDisplay().getCurrent().pointerPressed(x, y);
    }

    public void pointerReleased(int x, int y) {
        Mobile.getDisplay().getCurrent().pointerReleased(x, y);
    }

    private void updateKeyState(int key, int val) {
        int mask = 0;
        switch (key) {
            case 50: {
                mask = 2;
                break;
            }
            case 52: {
                mask = 4;
                break;
            }
            case 54: {
                mask = 32;
                break;
            }
            case 56: {
                mask = 64;
                break;
            }
            case 53: {
                mask = 256;
                break;
            }
            case 49: {
                mask = 512;
                break;
            }
            case 51: {
                mask = 1024;
                break;
            }
            case 55: {
                mask = 2048;
                break;
            }
            case 57: {
                mask = 4096;
                break;
            }
            case -1: {
                mask = 2;
                break;
            }
            case -3: {
                mask = 4;
                break;
            }
            case -4: {
                mask = 32;
                break;
            }
            case -2: {
                mask = 64;
            }
        }
        this.keyState |= mask;
        this.keyState ^= mask;
        if (val == 1) {
            this.keyState |= mask;
        }
    }

    public boolean loadJar(String jarurl) {
        try {
            URL jar = new URL(jarurl);
            this.loader = new MIDletLoader(new URL[]{jar});
            return true;
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    public void runJar() {
        try {
            this.loader.start();
        }
        catch (Exception e) {
            System.out.println("Error Running Jar");
            e.printStackTrace();
        }
    }

    public void flushGraphics(Image img, int x, int y, int width, int height) {
        this.gc.flushGraphics(img, x, y, width, height);
        this.painter.run();
    }

    public void repaint(Image img, int x, int y, int width, int height) {
        this.gc.flushGraphics(img, x, y, width, height);
        this.painter.run();
    }
}

