/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.rms;

import java.io.File;
import java.io.FileOutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Vector;
import javax.microedition.rms.InvalidRecordIDException;
import javax.microedition.rms.RecordComparator;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordFilter;
import javax.microedition.rms.RecordListener;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreNotFoundException;
import org.recompile.mobile.Mobile;

public class RecordStore {
    public static final int AUTHMODE_ANY = 1;
    public static final int AUTHMODE_PRIVATE = 0;
    private String name;
    private String appname;
    private static String rmsPath;
    private String rmsFile;
    private File file;
    private int version;
    private int nextid;
    private Vector<byte[]> records;
    private Vector<RecordListener> listeners;
    private int lastModified;

    private RecordStore(String recordStoreName, boolean createIfNecessary) throws RecordStoreException, RecordStoreNotFoundException {
        int count;
        block9: {
            this.version = 0;
            this.nextid = 0;
            this.lastModified = 0;
            this.records = new Vector();
            this.listeners = new Vector();
            this.records.add(new byte[0]);
            this.name = recordStoreName;
            this.appname = Mobile.getPlatform().loader.suitename;
            rmsPath = "rms/" + this.appname;
            this.rmsFile = "rms/" + this.appname + "/" + recordStoreName;
            try {
                Files.createDirectories(Paths.get(rmsPath, new String[0]), new FileAttribute[0]);
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
                throw new RecordStoreException("Problem Creating Record Store Path " + rmsPath);
            }
            try {
                this.file = new File(this.rmsFile);
                if (this.file.exists()) break block9;
                if (createIfNecessary) {
                    this.file.createNewFile();
                    this.version = 1;
                    this.nextid = 1;
                    count = 0;
                    this.save();
                    this.nextid = 1;
                    break block9;
                }
                throw new RecordStoreNotFoundException("Record Store Doesn't Exist: " + this.rmsFile);
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
                throw new RecordStoreException("Problem Opening Record Store (createIfNecessary " + createIfNecessary + "): " + this.rmsFile);
            }
        }
        try {
            Path path = Paths.get(this.file.getAbsolutePath(), new String[0]);
            byte[] data = Files.readAllBytes(path);
            if (data.length >= 4) {
                int offset = 0;
                this.version = this.getUInt16(data, offset);
                this.nextid = this.getUInt16(data, offset += 2);
                count = this.getUInt16(data, offset += 2);
                offset += 2;
                for (int i = 0; i < count; ++i) {
                    int reclen = this.getUInt16(data, offset);
                    this.loadRecord(data, offset += 2, reclen);
                    offset += reclen;
                }
            }
        }
        catch (Exception e) {
            System.out.println("Problem Reading Record Store: " + this.rmsFile);
            System.out.println(e.getMessage());
            throw new RecordStoreException("Problem Reading Record Store: " + this.rmsFile);
        }
    }

    private void save() {
        byte[] temp = new byte[2];
        try {
            FileOutputStream fout = new FileOutputStream(this.rmsFile);
            this.setUInt16(temp, 0, this.version);
            fout.write(temp);
            this.setUInt16(temp, 0, this.nextid);
            fout.write(temp);
            this.setUInt16(temp, 0, this.records.size() - 1);
            fout.write(temp);
            for (int i = 1; i < this.records.size(); ++i) {
                this.setUInt16(temp, 0, this.records.get(i).length);
                fout.write(temp);
                fout.write(this.records.get(i));
            }
            fout.close();
        }
        catch (Exception e) {
            System.out.println("Problem Saving RecordStore");
            e.printStackTrace();
        }
    }

    private void loadRecord(byte[] data, int offset, int numBytes) {
        byte[] rec = Arrays.copyOfRange(data, offset, offset + numBytes);
        if (rec == null) {
            rec = new byte[]{};
        }
        this.records.addElement(rec);
    }

    private int getUInt16(byte[] data, int offset) {
        int out = 0;
        out |= (data[offset] & 0xFF) << 8;
        return (out |= data[offset + 1] & 0xFF) | 0;
    }

    private void setUInt16(byte[] data, int offset, int val) {
        data[offset] = (byte)(val >> 8 & 0xFF);
        data[offset + 1] = (byte)(val & 0xFF);
    }

    public int addRecord(byte[] data, int offset, int numBytes) throws RecordStoreException {
        try {
            byte[] rec = Arrays.copyOfRange(data, offset, offset + numBytes);
            this.records.addElement(rec);
            this.lastModified = this.nextid++;
            ++this.version;
            this.save();
            for (int i = 0; i < this.listeners.size(); ++i) {
                this.listeners.get(i).recordAdded(this, this.lastModified);
            }
            return this.lastModified;
        }
        catch (Exception e) {
            throw new RecordStoreException("Can't Add RMS Record");
        }
    }

    public void addRecordListener(RecordListener listener) {
        this.listeners.add(listener);
    }

    public void closeRecordStore() {
    }

    public void deleteRecord(int recordId) {
        ++this.version;
        this.records.set(recordId, new byte[0]);
        this.save();
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).recordDeleted(this, recordId);
        }
    }

    public static void deleteRecordStore(String recordStoreName) {
        try {
            File fstore = new File("rms/" + Mobile.getPlatform().loader.suitename + "/" + recordStoreName);
            fstore.delete();
        }
        catch (Exception e) {
            System.out.println("Problem deleting RecordStore " + recordStoreName);
            e.printStackTrace();
        }
        System.gc();
    }

    public RecordEnumeration enumerateRecords(RecordFilter filter, RecordComparator comparator, boolean keepUpdated) {
        System.out.println("RecordStore.enumerateRecords");
        return new enumeration(filter, comparator, keepUpdated);
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public String getName() {
        return this.name;
    }

    public int getNextRecordID() {
        return this.nextid;
    }

    public int getNumRecords() {
        int count = 0;
        for (int i = 1; i < this.records.size(); ++i) {
            if (this.records.get(i).length != 0) continue;
            ++count;
        }
        count = this.records.size() - (1 + count);
        if (count < 0) {
            count = 0;
        }
        return count;
    }

    public byte[] getRecord(int recordId) throws InvalidRecordIDException, RecordStoreException {
        if (recordId >= this.records.size()) {
            throw new InvalidRecordIDException("(A) Invalid Record ID: " + recordId);
        }
        try {
            byte[] t = this.records.get(recordId);
            if (t.length == 0) {
                return null;
            }
            return t;
        }
        catch (Exception e) {
            System.out.println("(getRecord) Record Store Exception: " + recordId);
            e.printStackTrace();
            throw new RecordStoreException();
        }
    }

    public int getRecord(int recordId, byte[] buffer, int offset) throws InvalidRecordIDException, RecordStoreException {
        byte[] temp = this.getRecord(recordId);
        if (temp == null) {
            return 0;
        }
        int len = temp.length;
        while (offset + len > buffer.length) {
            --len;
        }
        for (int i = 0; i < len; ++i) {
            buffer[offset + i] = temp[i];
        }
        return len;
    }

    public int getRecordSize(int recordId) throws InvalidRecordIDException, RecordStoreException {
        return this.getRecord(recordId).length;
    }

    public int getSize() {
        return Short.MAX_VALUE;
    }

    public int getSizeAvailable() {
        return 65536;
    }

    public int getVersion() {
        return this.version;
    }

    public static String[] listRecordStores() {
        if (rmsPath == null) {
            rmsPath = "rms/" + Mobile.getPlatform().loader.name;
            try {
                Files.createDirectories(Paths.get(rmsPath, new String[0]), new FileAttribute[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            File folder = new File(rmsPath);
            File[] files = folder.listFiles();
            String[] out = new String[files.length];
            for (int i = 0; i < files.length; ++i) {
                out[i] = files[i].toString().substring(rmsPath.length() + 1);
            }
            return out;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static RecordStore openRecordStore(String recordStoreName, boolean createIfNecessary) throws RecordStoreException, RecordStoreNotFoundException {
        return new RecordStore(recordStoreName, createIfNecessary);
    }

    public static RecordStore openRecordStore(String recordStoreName, boolean createIfNecessary, int authmode, boolean writable) throws RecordStoreException, RecordStoreNotFoundException {
        return new RecordStore(recordStoreName, createIfNecessary);
    }

    public static RecordStore openRecordStore(String recordStoreName, String vendorName, String suiteName) throws RecordStoreException, RecordStoreNotFoundException {
        System.out.println("Open Record Store C");
        return new RecordStore(recordStoreName, false);
    }

    public void removeRecordListener(RecordListener listener) {
        this.listeners.remove(listener);
    }

    public void setMode(int authmode, boolean writable) {
    }

    public void setRecord(int recordId, byte[] newData, int offset, int numBytes) throws RecordStoreException, InvalidRecordIDException {
        if (recordId >= this.records.size()) {
            throw new InvalidRecordIDException("(C) Invalid Record ID: " + recordId);
        }
        try {
            byte[] rec = Arrays.copyOfRange(newData, offset, offset + numBytes);
            this.records.set(recordId, rec);
        }
        catch (Exception e) {
            System.out.println("Problem in Set Record");
            e.printStackTrace();
        }
        this.lastModified = recordId;
        this.save();
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).recordChanged(this, recordId);
        }
    }

    private class enumeration
    implements RecordEnumeration {
        private int index;
        private int[] elements;
        private int count;
        private boolean keepupdated;
        RecordFilter filter;
        RecordComparator comparator;

        public enumeration(RecordFilter filter, RecordComparator comparator, boolean keepUpdated) {
            this.keepupdated = keepUpdated;
            this.index = 0;
            this.filter = filter;
            this.comparator = comparator;
            this.build();
        }

        private void build() {
            int i;
            this.elements = new int[RecordStore.this.records.size() + 1];
            for (i = 0; i < RecordStore.this.records.size() + 1; ++i) {
                this.elements[i] = 1;
            }
            this.count = 0;
            if (this.filter == null) {
                for (i = 1; i < RecordStore.this.records.size(); ++i) {
                    if (((byte[])RecordStore.this.records.get(i)).length <= 0) continue;
                    this.elements[this.count] = i;
                    ++this.count;
                }
            } else {
                for (i = 1; i < RecordStore.this.records.size(); ++i) {
                    if (!this.filter.matches((byte[])RecordStore.this.records.get(i)) || ((byte[])RecordStore.this.records.get(i)).length <= 0) continue;
                    this.elements[this.count] = i;
                    ++this.count;
                }
            }
            int result = 0;
            if (this.comparator != null) {
                for (int i2 = 0; i2 < this.count - 1; ++i2) {
                    for (int j = 0; j < this.count - (1 + i2); ++j) {
                        result = this.comparator.compare((byte[])RecordStore.this.records.get(this.elements[j]), (byte[])RecordStore.this.records.get(this.elements[j + 1]));
                        if (result != 1) continue;
                        int temp = this.elements[j];
                        this.elements[j] = this.elements[j + 1];
                        this.elements[j + 1] = temp;
                    }
                }
            }
        }

        @Override
        public void destroy() {
        }

        @Override
        public boolean hasNextElement() {
            if (this.keepupdated) {
                this.rebuild();
            }
            return this.index < this.count;
        }

        @Override
        public boolean hasPreviousElement() {
            if (this.keepupdated) {
                this.rebuild();
            }
            return this.index > 0;
        }

        @Override
        public boolean isKeptUpdated() {
            return this.keepupdated;
        }

        @Override
        public void keepUpdated(boolean keepUpdated) {
            this.keepupdated = keepUpdated;
        }

        @Override
        public byte[] nextRecord() throws InvalidRecordIDException {
            if (this.keepupdated) {
                this.rebuild();
            }
            if (this.index >= this.count) {
                throw new InvalidRecordIDException();
            }
            ++this.index;
            return (byte[])RecordStore.this.records.get(this.elements[this.index - 1]);
        }

        @Override
        public int nextRecordId() throws InvalidRecordIDException {
            if (this.keepupdated) {
                this.rebuild();
            }
            if (this.index >= this.count) {
                throw new InvalidRecordIDException();
            }
            return this.elements[this.index];
        }

        @Override
        public int numRecords() {
            if (this.keepupdated) {
                this.rebuild();
            }
            return this.count;
        }

        @Override
        public byte[] previousRecord() throws InvalidRecordIDException {
            if (this.keepupdated) {
                this.rebuild();
            }
            --this.index;
            if (this.index >= 0) {
                return (byte[])RecordStore.this.records.get(this.elements[this.index]);
            }
            if (this.index < 0) {
                this.index = this.count - 1;
                return (byte[])RecordStore.this.records.get(this.elements[this.index]);
            }
            return null;
        }

        @Override
        public int previousRecordId() throws InvalidRecordIDException {
            if (this.keepupdated) {
                this.rebuild();
            }
            if (this.index == 0) {
                throw new InvalidRecordIDException();
            }
            return this.elements[this.index - 1];
        }

        @Override
        public void rebuild() {
            this.build();
            if (this.index >= this.count) {
                this.index = this.count - 1;
            }
        }

        @Override
        public void reset() {
            if (this.keepupdated) {
                this.rebuild();
            }
            this.index = 0;
        }
    }
}

