/*
 * Decompiled with CFR 0.152.
 */
package com.mascotcapsule.micro3d.v3;

public class Vector3D {
    public int x;
    public int y;
    public int z;

    public Vector3D() {
        this.x = 0;
        this.y = 0;
        this.z = 0;
    }

    public Vector3D(Vector3D v) {
        this.x = v.x;
        this.y = v.y;
        this.z = v.z;
    }

    public Vector3D(int X, int Y, int Z) {
        this.x = X;
        this.y = Y;
        this.z = Z;
    }

    public final int getX() {
        return this.x;
    }

    public final int getY() {
        return this.y;
    }

    public final int getZ() {
        return this.z;
    }

    public final void setX(int X) {
        this.x = X;
    }

    public final void setY(int Y) {
        this.y = Y;
    }

    public final void setZ(int Z) {
        this.z = Z;
    }

    public final void set(Vector3D v) {
        this.x = v.x;
        this.y = v.y;
        this.z = v.z;
    }

    public final void set(int X, int Y, int Z) {
        this.x = X;
        this.y = Y;
        this.z = Z;
    }

    public final void unit() {
        double len = Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
        this.x = (int)((double)this.x / len);
        this.y = (int)((double)this.y / len);
        this.z = (int)((double)this.z / len);
    }

    public final int innerProduct(Vector3D v) {
        return this.x * v.x + this.y * v.y + this.z * v.z;
    }

    public final void outerProduct(Vector3D v) {
        int t1 = this.y * v.z - this.z * v.y;
        int t2 = this.z * v.x - this.x * v.z;
        int t3 = this.x * v.y - this.y * v.x;
        this.x = t1;
        this.y = t2;
        this.z = t3;
    }

    public static final int innerProduct(Vector3D a, Vector3D b) {
        return a.x * b.x + a.y * b.y + a.z * b.z;
    }

    public static final Vector3D outerProduct(Vector3D a, Vector3D b) {
        Vector3D t = new Vector3D(a);
        t.outerProduct(b);
        return t;
    }
}

