/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Item;
import javax.microedition.midlet.MIDlet;
import org.recompile.mobile.Mobile;

public class Display {
    public static final int LIST_ELEMENT = 1;
    public static final int CHOICE_GROUP_ELEMENT = 2;
    public static final int ALERT = 3;
    public static final int COLOR_BACKGROUND = 0;
    public static final int COLOR_FOREGROUND = 1;
    public static final int COLOR_HIGHLIGHTED_BACKGROUND = 2;
    public static final int COLOR_HIGHLIGHTED_FOREGROUND = 3;
    public static final int COLOR_BORDER = 4;
    public static final int COLOR_HIGHLIGHTED_BORDER = 5;
    private Displayable current;
    private static Display display;
    public Vector<Runnable> serialCalls;
    private Timer timer;
    private SerialCallTimerTask timertask;

    public Display() {
        display = this;
        Mobile.setDisplay(this);
        this.serialCalls = new Vector(16);
        this.timer = new Timer();
        this.timertask = new SerialCallTimerTask();
        this.timer.schedule((TimerTask)this.timertask, 0L, 17L);
    }

    public void callSerially(Runnable r) {
        this.serialCalls.add(r);
    }

    public boolean flashBacklight(int duration) {
        return true;
    }

    public int getBestImageHeight(int imageType) {
        switch (imageType) {
            case 1: {
                return Mobile.getPlatform().lcdHeight / 8;
            }
            case 2: {
                return Mobile.getPlatform().lcdHeight / 8;
            }
            case 3: {
                return Mobile.getPlatform().lcdHeight;
            }
        }
        return Mobile.getPlatform().lcdHeight;
    }

    public int getBestImageWidth(int imageType) {
        return Mobile.getPlatform().lcdWidth;
    }

    public int getBorderStyle(boolean highlighted) {
        return 0;
    }

    public int getColor(int colorSpecifier) {
        switch (colorSpecifier) {
            case 0: {
                return 0;
            }
            case 1: {
                return 0xFFFFFF;
            }
            case 2: {
                return 0xFFFFFF;
            }
            case 3: {
                return 0;
            }
            case 4: {
                return 0x808080;
            }
            case 5: {
                return 0xFFFFFF;
            }
        }
        return 0;
    }

    public Displayable getCurrent() {
        return this.current;
    }

    public static Display getDisplay(MIDlet m) {
        return display;
    }

    public boolean isColor() {
        return true;
    }

    public int numAlphaLevels() {
        return 256;
    }

    public int numColors() {
        return 0x1000000;
    }

    public void setCurrent(Displayable next) {
        try {
            next.showNotify();
            this.current = next;
            this.current.notifySetCurrent();
            Mobile.getPlatform().flushGraphics(this.current.platformImage, 0, 0, this.current.width, this.current.height);
        }
        catch (Exception e) {
            System.out.println("Problem with setCurrent(next)");
            e.printStackTrace();
        }
    }

    public void setCurrent(Alert alert, Displayable next) {
        try {
            this.setCurrent(alert);
            alert.setNextScreen(next);
        }
        catch (Exception e) {
            System.out.println("Problem with setCurrent(alert, next)");
            e.printStackTrace();
        }
    }

    public void setCurrentItem(Item item) {
        System.out.println("Display.setCurrentItem");
    }

    public boolean vibrate(int duration) {
        return true;
    }

    private class SerialCallTimerTask
    extends TimerTask {
        private SerialCallTimerTask() {
        }

        @Override
        public void run() {
            if (!Display.this.serialCalls.isEmpty()) {
                try {
                    Display.this.serialCalls.get(0).run();
                    Display.this.serialCalls.removeElement(0);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

