/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import org.recompile.mobile.PlatformFont;

public final class Font {
    public static final int FACE_MONOSPACE = 32;
    public static final int FACE_PROPORTIONAL = 64;
    public static final int FACE_SYSTEM = 0;
    public static final int FONT_INPUT_TEXT = 1;
    public static final int FONT_STATIC_TEXT = 0;
    public static final int SIZE_LARGE = 16;
    public static final int SIZE_MEDIUM = 0;
    public static final int SIZE_SMALL = 8;
    public static final int STYLE_BOLD = 1;
    public static final int STYLE_ITALIC = 2;
    public static final int STYLE_PLAIN = 0;
    public static final int STYLE_UNDERLINED = 4;
    private int face;
    private int style;
    private int size;
    private static Font defaultFont = new Font(0, 0, 0);
    public PlatformFont platformFont;

    private Font(int fontFace, int fontStyle, int fontSize) {
        this.face = fontFace;
        this.style = fontStyle;
        this.size = fontSize;
        this.platformFont = new PlatformFont(this);
    }

    public int charsWidth(char[] ch, int offset, int length) {
        int len = 0;
        for (int i = offset; i < ch.length + length; ++i) {
            if (i >= ch.length) continue;
            len += this.charWidth(ch[i]);
        }
        return len;
    }

    public int charWidth(char ch) {
        return this.stringWidth(String.valueOf(ch));
    }

    public int getBaselinePosition() {
        return this.convertSize(this.size);
    }

    public static Font getDefaultFont() {
        return defaultFont;
    }

    public int getFace() {
        return this.face;
    }

    public static Font getFont(int fontSpecifier) {
        return defaultFont;
    }

    public static Font getFont(int face, int style, int size) {
        return new Font(face, style, size);
    }

    public int getHeight() {
        return this.convertSize(this.size);
    }

    public int getSize() {
        return this.size;
    }

    public int getPointSize() {
        return this.convertSize(this.size);
    }

    public int getStyle() {
        return this.style;
    }

    public boolean isBold() {
        return (this.style & 1) == 1;
    }

    public boolean isItalic() {
        return (this.style & 2) == 2;
    }

    public boolean isPlain() {
        return this.style == 0;
    }

    public boolean isUnderlined() {
        return (this.style & 4) == 4;
    }

    public int stringWidth(String str) {
        return this.platformFont.stringWidth(str);
    }

    public int substringWidth(String str, int offset, int len) {
        return this.stringWidth(str.substring(offset, offset + len));
    }

    private int convertSize(int size) {
        switch (size) {
            case 16: {
                return 14;
            }
            case 0: {
                return 12;
            }
            case 8: {
                return 10;
            }
        }
        return 10;
    }
}

