/*
 * Decompiled with CFR 0.152.
 */
package org.recompile.mobile;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import javax.microedition.midlet.MIDlet;
import javax.microedition.midlet.MIDletStateChangeException;
import org.objectweb.asm.ClassAdapter;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodAdapter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;

public class MIDletLoader
extends URLClassLoader {
    public String name;
    public String icon;
    private String className;
    public String suitename;
    private Class<?> mainClass;
    private MIDlet mainInst;
    private HashMap<String, String> properties = new HashMap(32);

    public MIDletLoader(URL[] urls) {
        super(urls);
        try {
            System.setProperty("microedition.platform", "j2me");
            System.setProperty("microedition.profiles", "MIDP-2.0");
            System.setProperty("microedition.configuration", "CLDC-1.0");
            System.setProperty("microedition.locale", "en-US");
            System.setProperty("microedition.encoding", "file.encoding");
        }
        catch (Exception e) {
            System.out.println("Can't add CLDC System Properties");
        }
        try {
            this.loadManifest();
            this.properties.put("microedition.platform", "j2me");
            this.properties.put("microedition.profiles", "MIDP-2.0");
            this.properties.put("microedition.configuration", "CLDC-1.0");
            this.properties.put("microedition.locale", "en-US");
            this.properties.put("microedition.encoding", "file.encoding");
        }
        catch (Exception e) {
            System.out.println("Can't Read Manifest!");
            return;
        }
    }

    public void start() throws MIDletStateChangeException {
        Method start;
        try {
            this.mainClass = this.loadClass(this.className, true);
            Constructor<?> constructor = this.mainClass.getConstructor(new Class[0]);
            constructor.setAccessible(true);
            MIDlet.initAppProperties(this.properties);
            this.mainInst = (MIDlet)constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            System.out.println("Problem Constructing " + this.name + " class: " + this.className);
            System.out.println("Reason: " + e.getMessage());
            e.printStackTrace();
            System.exit(0);
            return;
        }
        try {
            start = this.mainClass.getDeclaredMethod("startApp", new Class[0]);
            start.setAccessible(true);
        }
        catch (Exception e) {
            try {
                this.mainClass = this.loadClass(this.mainClass.getSuperclass().getName(), true);
                start = this.mainClass.getDeclaredMethod("startApp", new Class[0]);
                start.setAccessible(true);
            }
            catch (Exception f) {
                System.out.println("Can't Find startApp Method");
                f.printStackTrace();
                System.exit(0);
                return;
            }
        }
        try {
            start.invoke((Object)this.mainInst, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(0);
        }
    }

    private void loadManifest() {
        String resource = "META-INF/MANIFEST.MF";
        URL url = this.findResource(resource);
        if (url == null) {
            return;
        }
        try {
            String line;
            InputStream is = url.openStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            while ((line = br.readLine()) != null) {
                int split;
                if (line.startsWith("MIDlet-1:")) {
                    System.out.println(line);
                    line = line.substring(9);
                    String[] parts = line.split(",");
                    if (parts.length == 3) {
                        this.name = parts[0].trim();
                        this.icon = parts[1].trim();
                        this.className = parts[2].trim();
                        this.suitename = this.name;
                    }
                }
                if ((split = line.indexOf(":")) <= 0) continue;
                String key = line.substring(0, split).trim();
                String value = line.substring(split + 1).trim();
                this.properties.put(key, value);
            }
            this.suitename = this.suitename.replace(":", "");
        }
        catch (Exception e) {
            System.out.println("Can't Read Jar Manifest!");
            e.printStackTrace();
        }
    }

    @Override
    public InputStream getResourceAsStream(String resource) {
        if (resource.startsWith("/")) {
            resource = resource.substring(1);
        }
        try {
            URL url = this.findResource(resource);
            return url.openStream();
        }
        catch (Exception e) {
            System.out.println(resource + " Not Found");
            return super.getResourceAsStream(resource);
        }
    }

    @Override
    public URL getResource(String resource) {
        if (resource.startsWith("/")) {
            resource = resource.substring(1);
        }
        try {
            URL url = this.findResource(resource);
            return url;
        }
        catch (Exception e) {
            System.out.println(resource + " Not Found");
            return super.getResource(resource);
        }
    }

    public InputStream getMIDletResourceAsStream(String resource) {
        URL url = this.getResource(resource);
        try {
            InputStream stream = url.openStream();
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            int count = 0;
            byte[] data = new byte[4096];
            while (count != -1) {
                count = stream.read(data);
                if (count == -1) continue;
                buffer.write(data, 0, count);
            }
            return new ByteArrayInputStream(buffer.toByteArray());
        }
        catch (Exception e) {
            return super.getResourceAsStream(resource);
        }
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        if (name.startsWith("java.") || name.startsWith("javax.") || name.startsWith("com.nokia") || name.startsWith("com.mascotcapsule") || name.startsWith("com.samsung") || name.startsWith("sun.") || name.startsWith("com.siemens") || name.startsWith("org.recompile")) {
            return this.loadClass(name, true);
        }
        try {
            String resource = name.replace(".", "/") + ".class";
            InputStream stream = super.getResourceAsStream(resource);
            byte[] code = this.instrument(stream);
            return this.defineClass(name, code, 0, code.length);
        }
        catch (Exception e) {
            System.out.println("Error Adapting Class " + name);
            return null;
        }
    }

    private byte[] instrument(InputStream stream) throws Exception {
        ClassReader reader = new ClassReader(stream);
        ClassWriter writer = new ClassWriter(0);
        ASMVisitor visitor = new ASMVisitor(writer);
        reader.accept(visitor, 0);
        return writer.toByteArray();
    }

    private class ASMVisitor
    extends ClassAdapter {
        public ASMVisitor(ClassVisitor visitor) {
            super(visitor);
        }

        @Override
        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            super.visit(version, access, name, signature, superName, interfaces);
        }

        @Override
        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            return new ASMMethodVisitor(super.visitMethod(access, name, desc, signature, exceptions));
        }

        private class ASMMethodVisitor
        extends MethodAdapter
        implements Opcodes {
            public ASMMethodVisitor(MethodVisitor visitor) {
                super(visitor);
            }

            @Override
            public void visitMethodInsn(int opcode, String owner, String name, String desc) {
                if (opcode == 182 && name.equals("getResourceAsStream") && owner.equals("java/lang/Class")) {
                    this.mv.visitMethodInsn(184, "org/recompile/mobile/Mobile", name, "(Ljava/lang/Class;Ljava/lang/String;)Ljava/io/InputStream;");
                } else {
                    this.mv.visitMethodInsn(opcode, owner, name, desc);
                }
            }
        }
    }
}

