/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Hero {
    private MyCanvas canvas;
    public int xPosition;
    public int yPosition;
    public int width;
    public int height;
    public byte dir = 1;
    public byte frame;
    public byte bowPos = 1;
    private byte heroOffY;
    public byte frameCtr;
    public byte framePtr;
    public byte yVel;
    public int jumpCtr;
    public int jumpLimit;
    public boolean JumpHtReached;
    public byte actionFrmPtr = 0;
    public boolean isHit = false;
    private byte hitCounter = 0;
    public boolean swordLock = false;
    public boolean singleSordAttack = false;
    public byte weapon = 0;
    public boolean fireArrow;
    private byte waitCtr;
    public boolean isDead;
    private boolean isEnd;
    public byte swordCount;
    public boolean isInFight;
    public short fallHeight;
    public boolean blockHero;
    public boolean isNextDoor = false;
    public byte ctr = 0;
    public int xDist = 0;
    public int yDist = 0;
    public byte action = 0;
    public static final byte STAND = 0;
    public static final byte RUN = 1;
    public static final byte JUMP = 2;
    public static final byte EDGE_HANG = 3;
    public static final byte EDGE_CLIMB = 4;
    public static final byte FALL = 6;
    public static final byte CROUCH = 8;
    public static final byte CROUCH_ROLL = 28;
    public static final byte SLIDE = 9;
    public static final byte TOP_EDGE_CLIMB = 16;
    public static final byte TOP_EDGE_GETDOWN = 17;
    public static final byte SWORD_1 = 25;
    public static final byte SWORD_2 = 26;
    public static final byte SWORD_3 = 27;
    public static final byte CHAIN_SWING = 29;
    public static final byte ROPE_CLIMB = 30;
    public static final byte KNIFE_THROW = 31;
    public static final byte DEFENCE = 34;
    public static final byte HURT = 35;
    public static final byte DIE = 36;
    public static final byte KICK_FIGHT = 37;
    public static final byte GO_BLIND = 38;
    public static final byte ROPE_HANG = 39;
    public static final byte DOOR_PANNING = 40;
    public static final byte GOING_INSIDE_DOOR = 41;
    public static final byte GOING_OUT_DOOR = 42;
    public static final byte HORIZONTAL_DOOR_PANNING = 43;
    public byte imageNo;
    private byte imageRotation;
    public static Image[] image;
    public short[] heroClipping = new short[]{0, 0, 28, 64, 28, 1, 28, 63, 56, 5, 64, 59, 120, 5, 64, 59, 184, 6, 64, 58, 248, 5, 64, 59, 312, 4, 64, 60, 376, 4, 64, 60, 440, 5, 64, 59, 504, 6, 64, 58, 0, 22, 32, 59, 32, 14, 31, 67, 32, 14, 31, 67, 63, 14, 38, 67, 101, 0, 66, 80, 168, 1, 67, 80, 101, 0, 67, 81, 235, 22, 70, 59, 0, 0, 32, 59, 32, 9, 59, 50, 91, 16, 39, 43, 130, 30, 43, 29, 173, 15, 39, 44, 212, 18, 40, 41, 0, 0, 32, 59, 0, 0, 33, 54, 34, 0, 33, 61, 68, 0, 32, 59, 68, 0, 32, 59, 68, 0, 32, 59, 0, 0, 33, 54, 34, 0, 33, 61, 101, 0, 42, 56, 0, 8, 38, 61, 39, 0, 88, 71, 127, 19, 62, 50, 0, 0, 28, 81, 28, 6, 33, 75, 0, 0, 28, 81, 61, 10, 28, 71, 89, 27, 29, 54, 118, 6, 25, 75, 0, 9, 39, 62, 0, 10, 42, 65, 42, 0, 101, 75, 143, 22, 73, 53, 0, 0, 37, 58, 37, 7, 71, 51, 108, 3, 55, 55, 0, 0, 37, 58, 143, 15, 63, 66, 206, 17, 63, 64, 143, 15, 63, 66, 206, 17, 63, 64, 143, 15, 63, 66, 0, 0, 53, 61, 53, 1, 44, 60, 97, 0, 43, 61, 140, 3, 46, 58, 0, 0, 30, 64, 30, 5, 32, 59, 62, 0, 30, 64, 92, 5, 38, 58, 130, 28, 55, 36, 185, 51, 70, 13, 0, 0, 32, 59, 32, 3, 63, 56, 0, 0, 32, 59, 95, 2, 63, 57, 0, 0, 32, 59, 158, 10, 32, 49, 190, 5, 52, 54, 242, 6, 64, 53, 310, 6, 65, 53, 379, 6, 45, 53, 0, 0, 32, 59, 0, 17, 39, 62, 0, 17, 40, 62, 40, 0, 100, 79, 140, 26, 73, 53, 0, 0, 43, 77, 43, 0, 49, 32, 94, 0, 94, 97, 0, 77, 61, 42, 43, 32, 51, 45, 0, 0, 29, 66, 30, 0, 29, 66, 60, 0, 32, 66, 0, 0, 22, 64, 22, 1, 18, 63, 40, 0, 26, 64, 66, 1, 28, 63, 94, 0, 28, 64, 0, 0, 28, 64, 28, 0, 26, 64, 54, 0, 28, 64, 56, 6, 40, 58, 96, 7, 49, 57, 145, 5, 47, 59, 192, 6, 35, 58, 227, 6, 48, 58, 275, 7, 45, 57, 0, 8, 32, 59, 32, 0, 32, 67, 32, 0, 32, 67, 64, 23, 39, 44, 103, 28, 44, 39, 147, 23, 39, 44, 186, 28, 44, 39, 32, 0, 32, 67, 32, 0, 32, 67, 0, 8, 32, 59};
    public short[] heroPlacingRt = new short[]{0, 0, 0, 1, -11, 5, -11, 5, -11, 4, -11, 5, -11, 4, -11, 4, -11, 3, -11, 5, 3, 5, 2, -6, 2, -17, -4, -20, -27, -27, -27, -19, -27, -17, -29, 5, 5, 5, 0, 14, 0, 21, 0, 35, 0, 20, -1, 23, 5, 5, 18, 0, 13, 0, 9, -4, -2, -27, 2, -41, 22, -4, 17, -4, 28, -30, 3, 2, 5, -7, 5, 14, -20, 0, -25, -3, 0, -17, 0, -12, 1, -9, 1, -16, 2, 2, 5, -1, -12, -11, -24, 11, 2, 6, 0, 13, 0, 9, 2, 6, -26, -5, -26, -3, -26, -5, -26, -3, -26, -5, 0, 6, 11, 6, 12, 6, 11, 7, -11, 0, -19, 6, -11, 0, -22, 5, -36, 28, -52, 51, 3, 5, 3, 8, 3, 5, 3, 7, 3, 5, -3, -4, -11, 10, 4, 11, 4, 11, 1, 11, 3, 5, 2, 2, 2, 2, 8, -15, 3, 11, 0, -9, -1, 35, 0, 0, 24, 26, 27, 13, 2, 0, -2, 0, -1, 0, 3, 0, 13, 1, 12, 0, 21, -4, 21, -5, -2, 0, 4, 6, 5, 6, 9, 6, 0, 3, 2, 5, 9, 6, 0, 4, 2, 6, 3, 0, 2, 0, 2, 0, -5, 0, -2, 0, 12, 0, -2, 0, 8, 0, 8, 0, 9, 0};
    private short[] heroPlacingLf = new short[]{0, 0, 0, 1, -25, 5, -25, 5, -25, 4, -25, 5, -25, 4, -25, 4, -25, 3, -25, 5, -7, 5, -5, -6, -6, -17, -6, -20, -12, -27, -12, -19, -12, -17, -13, 5, -9, 5, -31, 14, -11, 21, -15, 35, -11, 20, -11, 23, -9, 5, -1, 0, 0, 0, 8, -4, 19, -27, 15, -41, -1, -4, -1, -4, -21, -30, -14, 2, -65, -7, -39, 14, -4, 0, -3, -3, 18, -17, 18, -12, 16, -9, 16, -16, -13, 2, -19, -1, -61, -11, -21, 11, -11, 6, -43, 13, -27, 9, -11, 6, -9, -5, -9, -3, -9, -5, -9, -3, -9, -5, -9, 6, -11, 6, -11, 6, -13, 7, 9, 0, 15, 6, 9, 0, 12, 5, 9, 28, 10, 51, -7, 5, -38, 8, -7, 5, -38, 7, -7, 5, -1, -4, -13, 10, -44, 11, -45, 11, -18, 11, -7, 5, -13, 2, -13, 2, -80, -15, -48, 11, 0, -9, -1, 35, 0, 0, 24, 26, 27, 13, 2, 0, -2, 0, -1, 0, 3, 0, -3, 1, -10, 0, -21, -4, -21, -5, 2, 0, -2, 6, -5, 6, -21, 6, -21, 3, -21, 5, -16, 6, -20, 4, -19, 6, -7, 0, -6, 0, -6, 0, -6, 0, -14, 0, -23, 0, -14, 0, -12, 0, -12, 0, -13, 0};
    public byte[] framePos = new byte[]{0, 96, 10, 18, 25, 30, 33, 36, 38, 42, 46, 50, 55, 59, 65, 76, 80, 85, 88, 93, 96, 102};
    public byte[] framePos1 = new byte[]{0, 2, 8, 16, 23, 30};

    public Hero(int xPosition, int yPosition, int width, int height, int direction, boolean hidden, MyCanvas canvas) {
        this.canvas = canvas;
        this.xPosition = xPosition;
        this.yPosition = yPosition;
        this.width = width;
        this.height = height;
        this.dir = (byte)direction;
        if (MyCanvas.gameLevel == 0) {
            this.heroClipping = canvas.convertBytetoShort(canvas.readFile("/heroClip"));
            this.heroPlacingRt = canvas.convertBytetoShort(canvas.readFile("/heroClipRt"));
            this.heroPlacingLf = canvas.convertBytetoShort(canvas.readFile("/heroClipLf"));
        }
    }

    public static void initResources() {
        try {
            switch (MyCanvas.gameLevel) {
                case 0: {
                    try {
                        image = new Image[5];
                        if (image[0] == null) {
                            Hero.image[0] = Image.createImage((String)"/intro_h_st_run.png");
                        }
                    }
                    catch (Exception e) {
                        System.out.println("Error in initResources() Image intro_h_st_run.png has not been loaded");
                    }
                    try {
                        if (image[1] == null) {
                            Hero.image[1] = Image.createImage((String)"/lenord_h_attack.png");
                        }
                    }
                    catch (Exception e) {
                        System.out.println("Error in initResources() Image lenord_h_attack.png has not been loaded");
                    }
                    try {
                        if (image[2] == null) {
                            Hero.image[2] = Image.createImage((String)"/lenord_h_kick.png");
                        }
                    }
                    catch (Exception e) {
                        System.out.println("Error in initResources() Image lenord_h_kick.png has not been loaded");
                    }
                    try {
                        if (image[3] == null) {
                            Hero.image[3] = Image.createImage((String)"/lenord_h_die.png");
                        }
                    }
                    catch (Exception e) {
                        System.out.println("Error in initResources() Image lenord_h_die.png has not been loaded");
                    }
                    try {
                        if (image[4] == null) {
                            Hero.image[4] = Image.createImage((String)"/lenord_h_punch.png");
                        }
                    }
                    catch (Exception e) {
                        System.out.println("Error in initResources() Image lenord_h_punch.png has not been loaded");
                    }
                    break;
                }
                default: {
                    image = new Image[16];
                    try {
                        if (image[0] == null) {
                            Hero.image[0] = Image.createImage((String)"/h_st_run.png");
                        }
                    }
                    catch (Exception e) {
                        System.out.println("Error in initResources() Image h_st_run.png has not been loaded");
                    }
                    try {
                        if (image[1] == null) {
                            Hero.image[1] = Image.createImage((String)"/h_jump.png");
                        }
                    }
                    catch (Exception e) {
                        System.out.println("Error in initResources() Image h_jump.png has not been loaded");
                    }
                    try {
                        if (image[2] == null) {
                            Hero.image[2] = Image.createImage((String)"/h_crouch.png");
                        }
                    }
                    catch (Exception e) {
                        System.out.println("Error in initResources() Image h_crouch.png has not been loaded");
                    }
                    try {
                        if (image[3] == null) {
                            Hero.image[3] = Image.createImage((String)"/h_eg_hang.png");
                        }
                    }
                    catch (Exception e) {
                        System.out.println("Error in initResources() Image h_eg_hang.png has not been loaded");
                    }
                    try {
                        if (image[4] == null) {
                            Hero.image[4] = Image.createImage((String)"/h_sword1.png");
                        }
                    }
                    catch (Exception e) {
                        System.out.println("Error in initResources() Image h_sword1.png has not been loaded");
                    }
                    try {
                        if (image[5] == null) {
                            Hero.image[5] = Image.createImage((String)"/h_rope.png");
                        }
                    }
                    catch (Exception e) {
                        System.out.println("Error in initResources() Image h_rope.png has not been loaded");
                    }
                    try {
                        if (image[6] == null) {
                            Hero.image[6] = Image.createImage((String)"/h_sword2.png");
                        }
                    }
                    catch (Exception e) {
                        System.out.println("Error in initResources() Image h_sword2.png has not been loaded");
                    }
                    Hero.image[7] = Image.createImage((String)"/h_knife.png");
                    try {
                        if (image[8] == null) {
                            Hero.image[8] = Image.createImage((String)"/h_sword3.png");
                        }
                    }
                    catch (Exception e) {
                        System.out.println("Error in initResources() Image h_sword3.png has not been loaded");
                    }
                    try {
                        if (image[9] == null) {
                            Hero.image[9] = Image.createImage((String)"/h_hurt_die.png");
                        }
                    }
                    catch (Exception e) {
                        System.out.println("Error in initResources() Image h_hurt_die.png has not been loaded");
                    }
                    try {
                        if (image[10] == null) {
                            Hero.image[10] = Image.createImage((String)"/h_kick.png");
                        }
                    }
                    catch (Exception e) {
                        System.out.println("Error in initResources() Image h_kick.png has not been loaded");
                    }
                    try {
                        if (image[12] == null) {
                            Hero.image[12] = Image.createImage((String)"/h_climb.png");
                        }
                    }
                    catch (Exception e) {
                        System.out.println("Error in initResources() Image h_climb.png has not been loaded");
                    }
                    try {
                        if (image[13] == null) {
                            Hero.image[13] = Image.createImage((String)"/h_going_in.png");
                        }
                    }
                    catch (Exception e) {
                        System.out.println("Error in initResources() Image h_going_in.png has not been loaded");
                    }
                    try {
                        if (image[14] == null) {
                            Hero.image[14] = Image.createImage((String)"/h_going_out.png");
                        }
                        break;
                    }
                    catch (Exception e) {
                        System.out.println("Error in initResources() Image h_going_out.png has not been loaded");
                    }
                }
            }
        }
        catch (Exception e) {
            System.out.println("Error in Hero Image Creation :" + e.toString());
        }
    }

    void updateHero() {
        try {
            switch (this.action) {
                case 0: {
                    if (MyCanvas.haveKeyPressed(4)) {
                        this.dir = 1;
                    } else if (MyCanvas.haveKeyPressed(64)) {
                        this.dir = (byte)-1;
                    } else if (MyCanvas.haveKeyHold(4)) {
                        this.action = 1;
                        this.dir = 1;
                    } else if (MyCanvas.haveKeyHold(64)) {
                        this.action = 1;
                        this.dir = (byte)-1;
                    }
                    if (MyCanvas.haveKeyPressed(1)) {
                        if ((MyCanvas.isReadyToClimbOnRope || MyCanvas.isReadyToClimbOnRope2) && !MyCanvas.isReadyToGetDown) {
                            this.xPosition = this.canvas.ladderOffX - 27;
                            this.action = (byte)39;
                            break;
                        }
                        this.action = (byte)2;
                        this.frame = (byte)-1;
                        this.jumpLimit = 4;
                        this.jumpCtr = 0;
                        this.JumpHtReached = false;
                        break;
                    }
                    if (MyCanvas.haveKeyPressed(16)) {
                        if (MyCanvas.isReadyToGetDown) {
                            this.xPosition = this.canvas.ladderOffX;
                            this.action = (byte)39;
                            break;
                        }
                        this.action = (byte)8;
                        break;
                    }
                    if (MyCanvas.haveKeyPressed(32)) {
                        this.action = (byte)25;
                        this.canvas.playSound(3);
                        this.frame = 0;
                        this.frameCtr = 0;
                        break;
                    }
                    if (MyCanvas.haveKeyPressed(256)) {
                        this.action = (byte)26;
                        this.singleSordAttack = true;
                        this.canvas.playSound(3);
                        this.frame = 0;
                        this.swordCount = 0;
                        break;
                    }
                    if (MyCanvas.haveKeyPressed(8)) {
                        this.action = (byte)37;
                        this.canvas.playSound(1);
                        this.frame = 0;
                        this.swordCount = 0;
                        break;
                    }
                    if (MyCanvas.haveKeyPressed(2048) && this.canvas.knifeCount > 0) {
                        this.action = (byte)31;
                        this.canvas.playSound(2);
                        this.frame = 0;
                        this.frameCtr = 0;
                        this.weapon = 1;
                        this.canvas.knifeCount = (byte)(this.canvas.knifeCount - 1);
                        break;
                    }
                    if (MyCanvas.haveKeyPressed(128)) {
                        this.action = (byte)2;
                        this.frame = (byte)-1;
                        this.jumpLimit = 4;
                        this.jumpCtr = 0;
                        this.JumpHtReached = false;
                        this.dir = (byte)-1;
                        break;
                    }
                    if (!MyCanvas.haveKeyPressed(2)) break;
                    this.action = (byte)2;
                    this.frame = (byte)-1;
                    this.jumpLimit = 4;
                    this.jumpCtr = 0;
                    this.JumpHtReached = false;
                    this.dir = 1;
                    break;
                }
                case 1: {
                    if (MyCanvas.haveKeyReleased(4) || MyCanvas.haveKeyReleased(64)) {
                        this.action = 0;
                        this.frame = 0;
                        this.frameCtr = 0;
                    }
                    if (MyCanvas.haveKeyHold(4)) {
                        this.action = 1;
                        this.dir = 1;
                    } else if (MyCanvas.haveKeyHold(64)) {
                        this.action = 1;
                        this.dir = (byte)-1;
                    } else if (MyCanvas.haveKeyPressed(16)) {
                        this.action = (byte)8;
                    } else if (MyCanvas.haveKeyPressed(32)) {
                        this.action = MyCanvas.random(0, 10) < 2 ? (byte)27 : (byte)(MyCanvas.random(0, 10) < 3 ? 26 : 25);
                        this.frame = 0;
                        this.swordCount = 0;
                    } else if (MyCanvas.haveKeyPressed(256)) {
                        this.action = (byte)27;
                        this.canvas.playSound(3);
                        this.frame = (byte)-1;
                        this.swordCount = 0;
                    } else if (MyCanvas.haveKeyPressed(8)) {
                        // empty if block
                    }
                    if (!MyCanvas.haveKeyPressed(1)) break;
                    this.action = (byte)2;
                    this.frame = (byte)-1;
                    this.jumpLimit = 4;
                    this.jumpCtr = 0;
                    this.JumpHtReached = false;
                    break;
                }
                case 25: {
                    if (!MyCanvas.haveKeyPressed(32)) break;
                    this.swordCount = (byte)(this.swordCount + 1);
                    break;
                }
                case 8: {
                    if (!MyCanvas.isWallAbove && MyCanvas.haveKeyPressed(1)) {
                        this.action = 0;
                        this.frame = 0;
                        this.frameCtr = 0;
                        break;
                    }
                    if (MyCanvas.haveKeyPressed(64)) {
                        if (this.dir == -1) {
                            this.action = (byte)28;
                            this.frame = 0;
                            break;
                        }
                        this.dir = (byte)-1;
                        break;
                    }
                    if (MyCanvas.haveKeyPressed(4)) {
                        if (this.dir == 1) {
                            this.action = (byte)28;
                            this.frame = 0;
                            break;
                        }
                        this.dir = 1;
                        break;
                    }
                    if (MyCanvas.isWallAbove || !MyCanvas.haveKeyPressed(256)) break;
                    this.action = (byte)(MyCanvas.random(0, 6) < 3 ? 37 : 25);
                    if (this.action == 37) {
                        this.canvas.playSound(1);
                    } else {
                        this.canvas.playSound(3);
                    }
                    this.frame = 0;
                    this.swordCount = 0;
                    break;
                }
                case 2: {
                    MyCanvas.startFalling = false;
                    if (!MyCanvas.haveKeyHold(1) || this.jumpLimit >= 4) break;
                    ++this.jumpLimit;
                    break;
                }
                case 9: {
                    if (MyCanvas.haveKeyPressed(1)) {
                        this.action = (byte)2;
                        this.frame = (byte)-1;
                        this.jumpLimit = 4;
                        this.jumpCtr = 0;
                        this.JumpHtReached = false;
                    }
                    if (MyCanvas.haveKeyPressed(128)) {
                        this.action = (byte)2;
                        this.frame = (byte)-1;
                        this.jumpLimit = 4;
                        this.jumpCtr = 0;
                        this.JumpHtReached = false;
                        this.dir = (byte)-1;
                        break;
                    }
                    if (!MyCanvas.haveKeyPressed(2)) break;
                    this.action = (byte)2;
                    this.frame = (byte)-1;
                    this.jumpLimit = 4;
                    this.jumpCtr = 0;
                    this.JumpHtReached = false;
                    this.dir = 1;
                    break;
                }
                case 3: {
                    if (MyCanvas.haveKeyPressed(1)) {
                        if (MyCanvas.isReadyToClimb) {
                            this.action = (byte)16;
                            this.xPosition = this.canvas.edgeOffX;
                            this.yPosition = this.canvas.edgeOffY;
                            break;
                        }
                        this.action = (byte)4;
                        this.frame = 0;
                        break;
                    }
                    if (MyCanvas.haveKeyPressed(16)) {
                        this.action = (byte)6;
                        this.yPosition += 24 >> 1;
                        break;
                    }
                    if (this.dir > 0 && (MyCanvas.haveKeyPressed(64) || MyCanvas.haveKeyPressed(128))) {
                        this.action = (byte)2;
                        this.dir = (byte)-1;
                        this.frame = (byte)-1;
                        this.jumpLimit = 3;
                        this.jumpCtr = 0;
                        this.JumpHtReached = false;
                        break;
                    }
                    if (this.dir >= 0 || !MyCanvas.haveKeyPressed(4) && !MyCanvas.haveKeyPressed(2)) break;
                    this.action = (byte)2;
                    this.dir = 1;
                    this.frame = (byte)-1;
                    this.jumpLimit = 3;
                    this.jumpCtr = 0;
                    this.JumpHtReached = false;
                    break;
                }
                case 39: {
                    this.imageNo = (byte)12;
                    this.actionFrmPtr = (byte)17;
                    if (MyCanvas.haveKeyHold(1)) {
                        if (MyCanvas.isReadyToGetDown) {
                            this.action = 0;
                            break;
                        }
                        this.yPosition -= 6;
                        this.frameCtr = (byte)(this.frameCtr + 1);
                        if (this.frameCtr <= 1) break;
                        this.frame = (byte)(this.frame + 1);
                        if (this.frame > 1) {
                            this.frame = 0;
                        }
                        this.frameCtr = 0;
                        break;
                    }
                    if (!MyCanvas.haveKeyHold(16)) break;
                    if (MyCanvas.isGroundTouched && (MyCanvas.isReadyToClimbOnRope || MyCanvas.isReadyToClimbOnRope2) && !MyCanvas.isReadyToGetDown) {
                        this.action = 0;
                        break;
                    }
                    this.yPosition += 12;
                    this.frame = 0;
                    break;
                }
                case 6: {
                    if (MyCanvas.haveKeyHold(4) || MyCanvas.haveKeyHold(2)) {
                        if (!MyCanvas.isReadyToClimb) break;
                        this.action = (byte)3;
                        this.xPosition = this.canvas.edgeOffX;
                        this.yPosition = this.canvas.edgeOffY;
                        this.frame = (byte)-1;
                        break;
                    }
                    if (!MyCanvas.haveKeyHold(64) && !MyCanvas.haveKeyHold(128) || !MyCanvas.isReadyToClimb) break;
                    this.action = (byte)3;
                    this.xPosition = this.canvas.edgeOffX;
                    this.yPosition = this.canvas.edgeOffY;
                    this.frame = (byte)-1;
                    break;
                }
                case 30: {
                    if (MyCanvas.haveKeyPressed(128) || MyCanvas.haveKeyPressed(2) || MyCanvas.haveKeyPressed(64) || MyCanvas.haveKeyPressed(4)) {
                        this.action = (byte)2;
                        this.dir = (byte)(MyCanvas.haveKeyPressed(128) || MyCanvas.haveKeyPressed(64) ? -1 : 1);
                        this.frame = (byte)-1;
                        this.jumpLimit = 3;
                        this.jumpCtr = 0;
                        this.xPosition += (this.width >> 1) * this.dir;
                        this.JumpHtReached = false;
                        MyCanvas.isOnRope = false;
                    } else if (MyCanvas.haveKeyPressed(1) || MyCanvas.haveKeyHold(1)) {
                        this.frameCtr = (byte)(this.frameCtr + 1);
                        if (this.frameCtr >= 2) {
                            this.frameCtr = 0;
                            this.frame = (byte)(this.frame + 1);
                        }
                        if (!MyCanvas.isUpsideCollided) {
                            this.yPosition -= 3;
                        }
                    } else if (MyCanvas.haveKeyPressed(16) || MyCanvas.haveKeyHold(16)) {
                        this.frame = 0;
                        this.yPosition += 6;
                    } else {
                        this.frame = 0;
                    }
                    if (MyCanvas.haveKeyPressed(64)) {
                        this.dir = (byte)-1;
                        break;
                    }
                    if (!MyCanvas.haveKeyPressed(4)) break;
                    this.dir = 1;
                }
            }
        }
        catch (Exception e) {
            System.out.println("err in updateHero>>" + e);
        }
    }

    void update() {
        try {
            byte by = this.canvas.currPage;
            this.canvas.getClass();
            if (by != 18 && !this.blockHero) {
                this.updateHero();
            }
            if (this.dir == 1) {
                this.imageRotation = 0;
                this.canvas.HeroXposOnScr = (MyCanvas.canvasWidth >> 1) - this.width;
            } else {
                this.imageRotation = (byte)2;
                this.canvas.HeroXposOnScr = MyCanvas.canvasWidth >> 1;
            }
            if (this.action != 6) {
                this.fallHeight = 0;
            }
            switch (this.action) {
                case 0: {
                    this.weapon = 0;
                    this.actionFrmPtr = 0;
                    this.frameCtr = (byte)(this.frameCtr + 1);
                    if (this.frameCtr > 3) {
                        this.frame = (byte)(this.frame + 1);
                        this.frameCtr = 0;
                    }
                    this.imageNo = 0;
                    if (this.frame > 1) {
                        this.frame = 0;
                    }
                    if (MyCanvas.isGroundTouched || MyCanvas.isOnChain || MyCanvas.isOnRope) break;
                    this.imageNo = 1;
                    this.frame = (byte)2;
                    this.action = (byte)6;
                    this.actionFrmPtr = (byte)21;
                    break;
                }
                case 1: {
                    this.actionFrmPtr = (byte)20;
                    this.frame = (byte)(this.frame + 1);
                    this.imageNo = 0;
                    if (this.frame > 5) {
                        this.frame = 0;
                    }
                    this.xPosition += 10 * this.dir;
                    if (MyCanvas.isGroundTouched || MyCanvas.isOnChain || MyCanvas.isOnRope) break;
                    this.imageNo = 1;
                    this.frame = (byte)2;
                    this.action = (byte)6;
                    this.actionFrmPtr = (byte)21;
                    break;
                }
                case 8: {
                    this.imageNo = (byte)2;
                    this.actionFrmPtr = (byte)3;
                    this.frame = (byte)5;
                    if (MyCanvas.isGroundTouched || MyCanvas.isOnChain || MyCanvas.isOnRope) break;
                    this.imageNo = 1;
                    this.frame = (byte)2;
                    this.action = (byte)6;
                    this.actionFrmPtr = (byte)21;
                    break;
                }
                case 28: {
                    this.imageNo = (byte)2;
                    this.actionFrmPtr = (byte)3;
                    this.frameCtr = (byte)(this.frameCtr + 1);
                    if (this.frameCtr >= 2) {
                        this.frame = (byte)(this.frame + 1);
                        this.frameCtr = 0;
                    }
                    if (this.frame >= 5) {
                        this.action = (byte)8;
                        this.frame = 0;
                    } else {
                        this.xPosition += 8 * this.dir;
                    }
                    if (MyCanvas.isGroundTouched || MyCanvas.isOnChain || MyCanvas.isOnRope) break;
                    this.imageNo = 1;
                    this.frame = (byte)2;
                    this.action = (byte)6;
                    this.actionFrmPtr = (byte)21;
                    break;
                }
                case 2: {
                    this.actionFrmPtr = (byte)21;
                    this.imageNo = 1;
                    this.xPosition += 14 * this.dir;
                    if (this.JumpHtReached) {
                        if (!MyCanvas.isGroundTouched) {
                            if (this.frame < 8) {
                                this.frame = (byte)(this.frame + 1);
                            }
                            this.action = (byte)6;
                            this.yPosition += 24 >> 1;
                            break;
                        }
                    }
                    if (this.JumpHtReached) {
                        if (MyCanvas.isGroundTouched) {
                            this.frame = 1;
                            this.action = (byte)6;
                            break;
                        }
                    }
                    if (this.jumpCtr >= this.jumpLimit) break;
                    if (this.frame < 5) {
                        this.frame = (byte)(this.frame + 1);
                    }
                    if (this.frame != 0) {
                        this.yPosition -= 24 >> 1;
                        ++this.jumpCtr;
                    }
                    if (this.jumpCtr < this.jumpLimit) break;
                    this.JumpHtReached = true;
                    break;
                }
                case 3: {
                    this.actionFrmPtr = (byte)4;
                    this.imageNo = (byte)3;
                    this.frame = 0;
                    break;
                }
                case 39: {
                    this.imageNo = (byte)12;
                    this.actionFrmPtr = (byte)17;
                    this.dir = 1;
                    if (MyCanvas.isReadyToClimbOnRope || MyCanvas.isReadyToClimbOnRope2 || MyCanvas.isGroundTouched) break;
                    this.imageNo = 1;
                    this.frame = 0;
                    this.action = (byte)6;
                    this.actionFrmPtr = (byte)21;
                    break;
                }
                case 4: {
                    this.actionFrmPtr = (byte)4;
                    this.imageNo = (byte)3;
                    this.frame = (byte)(this.frame + 1);
                    if (this.frame != 4) break;
                    this.action = (byte)6;
                    this.yPosition -= 24 * 2;
                    break;
                }
                case 16: {
                    this.actionFrmPtr = (byte)5;
                    this.imageNo = (byte)3;
                    this.frame = (byte)(this.frame + 1);
                    if (this.frame < 3) break;
                    this.action = 0;
                    this.frame = 0;
                    this.actionFrmPtr = 0;
                    this.imageNo = 0;
                    this.frameCtr = 0;
                    this.yPosition -= this.height;
                    this.xPosition += 24 * 2 * this.dir;
                    break;
                }
                case 17: {
                    this.actionFrmPtr = (byte)5;
                    this.imageNo = (byte)3;
                    this.xPosition = this.canvas.edgeOffX;
                    this.yPosition = this.canvas.edgeOffY;
                    this.frame = (byte)(this.frame - 1);
                    if (this.frame > 0) break;
                    this.action = (byte)3;
                    break;
                }
                case 35: {
                    this.imageNo = (byte)9;
                    this.actionFrmPtr = (byte)13;
                    this.frame = (byte)(this.frame + 1);
                    if (this.canvas.life > 0 && this.frame >= 2) {
                        this.action = 0;
                        this.imageNo = 0;
                        this.actionFrmPtr = 0;
                        this.frame = 0;
                        break;
                    }
                    if (this.canvas.life > 0 || this.frame < 2) break;
                    this.action = (byte)36;
                    break;
                }
                case 36: {
                    this.imageNo = (byte)9;
                    this.actionFrmPtr = (byte)13;
                    this.frame = (byte)(this.frame + 1);
                    if (this.frame == 1) {
                        this.canvas.playSound(6);
                    }
                    if (this.frame < 6) break;
                    this.frame = (byte)5;
                    if (MyCanvas.gameLevel == 2) {
                        if (!MyCanvas.isBlind && this.canvas.boss != null) {
                            this.canvas.getClass();
                            this.canvas.currPage = (byte)20;
                            this.canvas.mainMenuValueReset();
                            break;
                        }
                    }
                    this.canvas.getClass();
                    this.canvas.currPage = (byte)9;
                    this.canvas.shutterY = 0;
                    this.canvas.shutterMaxY = 24 * 2;
                    break;
                }
                case 25: {
                    this.imageNo = (byte)4;
                    this.actionFrmPtr = (byte)6;
                    this.frameCtr = (byte)(this.frameCtr + 1);
                    if (this.frameCtr > 1) {
                        this.frame = (byte)(this.frame + 1);
                        this.frameCtr = 0;
                    }
                    if (this.frame >= 2 && this.swordCount > 0) {
                        this.action = (byte)26;
                        this.imageNo = (byte)6;
                        this.actionFrmPtr = (byte)9;
                        this.frame = 0;
                        this.swordCount = 0;
                        break;
                    }
                    if (this.frame < 3) break;
                    this.action = (byte)26;
                    this.imageNo = 0;
                    this.actionFrmPtr = 0;
                    this.frame = 0;
                    break;
                }
                case 26: {
                    this.imageNo = (byte)6;
                    this.actionFrmPtr = (byte)9;
                    this.frameCtr = (byte)(this.frameCtr + 1);
                    if (this.frameCtr > 1) {
                        this.frame = (byte)(this.frame + 1);
                        this.frameCtr = 0;
                    }
                    if (this.frame < 3) break;
                    if (!this.singleSordAttack) {
                        this.action = (byte)27;
                        this.singleSordAttack = false;
                        this.imageNo = (byte)8;
                        this.actionFrmPtr = (byte)15;
                        this.frame = 0;
                        break;
                    }
                    this.action = 0;
                    this.imageNo = 0;
                    this.actionFrmPtr = 0;
                    this.frame = 0;
                    break;
                }
                case 27: {
                    this.imageNo = (byte)8;
                    this.actionFrmPtr = (byte)15;
                    this.frameCtr = (byte)(this.frameCtr + 1);
                    if (this.frameCtr > 1) {
                        this.frame = (byte)(this.frame + 1);
                        this.frameCtr = 0;
                    }
                    if (this.frame < 4) break;
                    this.action = 0;
                    this.imageNo = 0;
                    this.actionFrmPtr = 0;
                    this.frame = 0;
                    break;
                }
                case 31: {
                    this.imageNo = (byte)7;
                    this.actionFrmPtr = (byte)10;
                    this.frameCtr = (byte)(this.frameCtr + 1);
                    if (this.frameCtr >= 4) {
                        this.frameCtr = 0;
                        this.frame = (byte)(this.frame + 1);
                        if (this.frame == 1) {
                            this.canvas.addElementArr(new Elements(this.xPosition + (this.dir > 0 ? 52 : -28), this.yPosition + 19, 20, 4, (24 >> 1) * this.dir, 0, false, 0, 0, 0, this.canvas));
                        }
                    }
                    if (this.frame < 3) break;
                    this.action = 0;
                    this.imageNo = 0;
                    this.actionFrmPtr = 0;
                    this.frame = 0;
                    break;
                }
                case 6: {
                    if (this.isDead) {
                        this.yPosition += 24 >> 1;
                        this.actionFrmPtr = (byte)2;
                        this.imageNo = 1;
                        this.frame = (byte)4;
                        if (!MyCanvas.isGroundTouched) break;
                        this.imageNo = (byte)9;
                        this.actionFrmPtr = (byte)6;
                        this.frame = 0;
                        this.action = (byte)36;
                        break;
                    }
                    this.actionFrmPtr = (byte)21;
                    if (MyCanvas.isGroundTouched) {
                        this.frameCtr = (byte)(this.frameCtr + 1);
                        if (this.frame != 0 || this.frameCtr < 4) {
                            this.frame = 0;
                        } else {
                            this.JumpHtReached = false;
                            this.action = 0;
                            this.frame = 0;
                            this.actionFrmPtr = 0;
                            this.imageNo = 0;
                            this.frameCtr = 0;
                        }
                        if (this.fallHeight <= 144) break;
                        this.canvas.life = 0;
                        break;
                    }
                    this.xPosition += 4 * this.dir;
                    this.frameCtr = 0;
                    this.actionFrmPtr = (byte)21;
                    this.imageNo = 1;
                    this.frame = this.frame < 9 && this.frame != 0 ? (byte)(this.frame + 1) : (byte)0;
                    this.yPosition += 24 >> 1;
                    this.fallHeight = (short)(this.fallHeight + (24 >> 1));
                    break;
                }
                case 9: {
                    if (this.isDead) {
                        if (MyCanvas.isGroundTouched) {
                            this.imageNo = (byte)9;
                            this.actionFrmPtr = (byte)6;
                            this.frame = 0;
                            this.action = (byte)36;
                            break;
                        }
                    }
                    this.actionFrmPtr = (byte)11;
                    this.imageNo = (byte)5;
                    this.frame = (byte)(this.frame == 0 ? 1 : 0);
                    this.xPosition += (24 >> 2) * this.dir;
                    this.yPosition += 24 >> 3;
                    if (MyCanvas.isGroundTouched) break;
                    this.imageNo = 1;
                    this.frame = (byte)2;
                    this.action = (byte)6;
                    this.actionFrmPtr = (byte)21;
                    break;
                }
                case 29: {
                    this.actionFrmPtr = (byte)7;
                    this.imageNo = (byte)5;
                    break;
                }
                case 30: {
                    this.actionFrmPtr = (byte)8;
                    this.imageNo = (byte)5;
                    byte by2 = this.frame = this.frame > 2 ? (byte)0 : this.frame;
                    if (MyCanvas.isGroundTouched || MyCanvas.isOnChain || MyCanvas.isOnRope) break;
                    this.imageNo = 1;
                    this.frame = (byte)2;
                    this.action = (byte)6;
                    this.actionFrmPtr = (byte)21;
                    break;
                }
                case 37: {
                    this.actionFrmPtr = (byte)14;
                    this.imageNo = (byte)10;
                    if (this.frameCtr >= 0) {
                        this.frame = (byte)(this.frame + 1);
                        this.frameCtr = 0;
                    } else {
                        this.frameCtr = (byte)(this.frameCtr + 1);
                    }
                    if (this.frame < 11) break;
                    this.action = 0;
                    this.imageNo = 0;
                    this.actionFrmPtr = 0;
                    this.frame = 0;
                    break;
                }
                case 43: {
                    switch (this.ctr) {
                        case 0: {
                            if (this.xDist == 0) {
                                this.xDist = this.xPosition + 11 * 24;
                            }
                            if (this.xPosition < this.xDist) {
                                this.xPosition += this.dir * (24 >> 2);
                                this.xDist -= this.dir * (24 >> 2);
                                break;
                            }
                            if (MyCanvas.isCollide) {
                                MyCanvas.isCollide = false;
                            }
                            MyCanvas.IsHorizontalPan = false;
                            this.xDist = 0;
                            this.action = (byte)42;
                        }
                    }
                    break;
                }
                case 40: {
                    int slideHeight = 7;
                    int slideWidth = 9;
                    switch (this.ctr) {
                        case 0: {
                            if (this.xDist == 0) {
                                this.xDist = this.xPosition + 6 * 24;
                            }
                            if (this.xPosition < this.xDist) {
                                this.xPosition += this.dir * (24 >> 2);
                                this.xDist -= this.dir * (24 >> 2);
                                break;
                            }
                            this.ctr = (byte)(this.ctr + 1);
                            this.yDist = this.yPosition - slideHeight * 24;
                            break;
                        }
                        case 1: {
                            if (this.yPosition > this.yDist) {
                                this.yPosition -= this.dir * (24 >> 2);
                                this.yDist += this.dir * (24 >> 2);
                                break;
                            }
                            this.ctr = (byte)(this.ctr + 1);
                            this.xDist = this.xPosition + slideWidth * 24;
                            break;
                        }
                        case 2: {
                            if (this.xPosition < this.xDist) {
                                this.xPosition += this.dir * (24 >> 2);
                                this.xDist -= this.dir * (24 >> 2);
                                break;
                            }
                            if (MyCanvas.isCollide2) {
                                MyCanvas.isCollide2 = false;
                            }
                            MyCanvas.isZPan = true;
                            this.action = (byte)42;
                            this.frameCtr = 0;
                        }
                    }
                    break;
                }
                case 41: {
                    this.actionFrmPtr = (byte)18;
                    this.imageNo = (byte)13;
                    this.frameCtr = (byte)(this.frameCtr + 1);
                    if (this.frameCtr > 3) {
                        this.frame = (byte)(this.frame + 1);
                        this.frameCtr = 0;
                    }
                    if (this.frame <= 4) break;
                    this.frame = 0;
                    if (MyCanvas.IsHorizontalPan) {
                        if (!MyCanvas.isCollide) {
                            MyCanvas.isCollide = true;
                        }
                        this.action = (byte)43;
                        MyCanvas.IsHorizontalPan = false;
                        break;
                    }
                    if (!MyCanvas.isCollide2) {
                        MyCanvas.isCollide2 = true;
                    }
                    this.action = (byte)40;
                    break;
                }
                case 42: {
                    if (!MyCanvas.isZPan) {
                        System.out.println("i m in zpan");
                        this.actionFrmPtr = (byte)19;
                        this.imageNo = (byte)14;
                        this.frameCtr = (byte)(this.frameCtr + 1);
                        if (this.frameCtr > 1) {
                            System.out.println("i m in zpan faramctr>1");
                            this.frame = (byte)(this.frame + 1);
                            this.frameCtr = 0;
                        }
                        if (this.frame <= 1) break;
                        System.out.println("i m in zpan faramctr>22222222");
                        this.frame = 0;
                        if (MyCanvas.isCollide) {
                            MyCanvas.isCollide = false;
                        }
                        this.action = 0;
                        if (!MyCanvas.isCollide2) break;
                        MyCanvas.isCollide2 = false;
                        break;
                    }
                    System.out.println("you are in else part of Z-PanningZZZZZZZZZZZZZZZZZZ ");
                    MyCanvas.isCollide = false;
                    this.actionFrmPtr = 1;
                    this.imageNo = 0;
                    this.action = 1;
                    this.frameCtr = (byte)(this.frameCtr + 1);
                    this.frame = (byte)(this.frame + 1);
                    System.out.println("frame=" + this.frame);
                    if (this.frame < 3) break;
                    this.frame = 0;
                    break;
                }
                case 38: {
                    this.actionFrmPtr = (byte)16;
                    this.imageNo = (byte)11;
                    this.frameCtr = (byte)(this.frameCtr + 1);
                    this.frame = (byte)(this.frameCtr >= 10 ? 1 : 0);
                    if (this.frameCtr <= 20) break;
                    this.canvas.getClass();
                    this.canvas.currPage = (byte)20;
                    this.canvas.cutCtr = 0;
                    this.canvas.cutShutter = 0;
                    MyCanvas.shutterEnd = false;
                }
            }
            this.framePtr = (byte)(this.framePos[this.actionFrmPtr] + this.frame);
            if (this.isHit) {
                if (this.hitCounter == 0 && (this.action == 0 || this.action == 1 || this.action == 8 || this.action == 28)) {
                    this.imageNo = (byte)9;
                    this.actionFrmPtr = (byte)13;
                    this.frame = 0;
                    this.framePtr = (byte)(this.framePos[this.actionFrmPtr] + this.frame);
                    this.action = (byte)35;
                }
                if (this.hitCounter == 0) {
                    this.canvas.life = MyCanvas.gameLevel == 1 ? (this.canvas.life -= 10) : (this.canvas.life -= 5);
                }
                this.hitCounter = (byte)(this.hitCounter + 1);
                if (this.hitCounter > 8) {
                    this.isHit = false;
                    this.hitCounter = 0;
                }
            }
        }
        catch (Exception e) {
            System.out.println("err in hero update>>" + this.action + " " + e);
        }
    }

    public void draw(Graphics g) {
        try {
            if (!MyCanvas.isCollide) {
                if (!MyCanvas.isCollide2) {
                    g.drawRegion(image[this.imageNo], (int)this.heroClipping[this.framePtr * 4], (int)this.heroClipping[this.framePtr * 4 + 1], (int)this.heroClipping[this.framePtr * 4 + 2], (int)this.heroClipping[this.framePtr * 4 + 3], (int)this.imageRotation, this.xPosition + (this.dir == 1 ? this.heroPlacingRt[this.framePtr * 2] : this.heroPlacingLf[this.framePtr * 2]), this.yPosition + (this.dir == 1 ? this.heroPlacingRt[this.framePtr * 2 + 1] : this.heroPlacingLf[this.framePtr * 2 + 1]), 0);
                }
            }
        }
        catch (Exception e) {
            System.out.println("err in hero draw>>" + e + "framePtr----->" + this.framePtr + " imageno -->" + this.imageNo);
        }
    }

    void update1() {
        try {
            byte by = this.canvas.currPage;
            this.canvas.getClass();
            if (by != 18 && !this.blockHero) {
                this.updateHero1();
            }
            if (this.dir == 1) {
                this.imageRotation = 0;
                this.canvas.HeroXposOnScr = (MyCanvas.canvasWidth >> 1) - this.width;
            } else {
                this.imageRotation = (byte)2;
                this.canvas.HeroXposOnScr = MyCanvas.canvasWidth >> 1;
            }
            if (this.action != 6) {
                this.fallHeight = 0;
            }
            switch (this.action) {
                case 0: {
                    this.weapon = 0;
                    this.actionFrmPtr = 0;
                    this.frameCtr = (byte)(this.frameCtr + 1);
                    if (this.frameCtr > 3) {
                        this.frame = (byte)(this.frame + 1);
                        this.frameCtr = 0;
                    }
                    this.imageNo = 0;
                    if (this.frame <= 1) break;
                    this.frame = 0;
                    break;
                }
                case 1: {
                    this.actionFrmPtr = 1;
                    this.frameCtr = (byte)(this.frameCtr + 1);
                    if (this.frameCtr > 0) {
                        this.frame = (byte)(this.frame + 1);
                        this.frameCtr = 0;
                    }
                    this.imageNo = 0;
                    if (this.frame >= 5) {
                        this.frame = 0;
                    }
                    this.xPosition += 4 * this.dir;
                    break;
                }
                case 36: {
                    this.imageNo = (byte)3;
                    this.actionFrmPtr = (byte)4;
                    this.frame = (byte)(this.frame + 1);
                    if (this.frame < 6) break;
                    this.frame = (byte)6;
                    if (MyCanvas.gameLevel == 0) {
                        this.canvas.getClass();
                        this.canvas.currPage = (byte)25;
                        break;
                    }
                    this.canvas.getClass();
                    this.canvas.currPage = (byte)9;
                    this.canvas.shutterY = 0;
                    this.canvas.shutterMaxY = 24 * 2;
                    break;
                }
                case 25: {
                    this.imageNo = 1;
                    this.actionFrmPtr = (byte)2;
                    this.frame = (byte)(this.frame + 1);
                    if (this.frame < 7) break;
                    this.action = 0;
                    this.imageNo = 0;
                    this.actionFrmPtr = 0;
                    this.frame = 0;
                    break;
                }
                case 27: {
                    this.imageNo = (byte)4;
                    this.actionFrmPtr = (byte)5;
                    this.frameCtr = (byte)(this.frameCtr + 1);
                    if (this.frameCtr > 0) {
                        this.frame = (byte)(this.frame + 1);
                        this.frameCtr = 0;
                    }
                    if (this.frame < 4) break;
                    this.action = 0;
                    this.imageNo = 0;
                    this.actionFrmPtr = 0;
                    this.frame = 0;
                    break;
                }
                case 37: {
                    this.actionFrmPtr = (byte)3;
                    this.imageNo = (byte)2;
                    if (this.frameCtr >= 0) {
                        this.frame = (byte)(this.frame + 1);
                        this.frameCtr = 0;
                    } else {
                        this.frameCtr = (byte)(this.frameCtr + 1);
                    }
                    if (this.frame <= 6) break;
                    this.action = 0;
                    this.imageNo = 0;
                    this.actionFrmPtr = 0;
                    this.frame = 0;
                }
            }
            this.framePtr = (byte)(this.framePos1[this.actionFrmPtr] + this.frame);
            if (this.isHit) {
                if (this.hitCounter == 0) {
                    this.canvas.life -= 5;
                }
                this.hitCounter = (byte)(this.hitCounter + 1);
                if (this.hitCounter > 8) {
                    this.isHit = false;
                    this.hitCounter = 0;
                }
            }
        }
        catch (Exception e) {
            System.out.println("err in hero update1>>" + this.action + " " + e);
        }
    }

    void updateHero1() {
        try {
            switch (this.action) {
                case 0: {
                    if (MyCanvas.haveKeyPressed(4) || MyCanvas.haveKeyHold(4)) {
                        if (this.dir == 1) {
                            this.action = 1;
                            break;
                        }
                        this.dir = 1;
                        break;
                    }
                    if (MyCanvas.haveKeyPressed(64) || MyCanvas.haveKeyHold(64)) {
                        if (this.dir == -1) {
                            this.action = 1;
                            break;
                        }
                        this.dir = (byte)-1;
                        break;
                    }
                    if (MyCanvas.haveKeyPressed(256)) {
                        this.action = (byte)(MyCanvas.random(0, 10) < 3 ? 37 : 25);
                        if (this.action == 37) {
                            if (this.frame == 5) {
                                this.canvas.playSound(1);
                            } else if (this.frame == 9) {
                                this.canvas.playSound(5);
                            }
                        } else {
                            this.canvas.playSound(3);
                        }
                        this.frame = 0;
                        this.frameCtr = 0;
                        break;
                    }
                    if (MyCanvas.haveKeyPressed(8)) {
                        this.action = (byte)37;
                        this.canvas.playSound(1);
                        this.frame = 0;
                        this.swordCount = 0;
                        break;
                    }
                    if (MyCanvas.haveKeyPressed(2048)) {
                        this.action = (byte)27;
                        this.canvas.playSound(1);
                        this.frame = 0;
                        this.frameCtr = 0;
                        break;
                    }
                    if (!MyCanvas.haveKeyPressed(2)) break;
                    break;
                }
                case 1: {
                    if (MyCanvas.haveKeyReleased(4) || MyCanvas.haveKeyReleased(64)) {
                        this.action = 0;
                        this.frame = 0;
                        this.frameCtr = 0;
                    }
                    if (MyCanvas.haveKeyHold(4)) {
                        this.action = 1;
                        this.dir = 1;
                    } else if (MyCanvas.haveKeyHold(64)) {
                        this.action = 1;
                        this.dir = (byte)-1;
                    } else if (!MyCanvas.haveKeyPressed(16)) {
                        if (MyCanvas.haveKeyPressed(256)) {
                            this.action = (byte)(MyCanvas.random(0, 10) < 3 ? 37 : 25);
                            if (this.action == 37) {
                                this.canvas.playSound(1);
                            } else {
                                this.canvas.playSound(3);
                            }
                            this.frame = 0;
                            this.swordCount = 0;
                        } else if (!MyCanvas.haveKeyPressed(32) && MyCanvas.haveKeyPressed(8)) {
                            this.action = (byte)37;
                            this.canvas.playSound(1);
                            this.frame = 0;
                            this.swordCount = 0;
                        }
                    }
                    if (!MyCanvas.haveKeyPressed(1)) break;
                    break;
                }
                case 25: {
                    this.imageNo = 1;
                    this.actionFrmPtr = (byte)2;
                    if (!MyCanvas.haveKeyPressed(256)) break;
                    this.swordCount = (byte)(this.swordCount + 1);
                }
            }
        }
        catch (Exception e) {
            System.out.println("err in updateHero1>>" + e);
        }
    }
}

