/*
 * Decompiled with CFR 0.152.
 */
package code.Rendering;

import code.HUD.DeveloperMenu;
import code.Math.Matrix;
import code.Rendering.Meshes.Mesh;
import code.Rendering.MultyTexture;
import code.Rendering.RenderObject;
import code.Rendering.RenderObjectBuffer;
import code.Rendering.TMPElement;
import code.Rendering.Texture;
import code.Rendering.Vertex;
import javax.microedition.lcdui.Graphics;

public final class DirectX7 {
    public int width;
    public int height;
    public int[] display;
    public boolean flushAlpha = false;
    public Matrix camera;
    public Matrix invCamera;
    public Matrix finalCamera;
    public int centreX;
    public int centreY;
    public int distX;
    public int distY;
    public int fovX;
    public int fovY;
    public static int fDist = 1;
    public static int drDist = 30000000;
    public static int waterDistance = 10000;
    public static byte standartDrawmode = 0;
    public static int fogc = 0x5500FF;
    public static short lightdirx = 0;
    public static short lightdiry = 0;
    public static short lightdirz = 0;
    private final RenderObjectBuffer buffer;
    public int lx;
    public int ly;
    public int lz = 0;
    public int shootIntensity = 0;
    public int shootLength = 0;
    public static boolean useAutoWMove = true;
    public boolean flashlightEnabled = false;

    public DirectX7(int width, int height) {
        this.width = width;
        this.height = height;
        this.camera = new Matrix();
        this.invCamera = new Matrix();
        this.finalCamera = new Matrix();
        this.buffer = new RenderObjectBuffer();
        this.resize(width, height);
        this.lz = 0;
        this.ly = 0;
        this.lx = 0;
    }

    public void resize(int width, int height) {
        this.width = width;
        this.height = height;
        this.display = new int[width * height];
        this.centreX = width / 2;
        this.centreY = height / 2;
        this.updateFov(74);
    }

    public final void updateFov(int fov) {
        this.distX = (int)((double)this.centreX / Math.tan((double)fov * Math.PI / 360.0));
        this.distY = (int)((double)this.centreY / Math.tan((double)fov * Math.PI / 360.0));
        this.distX = this.distX * this.height / this.width;
        this.fovY = fov;
        this.fovX = fov * this.width / this.height;
    }

    public final void destroy() {
        fDist = 1;
        drDist = 30000000;
        standartDrawmode = 0;
        fogc = 0x5500FF;
        this.finalCamera = null;
        this.invCamera = null;
        this.camera = null;
        this.buffer.resetTex();
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    public final int[] getDisplay() {
        return this.display;
    }

    public final void setCamera(Matrix matrix) {
        this.invCamera.set(matrix);
        this.camera.set(matrix);
        this.invCamera.invert();
    }

    public final Matrix getInvCamera() {
        return this.invCamera;
    }

    public final Matrix getCamera() {
        return this.camera;
    }

    public final Matrix computeFinalMatrix(Matrix matrix) {
        this.finalCamera.mul(this.invCamera, matrix);
        return this.finalCamera;
    }

    public final void addRenderObject(RenderObject obj) {
        this.addRenderObject(obj, 0, 0, this.width, this.height);
    }

    public final void addRenderObject(RenderObject obj, int x1, int y1, int x2, int y2) {
        this.buffer.addRenderObject(obj, x1, y1, x2, y2);
    }

    public final void addRenderObject(RenderObject obj, Texture tex) {
        this.buffer.addRenderObject(obj, tex, 0, 0, this.width, this.height);
    }

    public final void addRenderObjectDT(RenderObject obj, Texture tex) {
        this.buffer.addRenderObjectDT(obj, tex, 0, 0, this.width, this.height);
    }

    public final void addMesh(Mesh mesh, int x1, int y1, int x2, int y2) {
        this.buffer.addRenderObjects(mesh.getPolygons(), mesh.getTexture(), x1, y1, x2, y2);
    }

    public final void addMesh(Mesh mesh, int x1, int y1, int x2, int y2, MultyTexture tex) {
        this.buffer.addRenderObjects(mesh.getPolygons(), tex, x1, y1, x2, y2);
    }

    public final void render() {
        this.lx = this.camera.m03;
        this.ly = this.camera.m13;
        this.lz = this.camera.m23;
        this.buffer.sort(0, this.buffer.getSize() - 1);
        if (DeveloperMenu.renderPolygonsOverwrite) {
            this.clearDisplay(0);
        }
        TMPElement[] buffer2 = this.buffer.getBuffer();
        for (int i = this.buffer.getSize() - 1; i >= 0; --i) {
            TMPElement element = buffer2[i];
            element.obj.render(this, element.tex);
        }
        this.buffer.reset();
    }

    public final void drawLine(int x1, int y1, int x2, int y2, int fat, int col) {
        int yEnd;
        int y;
        int tmp;
        if (y1 > y2) {
            tmp = y1;
            y1 = y2;
            y2 = tmp;
            tmp = x1;
            x1 = x2;
            x2 = tmp;
        }
        if (x1 > this.width && x2 > this.width || y1 > this.height || x2 < 0 && x1 < 0 || y2 < 0) {
            return;
        }
        int ySize = y2 - y1;
        int halfFat = fat / 2;
        if (fat == 1) {
            halfFat = 0;
        }
        if ((y = y1) < 0) {
            y = 0;
        }
        if ((yEnd = y2) > this.height) {
            yEnd = this.height;
        }
        while (y < yEnd) {
            int perc = y - y1;
            int x = (x1 * (ySize - perc) + x2 * perc) / ySize;
            tmp = y * this.width;
            int xx1 = x - halfFat;
            int xx2 = xx1 + fat;
            if (xx1 <= this.width && xx2 >= 0) {
                if (xx1 < 0) {
                    xx1 = 0;
                }
                if (xx2 >= this.width) {
                    xx2 = this.width - 1;
                }
                xx1 += tmp;
                xx2 += tmp;
                while (xx1 < xx2) {
                    this.display[xx1] = col;
                    ++xx1;
                }
            }
            ++y;
        }
    }

    public final void flush(Graphics g, int x, int y) {
        if (DeveloperMenu.renderPolygonsOverwrite) {
            for (int i = this.display.length - 1; i >= 0; --i) {
                int c = this.display[i];
                if (c == 0) {
                    this.display[i] = 0xFFFFFF;
                    continue;
                }
                if (c == 1) {
                    this.display[i] = 65280;
                    continue;
                }
                if (c == 2) {
                    this.display[i] = 0xFFFF00;
                    continue;
                }
                if (c == 3) {
                    this.display[i] = 0xFF8800;
                    continue;
                }
                if (c == 4) {
                    this.display[i] = 0xFF0000;
                    continue;
                }
                if (c != 5) continue;
                this.display[i] = 0x880000;
            }
        }
        g.drawRGB(this.display, 0, this.width, x, y, this.width, this.height, this.flushAlpha);
    }

    public static void transform(Mesh ms, Matrix m) {
        Vertex[] vers = ms.getVertices();
        int m00 = m.m00 >> 2;
        int m01 = m.m01 >> 2;
        int m02 = m.m02 >> 2;
        int m03 = m.m03;
        int m10 = m.m10 >> 2;
        int m11 = m.m11 >> 2;
        int m12 = m.m12 >> 2;
        int m13 = m.m13;
        int m20 = m.m20 >> 2;
        int m21 = m.m21 >> 2;
        int m22 = m.m22 >> 2;
        int m23 = m.m23;
        int fp = 12;
        for (int i = vers.length - 1; i >= 0; --i) {
            Vertex ver = vers[i];
            int x = ver.x;
            int y = ver.y;
            int z = ver.z;
            ver.sx = (x * m00 >> 12) + (y * m01 >> 12) + (z * m02 >> 12) + m03;
            ver.sy = (x * m10 >> 12) + (y * m11 >> 12) + (z * m12 >> 12) + m13;
            ver.rz = (x * m20 >> 12) + (y * m21 >> 12) + (z * m22 >> 12) + m23;
        }
    }

    public static void transform(Vertex[] vers, Matrix m) {
        if (m != null) {
            int m00 = m.m00 >> 2;
            int m01 = m.m01 >> 2;
            int m02 = m.m02 >> 2;
            int m03 = m.m03;
            int m10 = m.m10 >> 2;
            int m11 = m.m11 >> 2;
            int m12 = m.m12 >> 2;
            int m13 = m.m13;
            int m20 = m.m20 >> 2;
            int m21 = m.m21 >> 2;
            int m22 = m.m22 >> 2;
            int m23 = m.m23;
            int fp = 12;
            for (int i = vers.length - 1; i >= 0; --i) {
                Vertex ver = vers[i];
                int x = ver.x;
                int y = ver.y;
                int z = ver.z;
                ver.sx = (x * m00 >> 12) + (y * m01 >> 12) + (z * m02 >> 12) + m03;
                ver.sy = (x * m10 >> 12) + (y * m11 >> 12) + (z * m12 >> 12) + m13;
                ver.rz = (x * m20 >> 12) + (y * m21 >> 12) + (z * m22 >> 12) + m23;
            }
        } else {
            for (int i = vers.length - 1; i >= 0; --i) {
                Vertex ver = vers[i];
                ver.sx = ver.x;
                ver.sy = ver.y;
                ver.rz = ver.z;
            }
        }
    }

    public void project(Vertex[] vertices, int rz) {
        Vertex ver = null;
        for (int i = vertices.length - 1; i >= 0; --i) {
            ver = vertices[i];
            int sx = ver.sx;
            int sy = -ver.sy;
            if (rz <= 0) {
                sx = sx * this.distX / (rz + this.distX);
                sy = sy * this.distY / (rz + this.distY);
            }
            ver.sx = (short)(sx + this.centreX);
            ver.sy = (short)(sy + this.centreY);
        }
    }

    public static void returnMesh(Mesh ms) {
        Vertex[] vers = ms.getVertices();
        for (int i = vers.length - 1; i >= 0; --i) {
            Vertex ver = vers[i];
            ver.x = ver.sx;
            ver.y = ver.sy;
            ver.z = ver.rz;
        }
    }

    public static void transformSave(Object ms, Matrix m) {
        Vertex[] vers;
        if (ms instanceof Mesh) {
            vers = ((Mesh)ms).getVertices();
        } else if (ms instanceof Vertex[]) {
            vers = (Vertex[])ms;
        } else {
            return;
        }
        int m00 = m.m00 >> 2;
        int m01 = m.m01 >> 2;
        int m02 = m.m02 >> 2;
        int m03 = m.m03;
        int m10 = m.m10 >> 2;
        int m11 = m.m11 >> 2;
        int m12 = m.m12 >> 2;
        int m13 = m.m13;
        int m20 = m.m20 >> 2;
        int m21 = m.m21 >> 2;
        int m22 = m.m22 >> 2;
        int m23 = m.m23;
        int fp = 12;
        for (int i = vers.length - 1; i >= 0; --i) {
            Vertex ver = vers[i];
            int x = ver.x;
            int y = ver.y;
            int z = ver.z;
            ver.sx = x;
            ver.sy = y;
            ver.rz = z;
            ver.x = (x * m00 >> 12) + (y * m01 >> 12) + (z * m02 >> 12) + m03;
            ver.y = (x * m10 >> 12) + (y * m11 >> 12) + (z * m12 >> 12) + m13;
            ver.z = (x * m20 >> 12) + (y * m21 >> 12) + (z * m22 >> 12) + m23;
        }
    }

    public static void transformReturn(Object ms) {
        Vertex[] vers;
        if (ms instanceof Mesh) {
            vers = ((Mesh)ms).getVertices();
        } else if (ms instanceof Vertex[]) {
            vers = (Vertex[])ms;
        } else {
            return;
        }
        for (int i = vers.length - 1; i >= 0; --i) {
            Vertex ver = vers[i];
            int x = ver.x;
            int y = ver.y;
            int z = ver.z;
            ver.sx = x;
            ver.sy = y;
            ver.rz = z;
            ver.x = ver.sx;
            ver.y = ver.sy;
            ver.z = ver.rz;
        }
    }

    public void transformAndProjectVertices(Mesh ms, Matrix matrix) {
        Vertex[] vertices = ms.getVertices();
        int m00 = matrix.m00 >> 2;
        int m01 = matrix.m01 >> 2;
        int m02 = matrix.m02 >> 2;
        int m03 = matrix.m03;
        int m10 = matrix.m10 >> 2;
        int m11 = matrix.m11 >> 2;
        int m12 = matrix.m12 >> 2;
        int m13 = matrix.m13;
        int m20 = matrix.m20 >> 2;
        int m21 = matrix.m21 >> 2;
        int m22 = matrix.m22 >> 2;
        int m23 = matrix.m23;
        int fp = 12;
        for (int i = vertices.length - 1; i >= 0; --i) {
            Vertex ver = vertices[i];
            int x = ver.x;
            int y = ver.y;
            int z = ver.z;
            int sx = m03;
            if (m00 != 0) {
                sx += x * m00 >> 12;
            }
            if (m01 != 0) {
                sx += y * m01 >> 12;
            }
            if (m02 != 0) {
                sx += z * m02 >> 12;
            }
            int sy = -m13;
            if (m10 != 0) {
                sy -= x * m10 >> 12;
            }
            if (m11 != 0) {
                sy -= y * m11 >> 12;
            }
            if (m12 != 0) {
                sy -= z * m12 >> 12;
            }
            int rz = m23;
            if (m20 != 0) {
                rz += x * m20 >> 12;
            }
            if (m21 != 0) {
                rz += y * m21 >> 12;
            }
            if (m22 != 0) {
                rz += z * m22 >> 12;
            }
            if (rz < 0) {
                sx = sx * this.distX / (-rz + this.distX);
                sy = sy * this.distY / (-rz + this.distY);
            }
            ver.sx = sx + this.centreX;
            ver.sy = sy + this.centreY;
            ver.rz = rz;
        }
    }

    public void transformAndProjectVertices(Vertex[] vertices, Matrix matrix) {
        int m00 = matrix.m00 >> 2;
        int m01 = matrix.m01 >> 2;
        int m02 = matrix.m02 >> 2;
        int m03 = matrix.m03;
        int m10 = matrix.m10 >> 2;
        int m11 = matrix.m11 >> 2;
        int m12 = matrix.m12 >> 2;
        int m13 = matrix.m13;
        int m20 = matrix.m20 >> 2;
        int m21 = matrix.m21 >> 2;
        int m22 = matrix.m22 >> 2;
        int m23 = matrix.m23;
        int fp = 12;
        for (int i = vertices.length - 1; i >= 0; --i) {
            Vertex ver = vertices[i];
            int x = ver.x;
            int y = ver.y;
            int z = ver.z;
            int sx = m03;
            if (m00 != 0) {
                sx += x * m00 >> 12;
            }
            if (m01 != 0) {
                sx += y * m01 >> 12;
            }
            if (m02 != 0) {
                sx += z * m02 >> 12;
            }
            int sy = -m13;
            if (m10 != 0) {
                sy -= x * m10 >> 12;
            }
            if (m11 != 0) {
                sy -= y * m11 >> 12;
            }
            if (m12 != 0) {
                sy -= z * m12 >> 12;
            }
            int rz = m23;
            if (m20 != 0) {
                rz += x * m20 >> 12;
            }
            if (m21 != 0) {
                rz += y * m21 >> 12;
            }
            if (m22 != 0) {
                rz += z * m22 >> 12;
            }
            if (rz < 0) {
                sx = sx * this.distX / (-rz + this.distX);
                sy = sy * this.distY / (-rz + this.distY);
            }
            ver.sx = sx + this.centreX;
            ver.sy = sy + this.centreY;
            ver.rz = rz;
        }
    }

    public static void setFogDist(int d) {
        fDist = d;
    }

    public static void setDrDist(int d) {
        drDist = d;
    }

    public final void clearDisplay(int col) {
        int length = this.display.length;
        int i = 0;
        while (length - i > 5) {
            this.display[i] = col;
            this.display[i + 1] = col;
            this.display[i + 2] = col;
            this.display[i + 3] = col;
            this.display[i + 4] = col;
            i += 5;
        }
        while (i < length) {
            this.display[i] = col;
            ++i;
        }
    }
}

