/*
 * Decompiled with CFR 0.152.
 */
package code.Rendering.Meshes;

import code.Math.MathUtils;
import code.Rendering.DirectX7;
import code.Rendering.Meshes.ColorLightedPolygon3V;
import code.Rendering.Meshes.Polygon3V;
import code.Rendering.Texture;
import code.Rendering.TexturingAffine;
import code.Rendering.TexturingPers;
import code.Rendering.Vertex;
import code.utils.Main;

public class LightedPolygon3V
extends Polygon3V {
    public volatile int la;
    public volatile int lb;
    public volatile int lc;
    private static int q;
    private static int sz2;
    private static int sizex;
    private static int sizey;
    private static int sizeu;
    private static int sizev;
    private static int addmip;
    private static int fog;

    public LightedPolygon3V(LightedPolygon3V p) {
        super(p);
        this.la = p.la;
        this.lb = p.lb;
        this.lc = p.lc;
    }

    public LightedPolygon3V(ColorLightedPolygon3V p) {
        super(p);
        this.la = (p.ar + p.ag + p.ab) / 3;
        this.lb = (p.br + p.bg + p.bb) / 3;
        this.lc = (p.cr + p.cg + p.cb) / 3;
    }

    public LightedPolygon3V(Vertex a2, Vertex b2, Vertex c2, byte au, byte av, byte bu, byte bv, byte cu, byte cv) {
        super(a2, b2, c2, au, av, bu, bv, cu, cv);
        this.lc = 255;
        this.lb = 255;
        this.la = 255;
    }

    public final void render(DirectX7 g3d, Texture texture) {
        if (Main.persQ == 0 && !Main.mipMapping) {
            this.renderFast(g3d, texture);
            return;
        }
        fog = texture.drawmode;
        sizex = LightedPolygon3V.size(this.a.sx, this.b.sx, this.c.sx);
        sizey = LightedPolygon3V.size(this.a.sy, this.b.sy, this.c.sy);
        int la2 = this.getLight(this.a, this.la, g3d);
        int lb2 = this.getLight(this.b, this.lb, g3d);
        int lc2 = this.getLight(this.c, this.lc, g3d);
        if (fog == 5) {
            sz2 = 255 - MathUtils.calcLight(this.nx, this.ny, this.nz, DirectX7.lightdirx, DirectX7.lightdiry, DirectX7.lightdirz);
        }
        if (fog == 1) {
            this.szCalcfogAdd();
        }
        int n = q = this.ny > 4000 || this.ny < -4000 ? 9999999 : Main.q;
        if (Main.mipMapping && texture.mip != null) {
            texture.rImg = texture.mip[0];
            if (texture.drawmode < 10 || texture.drawmode > 12) {
                addmip = q > 999 ? 2 : 3;
                if ((sizex + sizey >> 1) * addmip < (sizeu = LightedPolygon3V.size(this.au, this.bu, this.cu) * texture.rImg.w >> 8) + (sizev = LightedPolygon3V.size(this.av, this.bv, this.cv) * texture.rImg.h >> 8)) {
                    texture.rImg = texture.mip[1];
                    if (texture.mip != null && (sizex + sizey >> 1) * addmip < (sizeu >>= 1) + (sizev >>= 1)) {
                        texture.rImg = texture.mip[2];
                    }
                }
            } else if (sizex < texture.rImg.w || sizey < texture.rImg.w) {
                texture.rImg = texture.mip[1];
                if (texture.mip != null && (sizex < texture.rImg.w || sizey < texture.rImg.w)) {
                    texture.rImg = texture.mip[2];
                }
            }
        }
        if (texture.perspectiveCorrection && (sizex > 30 - (Main.persQ < 3 ? 0 : 15) || sizey > 30 - (Main.persQ < 3 ? 0 : 15)) && Main.persQ != 0 || Main.persQ == 4) {
            TexturingPers.paint(g3d, texture, this.a, this.au, this.av, this.b, this.bu, this.bv, this.c, this.cu, this.cv, DirectX7.fogc, fog, sz2, q, la2, lb2, lc2, la2, lb2, lc2, la2, lb2, lc2, this.nx, this.ny, this.nz);
        } else {
            TexturingAffine.paint(g3d, texture, this.a, this.au, this.av, this.b, this.bu, this.bv, this.c, this.cu, this.cv, DirectX7.fogc, fog, sz2, la2, lb2, lc2, la2, lb2, lc2, la2, lb2, lc2, this.nx, this.ny, this.nz);
        }
    }

    public void renderFast(DirectX7 g3d, Texture texture) {
        if (texture.drawmode == 5 && (sz2 = 255 - MathUtils.calcLight(this.nx, this.ny, this.nz, DirectX7.lightdirx, DirectX7.lightdiry, DirectX7.lightdirz)) < 0) {
            sz2 = 0;
        }
        if (texture.drawmode == 1 && fog == 1) {
            this.szCalcfogAdd();
        }
        TexturingAffine.paint(g3d, texture, this.a, this.au, this.av, this.b, this.bu, this.bv, this.c, this.cu, this.cv, DirectX7.fogc, texture.drawmode, sz2, this.la, this.lb, this.lc, this.la, this.lb, this.lc, this.la, this.lb, this.lc, this.nx, this.ny, this.nz);
    }

    private static final int size(int a, int b, int c) {
        int t;
        if (b < a) {
            t = a;
            a = b;
            b = t;
        }
        if (c < a) {
            t = c;
            c = a;
            a = t;
        }
        if (c < b) {
            t = b;
            b = c;
            c = t;
        }
        return c - a;
    }
}

