/*
 * Decompiled with CFR 0.152.
 */
package code.Rendering.Meshes;

import code.Math.MathUtils;
import code.Rendering.DirectX7;
import code.Rendering.RenderObject;
import code.Rendering.Texture;
import code.Rendering.TexturingAffine;
import code.Rendering.TexturingPers;
import code.Rendering.Vertex;
import code.utils.Main;
import java.util.Random;

public class Polygon4V
extends RenderObject {
    public Vertex a;
    public Vertex b;
    public Vertex c;
    public Vertex d;
    public int au;
    public int av;
    public int bu;
    public int bv;
    public int cu;
    public int cv;
    public int du;
    public int dv;
    public int tex = 0;
    private static int q;
    private static int sz2;
    private static int sizex;
    private static int sizey;
    private static int sizeu;
    private static int sizev;
    private static int addmip;
    private static int fog;
    private static Random r;

    public Polygon4V(Polygon4V p) {
        this.nx = p.nx;
        this.ny = p.ny;
        this.nz = p.nz;
        this.a = p.a;
        this.au = p.au;
        this.av = p.av;
        this.b = p.b;
        this.bu = p.bu;
        this.bv = p.bv;
        this.c = p.c;
        this.cu = p.cu;
        this.cv = p.cv;
        this.d = p.d;
        this.du = p.du;
        this.dv = p.dv;
        this.tex = p.tex;
    }

    public Polygon4V(Vertex a2, Vertex b2, Vertex c2, Vertex d2, byte au, byte av, byte bu, byte bv, byte cu, byte cv, byte du, byte dv) {
        super(a2, b2, c2);
        int oldnx = this.nx;
        int oldny = this.ny;
        int oldnz = this.nz;
        this.calculateNormals(a2, c2, d2);
        this.nx = this.nx / 2 + oldnx / 2;
        this.ny = this.ny / 2 + oldny / 2;
        this.nz = this.nz / 2 + oldnz / 2;
        this.a = a2;
        this.au = au & 0xFF;
        this.av = av & 0xFF;
        this.b = b2;
        this.bu = bu & 0xFF;
        this.bv = bv & 0xFF;
        this.c = c2;
        this.cu = cu & 0xFF;
        this.cv = cv & 0xFF;
        this.d = d2;
        this.du = du & 0xFF;
        this.dv = dv & 0xFF;
    }

    public final void szCalcfogAdd() {
        this.sz = this.a.rz;
        if (this.d.rz < this.sz) {
            this.sz = this.d.rz;
        }
        if (this.c.rz < this.sz) {
            this.sz = this.c.rz;
        }
        if (this.b.rz < this.sz) {
            this.sz = this.b.rz;
        }
        sz2 = -this.sz / 255;
        if (DirectX7.fDist / 255 != 0) {
            sz2 = -this.sz / (DirectX7.fDist / 255);
        }
        if (sz2 > 255) {
            sz2 = 255;
        }
        if (sz2 < 0) {
            sz2 = 0;
        }
        sz2 = 255 - sz2;
        int cr = DirectX7.fogc >> 16 & 0xFF;
        int cg = DirectX7.fogc >> 8 & 0xFF;
        int cb = DirectX7.fogc & 0xFF;
        if ((cr -= sz2) < 0) {
            cr = 0;
        }
        if ((cg -= sz2) < 0) {
            cg = 0;
        }
        if ((cb -= sz2) < 0) {
            cb = 0;
        }
        sz2 = cr << 16 | cg << 8 | cb;
    }

    public final boolean isVisible(int x1, int y1, int x2, int y2) {
        if (this.a.sx < x1 && this.b.sx < x1 && this.c.sx < x1 && this.d.sx < x1) {
            return false;
        }
        if (this.a.sx > x2 && this.b.sx > x2 && this.c.sx > x2 && this.d.sx > x2) {
            return false;
        }
        if (this.a.sy < y1 && this.b.sy < y1 && this.c.sy < y1 && this.d.sy < y1) {
            return false;
        }
        if (this.a.sy > y2 && this.b.sy > y2 && this.c.sy > y2 && this.d.sy > y2) {
            return false;
        }
        if ((this.a.sx - this.b.sx) * (this.b.sy - this.d.sy) <= (this.a.sy - this.b.sy) * (this.b.sx - this.d.sx) && (this.c.sx - this.d.sx) * (this.d.sy - this.b.sy) <= (this.c.sy - this.d.sy) * (this.d.sx - this.b.sx)) {
            return false;
        }
        this.sz = this.a.rz;
        if (this.d.rz < this.sz) {
            this.sz = this.d.rz;
        }
        if (this.c.rz < this.sz) {
            this.sz = this.c.rz;
        }
        if (this.b.rz < this.sz) {
            this.sz = this.b.rz;
        }
        if (this.sz > 0) {
            return false;
        }
        if (-this.sz > DirectX7.drDist) {
            return false;
        }
        this.sz = this.a.rz + this.b.rz + this.c.rz + this.d.rz;
        if (this.ny > 4000 || this.ny < -4000) {
            this.sz += Main.floorOffsetSZ;
        }
        return true;
    }

    public void render(DirectX7 g3d, Texture texture) {
        boolean base;
        boolean pers;
        if (Main.persQ == 0 && !Main.mipMapping) {
            this.renderFast(g3d, texture);
            return;
        }
        fog = texture.drawmode;
        boolean bl = pers = Main.persQ > 0;
        if (Main.mipMapping && texture.mip != null || pers) {
            sizex = Polygon4V.size(this.a.sx, this.b.sx, this.c.sx, this.d.sx);
            sizey = Polygon4V.size(this.a.sy, this.b.sy, this.c.sy, this.d.sy);
        }
        if (fog == 5) {
            sz2 = 255 - MathUtils.calcLight(this.nx, this.ny, this.nz, DirectX7.lightdirx, DirectX7.lightdiry, DirectX7.lightdirz);
        } else if (fog == 1) {
            this.szCalcfogAdd();
        }
        int n = q = this.ny > 4000 || this.ny < -4000 ? 9999999 : Main.q;
        if (Main.mipMapping && texture.mip != null) {
            texture.rImg = texture.mip[0];
            if (texture.drawmode < 10 || texture.drawmode > 12) {
                addmip = q > 999 ? 2 : 3;
                if ((sizex + sizey >> 1) * addmip < (sizeu = Polygon4V.size(this.au, this.bu, this.cu, this.du) * texture.rImg.w >> 8) + (sizev = Polygon4V.size(this.av, this.bv, this.cv, this.dv) * texture.rImg.h >> 8)) {
                    texture.rImg = texture.mip[1];
                    if (texture.mip != null && (sizex + sizey >> 1) * addmip < (sizeu >>= 1) + (sizev >>= 1)) {
                        texture.rImg = texture.mip[2];
                    }
                }
            } else if (sizex < texture.rImg.w || sizey < texture.rImg.w) {
                texture.rImg = texture.mip[1];
                if (texture.mip != null && (sizex < texture.rImg.w || sizey < texture.rImg.w)) {
                    texture.rImg = texture.mip[2];
                }
            }
        }
        if (pers) {
            pers = (sizex > (Main.persQ < 3 ? 70 : 50) || sizey > (Main.persQ < 3 ? 100 : 70)) && texture.perspectiveCorrection || Main.persQ == 4;
        }
        boolean bl2 = base = fog != 3 && fog != 6 || Main.fogQ == 0;
        if (!base) {
            boolean bl3 = base = Polygon4V.min(this.a.rz, this.b.rz, this.c.rz, this.d.rz) == (this.a.rz < this.c.rz ? this.a.rz : this.c.rz);
        }
        if (base) {
            if (pers) {
                TexturingPers.paint(g3d, texture, this.a, this.au, this.av, this.b, this.bu, this.bv, this.d, this.du, this.dv, DirectX7.fogc, fog, sz2, q, 255, 255, 255, 255, 255, 255, 255, 255, 255, this.nx, this.ny, this.nz);
                TexturingPers.paint(g3d, texture, this.b, this.bu, this.bv, this.c, this.cu, this.cv, this.d, this.du, this.dv, DirectX7.fogc, fog, sz2, q, 255, 255, 255, 255, 255, 255, 255, 255, 255, this.nx, this.ny, this.nz);
            } else {
                TexturingAffine.paint(g3d, texture, this.a, this.au, this.av, this.b, this.bu, this.bv, this.d, this.du, this.dv, DirectX7.fogc, fog, sz2, 255, 255, 255, 255, 255, 255, 255, 255, 255, this.nx, this.ny, this.nz);
                TexturingAffine.paint(g3d, texture, this.b, this.bu, this.bv, this.c, this.cu, this.cv, this.d, this.du, this.dv, DirectX7.fogc, fog, sz2, 255, 255, 255, 255, 255, 255, 255, 255, 255, this.nx, this.ny, this.nz);
            }
        } else if (pers) {
            TexturingPers.paint(g3d, texture, this.a, this.au, this.av, this.b, this.bu, this.bv, this.c, this.cu, this.cv, DirectX7.fogc, fog, sz2, q, 255, 255, 255, 255, 255, 255, 255, 255, 255, this.nx, this.ny, this.nz);
            TexturingPers.paint(g3d, texture, this.a, this.au, this.av, this.c, this.cu, this.cv, this.d, this.du, this.dv, DirectX7.fogc, fog, sz2, q, 255, 255, 255, 255, 255, 255, 255, 255, 255, this.nx, this.ny, this.nz);
        } else {
            TexturingAffine.paint(g3d, texture, this.a, this.au, this.av, this.b, this.bu, this.bv, this.c, this.cu, this.cv, DirectX7.fogc, fog, sz2, 255, 255, 255, 255, 255, 255, 255, 255, 255, this.nx, this.ny, this.nz);
            TexturingAffine.paint(g3d, texture, this.a, this.au, this.av, this.c, this.cu, this.cv, this.d, this.du, this.dv, DirectX7.fogc, fog, sz2, 255, 255, 255, 255, 255, 255, 255, 255, 255, this.nx, this.ny, this.nz);
        }
    }

    public void renderFast(DirectX7 g3d, Texture texture) {
        if (texture.drawmode == 5) {
            sz2 = 255 - MathUtils.calcLight(this.nx, this.ny, this.nz, DirectX7.lightdirx, DirectX7.lightdiry, DirectX7.lightdirz);
        }
        if (texture.drawmode == 1) {
            this.szCalcfogAdd();
        }
        TexturingAffine.paint(g3d, texture, this.a, this.au & 0xFF, this.av & 0xFF, this.b, this.bu & 0xFF, this.bv & 0xFF, this.d, this.du & 0xFF, this.dv & 0xFF, DirectX7.fogc, texture.drawmode, sz2, 255, 255, 255, 255, 255, 255, 255, 255, 255, this.nx, this.ny, this.nz);
        TexturingAffine.paint(g3d, texture, this.b, this.bu & 0xFF, this.bv & 0xFF, this.c, this.cu & 0xFF, this.cv & 0xFF, this.d, this.du & 0xFF, this.dv & 0xFF, DirectX7.fogc, texture.drawmode, sz2, 255, 255, 255, 255, 255, 255, 255, 255, 255, this.nx, this.ny, this.nz);
    }

    private static int size(int a, int b, int c, int d) {
        int t;
        if (b < a) {
            t = a;
            a = b;
            b = t;
        }
        if (c < a) {
            t = c;
            c = a;
            a = t;
        }
        if (c < b) {
            t = b;
            b = c;
            c = t;
        }
        int min = a < d ? a : d;
        int max = c > d ? c : d;
        return max - min;
    }

    private static final int min(int a, int b, int c, int d) {
        int t;
        if (a == b || b == d || b == c || d == c) {
            return Polygon4V.min(a, c, d);
        }
        if (a == c) {
            return Polygon4V.min(a, b, d);
        }
        if (a == d) {
            return Polygon4V.min(a, b, c);
        }
        if (b < a) {
            t = a;
            a = b;
            b = t;
        }
        if (c < a) {
            t = c;
            c = a;
            a = t;
        }
        if (c < b) {
            t = b;
            b = c;
            c = t;
        }
        int min = a < d ? a : d;
        return min;
    }

    private static final int min(int a, int b, int c) {
        if (a == b || b == c) {
            return a < c ? a : c;
        }
        if (a == c) {
            return a < b ? a : b;
        }
        if (a < b && a < c) {
            return a;
        }
        if (b < a && b < c) {
            return b;
        }
        return c;
    }
}

