/*
 * Decompiled with CFR 0.152.
 */
package code.HUD;

import code.Gameplay.GameScreen;
import code.HUD.Base.Font;
import code.HUD.Base.Selectable;
import code.HUD.DeveloperMenu;
import code.HUD.LoadingScreen;
import code.HUD.Menu;
import code.HUD.Setting;
import code.utils.IniFile;
import code.utils.Main;
import javax.microedition.lcdui.Graphics;

public final class PauseScreen
extends Selectable {
    private Main main;
    GameScreen gameScreen;
    private Object background;
    private boolean mus;
    private long mt = 0L;
    private int height3D;
    private int backgroundH;
    private int state = 0;
    private int lastIndex = 0;
    private boolean saveGame = true;

    public PauseScreen(Main main, GameScreen gameScreen, int[] background2, long time) {
        this.main = main;
        this.gameScreen = gameScreen;
        this.background = background2;
        this.mus = Main.isMusic;
        this.lastIndex = 0;
        this.mt = time;
        this.state = 0;
        IniFile text = Main.getGameText();
        String[] items = new String[Main.pauseScreenSave ? 6 : 5 + (DeveloperMenu.debugMode ? 1 : 0)];
        this.set(Main.getFont(), items, text.get("SELECT"), text.get("BACK"));
        this.reloadText();
        this.height3D = this.getHeight() / 2 - this.getHeight() * Main.getDisplaySize() / 200;
        this.backgroundH = this.getHeight() * Main.getDisplaySize() / 100;
        this.repaint(0, 0, this.getWidth(), this.getHeight());
    }

    public void reloadText() {
        IniFile text = Main.getGameText();
        String[] items = new String[(Main.pauseScreenSave ? 6 : 5) + (DeveloperMenu.debugMode ? 1 : 0)];
        this.set(Main.getFont(), items, text.get("SELECT"), text.get("BACK"));
        int i = 0;
        items[i++] = text.get("CONTINUE");
        items[i++] = text.get("RELOAD");
        if (Main.pauseScreenSave) {
            items[i++] = text.get("SAVE_GAME");
        }
        items[i++] = text.get("OPTIONS");
        items[i++] = text.get("MENU");
        items[i++] = text.get("EXIT");
        if (DeveloperMenu.debugMode) {
            items[i++] = "Developer Menu";
        }
    }

    protected final void paint(Graphics g) {
        g.setColor(0);
        if (this.state == 0) {
            this.lastIndex = this.list.getIndex();
        }
        IniFile text = Main.getGameText();
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.background instanceof int[]) {
            g.drawRGB((int[])this.background, 0, this.getWidth(), 0, this.height3D, this.getWidth(), this.backgroundH, false);
        }
        g.setColor(0xFFFFFF);
        Font font = Main.getFont();
        Main.drawBckDialog(g, this.getHeight() - Main.getFont().height(), this.getHeight());
        if (this.state == 0) {
            this.setSoftKeysNames(text.get("SELECT"), text.get("BACK"));
            this.list.drawBck(g, 0, Main.getFont().height(), this.getWidth(), this.getHeight() - Main.getFont().height() * 2);
            super.paint(g);
            int y = (this.getHeight() - Main.getFont().height() * 2 - this.list.getHeight()) / 2 + Main.getFont().height();
            Main.drawBckDialog(g, (y /= 3) - font.height() / 2, y + font.height() / 2);
            font.drawString(g, Main.getGameText().get("PAUSE"), this.getWidth() / 2, y, 3);
        } else if (this.state == 1 || this.state == 2) {
            int y = this.getHeight() / 2;
            Main.drawBckDialog(g, y - font.height() / 2, y + font.height() / 2);
            font.drawString(g, Main.getGameText().get(this.state == 1 ? "CONFIRM" : "SAVE_GAME?"), this.getWidth() / 2, y, 3);
            this.setSoftKeysNames(text.get("YES"), text.get("NO"));
            this.drawSoftKeys(g);
        }
    }

    protected final void onRightSoftKey() {
        if (this.state == 0) {
            this.setItemIndex(0);
            this.checkVariant();
        } else if (this.state == 1) {
            this.list.setIndex(this.lastIndex);
            this.state = 0;
            this.repaint();
        } else if (this.state == 2) {
            this.list.setIndex(this.lastIndex);
            this.saveGame = false;
            this.closeGS();
        }
    }

    protected final void onLeftSoftKey() {
        if (this.state == 0 && (this.itemIndex() < (Main.pauseScreenSave ? 4 : 3) || this.itemIndex() == this.getItems().length - 1 && DeveloperMenu.debugMode) && this.itemIndex() != 1 && (this.itemIndex() != 2 || !Main.pauseScreenSave)) {
            this.checkVariant();
        } else if (this.state == 2) {
            this.list.setIndex(this.lastIndex);
            this.closeGS();
        } else if (this.state == 1) {
            this.list.setIndex(this.lastIndex);
            if (!Main.saveOnQuit || this.itemIndex() == 1 || this.itemIndex() == 2 && Main.pauseScreenSave) {
                this.closeGS();
            } else {
                this.state = 2;
                this.repaint();
            }
        } else {
            this.state = 1;
            this.repaint();
        }
    }

    protected final void onKey5() {
        this.onLeftSoftKey();
    }

    private final void closeGS() {
        int index = this.itemIndex();
        if (index == (Main.pauseScreenSave ? 4 : 3)) {
            if (Main.saveOnQuit && this.saveGame && this.gameScreen.player.getHp() > 0) {
                Main.saveGame(this.gameScreen.levelNumber, this.gameScreen.player, this.gameScreen.scene);
                Main.saveObjects(this.gameScreen.levelNumber, this.gameScreen.player, this.gameScreen.scene);
            }
            this.gameScreen.destroy();
            this.gameScreen = null;
            this.background = null;
            System.gc();
            Main.setCurrent(new Menu(this.main));
        } else if (index == (Main.pauseScreenSave ? 5 : 4)) {
            if (Main.saveOnQuit && this.saveGame && this.gameScreen.player.getHp() > 0) {
                Main.saveGame(this.gameScreen.levelNumber, this.gameScreen.player, this.gameScreen.scene);
                Main.saveObjects(this.gameScreen.levelNumber, this.gameScreen.player, this.gameScreen.scene);
            }
            Main.saveOnQuit = false;
            this.gameScreen.destroy();
            this.gameScreen = null;
            this.background = null;
            System.gc();
            this.main.notifyDestroyed();
        } else if (index == 1) {
            this.background = null;
            System.gc();
            boolean hasSave = Main.hasSave();
            int lvl = hasSave ? Main.getContinueLevel() : this.gameScreen.levelNumber;
            this.gameScreen.destroy();
            this.gameScreen = null;
            LoadingScreen ls = new LoadingScreen(this.main, lvl, hasSave, true);
            Main.setCurrent(ls);
        } else if (index == 2 && Main.pauseScreenSave) {
            if (this.gameScreen.player.getHp() > 0) {
                Main.saveGame(this.gameScreen.levelNumber, this.gameScreen.player, this.gameScreen.scene);
                Main.saveObjects(this.gameScreen.levelNumber, this.gameScreen.player, this.gameScreen.scene);
            }
            this.state = 0;
            this.repaint();
        }
    }

    private final void checkVariant() {
        int item = this.itemIndex();
        if (item == 0) {
            if (Main.isMusic != this.mus) {
                if (Main.isMusic) {
                    this.gameScreen.musTime = 0L;
                    this.mt = 0L;
                    this.gameScreen.init();
                } else {
                    this.gameScreen.destroyMusic();
                }
            }
            if (this.height3D != this.getHeight() / 2 - this.getHeight() * Main.getDisplaySize() / 200) {
                this.gameScreen.resize();
                this.gameScreen.scene.getG3D().resize(this.getWidth(), this.getHeight() * Main.getDisplaySize() / 100);
            }
            this.gameScreen.paused = false;
            Main.setCurrent(this.gameScreen);
            this.gameScreen.start();
            if (Main.isMusic) {
                this.gameScreen.startMus(this.mt);
            }
            this.background = null;
            System.gc();
            this.gameScreen = null;
        }
        if (item == (Main.pauseScreenSave ? 3 : 2)) {
            Main.setCurrent(new Setting(this.main, this, this.background));
        }
        if (item == this.getItems().length - 1 && DeveloperMenu.debugMode) {
            Main.setCurrent(new DeveloperMenu(this.main, this, this.background));
        }
    }
}

