/*
 * Decompiled with CFR 0.152.
 */
package code.Rendering;

import java.util.Vector;

class TextureCompressor {
    TextureCompressor() {
    }

    public static int[] compress(int w, int h, int[] rgb) {
        int[] img = new int[w / 4 * h / 4 * 5];
        Vector<Integer> colors = new Vector<Integer>();
        boolean hasAlpha = false;
        int im = 0;
        for (int y = 0; y < h / 4; ++y) {
            for (int x = 0; x < w / 4; ++x) {
                int ids = 0;
                colors.removeAllElements();
                for (int xx = x * 4; xx < x * 4 + 4; ++xx) {
                    for (int yy = y * 4; yy < y * 4 + 4; ++yy) {
                        int color = rgb[xx + yy * w];
                        if ((color >> 24 & 0xFF) == 0) {
                            hasAlpha = true;
                            continue;
                        }
                        if (TextureCompressor.hasColor(colors, color)) continue;
                        colors.addElement(new Integer(color));
                    }
                }
                int[] sColors = TextureCompressor.sortColors(colors);
                int[] outcolors = new int[4];
                if (hasAlpha) {
                    outcolors[0] = 0;
                    if (sColors.length <= 3) {
                        if (sColors.length >= 1) {
                            outcolors[1] = sColors[0];
                        }
                        if (sColors.length >= 2) {
                            outcolors[2] = sColors[1];
                        }
                        if (sColors.length >= 3) {
                            outcolors[3] = sColors[2];
                        }
                    } else {
                        outcolors[1] = sColors[0];
                        outcolors[2] = sColors[sColors.length / 2];
                        outcolors[3] = sColors[sColors.length - 1];
                    }
                } else if (sColors.length <= 4) {
                    if (sColors.length >= 1) {
                        outcolors[0] = sColors[0];
                    }
                    if (sColors.length >= 2) {
                        outcolors[1] = sColors[1];
                    }
                    if (sColors.length >= 3) {
                        outcolors[2] = sColors[2];
                    }
                    if (sColors.length >= 4) {
                        outcolors[3] = sColors[3];
                    }
                } else {
                    outcolors[0] = sColors[0];
                    outcolors[1] = sColors[sColors.length / 3];
                    outcolors[2] = sColors[sColors.length * 2 / 3];
                    outcolors[3] = sColors[sColors.length - 1];
                }
                int ind = 0;
                for (int yy = y * 4; yy < y * 4 + 4; ++yy) {
                    for (int xx = x * 4; xx < x * 4 + 4; ++xx) {
                        int color = rgb[xx + yy * w];
                        int id = (color >> 24 & 0xFF) == 0 ? 0 : TextureCompressor.findNearest(outcolors, color);
                        ids |= (id & 3) << ind * 2;
                        ++ind;
                    }
                }
                img[im * 5 + 0] = outcolors[0];
                img[im * 5 + 1] = outcolors[1];
                img[im * 5 + 2] = outcolors[2];
                img[im * 5 + 3] = outcolors[3];
                img[im * 5 + 4] = ids;
                ++im;
            }
        }
        return img;
    }

    static boolean hasColor(Vector vec, int color) {
        for (int i = 0; i < vec.size(); ++i) {
            if ((Integer)vec.elementAt(i) != color) continue;
            return true;
        }
        return false;
    }

    static int[] sortColors(Vector vec) {
        int[] out = new int[vec.size()];
        for (int i = 0; i < vec.size(); ++i) {
            out[i] = (Integer)vec.elementAt(i);
        }
        for (int end = out.length - 1; end > 0; --end) {
            for (int i = 1; i <= end; ++i) {
                if (out[i - 1] <= out[i]) continue;
                int t = out[i - 1];
                out[i - 1] = out[i];
                out[i] = t;
            }
        }
        return out;
    }

    static int findNearest(int[] arr, int col) {
        int nearest = 0;
        int dist = Integer.MAX_VALUE;
        int r = col >> 16 & 0xFF;
        int g = col >> 8 & 0xFF;
        int b = col & 0xFF;
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i] == 0) continue;
            int rr = arr[i] >> 16 & 0xFF;
            int gg = arr[i] >> 8 & 0xFF;
            int bb = arr[i] & 0xFF;
            int ndist = Math.abs(rr - r) + Math.abs(gg - g) + Math.abs(bb - b);
            if (ndist >= dist) continue;
            nearest = i;
            dist = ndist;
        }
        return nearest;
    }
}

