/*
 * Decompiled with CFR 0.152.
 */
package code.AI;

import code.AI.BigZombie;
import code.AI.Bot;
import code.Gameplay.Map.House;
import code.Gameplay.Map.Portal;
import code.Gameplay.Map.Scene;
import code.Gameplay.Objects.GameObject;
import code.Math.Matrix;
import code.Math.Vector3D;
import code.Rendering.DirectX7;
import code.Rendering.Meshes.BoundingBox;
import code.Rendering.Meshes.MeshImage;
import code.Rendering.MultyTexture;
import code.utils.FPS;
import java.util.Vector;

public final class Zombie
extends Bot {
    public static byte fallDeath = 1;
    public static boolean bloodHas = true;
    public static int maxHP = 400;
    public static int model_height = 2000;
    private static BoundingBox boundingBox;
    public static int[] attackTo;
    public static int enemyReaction;
    public static int animSpeed;
    public static int attackDamage;
    public static int walkSpeed;
    public static int attackAnimSpeed;
    public static float jumpSpeed;
    public static int reactTimer;
    public static MultyTexture texture;
    public static int jumpHeight;
    public static int attackState;
    public static MeshImage model;
    public static float attackRadius;
    public static int moneyOnDeath;
    public static int attackTimer;
    public static int AI;
    private int state = -1;
    public MeshImage meshImage;
    private GameObject enemy = null;
    private boolean notCol = false;
    private final Vector3D dir = new Vector3D();

    public Zombie(Vector3D pos) {
        if (model != null) {
            this.meshImage = new MeshImage(model.getMesh(), model.getAnimation());
            boundingBox = new BoundingBox(model.getAnimation());
        }
        this.name = "ZOMBIE";
        this.fraction = 1;
        this.character.getTransform().setIdentity();
        this.set(pos);
        this.deathFall = fallDeath;
        this.hasBlood = BigZombie.bloodHas;
    }

    public final void set(Vector3D pos) {
        super.set(pos);
        this.setHp(maxHP);
        this.setCharacterSize(model_height);
        this.dir.set(pos.x, pos.y, pos.z + 50);
        this.lookAt(pos.x, pos.z + 50);
        this.notCol = false;
    }

    public final void destroy() {
        super.destroy();
        this.enemy = null;
        this.meshImage = null;
    }

    public final void render(DirectX7 g3d, int x1, int y1, int x2, int y2) {
        if (!this.visible) {
            return;
        }
        Matrix mat = this.getCharacter().getTransform();
        Matrix finalMatrix = g3d.computeFinalMatrix(mat);
        if (!boundingBox.isVisible(g3d, finalMatrix, x1, y1, x2, y2)) {
            return;
        }
        if (mat.m11 == 16384) {
            if (this.state == 1) {
                this.meshImage.setFrame(this.getFrameInter() * animSpeed / 100);
            }
            if (this.state == 2) {
                this.meshImage.setFrame(this.getFrameInter() * attackAnimSpeed / 100);
            }
        }
        this.meshImage.setMatrix(finalMatrix);
        this.meshImage.setTexture(texture);
        g3d.addRenderObject(this.meshImage, x1, y1, x2, y2);
        this.meshImage.sz += this.character.getRadius();
        if (this.character.oldFloorPoly != null && this.character.oldFloorPoly.sz > this.meshImage.sz) {
            this.character.oldFloorPoly.sz = this.meshImage.sz - 1;
        }
        this.renderBlood(g3d, 1500);
    }

    protected final void action(Scene scene) {
        if (Math.abs(this.getFrameInterDiv()) % reactTimer == 1) {
            House house = scene.getHouse();
            Vector objects = house.getObjects();
            if (this.enemy != null && this.enemy.isDead() || this.enemy != null && FPS.frames == 0) {
                this.enemy = null;
            }
            this.enemy = this.findBot(objects, this, attackTo);
            if (this.enemy != null) {
                Vector3D walkTo = this.dir;
                if (this.notCollided(house, this.enemy) && scene.getHouse().isNear(this.getPart(), this.enemy.getPart())) {
                    Matrix var8 = this.enemy.getCharacter().getTransform();
                    walkTo.set(var8.m03, var8.m13, var8.m23);
                    this.notCol = true;
                } else {
                    int nextPart = scene.getNext(this.getPart(), this.enemy.getPart());
                    Portal portal = Zombie.commonPortal(house, this.getPart(), nextPart);
                    if (portal != null) {
                        Zombie.computeCentre(portal, walkTo);
                    }
                    this.notCol = false;
                }
                this.lookAt(this.dir.x, this.dir.z);
                long distance = this.character.distance(this.enemy.getCharacter());
                if (this.notCol && (float)distance <= (float)Zombie.sqr(this.character.getRadius() + this.enemy.getCharacter().getRadius()) * attackRadius) {
                    this.state = enemyReaction;
                } else {
                    if (this.character.isCollision()) {
                        this.character.jump(jumpHeight, jumpSpeed);
                    }
                    this.state = AI;
                }
            } else {
                this.state = -1;
            }
        }
        if (this.state == 1) {
            this.moveZ(walkSpeed);
        }
        if (this.state == attackState && this.getFrameInterDiv() % attackTimer == 0 && this.notCol) {
            this.enemy.damage(this, attackDamage);
        }
    }

    protected final void drop(Scene scene) {
        super.drop(scene);
        this.state = -1;
    }

    static {
        enemyReaction = 2;
        animSpeed = 140;
        attackDamage = 1;
        walkSpeed = 140;
        attackAnimSpeed = 700;
        jumpSpeed = 1.2f;
        reactTimer = 8;
        jumpHeight = 140;
        attackState = 2;
        attackRadius = 1.2f;
        moneyOnDeath = 10;
        attackTimer = 8;
        AI = 1;
    }
}

