/*
 * Decompiled with CFR 0.152.
 */
package code.utils;

import code.utils.FPS;
import javax.microedition.lcdui.Canvas;

public class Keyboard {
    public final int LEFT;
    public final int RIGHT;
    public final int UP;
    public final int DOWN;
    public final int FIRE;
    public final int SOFT_LEFT;
    public final int SOFT_RIGHT;
    public boolean up;
    public boolean down;
    public boolean left;
    public boolean right;
    public boolean key1;
    public boolean key3;
    public boolean key7;
    public boolean key9;
    public boolean star;
    public boolean pound;
    public boolean key0;
    public boolean fire;
    public long upAction;
    public long downAction;
    public long leftAction;
    public long rightAction;
    public long okAction;

    public Keyboard(Canvas c) {
        if (Keyboard.isSelect(c, -26)) {
            this.LEFT = -61;
            this.RIGHT = -62;
            this.DOWN = -60;
            this.UP = -59;
            this.FIRE = -26;
            this.SOFT_LEFT = -1;
            this.SOFT_RIGHT = -4;
        } else if (Keyboard.isSelect(c, -20)) {
            this.LEFT = -2;
            this.RIGHT = -5;
            this.DOWN = -6;
            this.UP = -1;
            this.FIRE = -20;
            this.SOFT_LEFT = -21;
            this.SOFT_RIGHT = -22;
        } else {
            this.LEFT = -3;
            this.RIGHT = -4;
            this.DOWN = -2;
            this.UP = -1;
            this.FIRE = -5;
            this.SOFT_LEFT = -6;
            this.SOFT_RIGHT = -7;
        }
        this.reset();
    }

    private static boolean isSelect(Canvas c, int i) {
        try {
            return c.getKeyName(i).toUpperCase().indexOf("SELECT") != -1;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public void reset() {
        this.fire = false;
        this.pound = false;
        this.star = false;
        this.key9 = false;
        this.key7 = false;
        this.key3 = false;
        this.key1 = false;
        this.right = false;
        this.left = false;
        this.down = false;
        this.up = false;
    }

    public void keyPressed(int keyCode) {
        this.keyInput(keyCode, true);
    }

    public void keyReleased(int keyCode) {
        this.keyInput(keyCode, false);
    }

    public void keyInput(int keyCode, boolean pressed) {
        if (keyCode == this.UP || keyCode == 50) {
            this.up = pressed;
            this.upAction = FPS.currentTime;
        }
        if (keyCode == this.DOWN || keyCode == 56) {
            this.down = pressed;
            this.downAction = FPS.currentTime;
        } else if (keyCode == this.LEFT || keyCode == 52) {
            this.left = pressed;
            this.leftAction = FPS.currentTime;
        } else if (keyCode == this.RIGHT || keyCode == 54) {
            this.right = pressed;
            this.rightAction = FPS.currentTime;
        } else if (keyCode == this.FIRE || keyCode == 53) {
            this.fire = pressed;
            this.okAction = FPS.currentTime;
        } else if (keyCode == 49) {
            this.key1 = pressed;
        } else if (keyCode == 51) {
            this.key3 = pressed;
        } else if (keyCode == 55) {
            this.key7 = pressed;
        } else if (keyCode == 57) {
            this.key9 = pressed;
        } else if (keyCode == 48) {
            this.key0 = pressed;
        } else if (keyCode == 42) {
            this.star = pressed;
        } else if (keyCode == 35) {
            this.pound = pressed;
        }
    }
}

