/*
 * Decompiled with CFR 0.152.
 */
package code.utils;

import java.io.InputStream;
import java.util.Vector;

public class StringTools {
    public static String getStringFromResource(String file) {
        InputStream is = null;
        try {
            int ch;
            is = new Object().getClass().getResourceAsStream(file);
            StringBuffer str = new StringBuffer();
            while ((ch = is.read()) != -1) {
                if (ch == 13) continue;
                if (ch >= 192 && ch <= 255) {
                    ch += 848;
                }
                str.append((char)ch);
            }
            is.close();
            return str.toString();
        }
        catch (Exception exc) {
            System.out.println("Reading txt error: " + exc);
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    private static Vector fragments(String text, char divider) {
        Vector<String> fragments = new Vector<String>();
        int start = 0;
        while (start < text.length()) {
            int end = text.indexOf(divider, start);
            if (end == -1) {
                end = text.length();
            }
            if (start < end) {
                fragments.addElement(text.substring(start, end));
            }
            start = end + 1;
        }
        return fragments;
    }

    public static String[] cutOnStrings(String str, char d) {
        if (str == null) {
            return null;
        }
        Vector fragments = StringTools.fragments(str, d);
        Object[] out = new String[fragments.size()];
        fragments.copyInto(out);
        return out;
    }

    public static int[] cutOnInts(String str, char d) {
        if (str == null) {
            return null;
        }
        Vector fragments = StringTools.fragments(str, d);
        int[] out = new int[fragments.size()];
        for (int i = 0; i < out.length; ++i) {
            out[i] = StringTools.parseInt((String)fragments.elementAt(i));
        }
        return out;
    }

    public static float[] cutOnFloats(String str, char d) {
        if (str == null) {
            return null;
        }
        Vector fragments = StringTools.fragments(str, d);
        float[] out = new float[fragments.size()];
        for (int i = 0; i < out.length; ++i) {
            out[i] = StringTools.parseFloat((String)fragments.elementAt(i));
        }
        return out;
    }

    public static float parseFloat(String val) {
        return Float.parseFloat(val.trim());
    }

    public static int parseInt(String val) {
        return Integer.parseInt(val.trim());
    }

    public static int cleverParseInt(String val) {
        int ind = (val = val.trim()).indexOf(46);
        if (ind > -1) {
            val = val.substring(0, ind);
        }
        return Integer.parseInt(val);
    }

    public static byte parseByte(String val) {
        return Byte.parseByte(val.trim());
    }

    public static long parseLong(String val) {
        return Long.parseLong(val.trim());
    }

    public static boolean isNumeric(String s) {
        if (s == null) {
            return false;
        }
        s = s.trim();
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (ch == '-' || Character.isDigit(ch)) continue;
            return false;
        }
        return true;
    }

    public static String deleteNonNumeric(String s) {
        while (s.length() > 0 && !Character.isDigit(s.charAt(0)) && s.charAt(0) != '-') {
            s = s.substring(1, s.length());
        }
        while (s.length() > 0 && !Character.isDigit(s.charAt(s.length() - 1))) {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }

    public static int getRGB(String rgbs, char div) {
        int[] rgb = StringTools.cutOnInts(rgbs, div);
        return rgb[0] << 16 | rgb[1] << 8 | rgb[2];
    }

    public static int parseXMLColor(String argb) {
        int col = 0;
        argb = argb.toUpperCase();
        for (int i = 1; i < argb.length(); ++i) {
            char ch = argb.charAt(i);
            int val = Character.isDigit(ch) ? ch - 48 : ch - 65 + 10;
            col |= val << (6 - i) * 4;
        }
        return col;
    }
}

