/*
 * Decompiled with CFR 0.152.
 */
package code.Gameplay.Objects;

import code.AI.Player;
import code.Gameplay.GameScreen;
import code.Gameplay.Inventory.ItemList;
import code.Gameplay.Inventory.ItemsEngine;
import code.Gameplay.Map.House;
import code.Gameplay.Map.RoomObject;
import code.Math.Matrix;
import code.Math.Vector3D;
import code.Rendering.DirectX7;
import code.Rendering.Meshes.Mesh;
import code.Rendering.Meshes.Sprite;
import code.Rendering.MultyTexture;
import code.utils.Asset;
import code.utils.IniFile;
import code.utils.Main;
import code.utils.StringTools;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class ItemsBag
extends RoomObject {
    public static int addsz = -1;
    public static Matrix matrix = new Matrix();
    public Vector3D pos = new Vector3D(0, 0, 0);
    public Mesh mesh;
    public Sprite spr;
    public ItemList items;

    public ItemsBag(Vector3D pos2) {
        this.activable = true;
        this.clickable = true;
        this.radius = 800L;
        this.items = new ItemList();
        this.pos.set(pos2);
        float scale = Main.settings.getFloat("BAG_SCALE", 1.0f);
        String meshStr = Main.settings.get("BAG_MESH");
        String tex = Main.settings.get("BAG_TEXTURE");
        if (meshStr != null) {
            this.mesh = Asset.getMeshCloneDynamic(meshStr, scale, scale, scale);
            this.mesh.setTexture(new MultyTexture(tex, true));
        } else {
            this.spr = new Sprite(Asset.getTexture(tex), (int)scale);
        }
        if (addsz == -1) {
            addsz = Main.settings.getInt("BAG_ADDSZ", 4500);
        }
    }

    public final void destroy() {
    }

    public final void render(DirectX7 g3d, int x1, int y1, int x2, int y2) {
        matrix.setPosition(this.pos);
        Matrix mat = g3d.computeFinalMatrix(matrix);
        if (this.mesh != null) {
            g3d.transformAndProjectVertices(this.mesh, mat);
            g3d.addMesh(this.mesh, x1, y1, x2, y2, this.mesh.getTexture());
            this.mesh.increaseMeshSz(addsz);
        } else {
            this.spr.updateFrame();
            this.spr.getPosition().set(this.pos.x, this.pos.y, this.pos.z);
            this.spr.project(g3d.getInvCamera(), g3d);
            if (!this.spr.isVisible(x1, y1, x2, y2)) {
                return;
            }
            g3d.addRenderObject(this.spr, x1, y1, x2, y2);
            this.spr.sz += addsz;
        }
    }

    public final int getPosX() {
        return this.pos.x;
    }

    public final int getPosZ() {
        return this.pos.z;
    }

    public final int getPosY() {
        return this.pos.y;
    }

    public final void setPos(int x, int y, int z) {
        this.pos.set(x, y, z);
    }

    public void activate(House house, Player player, GameScreen gs) {
        this.message = Main.getGameText().get("ITEMS_PICKEDUP") + ":";
        for (int i = 0; i < this.items.size(); ++i) {
            int itemId = this.items.itemAt(i);
            int count = this.items.itemAtCount(i);
            IniFile item = ItemsEngine.items[itemId];
            String itemName = item.get("NAME");
            String tmp = Main.getGameText().get(itemName + "_ITEM");
            if (tmp != null) {
                itemName = tmp;
            }
            this.message = this.message + '*' + itemName;
            if (this.items.itemAtCount(i) > 1) {
                this.message = this.message + " " + String.valueOf(count) + "x";
            }
            player.items.addItem(itemId, count);
            String pickupScript = item.get("ON_PICKUP");
            if (pickupScript == null) continue;
            gs.runScript(StringTools.cutOnStrings(pickupScript, ';'));
        }
        this.prMsg(gs);
        house.removeObject(this);
    }

    public void writeSave(DataOutputStream dos) throws IOException {
        dos.writeInt(this.pos.x);
        dos.writeInt(this.pos.y);
        dos.writeInt(this.pos.z);
        this.items.writeSave(dos);
    }

    public void loadSave(DataInputStream dis) throws IOException {
        this.pos.set(dis.readInt(), dis.readInt(), dis.readInt());
        this.items.loadSave(dis);
    }
}

