/*
 * Decompiled with CFR 0.152.
 */
package com.Gameplay.Objects;

import com.AI.NPC;
import com.AI.Player;
import com.Gameplay.GameScreen;
import com.Gameplay.Map.House;
import com.Gameplay.Map.RoomObject;
import com.Gameplay.Map.Scene;
import com.Math.Vector3D;
import com.Rendering.DirectX7;
import com.misc.Asset;
import com.misc.Main;
import java.util.Vector;

public final class NPCSpawner
extends RoomObject {
    public Vector3D pos = new Vector3D(0, 0, 0);
    public int rot = 0;
    public NPC[] bots;
    public boolean visible = false;
    public long lastVisiblityCheck = 0L;
    private boolean dead = false;
    private long lastSpawn = 0L;
    public int respawnIn = 5000;
    public int canSpawn = 1;
    public int spawned = 0;
    public long distanceToSpawn = -1L;
    public boolean visiblityChecker = true;
    private boolean distanceAccess = true;
    private long lastDistanceCheck = 0L;
    public String[] onSpawn;
    public int spawnerId = -1;

    public NPCSpawner(Vector3D pos2) {
        this.pos.set(pos2);
    }

    public final void destroy() {
    }

    public final void render(DirectX7 g3d, int x1, int y1, int x2, int y2) {
        if (System.currentTimeMillis() - this.lastVisiblityCheck >= 500L && this.visiblityChecker) {
            this.visible = this.visiblyCheck(g3d, x1, y1, x2, y2);
            this.lastVisiblityCheck = System.currentTimeMillis();
        }
    }

    public final boolean visiblyCheck(DirectX7 g3d, int x1, int y1, int x2, int y2) {
        boolean vis = false;
        for (int i = 0; i < this.bots.length; ++i) {
            vis = vis || this.bots[i].checkVisiblity(g3d, this.pos.x, this.pos.y, this.pos.z, x1, y1, x2, y2);
        }
        return vis;
    }

    public final boolean deathCheck() {
        boolean dea = true;
        for (int i = 0; i < this.bots.length; ++i) {
            dea = dea && this.bots[i].isDead();
        }
        return dea;
    }

    public final boolean renewCheck() {
        boolean dea = false;
        for (int i = 0; i < this.bots.length; ++i) {
            dea = dea || this.bots[i].isTimeToRenew();
        }
        return dea;
    }

    public final void update(Scene scene, Player player, GameScreen gs) {
        if (this.dead != this.deathCheck()) {
            this.dead = this.deathCheck();
            this.lastSpawn = System.currentTimeMillis();
        }
        if (this.canSpawn <= this.spawned && this.canSpawn != -1 || !this.renewCheck() && this.spawned > 0) {
            return;
        }
        if (System.currentTimeMillis() - this.lastVisiblityCheck >= 1000L || !this.visiblityChecker) {
            this.visible = false;
        }
        if (!this.distanceAccess && !this.visible && this.distance(player) > (this.distanceToSpawn ^ 2L)) {
            this.distanceAccess = true;
            this.lastDistanceCheck = System.currentTimeMillis();
        }
        if (!this.visible && System.currentTimeMillis() - this.lastDistanceCheck > 8000L && System.currentTimeMillis() - this.lastSpawn >= (long)this.respawnIn && Main.updateOnlyNear) {
            this.distanceAccess = true;
            this.lastDistanceCheck = System.currentTimeMillis();
        }
        if (!this.visible && System.currentTimeMillis() - this.lastSpawn >= (long)this.respawnIn && (this.distanceToSpawn == -1L || this.distanceAccess)) {
            this.spawn(scene.getHouse(), scene, gs);
        }
    }

    private long distance(Player player) {
        return player.getPosX() - this.getPosX() ^ 2 + (player.getPosY() - this.getPosY()) ^ 2 + (player.getPosZ() - this.getPosZ()) ^ 2;
    }

    public final void spawn(House house, Scene scene, GameScreen gs) {
        if (this.canSpawn(house, scene.botLimiter, this.bots[0].fraction)) {
            for (int i = 0; i < this.bots.length; ++i) {
                house.removeObject(this.bots[i]);
                this.bots[i].init(this.pos);
                this.bots[i].getCharacter().getTransform().m03 += i * 10;
                this.bots[i].getCharacter().rotY(this.rot);
                house.addObject(this.bots[i]);
                ++this.spawned;
            }
            this.distanceAccess = false;
            this.lastDistanceCheck = System.currentTimeMillis();
            if (this.onSpawn != null) {
                this.give(this.onSpawn, gs.player, house, gs);
            }
        }
    }

    public final void setPos(int x, int y, int z) {
        this.pos.set(x, y, z);
    }

    private boolean canSpawn(House house, int[] limiter, int frac) {
        if (limiter == null) {
            return true;
        }
        int count = 0;
        int max = -1;
        for (int i = 0; i < limiter.length / 2; ++i) {
            if (limiter[i * 2] != frac) continue;
            max = limiter[i * 2 + 1];
            break;
        }
        if (max == -1) {
            return true;
        }
        Vector objs = Main.updateOnlyNear ? house.getNearObjects(this.getPart()) : house.getObjects();
        if (objs == null) {
            return true;
        }
        if (objs.isEmpty()) {
            return true;
        }
        for (int i = 0; i < objs.size(); ++i) {
            RoomObject obj = (RoomObject)objs.elementAt(i);
            if (!(obj instanceof NPC) || ((NPC)obj).fraction != frac) continue;
            ++count;
        }
        return count + this.bots.length <= max;
    }

    public final int getPosX() {
        return this.pos.x;
    }

    public final int getPosZ() {
        return this.pos.z;
    }

    public final int getPosY() {
        return this.pos.y;
    }

    public void activate(House house, Player player, GameScreen gs) {
        if (this.lastActivate > 0L && this.lastActivate + this.timeToReset > GameScreen.time) {
            return;
        }
        if (!this.isAllCollected(Player.usedPoints, player, house, gs)) {
            if (this.errMessage != null) {
                this.errMsg(gs);
            }
            return;
        }
        if (this.sound != null && Main.isSounds && Main.sounds != 0) {
            Asset.getSound(this.sound).start(Main.sounds);
        }
        if (!(this.singleUse && this.activated || this.message == null)) {
            this.prMsg(gs);
        }
        if (!this.singleUse || !this.activated) {
            this.give(this.additional, player, house, gs);
        }
        if (!this.contains(Player.usedPoints, this.name)) {
            this.give(this.name, player);
            this.spawn(house, gs.scene, gs);
            this.activated = true;
            if (this.lastActivate >= 0L) {
                this.lastActivate = GameScreen.time;
            }
        }
        if (this.destroyOnUse) {
            house.removeObject(this);
        }
    }
}

