/*
 * Decompiled with CFR 0.152.
 */
package com.Rendering.Meshes;

import com.Rendering.Meshes.Mesh;
import com.Rendering.Vertex;

public final class Morphing {
    private short[][] animation;
    private Mesh mesh;
    private int frame = 0;
    public static final int fp = 10;
    public static final int FP = 1024;

    public final void destroy() {
        this.animation = null;
        this.mesh = null;
    }

    public short[][] getVertices() {
        return this.animation;
    }

    public static short[][] create(Mesh[] meshes) {
        short[][] var1 = new short[meshes.length][];
        for (int var2 = 0; var2 < meshes.length; ++var2) {
            Mesh var3 = meshes[var2];
            Vertex[] var7 = var3.getVertices();
            short[] var4 = new short[var7.length * 3];
            for (int var5 = 0; var5 < var7.length; ++var5) {
                Vertex var6 = var7[var5];
                var4[var5 * 3] = (short)var6.x;
                var4[var5 * 3 + 1] = (short)var6.y;
                var4[var5 * 3 + 2] = (short)var6.z;
            }
            var1[var2] = var4;
        }
        return var1;
    }

    public Morphing() {
    }

    public Morphing(short[][] animation, Mesh mesh) {
        this.animation = animation;
        this.mesh = mesh;
    }

    public int getMaxFrame() {
        return 1024 * this.animation.length;
    }

    public int getFrame() {
        return this.frame;
    }

    public final void setFrameNI(int frame) {
        int maxFrame = this.getMaxFrame();
        while (frame < 0) {
            frame += maxFrame;
        }
        this.frame = frame %= maxFrame;
    }

    public final void setFrame(int frame) {
        int maxFrame = this.getMaxFrame();
        while (frame < 0) {
            frame += maxFrame;
        }
        this.frame = frame %= maxFrame;
        this.interpolation(this.mesh.getVertices());
    }

    void interpolation(Vertex[] versRes) {
        int n = this.frame / 1024;
        int a = n % this.animation.length;
        int b = (n + 1) % this.animation.length;
        this.interpolation(this.animation[a], this.animation[b], versRes, this.frame % 1024);
    }

    private void interpolation(short[] versA, short[] versB, Vertex[] versRes, int frame) {
        int k = 1024 - frame;
        for (int i = 0; i < versRes.length; ++i) {
            int n = i * 3;
            short ax = versA[n];
            short ay = versA[n + 1];
            short az = versA[n + 2];
            short bx = versB[n];
            short by = versB[n + 1];
            short bz = versB[n + 2];
            versRes[i].set((ax * k >> 10) + (bx * frame >> 10), (ay * k >> 10) + (by * frame >> 10), (az * k >> 10) + (bz * frame >> 10));
        }
    }

    public final void setFrame2(int frame) {
        this.frame = frame;
        Morphing var13 = this;
        int var4 = frame % 1024;
        Mesh var3 = this.mesh;
        short[][] var2 = this.animation;
        int var5 = (frame /= 1024) % var2.length;
        frame = (frame + 1) % var2.length;
        short[] var10000 = var2[var5];
        short[] var10001 = var2[frame];
        int var17 = var4;
        short[] var14 = var10001;
        short[] var18 = var10000;
        Vertex[] var16 = var3.getVertices();
        var5 = 1024 - var4;
        for (int var6 = 0; var6 < var16.length; ++var6) {
            int var7 = var6 * 3;
            short var8 = var18[var7];
            short var9 = var18[var7 + 1];
            short var10 = var18[var7 + 2];
            short var11 = var14[var7];
            short var12 = var14[var7 + 1];
            short var19 = var14[var7 + 2];
            var16[var6].set((var8 * var5 >> 10) + (var11 * var17 >> 10), (var9 * var5 >> 10) + (var12 * var17 >> 10), (var10 * var5 >> 10) + (var19 * var17 >> 10));
        }
    }

    public final Mesh getMesh() {
        return this.mesh;
    }

    public final short[][] getAnimation() {
        return this.animation;
    }
}

