/*
 * Decompiled with CFR 0.152.
 */
package com.Rendering;

import com.Rendering.Meshes.Mesh;
import com.Rendering.Texture;
import com.misc.Asset;
import com.misc.Stringer;

public class MultyTexture {
    public Texture[] textures;

    MultyTexture() {
    }

    public MultyTexture(String files, boolean iz) {
        String[] texList = Mesh.cutOnStrings(files, ',', ';');
        this.textures = new Texture[texList.length];
        for (int it = 0; it < texList.length; ++it) {
            String[] anims = Mesh.cutOnStrings(texList[it], ':');
            if (anims.length == 1) {
                this.textures[it] = Asset.getTexture(anims[0]);
                this.textures[it].setPerspectiveCorrection(iz);
                continue;
            }
            this.textures[it] = Asset.getTexture(anims[1]);
            this.textures[it].animation_speed = Float.parseFloat(Stringer.deleteExtremeSpaces(anims[0]));
            this.textures[it].animMIP = new Texture[anims.length - 1];
            for (int i = 1; i < anims.length; ++i) {
                this.textures[it].animMIP[i - 1] = Asset.getTexture(anims[i]);
            }
            this.textures[it].setPerspectiveCorrection(iz);
        }
    }

    public MultyTexture(String[] texList) {
        this.textures = new Texture[texList.length];
        for (int i = 0; i < texList.length; ++i) {
            System.out.println("Loading Texture:" + i);
            String[] texInfo = Mesh.cutOnStrings(texList[i], ',', ';');
            String[] animation = Mesh.cutOnStrings(texInfo[0], ':');
            this.textures[i] = Asset.getTexture(Stringer.deleteExtremeSpaces(animation[animation.length > 1 ? 1 : 0]));
            if (animation.length > 1) {
                this.textures[i].animation_speed = Float.parseFloat(Stringer.deleteExtremeSpaces(animation[0]));
                this.textures[i].animMIP = new Texture[animation.length - 1];
                for (int i2 = 1; i2 < animation.length; ++i2) {
                    this.textures[i].animMIP[i2 - 1] = Asset.getTexture(Stringer.deleteExtremeSpaces(animation[i]));
                }
            }
            this.textures[i].setPerspectiveCorrection(true);
            if (texInfo.length >= 2 && !Stringer.removeEmpty(texInfo[1].toLowerCase()).equals("std")) {
                this.textures[i].drawmode = (byte)Stringer.parseInt(texInfo[1]);
            }
            if (texInfo.length >= 3) {
                this.textures[i].addsz = Stringer.parseInt(texInfo[2]);
            }
            if (texInfo.length < 4) continue;
            this.textures[i].setPerspectiveCorrection(Stringer.parseInt(texInfo[3]) == 1);
        }
        System.out.println("Textures Imported");
    }

    public MultyTexture(Texture tex) {
        this.textures = new Texture[1];
        this.textures[0] = tex;
    }

    public void updateAnimation() {
        for (int i = 0; i < this.textures.length; ++i) {
            this.textures[i].updateAnimation();
        }
    }
}

