/*
 * Decompiled with CFR 0.152.
 */
package com.misc;

import java.util.Random;
import javax.microedition.lcdui.Graphics;

public class WeatherGenerator {
    public byte generate;
    public float[] coords;
    public int[] info;
    public int screenWidth;
    public int screenHeight;
    public int rainColorNear;
    public int rainColorFar;
    public int snowColorNear;
    public int snowColorFar;
    public boolean lighting = false;
    public int snowSize;
    public int rainSize;
    public int fov;
    public int centerX;
    public int centerY;
    public int snowSpeed;
    public int rainSpeed;
    public boolean isZoom = false;

    public WeatherGenerator(int scrwidth, int scrheight, int quality, int rcn, int rcf, int scn, int scf, boolean light, int ss, int fovv, int cenx, int ceny, int sspeed, int rspeed, int rs) {
        this.screenWidth = scrwidth;
        this.screenHeight = scrheight;
        this.coords = new float[quality * scrwidth / 240 * scrheight / 320 * 2];
        this.info = new int[quality * scrwidth / 240 * scrheight / 320 * 2];
        this.clearBuffers();
        this.lighting = light;
        this.rainColorNear = rcn;
        this.rainColorFar = rcf;
        this.snowColorNear = scn;
        this.snowColorFar = scf;
        this.snowSize = ss * scrheight / 320;
        if (this.snowSize < ss) {
            this.snowSize = ss;
        }
        this.rainSize = rs * scrheight / 320;
        if (this.rainSize < rs) {
            this.rainSize = rs;
        }
        this.fov = fovv * scrwidth / scrheight;
        this.centerX = cenx;
        this.centerY = ceny;
        this.snowSpeed = sspeed * scrheight / 320;
        this.rainSpeed = rspeed * scrheight / 320;
        this.generate = 0;
    }

    public void clearBuffers() {
        int i;
        for (i = 0; i < this.coords.length; ++i) {
            this.coords[i] = 0.0f;
        }
        for (i = 0; i < this.info.length; ++i) {
            this.info[i] = 0;
        }
    }

    public void createParticles() {
        Random r = new Random();
        for (int i = 0; i < this.coords.length / 2; ++i) {
            if (this.info[i * 2] != 0) continue;
            this.coords[i * 2 + 1] = r.nextInt(this.screenHeight);
            this.coords[i * 2] = r.nextInt(this.screenWidth);
            this.info[i * 2] = this.generate;
            this.info[i * 2 + 1] = r.nextInt(100);
        }
    }

    public void moveX(int x, int fps) {
        float xx = x * 600 / fps;
        for (int i = 0; i < this.coords.length / 2; ++i) {
            int depth = this.info[i * 2 + 1] / 22;
            if (depth <= 0) {
                depth = 1;
            }
            if (depth > 65) {
                depth = 65;
            }
            if (this.info[i * 2] == 0) continue;
            int n = i * 2;
            this.coords[n] = this.coords[n] + xx / (float)depth;
        }
    }

    public void moveX2(int x, int fps) {
        float xx = x * 800 / fps;
        for (int i = 0; i < this.coords.length / 2; ++i) {
            if (this.info[i * 2] == 0) continue;
            int n = i * 2;
            this.coords[n] = this.coords[n] + xx;
        }
    }

    public void moveY(int y, int fps) {
        float yy = (float)y * 1.3f * 800.0f / (float)fps;
        for (int i = 0; i < this.coords.length / 2; ++i) {
            if (this.info[i * 2] == 0) continue;
            int n = i * 2 + 1;
            this.coords[n] = this.coords[n] + yy;
        }
    }

    public void moveY2(int y, int fps) {
        float yy = (float)y * 1.3f * 600.0f / 80.0f / (float)fps;
        for (int i = 0; i < this.coords.length / 2; ++i) {
            int depth = this.info[i * 2 + 1] / 25;
            if (depth <= 0) {
                depth = 1;
            }
            if (depth > 65) {
                depth = 65;
            }
            if (this.info[i * 2] == 0) continue;
            int n = i * 2 + 1;
            this.coords[n] = this.coords[n] + yy / (float)depth;
        }
    }

    public void move(int z, int fps, int diry) {
        float zz = z * 550 / fps;
        this.isZoom = true;
        float mz = 1.0f + 0.05f * (float)z / 5.0f * 200.0f / (float)fps;
        Random r = new Random();
        int centerY2 = this.centerY * (90 + diry * 7 / 5) / 90;
        for (int i = 0; i < this.coords.length / 2; ++i) {
            if (this.info[i * 2] != 0) {
                float f = (this.coords[i * 2] - (float)this.centerX) * mz + (float)this.centerX;
                this.coords[i * 2] = f;
                float x = f;
                float f2 = (this.coords[i * 2 + 1] - (float)centerY2) * mz + (float)centerY2;
                this.coords[i * 2 + 1] = f2;
                float y = f2;
                int n = i * 2 + 1;
                this.info[n] = (int)((float)this.info[n] - zz / 3.5f);
                if (!(x > (float)this.screenWidth || x < 0.0f || y > (float)this.screenHeight) && !(y < 0.0f)) continue;
                this.coords[i * 2] = r.nextInt(this.screenWidth);
                this.coords[i * 2 + 1] = r.nextInt(this.screenHeight);
                this.info[i * 2 + 1] = 100;
                continue;
            }
            if (this.info[i * 2] != 0) continue;
            this.coords[i * 2] = r.nextInt(this.screenWidth);
            this.coords[i * 2 + 1] = r.nextInt(this.screenHeight);
            this.info[i * 2 + 1] = 100;
            this.info[i * 2] = this.generate;
        }
    }

    public void moveB(int z, int fps, int diry) {
        float zz = z * 550 / fps;
        float mz = 1.0f - 0.05f * (float)z / 5.0f * 200.0f / (float)fps;
        Random r = new Random();
        int centerY2 = this.centerY * (90 + diry * 7 / 5) / 90;
        for (int i = 0; i < this.coords.length / 2; ++i) {
            if (this.info[i * 2] == 0) continue;
            float f = (this.coords[i * 2] - (float)this.centerX) * mz + (float)this.centerX;
            this.coords[i * 2] = f;
            float x = f;
            float f2 = (this.coords[i * 2 + 1] - (float)centerY2) * mz + (float)centerY2;
            this.coords[i * 2 + 1] = f2;
            float y = f2;
            int n = i * 2 + 1;
            this.info[n] = (int)((float)this.info[n] + zz / 4.0f);
            if (this.info[i * 2 + 1] <= 100) continue;
            if (r.nextInt(2) == 0) {
                this.coords[i * 2] = r.nextInt(2) * this.screenWidth;
                this.coords[i * 2 + 1] = r.nextInt(this.screenHeight);
            } else {
                this.coords[i * 2] = r.nextInt(this.screenWidth);
                this.coords[i * 2 + 1] = r.nextInt(2) * this.screenHeight;
            }
            this.info[i * 2 + 1] = 0;
        }
    }

    public void update(int fps, int diry) {
        Random r = new Random();
        for (int i = 0; i < this.coords.length / 2; ++i) {
            if (this.coords[i * 2 + 1] < -2.0f) {
                int n = i * 2 + 1;
                this.coords[n] = this.coords[n] + (float)(this.screenHeight - 1);
            }
            if (this.coords[i * 2] > (float)this.screenWidth) {
                this.coords[i * 2] = this.coords[i * 2] - (float)this.screenWidth;
            }
            if (this.coords[i * 2] < -2.0f) {
                this.coords[i * 2] = this.coords[i * 2] + (float)this.screenWidth + 2.0f;
            }
            if (!this.isZoom) {
                if (this.coords[i * 2 + 1] > (float)this.screenHeight) {
                    this.info[i * 2] = 0;
                }
                if (this.coords[i * 2 + 1] > (float)(this.screenHeight * (diry + 90) / 180 + this.screenHeight / 5) && this.info[i * 2 + 1] > 40) {
                    this.info[i * 2] = 0;
                }
                if (this.coords[i * 2] > (float)(this.screenWidth + 10)) {
                    this.info[i * 2] = 0;
                }
                if (this.coords[i * 2] < -12.0f) {
                    this.info[i * 2] = 0;
                }
                if (this.info[i * 2] == 0) {
                    this.coords[i * 2 + 1] = 0.0f;
                    this.coords[i * 2] = r.nextInt(this.screenWidth);
                    this.info[i * 2] = this.generate;
                    this.info[i * 2 + 1] = r.nextInt(100);
                }
            }
            if (this.info[i * 2] == 2) {
                int rand = r.nextInt(3) - 1;
                int n = i * 2 + 1;
                this.info[n] = this.info[n] + rand * this.snowSpeed * 200 / fps / 4;
                int depth = this.info[i * 2 + 1];
                if (depth <= 0) {
                    depth = 1;
                }
                if (depth > 100) {
                    depth = 100;
                }
                depth = 100 - depth;
                if (this.info[i * 2 + 1] > 100) {
                    this.info[i * 2 + 1] = 100;
                }
                if (this.info[i * 2 + 1] < 0) {
                    this.info[i * 2 + 1] = 0;
                }
                int n2 = i * 2;
                this.coords[n2] = this.coords[n2] + (float)(rand * 2 * this.snowSpeed * 200 / ((100 - depth) / 50 + 1) / fps / 4);
                int n3 = i * 2 + 1;
                this.coords[n3] = this.coords[n3] + (float)((this.snowSpeed + r.nextInt(4) / 2) * 200 * (depth / 40 + 2) / 2 / fps);
                continue;
            }
            if (this.info[i * 2] != 1) continue;
            int depth = this.info[i * 2 + 1];
            if (depth <= 0) {
                depth = 1;
            }
            if (depth > 100) {
                depth = 100;
            }
            depth = 100 - depth;
            if (this.info[i * 2 + 1] > 100) {
                this.info[i * 2 + 1] = 100;
            }
            if (this.info[i * 2 + 1] < 0) {
                this.info[i * 2 + 1] = 0;
            }
            float speed = this.rainSpeed * 200 * (depth / 40 + 2) / 2 / fps;
            int n = i * 2;
            this.coords[n] = this.coords[n] - speed / 4.0f;
            int n4 = i * 2 + 1;
            this.coords[n4] = this.coords[n4] + speed;
        }
        this.isZoom = false;
    }

    public void paint(Graphics g, int xx) {
        for (int i = 0; i < this.coords.length / 2; ++i) {
            int y;
            int x;
            int size;
            int depth;
            if (this.info[i * 2] == 2) {
                depth = this.info[i * 2 + 1];
                size = (this.snowSize * (100 - depth) + depth) / 100;
                if (depth < 0) {
                    size = this.snowSize * (100 - depth) / 100;
                }
                if (depth < 0) {
                    depth = 0;
                }
                if (depth > 100) {
                    depth = 100;
                }
                g.setColor(this.mixColor(this.snowColorNear, this.snowColorFar, depth));
                x = (int)this.coords[i * 2];
                y = (int)this.coords[i * 2 + 1];
                if (size > 1) {
                    g.fillRect(x - size / 2, y - size / 2 + xx, size - 1, size - 1);
                }
                if (size > 1) continue;
                g.drawLine(x, y + xx, x, y + xx);
                continue;
            }
            if (this.info[i * 2] != 1) continue;
            depth = this.info[i * 2 + 1];
            size = (this.rainSize * (100 - depth) + depth) / 100;
            if (depth < 0) {
                size = this.rainSize * (100 - depth) / 100;
            }
            if (depth < 0) {
                depth = 0;
            }
            if (depth > 100) {
                depth = 100;
            }
            g.setColor(this.mixColor(this.rainColorNear, this.rainColorFar, depth));
            x = (int)this.coords[i * 2];
            y = (int)this.coords[i * 2 + 1];
            g.drawLine(x, y + xx, x - size / 4, y + xx + size);
        }
        g.setColor(0xFFFFFF);
    }

    public int mixColor(int col1, int col2, int mix) {
        int cr = (col1 >> 16 & 0xFF) * (100 - mix) + (col2 >> 16 & 0xFF) * mix;
        int cg = (col1 >> 8 & 0xFF) * (100 - mix) + (col2 >> 8 & 0xFF) * mix;
        int cb = (col1 & 0xFF) * (100 - mix) + (col2 & 0xFF) * mix;
        return (cr /= 100) << 16 | (cg /= 100) << 8 | (cb /= 100);
    }
}

