/*
 * Decompiled with CFR 0.152.
 */
package com.Gameplay.Map;

import com.Collision.Ray;
import com.Collision.RayCast;
import com.Gameplay.Map.House;
import com.Gameplay.Map.Light;
import com.Gameplay.Map.Room;
import com.Math.MathUtils;
import com.Math.Vector3D;
import com.Rendering.DirectX7;
import com.Rendering.Meshes.ColorLightedPolygon3V;
import com.Rendering.Meshes.ColorLightedPolygon4V;
import com.Rendering.Meshes.LightedPolygon3V;
import com.Rendering.Meshes.LightedPolygon4V;
import com.Rendering.Meshes.Mesh;
import com.Rendering.Meshes.Polygon3V;
import com.Rendering.Meshes.Polygon4V;
import com.Rendering.RenderObject;
import com.Rendering.Texture;
import com.Rendering.Vertex;
import com.misc.Main;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.microedition.io.Connector;
import javax.microedition.io.OutputConnection;
import javax.microedition.io.file.FileConnection;

public class LightMapper
implements Runnable {
    public static int aoDistance;
    public static int aoIntensity;
    public static int[] ambientLight;
    public static int[] skyLightIntensity;
    public static int[] sunLightIntensity;
    public static int[] giIntensity;
    public static int[] giFallOff;
    public static int ambientLightMid;
    public static int skyLightIntensityMid;
    public static int sunLightIntensityMid;
    public static int giRays;
    public static boolean cameraVectorLight;
    public static boolean bwGI;
    public static boolean lumFromTextures;
    public static boolean allRooms;
    public static Ray ray;
    static final int meterUnit = 885;
    public static final int sqrMeter = 783225;
    public static Light[] lights;
    public static final int perPolygonSleep = 1;
    private static House thouse;
    private static Mesh[] tmeshes;
    private static String tpath;
    protected Thread thread;
    private boolean run;
    public static int smoothMax;

    public static void reset() {
        aoDistance = 2048;
        aoIntensity = 0;
        ambientLight = new int[]{64, 64, 64};
        ambientLightMid = 64;
        skyLightIntensity = new int[]{512, 512, 515};
        skyLightIntensityMid = 512;
        sunLightIntensity = new int[]{0, 0, 0};
        sunLightIntensityMid = 0;
        cameraVectorLight = false;
        giRays = 0;
        giIntensity = new int[]{768, 768, 768};
        giFallOff = new int[]{230, 230, 230};
        smoothMax = 2700;
        bwGI = false;
        lumFromTextures = false;
        allRooms = true;
    }

    public static void ambientLightSet(int[] c) {
        if (c == null) {
            return;
        }
        LightMapper.ambientLight[0] = c[0];
        if (c.length == 1) {
            LightMapper.ambientLight[1] = LightMapper.ambientLight[2] = ambientLight[0];
        } else {
            LightMapper.ambientLight[1] = c[1];
            LightMapper.ambientLight[2] = c[2];
        }
        ambientLightMid = (ambientLight[1] + ambientLight[2] + ambientLight[0]) / 3;
    }

    public static void skyLightIntensitySet(int[] c) {
        if (c == null) {
            return;
        }
        LightMapper.skyLightIntensity[0] = c[0];
        if (c.length == 1) {
            LightMapper.skyLightIntensity[1] = LightMapper.skyLightIntensity[2] = skyLightIntensity[0];
        } else {
            LightMapper.skyLightIntensity[1] = c[1];
            LightMapper.skyLightIntensity[2] = c[2];
        }
        skyLightIntensityMid = (skyLightIntensity[1] + skyLightIntensity[2] + skyLightIntensity[0]) / 3;
    }

    public static void sunLightIntensitySet(int[] c) {
        if (c == null) {
            return;
        }
        LightMapper.sunLightIntensity[0] = c[0];
        if (c.length == 1) {
            LightMapper.sunLightIntensity[1] = LightMapper.sunLightIntensity[2] = sunLightIntensity[0];
        } else {
            LightMapper.sunLightIntensity[1] = c[1];
            LightMapper.sunLightIntensity[2] = c[2];
        }
        sunLightIntensityMid = (sunLightIntensity[1] + sunLightIntensity[2] + sunLightIntensity[0]) / 3;
    }

    public static void giIntensitySet(int[] c) {
        if (c == null) {
            return;
        }
        LightMapper.giIntensity[0] = c[0];
        if (c.length == 1) {
            LightMapper.giIntensity[1] = LightMapper.giIntensity[2] = giIntensity[0];
        } else {
            LightMapper.giIntensity[1] = c[1];
            LightMapper.giIntensity[2] = c[2];
        }
    }

    public static void giFallOffSet(int[] c) {
        if (c == null) {
            return;
        }
        LightMapper.giFallOff[0] = c[0];
        if (c.length == 1) {
            LightMapper.giFallOff[1] = LightMapper.giFallOff[2] = giFallOff[0];
        } else {
            LightMapper.giFallOff[1] = c[1];
            LightMapper.giFallOff[2] = c[2];
        }
    }

    public static final void generateLightMapSaveThread(House house2, Mesh[] meshes2, String path2) {
        tpath = path2;
        tmeshes = meshes2;
        thouse = house2;
        new LightMapper().start();
    }

    public void start() {
        if (this.run) {
            return;
        }
        this.run = true;
        this.thread = new Thread(this);
        this.thread.setPriority(10);
        this.thread.start();
    }

    protected void stop() {
        if (!this.run) {
            return;
        }
        this.run = false;
        this.thread = null;
    }

    public static final void generateLightMap(House house, Mesh[] meshes) {
        Room room;
        int i;
        long totalBeginTime = System.currentTimeMillis();
        Room[] rooms = house.getRooms();
        ray = new Ray();
        LightMapper.ray.findNearest = true;
        LightMapper.ray.infinity = true;
        for (int i2 = 0; i2 < rooms.length; ++i2) {
            Room room2 = rooms[i2];
            if (room2 == null) continue;
            LightMapper.zeroBrightness(room2);
        }
        long beginTime = System.currentTimeMillis();
        System.out.println("Generating sun and sky light...");
        for (i = 0; i < rooms.length; ++i) {
            room = rooms[i];
            if (room == null) continue;
            LightMapper.calculateSkyLight(house, room, meshes);
        }
        System.out.println("Sun and sky light done in: " + (System.currentTimeMillis() / 1000L - beginTime / 1000L) + " seconds");
        beginTime = System.currentTimeMillis();
        System.out.println("Generating ambient occulusion...");
        for (i = 0; i < rooms.length; ++i) {
            room = rooms[i];
            if (room == null || aoIntensity == 0) continue;
            LightMapper.calculateAO(house, room, meshes);
        }
        ray.reset();
        System.out.println("Ambient occulusion done in: " + (System.currentTimeMillis() / 1000L - beginTime / 1000L) + " seconds");
        beginTime = System.currentTimeMillis();
        System.out.println("Generating lights...");
        for (i = 0; i < rooms.length; ++i) {
            room = rooms[i];
            if (room == null || lights == null) continue;
            LightMapper.calculateLights(house, room, meshes);
        }
        ray.reset();
        System.out.println("Lights done in: " + (System.currentTimeMillis() / 1000L - beginTime / 1000L) + " seconds");
        if (giRays > 0) {
            beginTime = System.currentTimeMillis();
            System.out.println("Generating GI...");
            Mesh[] oldMeshes = new Mesh[rooms.length];
            for (int i3 = 0; i3 < oldMeshes.length; ++i3) {
                Mesh newMesh;
                Mesh mesh = rooms[i3].fullMesh;
                RenderObject[] ro = new RenderObject[rooms[i3].fullMesh.getPolygons().length];
                oldMeshes[i3] = newMesh = new Mesh(mesh.getVertices(), ro, mesh.getTexture());
                for (int x = 0; x < ro.length; ++x) {
                    RenderObject rOld = mesh.getPolygons()[x];
                    if (rOld instanceof LightedPolygon4V) {
                        ro[x] = new LightedPolygon4V((LightedPolygon4V)rOld);
                        continue;
                    }
                    if (rOld instanceof LightedPolygon3V) {
                        ro[x] = new LightedPolygon3V((LightedPolygon3V)rOld);
                        continue;
                    }
                    if (rOld instanceof ColorLightedPolygon4V) {
                        ro[x] = new ColorLightedPolygon4V((ColorLightedPolygon4V)rOld);
                        continue;
                    }
                    if (rOld instanceof ColorLightedPolygon3V) {
                        ro[x] = new ColorLightedPolygon3V((ColorLightedPolygon3V)rOld);
                        continue;
                    }
                    if (rOld instanceof Polygon4V) {
                        ro[x] = new Polygon4V((Polygon4V)rOld);
                        continue;
                    }
                    if (!(rOld instanceof Polygon3V)) continue;
                    ro[x] = new Polygon3V((Polygon3V)rOld);
                }
            }
            Mesh[] reflected = new Mesh[rooms.length];
            for (int i4 = 0; i4 < reflected.length; ++i4) {
                Mesh mesh = rooms[i4].fullMesh;
                RenderObject[] ro = new RenderObject[rooms[i4].fullMesh.getPolygons().length];
                reflected[i4] = new Mesh(mesh.getVertices(), ro, mesh.getTexture());
                for (int x = 0; x < ro.length; ++x) {
                    RenderObject rOld = mesh.getPolygons()[x];
                    if (rOld instanceof LightedPolygon4V) {
                        ro[x] = new LightedPolygon4V((LightedPolygon4V)rOld);
                        continue;
                    }
                    if (rOld instanceof LightedPolygon3V) {
                        ro[x] = new LightedPolygon3V((LightedPolygon3V)rOld);
                        continue;
                    }
                    if (rOld instanceof ColorLightedPolygon4V) {
                        ro[x] = new ColorLightedPolygon4V((ColorLightedPolygon4V)rOld);
                        continue;
                    }
                    if (rOld instanceof ColorLightedPolygon3V) {
                        ro[x] = new ColorLightedPolygon3V((ColorLightedPolygon3V)rOld);
                        continue;
                    }
                    if (rOld instanceof Polygon4V) {
                        ro[x] = new Polygon4V((Polygon4V)rOld);
                        continue;
                    }
                    if (!(rOld instanceof Polygon3V)) continue;
                    ro[x] = new Polygon3V((Polygon3V)rOld);
                }
            }
            for (int threads = 0; threads < giRays; ++threads) {
                for (int i5 = 0; i5 < rooms.length; ++i5) {
                    Room room3 = rooms[i5];
                    if (room3 == null) continue;
                    LightMapper.calculateGI(house, room3, meshes, oldMeshes, reflected[i5]);
                }
                for (int i2 = 0; i2 < reflected.length; ++i2) {
                    Mesh mesh = reflected[i2];
                    RenderObject[] ro = new RenderObject[mesh.getPolygons().length];
                    oldMeshes[i2] = new Mesh(mesh.getVertices(), ro, mesh.getTexture());
                    for (int x = 0; x < ro.length; ++x) {
                        RenderObject rOld = mesh.getPolygons()[x];
                        if (rOld instanceof LightedPolygon4V) {
                            ro[x] = new LightedPolygon4V((LightedPolygon4V)rOld);
                            continue;
                        }
                        if (rOld instanceof LightedPolygon3V) {
                            ro[x] = new LightedPolygon3V((LightedPolygon3V)rOld);
                            continue;
                        }
                        if (rOld instanceof ColorLightedPolygon4V) {
                            ro[x] = new ColorLightedPolygon4V((ColorLightedPolygon4V)rOld);
                            continue;
                        }
                        if (rOld instanceof ColorLightedPolygon3V) {
                            ro[x] = new ColorLightedPolygon3V((ColorLightedPolygon3V)rOld);
                            continue;
                        }
                        if (rOld instanceof Polygon4V) {
                            ro[x] = new Polygon4V((Polygon4V)rOld);
                            continue;
                        }
                        if (!(rOld instanceof Polygon3V)) continue;
                        ro[x] = new Polygon3V((Polygon3V)rOld);
                    }
                }
                ray.reset();
            }
            System.out.println("GI done in: " + (System.currentTimeMillis() / 1000L - beginTime / 1000L) + " seconds");
        }
        System.out.println("Lightmapping done in: " + (System.currentTimeMillis() / 1000L - totalBeginTime / 1000L) + " seconds");
    }

    private static boolean checkOpenSky(House house, Room room) {
        if (room.isOpenSky()) {
            return true;
        }
        Room[] rooms = house.getNeighbourRooms(room.getId());
        if (rooms == null) {
            return false;
        }
        for (int i = 0; i < rooms.length; ++i) {
            if (rooms[i] == null || !rooms[i].isOpenSky()) continue;
            return true;
        }
        return false;
    }

    private static void zeroBrightness(Room room) {
        Vertex tmp = new Vertex();
        RenderObject[] objs = room.fullMesh.getPolygons();
        for (int i = 0; i < objs.length; ++i) {
            RenderObject pol;
            if (objs[i] instanceof LightedPolygon3V) {
                pol = (LightedPolygon3V)objs[i];
                pol.lc = (byte)-128;
                pol.lb = (byte)-128;
                pol.la = (byte)-128;
            } else if (objs[i] instanceof LightedPolygon4V) {
                pol = (LightedPolygon4V)objs[i];
                ((LightedPolygon4V)pol).ld = (byte)-128;
                ((LightedPolygon4V)pol).lc = (byte)-128;
                ((LightedPolygon4V)pol).lb = (byte)-128;
                ((LightedPolygon4V)pol).la = (byte)-128;
            } else if (objs[i] instanceof ColorLightedPolygon3V) {
                pol = (ColorLightedPolygon3V)objs[i];
                ((ColorLightedPolygon3V)pol).cb = (byte)-128;
                ((ColorLightedPolygon3V)pol).cg = (byte)-128;
                ((ColorLightedPolygon3V)pol).cr = (byte)-128;
                ((ColorLightedPolygon3V)pol).bb = (byte)-128;
                ((ColorLightedPolygon3V)pol).bg = (byte)-128;
                ((ColorLightedPolygon3V)pol).br = (byte)-128;
                ((ColorLightedPolygon3V)pol).ab = (byte)-128;
                ((ColorLightedPolygon3V)pol).ag = (byte)-128;
                ((ColorLightedPolygon3V)pol).ar = (byte)-128;
            } else if (objs[i] instanceof ColorLightedPolygon4V) {
                pol = (ColorLightedPolygon4V)objs[i];
                ((ColorLightedPolygon4V)pol).db = (byte)-128;
                ((ColorLightedPolygon4V)pol).dg = (byte)-128;
                ((ColorLightedPolygon4V)pol).dr = (byte)-128;
                ((ColorLightedPolygon4V)pol).cb = (byte)-128;
                ((ColorLightedPolygon4V)pol).cg = (byte)-128;
                ((ColorLightedPolygon4V)pol).cr = (byte)-128;
                ((ColorLightedPolygon4V)pol).bb = (byte)-128;
                ((ColorLightedPolygon4V)pol).bg = (byte)-128;
                ((ColorLightedPolygon4V)pol).br = (byte)-128;
                ((ColorLightedPolygon4V)pol).ab = (byte)-128;
                ((ColorLightedPolygon4V)pol).ag = (byte)-128;
                ((ColorLightedPolygon4V)pol).ar = (byte)-128;
            }
            try {
                Thread.sleep(1L);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static void calculateSkyLight(House house, Room room, Mesh[] meshes) {
        Vertex tmp = new Vertex();
        RenderObject[] objs = room.fullMesh.getPolygons();
        for (int i = 0; i < objs.length; ++i) {
            RenderObject pol;
            if (objs[i] instanceof LightedPolygon3V) {
                pol = (LightedPolygon3V)objs[i];
                tmp.set(pol.a);
                tmp.add(pol.b.x, pol.b.y, pol.b.z);
                tmp.add(pol.c.x, pol.c.y, pol.c.z);
                tmp.div(3, 3, 3);
                int litA = LightMapper.skySunLight(house, room, meshes, pol.a, pol.nx, pol.ny, pol.nz, tmp).average();
                int litB = LightMapper.skySunLight(house, room, meshes, pol.b, pol.nx, pol.ny, pol.nz, tmp).average();
                int litC = LightMapper.skySunLight(house, room, meshes, pol.c, pol.nx, pol.ny, pol.nz, tmp).average();
                pol.la = (byte)Math.min(127, pol.la + litA);
                pol.lb = (byte)Math.min(127, pol.lb + litB);
                pol.lc = (byte)Math.min(127, pol.lc + litC);
            } else if (objs[i] instanceof LightedPolygon4V) {
                pol = (LightedPolygon4V)objs[i];
                tmp.set(((LightedPolygon4V)pol).a);
                tmp.add(((LightedPolygon4V)pol).b.x, ((LightedPolygon4V)pol).b.y, ((LightedPolygon4V)pol).b.z);
                tmp.add(((LightedPolygon4V)pol).c.x, ((LightedPolygon4V)pol).c.y, ((LightedPolygon4V)pol).c.z);
                tmp.add(((LightedPolygon4V)pol).d.x, ((LightedPolygon4V)pol).d.y, ((LightedPolygon4V)pol).d.z);
                tmp.div(4, 4, 4);
                int litA = LightMapper.skySunLight(house, room, meshes, ((LightedPolygon4V)pol).a, ((LightedPolygon4V)pol).nx, ((LightedPolygon4V)pol).ny, ((LightedPolygon4V)pol).nz, tmp).average();
                int litB = LightMapper.skySunLight(house, room, meshes, ((LightedPolygon4V)pol).b, ((LightedPolygon4V)pol).nx, ((LightedPolygon4V)pol).ny, ((LightedPolygon4V)pol).nz, tmp).average();
                int litC = LightMapper.skySunLight(house, room, meshes, ((LightedPolygon4V)pol).c, ((LightedPolygon4V)pol).nx, ((LightedPolygon4V)pol).ny, ((LightedPolygon4V)pol).nz, tmp).average();
                int litD = LightMapper.skySunLight(house, room, meshes, ((LightedPolygon4V)pol).d, ((LightedPolygon4V)pol).nx, ((LightedPolygon4V)pol).ny, ((LightedPolygon4V)pol).nz, tmp).average();
                ((LightedPolygon4V)pol).la = (byte)Math.min(127, ((LightedPolygon4V)pol).la + litA);
                ((LightedPolygon4V)pol).lb = (byte)Math.min(127, ((LightedPolygon4V)pol).lb + litB);
                ((LightedPolygon4V)pol).lc = (byte)Math.min(127, ((LightedPolygon4V)pol).lc + litC);
                ((LightedPolygon4V)pol).ld = (byte)Math.min(127, ((LightedPolygon4V)pol).ld + litD);
            } else if (objs[i] instanceof ColorLightedPolygon3V) {
                pol = (ColorLightedPolygon3V)objs[i];
                tmp.set(((ColorLightedPolygon3V)pol).a);
                tmp.add(((ColorLightedPolygon3V)pol).b.x, ((ColorLightedPolygon3V)pol).b.y, ((ColorLightedPolygon3V)pol).b.z);
                tmp.add(((ColorLightedPolygon3V)pol).c.x, ((ColorLightedPolygon3V)pol).c.y, ((ColorLightedPolygon3V)pol).c.z);
                tmp.div(3, 3, 3);
                Vector3D litA = LightMapper.skySunLight(house, room, meshes, ((ColorLightedPolygon3V)pol).a, ((ColorLightedPolygon3V)pol).nx, ((ColorLightedPolygon3V)pol).ny, ((ColorLightedPolygon3V)pol).nz, tmp);
                Vector3D litB = LightMapper.skySunLight(house, room, meshes, ((ColorLightedPolygon3V)pol).b, ((ColorLightedPolygon3V)pol).nx, ((ColorLightedPolygon3V)pol).ny, ((ColorLightedPolygon3V)pol).nz, tmp);
                Vector3D litC = LightMapper.skySunLight(house, room, meshes, ((ColorLightedPolygon3V)pol).c, ((ColorLightedPolygon3V)pol).nx, ((ColorLightedPolygon3V)pol).ny, ((ColorLightedPolygon3V)pol).nz, tmp);
                ((ColorLightedPolygon3V)pol).ar = (byte)Math.min(127, ((ColorLightedPolygon3V)pol).ar + litA.x);
                ((ColorLightedPolygon3V)pol).ag = (byte)Math.min(127, ((ColorLightedPolygon3V)pol).ag + litA.y);
                ((ColorLightedPolygon3V)pol).ab = (byte)Math.min(127, ((ColorLightedPolygon3V)pol).ab + litA.z);
                ((ColorLightedPolygon3V)pol).br = (byte)Math.min(127, ((ColorLightedPolygon3V)pol).br + litB.x);
                ((ColorLightedPolygon3V)pol).bg = (byte)Math.min(127, ((ColorLightedPolygon3V)pol).bg + litB.y);
                ((ColorLightedPolygon3V)pol).bb = (byte)Math.min(127, ((ColorLightedPolygon3V)pol).bb + litB.z);
                ((ColorLightedPolygon3V)pol).cr = (byte)Math.min(127, ((ColorLightedPolygon3V)pol).cr + litC.x);
                ((ColorLightedPolygon3V)pol).cg = (byte)Math.min(127, ((ColorLightedPolygon3V)pol).cg + litC.y);
                ((ColorLightedPolygon3V)pol).cb = (byte)Math.min(127, ((ColorLightedPolygon3V)pol).cb + litC.z);
            } else if (objs[i] instanceof ColorLightedPolygon4V) {
                pol = (ColorLightedPolygon4V)objs[i];
                tmp.set(((ColorLightedPolygon4V)pol).a);
                tmp.add(((ColorLightedPolygon4V)pol).b.x, ((ColorLightedPolygon4V)pol).b.y, ((ColorLightedPolygon4V)pol).b.z);
                tmp.add(((ColorLightedPolygon4V)pol).c.x, ((ColorLightedPolygon4V)pol).c.y, ((ColorLightedPolygon4V)pol).c.z);
                tmp.add(((ColorLightedPolygon4V)pol).d.x, ((ColorLightedPolygon4V)pol).d.y, ((ColorLightedPolygon4V)pol).d.z);
                tmp.div(4, 4, 4);
                Vector3D litA = LightMapper.skySunLight(house, room, meshes, ((ColorLightedPolygon4V)pol).a, ((ColorLightedPolygon4V)pol).nx, ((ColorLightedPolygon4V)pol).ny, ((ColorLightedPolygon4V)pol).nz, tmp);
                Vector3D litB = LightMapper.skySunLight(house, room, meshes, ((ColorLightedPolygon4V)pol).b, ((ColorLightedPolygon4V)pol).nx, ((ColorLightedPolygon4V)pol).ny, ((ColorLightedPolygon4V)pol).nz, tmp);
                Vector3D litC = LightMapper.skySunLight(house, room, meshes, ((ColorLightedPolygon4V)pol).c, ((ColorLightedPolygon4V)pol).nx, ((ColorLightedPolygon4V)pol).ny, ((ColorLightedPolygon4V)pol).nz, tmp);
                Vector3D litD = LightMapper.skySunLight(house, room, meshes, ((ColorLightedPolygon4V)pol).d, ((ColorLightedPolygon4V)pol).nx, ((ColorLightedPolygon4V)pol).ny, ((ColorLightedPolygon4V)pol).nz, tmp);
                ((ColorLightedPolygon4V)pol).ar = (byte)Math.min(127, ((ColorLightedPolygon4V)pol).ar + litA.x);
                ((ColorLightedPolygon4V)pol).ag = (byte)Math.min(127, ((ColorLightedPolygon4V)pol).ag + litA.y);
                ((ColorLightedPolygon4V)pol).ab = (byte)Math.min(127, ((ColorLightedPolygon4V)pol).ab + litA.z);
                ((ColorLightedPolygon4V)pol).br = (byte)Math.min(127, ((ColorLightedPolygon4V)pol).br + litB.x);
                ((ColorLightedPolygon4V)pol).bg = (byte)Math.min(127, ((ColorLightedPolygon4V)pol).bg + litB.y);
                ((ColorLightedPolygon4V)pol).bb = (byte)Math.min(127, ((ColorLightedPolygon4V)pol).bb + litB.z);
                ((ColorLightedPolygon4V)pol).cr = (byte)Math.min(127, ((ColorLightedPolygon4V)pol).cr + litC.x);
                ((ColorLightedPolygon4V)pol).cg = (byte)Math.min(127, ((ColorLightedPolygon4V)pol).cg + litC.y);
                ((ColorLightedPolygon4V)pol).cb = (byte)Math.min(127, ((ColorLightedPolygon4V)pol).cb + litC.z);
                ((ColorLightedPolygon4V)pol).dr = (byte)Math.min(127, ((ColorLightedPolygon4V)pol).dr + litD.x);
                ((ColorLightedPolygon4V)pol).dg = (byte)Math.min(127, ((ColorLightedPolygon4V)pol).dg + litD.y);
                ((ColorLightedPolygon4V)pol).db = (byte)Math.min(127, ((ColorLightedPolygon4V)pol).db + litD.z);
            }
            try {
                Thread.sleep(1L);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static void calculateAO(House house, Room room, Mesh[] meshes) {
        Vertex tmp = new Vertex();
        RenderObject[] objs = room.fullMesh.getPolygons();
        for (int i = 0; i < objs.length; ++i) {
            int aoC;
            int aoB;
            int aoA;
            RenderObject pol;
            if (objs[i] instanceof LightedPolygon3V) {
                pol = (LightedPolygon3V)objs[i];
                tmp.set(pol.a);
                tmp.add(pol.b.x, pol.b.y, pol.b.z);
                tmp.add(pol.c.x, pol.c.y, pol.c.z);
                tmp.div(3, 3, 3);
                pol.la = LightMapper.mul(LightMapper.ambientOcculusion(house, room, meshes, pol.a, pol.nx, pol.ny, pol.nz, tmp), pol.la);
                pol.lb = LightMapper.mul(LightMapper.ambientOcculusion(house, room, meshes, pol.b, pol.nx, pol.ny, pol.nz, tmp), pol.lb);
                pol.lc = LightMapper.mul(LightMapper.ambientOcculusion(house, room, meshes, pol.c, pol.nx, pol.ny, pol.nz, tmp), pol.lc);
            } else if (objs[i] instanceof LightedPolygon4V) {
                pol = (LightedPolygon4V)objs[i];
                tmp.set(((LightedPolygon4V)pol).a);
                tmp.add(((LightedPolygon4V)pol).b.x, ((LightedPolygon4V)pol).b.y, ((LightedPolygon4V)pol).b.z);
                tmp.add(((LightedPolygon4V)pol).c.x, ((LightedPolygon4V)pol).c.y, ((LightedPolygon4V)pol).c.z);
                tmp.add(((LightedPolygon4V)pol).d.x, ((LightedPolygon4V)pol).d.y, ((LightedPolygon4V)pol).d.z);
                tmp.div(4, 4, 4);
                ((LightedPolygon4V)pol).la = LightMapper.mul(LightMapper.ambientOcculusion(house, room, meshes, ((LightedPolygon4V)pol).a, ((LightedPolygon4V)pol).nx, ((LightedPolygon4V)pol).ny, ((LightedPolygon4V)pol).nz, tmp), ((LightedPolygon4V)pol).la);
                ((LightedPolygon4V)pol).lb = LightMapper.mul(LightMapper.ambientOcculusion(house, room, meshes, ((LightedPolygon4V)pol).b, ((LightedPolygon4V)pol).nx, ((LightedPolygon4V)pol).ny, ((LightedPolygon4V)pol).nz, tmp), ((LightedPolygon4V)pol).lb);
                ((LightedPolygon4V)pol).lc = LightMapper.mul(LightMapper.ambientOcculusion(house, room, meshes, ((LightedPolygon4V)pol).c, ((LightedPolygon4V)pol).nx, ((LightedPolygon4V)pol).ny, ((LightedPolygon4V)pol).nz, tmp), ((LightedPolygon4V)pol).lc);
                ((LightedPolygon4V)pol).ld = LightMapper.mul(LightMapper.ambientOcculusion(house, room, meshes, ((LightedPolygon4V)pol).d, ((LightedPolygon4V)pol).nx, ((LightedPolygon4V)pol).ny, ((LightedPolygon4V)pol).nz, tmp), ((LightedPolygon4V)pol).ld);
            } else if (objs[i] instanceof ColorLightedPolygon3V) {
                pol = (ColorLightedPolygon3V)objs[i];
                tmp.set(((ColorLightedPolygon3V)pol).a);
                tmp.add(((ColorLightedPolygon3V)pol).b.x, ((ColorLightedPolygon3V)pol).b.y, ((ColorLightedPolygon3V)pol).b.z);
                tmp.add(((ColorLightedPolygon3V)pol).c.x, ((ColorLightedPolygon3V)pol).c.y, ((ColorLightedPolygon3V)pol).c.z);
                tmp.div(3, 3, 3);
                aoA = LightMapper.ambientOcculusion(house, room, meshes, ((ColorLightedPolygon3V)pol).a, ((ColorLightedPolygon3V)pol).nx, ((ColorLightedPolygon3V)pol).ny, ((ColorLightedPolygon3V)pol).nz, tmp);
                aoB = LightMapper.ambientOcculusion(house, room, meshes, ((ColorLightedPolygon3V)pol).b, ((ColorLightedPolygon3V)pol).nx, ((ColorLightedPolygon3V)pol).ny, ((ColorLightedPolygon3V)pol).nz, tmp);
                aoC = LightMapper.ambientOcculusion(house, room, meshes, ((ColorLightedPolygon3V)pol).c, ((ColorLightedPolygon3V)pol).nx, ((ColorLightedPolygon3V)pol).ny, ((ColorLightedPolygon3V)pol).nz, tmp);
                ((ColorLightedPolygon3V)pol).ar = LightMapper.mul(aoA, ((ColorLightedPolygon3V)pol).ar);
                ((ColorLightedPolygon3V)pol).ag = LightMapper.mul(aoA, ((ColorLightedPolygon3V)pol).ag);
                ((ColorLightedPolygon3V)pol).ab = LightMapper.mul(aoA, ((ColorLightedPolygon3V)pol).ab);
                ((ColorLightedPolygon3V)pol).br = LightMapper.mul(aoB, ((ColorLightedPolygon3V)pol).br);
                ((ColorLightedPolygon3V)pol).bg = LightMapper.mul(aoB, ((ColorLightedPolygon3V)pol).bg);
                ((ColorLightedPolygon3V)pol).bb = LightMapper.mul(aoB, ((ColorLightedPolygon3V)pol).bb);
                ((ColorLightedPolygon3V)pol).cr = LightMapper.mul(aoC, ((ColorLightedPolygon3V)pol).cr);
                ((ColorLightedPolygon3V)pol).cg = LightMapper.mul(aoC, ((ColorLightedPolygon3V)pol).cg);
                ((ColorLightedPolygon3V)pol).cb = LightMapper.mul(aoC, ((ColorLightedPolygon3V)pol).cb);
            } else if (objs[i] instanceof ColorLightedPolygon4V) {
                pol = (ColorLightedPolygon4V)objs[i];
                tmp.set(((ColorLightedPolygon4V)pol).a);
                tmp.add(((ColorLightedPolygon4V)pol).b.x, ((ColorLightedPolygon4V)pol).b.y, ((ColorLightedPolygon4V)pol).b.z);
                tmp.add(((ColorLightedPolygon4V)pol).c.x, ((ColorLightedPolygon4V)pol).c.y, ((ColorLightedPolygon4V)pol).c.z);
                tmp.add(((ColorLightedPolygon4V)pol).d.x, ((ColorLightedPolygon4V)pol).d.y, ((ColorLightedPolygon4V)pol).d.z);
                tmp.div(4, 4, 4);
                aoA = LightMapper.ambientOcculusion(house, room, meshes, ((ColorLightedPolygon4V)pol).a, ((ColorLightedPolygon4V)pol).nx, ((ColorLightedPolygon4V)pol).ny, ((ColorLightedPolygon4V)pol).nz, tmp);
                aoB = LightMapper.ambientOcculusion(house, room, meshes, ((ColorLightedPolygon4V)pol).b, ((ColorLightedPolygon4V)pol).nx, ((ColorLightedPolygon4V)pol).ny, ((ColorLightedPolygon4V)pol).nz, tmp);
                aoC = LightMapper.ambientOcculusion(house, room, meshes, ((ColorLightedPolygon4V)pol).c, ((ColorLightedPolygon4V)pol).nx, ((ColorLightedPolygon4V)pol).ny, ((ColorLightedPolygon4V)pol).nz, tmp);
                int aoD = LightMapper.ambientOcculusion(house, room, meshes, ((ColorLightedPolygon4V)pol).d, ((ColorLightedPolygon4V)pol).nx, ((ColorLightedPolygon4V)pol).ny, ((ColorLightedPolygon4V)pol).nz, tmp);
                ((ColorLightedPolygon4V)pol).ar = LightMapper.mul(aoA, ((ColorLightedPolygon4V)pol).ar);
                ((ColorLightedPolygon4V)pol).ag = LightMapper.mul(aoA, ((ColorLightedPolygon4V)pol).ag);
                ((ColorLightedPolygon4V)pol).ab = LightMapper.mul(aoA, ((ColorLightedPolygon4V)pol).ab);
                ((ColorLightedPolygon4V)pol).br = LightMapper.mul(aoB, ((ColorLightedPolygon4V)pol).br);
                ((ColorLightedPolygon4V)pol).bg = LightMapper.mul(aoB, ((ColorLightedPolygon4V)pol).bg);
                ((ColorLightedPolygon4V)pol).bb = LightMapper.mul(aoB, ((ColorLightedPolygon4V)pol).bb);
                ((ColorLightedPolygon4V)pol).cr = LightMapper.mul(aoC, ((ColorLightedPolygon4V)pol).cr);
                ((ColorLightedPolygon4V)pol).cg = LightMapper.mul(aoC, ((ColorLightedPolygon4V)pol).cg);
                ((ColorLightedPolygon4V)pol).cb = LightMapper.mul(aoC, ((ColorLightedPolygon4V)pol).cb);
                ((ColorLightedPolygon4V)pol).dr = LightMapper.mul(aoD, ((ColorLightedPolygon4V)pol).dr);
                ((ColorLightedPolygon4V)pol).dg = LightMapper.mul(aoD, ((ColorLightedPolygon4V)pol).dg);
                ((ColorLightedPolygon4V)pol).db = LightMapper.mul(aoD, ((ColorLightedPolygon4V)pol).db);
            }
            try {
                Thread.sleep(1L);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static final byte mul(int mul, byte bri) {
        return (byte)(Math.max(0, Math.min((bri + 128) * mul >> 8, 255)) - 128);
    }

    private static void calculateLights(House house, Room room, Mesh[] meshes) {
        Vertex tmp = new Vertex();
        RenderObject[] objs = room.fullMesh.getPolygons();
        for (int i = 0; i < objs.length; ++i) {
            Vector3D lC;
            Vector3D lB;
            Vector3D lA;
            RenderObject pol;
            if (objs[i] instanceof LightedPolygon3V) {
                pol = (LightedPolygon3V)objs[i];
                tmp.set(pol.a);
                tmp.add(pol.b.x, pol.b.y, pol.b.z);
                tmp.add(pol.c.x, pol.c.y, pol.c.z);
                tmp.div(3, 3, 3);
                pol.la = LightMapper.add(LightMapper.lightCalcMini(house, room, meshes, pol.a, pol.nx, pol.ny, pol.nz, tmp).average(), pol.la);
                pol.lb = LightMapper.add(LightMapper.lightCalcMini(house, room, meshes, pol.b, pol.nx, pol.ny, pol.nz, tmp).average(), pol.lb);
                pol.lc = LightMapper.add(LightMapper.lightCalcMini(house, room, meshes, pol.c, pol.nx, pol.ny, pol.nz, tmp).average(), pol.lc);
            } else if (objs[i] instanceof LightedPolygon4V) {
                pol = (LightedPolygon4V)objs[i];
                tmp.set(((LightedPolygon4V)pol).a);
                tmp.add(((LightedPolygon4V)pol).b.x, ((LightedPolygon4V)pol).b.y, ((LightedPolygon4V)pol).b.z);
                tmp.add(((LightedPolygon4V)pol).c.x, ((LightedPolygon4V)pol).c.y, ((LightedPolygon4V)pol).c.z);
                tmp.add(((LightedPolygon4V)pol).d.x, ((LightedPolygon4V)pol).d.y, ((LightedPolygon4V)pol).d.z);
                tmp.div(4, 4, 4);
                ((LightedPolygon4V)pol).la = LightMapper.add(LightMapper.lightCalcMini(house, room, meshes, ((LightedPolygon4V)pol).a, ((LightedPolygon4V)pol).nx, ((LightedPolygon4V)pol).ny, ((LightedPolygon4V)pol).nz, tmp).average(), ((LightedPolygon4V)pol).la);
                ((LightedPolygon4V)pol).lb = LightMapper.add(LightMapper.lightCalcMini(house, room, meshes, ((LightedPolygon4V)pol).b, ((LightedPolygon4V)pol).nx, ((LightedPolygon4V)pol).ny, ((LightedPolygon4V)pol).nz, tmp).average(), ((LightedPolygon4V)pol).lb);
                ((LightedPolygon4V)pol).lc = LightMapper.add(LightMapper.lightCalcMini(house, room, meshes, ((LightedPolygon4V)pol).c, ((LightedPolygon4V)pol).nx, ((LightedPolygon4V)pol).ny, ((LightedPolygon4V)pol).nz, tmp).average(), ((LightedPolygon4V)pol).lc);
                ((LightedPolygon4V)pol).ld = LightMapper.add(LightMapper.lightCalcMini(house, room, meshes, ((LightedPolygon4V)pol).d, ((LightedPolygon4V)pol).nx, ((LightedPolygon4V)pol).ny, ((LightedPolygon4V)pol).nz, tmp).average(), ((LightedPolygon4V)pol).ld);
            } else if (objs[i] instanceof ColorLightedPolygon3V) {
                pol = (ColorLightedPolygon3V)objs[i];
                tmp.set(((ColorLightedPolygon3V)pol).a);
                tmp.add(((ColorLightedPolygon3V)pol).b.x, ((ColorLightedPolygon3V)pol).b.y, ((ColorLightedPolygon3V)pol).b.z);
                tmp.add(((ColorLightedPolygon3V)pol).c.x, ((ColorLightedPolygon3V)pol).c.y, ((ColorLightedPolygon3V)pol).c.z);
                tmp.div(3, 3, 3);
                lA = LightMapper.lightCalcMini(house, room, meshes, ((ColorLightedPolygon3V)pol).a, ((ColorLightedPolygon3V)pol).nx, ((ColorLightedPolygon3V)pol).ny, ((ColorLightedPolygon3V)pol).nz, tmp);
                lB = LightMapper.lightCalcMini(house, room, meshes, ((ColorLightedPolygon3V)pol).b, ((ColorLightedPolygon3V)pol).nx, ((ColorLightedPolygon3V)pol).ny, ((ColorLightedPolygon3V)pol).nz, tmp);
                lC = LightMapper.lightCalcMini(house, room, meshes, ((ColorLightedPolygon3V)pol).c, ((ColorLightedPolygon3V)pol).nx, ((ColorLightedPolygon3V)pol).ny, ((ColorLightedPolygon3V)pol).nz, tmp);
                ((ColorLightedPolygon3V)pol).ar = LightMapper.add(lA.x, ((ColorLightedPolygon3V)pol).ar);
                ((ColorLightedPolygon3V)pol).ag = LightMapper.add(lA.y, ((ColorLightedPolygon3V)pol).ag);
                ((ColorLightedPolygon3V)pol).ab = LightMapper.add(lA.z, ((ColorLightedPolygon3V)pol).ab);
                ((ColorLightedPolygon3V)pol).br = LightMapper.add(lB.x, ((ColorLightedPolygon3V)pol).br);
                ((ColorLightedPolygon3V)pol).bg = LightMapper.add(lB.y, ((ColorLightedPolygon3V)pol).bg);
                ((ColorLightedPolygon3V)pol).bb = LightMapper.add(lB.z, ((ColorLightedPolygon3V)pol).bb);
                ((ColorLightedPolygon3V)pol).cr = LightMapper.add(lC.x, ((ColorLightedPolygon3V)pol).cr);
                ((ColorLightedPolygon3V)pol).cg = LightMapper.add(lC.y, ((ColorLightedPolygon3V)pol).cg);
                ((ColorLightedPolygon3V)pol).cb = LightMapper.add(lC.z, ((ColorLightedPolygon3V)pol).cb);
            } else if (objs[i] instanceof ColorLightedPolygon4V) {
                pol = (ColorLightedPolygon4V)objs[i];
                tmp.set(((ColorLightedPolygon4V)pol).a);
                tmp.add(((ColorLightedPolygon4V)pol).b.x, ((ColorLightedPolygon4V)pol).b.y, ((ColorLightedPolygon4V)pol).b.z);
                tmp.add(((ColorLightedPolygon4V)pol).c.x, ((ColorLightedPolygon4V)pol).c.y, ((ColorLightedPolygon4V)pol).c.z);
                tmp.add(((ColorLightedPolygon4V)pol).d.x, ((ColorLightedPolygon4V)pol).d.y, ((ColorLightedPolygon4V)pol).d.z);
                tmp.div(4, 4, 4);
                lA = LightMapper.lightCalcMini(house, room, meshes, ((ColorLightedPolygon4V)pol).a, ((ColorLightedPolygon4V)pol).nx, ((ColorLightedPolygon4V)pol).ny, ((ColorLightedPolygon4V)pol).nz, tmp);
                lB = LightMapper.lightCalcMini(house, room, meshes, ((ColorLightedPolygon4V)pol).b, ((ColorLightedPolygon4V)pol).nx, ((ColorLightedPolygon4V)pol).ny, ((ColorLightedPolygon4V)pol).nz, tmp);
                lC = LightMapper.lightCalcMini(house, room, meshes, ((ColorLightedPolygon4V)pol).c, ((ColorLightedPolygon4V)pol).nx, ((ColorLightedPolygon4V)pol).ny, ((ColorLightedPolygon4V)pol).nz, tmp);
                Vector3D lD = LightMapper.lightCalcMini(house, room, meshes, ((ColorLightedPolygon4V)pol).d, ((ColorLightedPolygon4V)pol).nx, ((ColorLightedPolygon4V)pol).ny, ((ColorLightedPolygon4V)pol).nz, tmp);
                ((ColorLightedPolygon4V)pol).ar = LightMapper.add(lA.x, ((ColorLightedPolygon4V)pol).ar);
                ((ColorLightedPolygon4V)pol).ag = LightMapper.add(lA.y, ((ColorLightedPolygon4V)pol).ag);
                ((ColorLightedPolygon4V)pol).ab = LightMapper.add(lA.z, ((ColorLightedPolygon4V)pol).ab);
                ((ColorLightedPolygon4V)pol).br = LightMapper.add(lB.x, ((ColorLightedPolygon4V)pol).br);
                ((ColorLightedPolygon4V)pol).bg = LightMapper.add(lB.y, ((ColorLightedPolygon4V)pol).bg);
                ((ColorLightedPolygon4V)pol).bb = LightMapper.add(lB.z, ((ColorLightedPolygon4V)pol).bb);
                ((ColorLightedPolygon4V)pol).cr = LightMapper.add(lC.x, ((ColorLightedPolygon4V)pol).cr);
                ((ColorLightedPolygon4V)pol).cg = LightMapper.add(lC.y, ((ColorLightedPolygon4V)pol).cg);
                ((ColorLightedPolygon4V)pol).cb = LightMapper.add(lC.z, ((ColorLightedPolygon4V)pol).cb);
                ((ColorLightedPolygon4V)pol).dr = LightMapper.add(lD.x, ((ColorLightedPolygon4V)pol).dr);
                ((ColorLightedPolygon4V)pol).dg = LightMapper.add(lD.y, ((ColorLightedPolygon4V)pol).dg);
                ((ColorLightedPolygon4V)pol).db = LightMapper.add(lD.z, ((ColorLightedPolygon4V)pol).db);
            }
            try {
                Thread.sleep(1L);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static final byte add(int add, byte bri) {
        return (byte)Math.max(-128, Math.min(add + bri, 127));
    }

    private static void calculateGI(House house, Room room, Mesh[] meshes, Mesh[] oldMeshes, Mesh reflection) {
        Vertex tmp = new Vertex();
        RenderObject[] objs = room.fullMesh.getPolygons();
        for (int i = 0; i < objs.length; ++i) {
            RenderObject pol2;
            RenderObject pol;
            if (objs[i] instanceof LightedPolygon3V) {
                pol = (LightedPolygon3V)objs[i];
                pol2 = (LightedPolygon3V)reflection.getPolygons()[i];
                tmp.set(pol.a);
                tmp.add(pol.b.x, pol.b.y, pol.b.z);
                tmp.add(pol.c.x, pol.c.y, pol.c.z);
                tmp.div(3, 3, 3);
                int lA = LightMapper.GI(house, meshes, oldMeshes, pol.a, pol.nx, pol.ny, pol.nz, tmp).average();
                int lB = LightMapper.GI(house, meshes, oldMeshes, pol.b, pol.nx, pol.ny, pol.nz, tmp).average();
                int lC = LightMapper.GI(house, meshes, oldMeshes, pol.c, pol.nx, pol.ny, pol.nz, tmp).average();
                pol.la = LightMapper.add(lA, pol.la);
                pol.lb = LightMapper.add(lB, pol.lb);
                pol.lc = LightMapper.add(lC, pol.lc);
                pol2.la = (byte)Math.max(-128, Math.min(127, lA - 128));
                pol2.lb = (byte)Math.max(-128, Math.min(127, lB - 128));
                pol2.lc = (byte)Math.max(-128, Math.min(127, lC - 128));
            } else if (objs[i] instanceof LightedPolygon4V) {
                pol = (LightedPolygon4V)objs[i];
                pol2 = (LightedPolygon4V)reflection.getPolygons()[i];
                tmp.set(((LightedPolygon4V)pol).a);
                tmp.add(((LightedPolygon4V)pol).b.x, ((LightedPolygon4V)pol).b.y, ((LightedPolygon4V)pol).b.z);
                tmp.add(((LightedPolygon4V)pol).c.x, ((LightedPolygon4V)pol).c.y, ((LightedPolygon4V)pol).c.z);
                tmp.add(((LightedPolygon4V)pol).d.x, ((LightedPolygon4V)pol).d.y, ((LightedPolygon4V)pol).d.z);
                tmp.div(4, 4, 4);
                int lA = LightMapper.GI(house, meshes, oldMeshes, ((LightedPolygon4V)pol).a, ((LightedPolygon4V)pol).nx, ((LightedPolygon4V)pol).ny, ((LightedPolygon4V)pol).nz, tmp).average();
                int lB = LightMapper.GI(house, meshes, oldMeshes, ((LightedPolygon4V)pol).b, ((LightedPolygon4V)pol).nx, ((LightedPolygon4V)pol).ny, ((LightedPolygon4V)pol).nz, tmp).average();
                int lC = LightMapper.GI(house, meshes, oldMeshes, ((LightedPolygon4V)pol).c, ((LightedPolygon4V)pol).nx, ((LightedPolygon4V)pol).ny, ((LightedPolygon4V)pol).nz, tmp).average();
                int lD = LightMapper.GI(house, meshes, oldMeshes, ((LightedPolygon4V)pol).d, ((LightedPolygon4V)pol).nx, ((LightedPolygon4V)pol).ny, ((LightedPolygon4V)pol).nz, tmp).average();
                ((LightedPolygon4V)pol).la = LightMapper.add(lA, ((LightedPolygon4V)pol).la);
                ((LightedPolygon4V)pol).lb = LightMapper.add(lB, ((LightedPolygon4V)pol).lb);
                ((LightedPolygon4V)pol).lc = LightMapper.add(lC, ((LightedPolygon4V)pol).lc);
                ((LightedPolygon4V)pol).ld = LightMapper.add(lD, ((LightedPolygon4V)pol).ld);
                ((LightedPolygon4V)pol2).la = (byte)Math.max(-128, Math.min(127, lA - 128));
                ((LightedPolygon4V)pol2).lb = (byte)Math.max(-128, Math.min(127, lB - 128));
                ((LightedPolygon4V)pol2).lc = (byte)Math.max(-128, Math.min(127, lC - 128));
                ((LightedPolygon4V)pol2).ld = (byte)Math.max(-128, Math.min(127, lC - 128));
            } else if (objs[i] instanceof ColorLightedPolygon3V) {
                pol = (ColorLightedPolygon3V)objs[i];
                pol2 = (ColorLightedPolygon3V)reflection.getPolygons()[i];
                tmp.set(((ColorLightedPolygon3V)pol).a);
                tmp.add(((ColorLightedPolygon3V)pol).b.x, ((ColorLightedPolygon3V)pol).b.y, ((ColorLightedPolygon3V)pol).b.z);
                tmp.add(((ColorLightedPolygon3V)pol).c.x, ((ColorLightedPolygon3V)pol).c.y, ((ColorLightedPolygon3V)pol).c.z);
                tmp.div(3, 3, 3);
                Vector3D lA = LightMapper.GI(house, meshes, oldMeshes, ((ColorLightedPolygon3V)pol).a, ((ColorLightedPolygon3V)pol).nx, ((ColorLightedPolygon3V)pol).ny, ((ColorLightedPolygon3V)pol).nz, tmp);
                Vector3D lB = LightMapper.GI(house, meshes, oldMeshes, ((ColorLightedPolygon3V)pol).b, ((ColorLightedPolygon3V)pol).nx, ((ColorLightedPolygon3V)pol).ny, ((ColorLightedPolygon3V)pol).nz, tmp);
                Vector3D lC = LightMapper.GI(house, meshes, oldMeshes, ((ColorLightedPolygon3V)pol).c, ((ColorLightedPolygon3V)pol).nx, ((ColorLightedPolygon3V)pol).ny, ((ColorLightedPolygon3V)pol).nz, tmp);
                ((ColorLightedPolygon3V)pol).ar = LightMapper.add(lA.x, ((ColorLightedPolygon3V)pol).ar);
                ((ColorLightedPolygon3V)pol).ag = LightMapper.add(lA.y, ((ColorLightedPolygon3V)pol).ag);
                ((ColorLightedPolygon3V)pol).ab = LightMapper.add(lA.z, ((ColorLightedPolygon3V)pol).ab);
                ((ColorLightedPolygon3V)pol).br = LightMapper.add(lB.x, ((ColorLightedPolygon3V)pol).br);
                ((ColorLightedPolygon3V)pol).bg = LightMapper.add(lB.y, ((ColorLightedPolygon3V)pol).bg);
                ((ColorLightedPolygon3V)pol).bb = LightMapper.add(lB.z, ((ColorLightedPolygon3V)pol).bb);
                ((ColorLightedPolygon3V)pol).cr = LightMapper.add(lC.x, ((ColorLightedPolygon3V)pol).cr);
                ((ColorLightedPolygon3V)pol).cg = LightMapper.add(lC.y, ((ColorLightedPolygon3V)pol).cg);
                ((ColorLightedPolygon3V)pol).cb = LightMapper.add(lC.z, ((ColorLightedPolygon3V)pol).cb);
                ((ColorLightedPolygon3V)pol2).ar = (byte)Math.max(-128, Math.min(127, lA.x - 128));
                ((ColorLightedPolygon3V)pol2).ag = (byte)Math.max(-128, Math.min(127, lA.y - 128));
                ((ColorLightedPolygon3V)pol2).ab = (byte)Math.max(-128, Math.min(127, lA.z - 128));
                ((ColorLightedPolygon3V)pol2).br = (byte)Math.max(-128, Math.min(127, lB.x - 128));
                ((ColorLightedPolygon3V)pol2).bg = (byte)Math.max(-128, Math.min(127, lB.y - 128));
                ((ColorLightedPolygon3V)pol2).bb = (byte)Math.max(-128, Math.min(127, lB.z - 128));
                ((ColorLightedPolygon3V)pol2).cr = (byte)Math.max(-128, Math.min(127, lC.x - 128));
                ((ColorLightedPolygon3V)pol2).cg = (byte)Math.max(-128, Math.min(127, lC.y - 128));
                ((ColorLightedPolygon3V)pol2).cb = (byte)Math.max(-128, Math.min(127, lC.z - 128));
            } else if (objs[i] instanceof ColorLightedPolygon4V) {
                pol = (ColorLightedPolygon4V)objs[i];
                pol2 = (ColorLightedPolygon4V)reflection.getPolygons()[i];
                tmp.set(((ColorLightedPolygon4V)pol).a);
                tmp.add(((ColorLightedPolygon4V)pol).b.x, ((ColorLightedPolygon4V)pol).b.y, ((ColorLightedPolygon4V)pol).b.z);
                tmp.add(((ColorLightedPolygon4V)pol).c.x, ((ColorLightedPolygon4V)pol).c.y, ((ColorLightedPolygon4V)pol).c.z);
                tmp.add(((ColorLightedPolygon4V)pol).d.x, ((ColorLightedPolygon4V)pol).d.y, ((ColorLightedPolygon4V)pol).d.z);
                tmp.div(4, 4, 4);
                Vector3D lA = LightMapper.GI(house, meshes, oldMeshes, ((ColorLightedPolygon4V)pol).a, ((ColorLightedPolygon4V)pol).nx, ((ColorLightedPolygon4V)pol).ny, ((ColorLightedPolygon4V)pol).nz, tmp);
                Vector3D lB = LightMapper.GI(house, meshes, oldMeshes, ((ColorLightedPolygon4V)pol).b, ((ColorLightedPolygon4V)pol).nx, ((ColorLightedPolygon4V)pol).ny, ((ColorLightedPolygon4V)pol).nz, tmp);
                Vector3D lC = LightMapper.GI(house, meshes, oldMeshes, ((ColorLightedPolygon4V)pol).c, ((ColorLightedPolygon4V)pol).nx, ((ColorLightedPolygon4V)pol).ny, ((ColorLightedPolygon4V)pol).nz, tmp);
                Vector3D lD = LightMapper.GI(house, meshes, oldMeshes, ((ColorLightedPolygon4V)pol).d, ((ColorLightedPolygon4V)pol).nx, ((ColorLightedPolygon4V)pol).ny, ((ColorLightedPolygon4V)pol).nz, tmp);
                ((ColorLightedPolygon4V)pol).ar = LightMapper.add(lA.x, ((ColorLightedPolygon4V)pol).ar);
                ((ColorLightedPolygon4V)pol).ag = LightMapper.add(lA.y, ((ColorLightedPolygon4V)pol).ag);
                ((ColorLightedPolygon4V)pol).ab = LightMapper.add(lA.z, ((ColorLightedPolygon4V)pol).ab);
                ((ColorLightedPolygon4V)pol).br = LightMapper.add(lB.x, ((ColorLightedPolygon4V)pol).br);
                ((ColorLightedPolygon4V)pol).bg = LightMapper.add(lB.y, ((ColorLightedPolygon4V)pol).bg);
                ((ColorLightedPolygon4V)pol).bb = LightMapper.add(lB.z, ((ColorLightedPolygon4V)pol).bb);
                ((ColorLightedPolygon4V)pol).cr = LightMapper.add(lC.x, ((ColorLightedPolygon4V)pol).cr);
                ((ColorLightedPolygon4V)pol).cg = LightMapper.add(lC.y, ((ColorLightedPolygon4V)pol).cg);
                ((ColorLightedPolygon4V)pol).cb = LightMapper.add(lC.z, ((ColorLightedPolygon4V)pol).cb);
                ((ColorLightedPolygon4V)pol).dr = LightMapper.add(lD.x, ((ColorLightedPolygon4V)pol).dr);
                ((ColorLightedPolygon4V)pol).dg = LightMapper.add(lD.y, ((ColorLightedPolygon4V)pol).dg);
                ((ColorLightedPolygon4V)pol).db = LightMapper.add(lD.z, ((ColorLightedPolygon4V)pol).db);
                ((ColorLightedPolygon4V)pol2).ar = (byte)Math.max(-128, Math.min(127, lA.x - 128));
                ((ColorLightedPolygon4V)pol2).ag = (byte)Math.max(-128, Math.min(127, lA.y - 128));
                ((ColorLightedPolygon4V)pol2).ab = (byte)Math.max(-128, Math.min(127, lA.z - 128));
                ((ColorLightedPolygon4V)pol2).br = (byte)Math.max(-128, Math.min(127, lB.x - 128));
                ((ColorLightedPolygon4V)pol2).bg = (byte)Math.max(-128, Math.min(127, lB.y - 128));
                ((ColorLightedPolygon4V)pol2).bb = (byte)Math.max(-128, Math.min(127, lB.z - 128));
                ((ColorLightedPolygon4V)pol2).cr = (byte)Math.max(-128, Math.min(127, lC.x - 128));
                ((ColorLightedPolygon4V)pol2).cg = (byte)Math.max(-128, Math.min(127, lC.y - 128));
                ((ColorLightedPolygon4V)pol2).cb = (byte)Math.max(-128, Math.min(127, lC.z - 128));
                ((ColorLightedPolygon4V)pol2).dr = (byte)Math.max(-128, Math.min(127, lD.x - 128));
                ((ColorLightedPolygon4V)pol2).dg = (byte)Math.max(-128, Math.min(127, lD.y - 128));
                ((ColorLightedPolygon4V)pol2).db = (byte)Math.max(-128, Math.min(127, lD.z - 128));
            }
            try {
                Thread.sleep(1L);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static int calculateNormal(Mesh[] meshes, Vector3D norm, int nx, int ny, int nz, Vertex vert, int maxRot, int D, boolean div) {
        int polys = 0;
        for (int r = 0; r < meshes.length - (meshes.length > 1 ? 1 : 0); ++r) {
            polys = LightMapper.calcMeshNormals(meshes[r].getPolygons(), norm, nx, ny, nz, vert, maxRot, polys, D);
        }
        if (polys > 1 && div) {
            norm.div(polys, polys, polys);
        }
        return polys;
    }

    private static int calcMeshNormals(RenderObject[] objs, Vector3D norm, int nx, int ny, int nz, Vertex vert, int maxRot, int polys, int D) {
        for (int i = 0; i < objs.length; ++i) {
            RenderObject pol;
            if (objs[i] instanceof Polygon3V) {
                pol = (Polygon3V)objs[i];
                if (!LightMapper.distance(pol.a, vert, D) && !LightMapper.distance(pol.b, vert, D) && !LightMapper.distance(pol.c, vert, D) || !LightMapper.distance(pol.nx, pol.ny, pol.nz, nx, ny, nz, maxRot)) continue;
                norm.add(pol.nx, pol.ny, pol.nz);
                ++polys;
                continue;
            }
            if (!(objs[i] instanceof Polygon4V)) continue;
            pol = (Polygon4V)objs[i];
            if (!LightMapper.distance(((Polygon4V)pol).a, vert, D) && !LightMapper.distance(((Polygon4V)pol).b, vert, D) && !LightMapper.distance(((Polygon4V)pol).c, vert, D) && !LightMapper.distance(((Polygon4V)pol).d, vert, D) || !LightMapper.distance(((Polygon4V)pol).nx, ((Polygon4V)pol).ny, ((Polygon4V)pol).nz, nx, ny, nz, maxRot)) continue;
            norm.add(((Polygon4V)pol).nx, ((Polygon4V)pol).ny, ((Polygon4V)pol).nz);
            ++polys;
        }
        return polys;
    }

    private static boolean distance(Vertex a, Vertex b, int D) {
        return Math.abs(a.x - b.x) <= D && Math.abs(a.y - b.y) <= D && Math.abs(a.z - b.z) <= D;
    }

    private static long distanceSqr(Vector3D a, Vector3D b) {
        return (a.x - b.x) * (a.x - b.x) + (a.y - b.y) * (a.y - b.y) + (a.z - b.z) * (a.z - b.z);
    }

    public static long distanceSqr(Vertex a, Vector3D b) {
        return (a.x - b.x) * (a.x - b.x) + (a.y - b.y) * (a.y - b.y) + (a.z - b.z) * (a.z - b.z);
    }

    private static boolean distance(int x1, int y1, int z1, int x, int y, int z, int D) {
        return Math.abs(x1 - x) < D && Math.abs(y1 - y) < D && Math.abs(z1 - z) < D;
    }

    private static void castRay(House house, Room room, Mesh[] meshes, Ray ray) {
        if (allRooms) {
            for (int i = 0; i < meshes.length - (meshes.length > 1 ? 1 : 0); ++i) {
                RayCast.rayCast(meshes[i], ray);
            }
        } else {
            int i;
            Room[] neighbours = house.getNeighbourRooms(room.getId());
            int neighboursCount = 0;
            if (neighbours != null) {
                neighboursCount = neighbours.length;
            }
            meshes = new Mesh[1 + neighboursCount];
            meshes[0] = room.getMesh();
            for (i = 1; i < meshes.length; ++i) {
                if (neighbours[i - 1] == null) continue;
                meshes[i] = neighbours[i - 1].getMesh();
            }
            for (i = 0; i < meshes.length; ++i) {
                if (meshes[i] == null) continue;
                RayCast.rayCast(meshes[i], ray);
            }
        }
    }

    private static int ambientOcculusion(House house, Room room, Mesh[] meshes, Vertex vert, int nx, int ny, int nz, Vertex polCentre) {
        Vector3D posCheck = new Vector3D(0, 0, 0);
        Vector3D norm = new Vector3D(nx, ny, nz);
        Vector3D norm2 = new Vector3D(nx, ny, nz);
        posCheck.set(0, 0, 0);
        int polys = LightMapper.calculateNormal(meshes, posCheck, nx, ny, nz, vert, 6000, 3, false);
        norm2.set(posCheck);
        norm2.div(polys, polys, polys);
        posCheck.setLength(4096);
        if (polys > 1) {
            int mz;
            int my;
            int r = 6;
            Vector3D ps = new Vector3D(0, 0, 0);
            ps.set(posCheck);
            posCheck.div(polys, polys, polys);
            int mx = posCheck.x / 256;
            if (mx > -6 && mx < 6 && ps.x != 0) {
                mx = ps.x * 6 / Math.abs(ps.x);
            }
            if ((my = posCheck.y / 256) > -6 && my < 6 && ps.y != 0) {
                my = ps.y * 6 / Math.abs(ps.y);
            }
            if ((mz = posCheck.z / 256) > -6 && mz < 6 && ps.z != 0) {
                mz = ps.z * 6 / Math.abs(ps.z);
            }
            posCheck.set(vert.x - mx, vert.y - my, vert.z - mz);
        } else {
            posCheck.set((vert.x * 3 + polCentre.x) / 4 - nx / 256, (vert.y * 3 + polCentre.y) / 4 - ny / 256, (vert.z * 3 + polCentre.z) / 4 - nz / 256);
        }
        int skydomelight = 0;
        int rays = 0;
        if (aoIntensity != 0) {
            LightMapper.calculateNormal(meshes, norm, nx, ny, nz, vert, smoothMax, 1, true);
            for (int x = -4096; x <= 4096; x += 2048) {
                for (int y = -4096; y <= 4096; y += 2048) {
                    for (int z = -4096; z <= 4096; z += 2048) {
                        ++rays;
                        int shadow2 = 0;
                        int lit = MathUtils.calcLight(-x, -y, -z, norm.x, norm.y, norm.z);
                        ray.reset();
                        ray.getDir().set(x, y, z);
                        ray.getDir().setLength(4096);
                        ray.getStart().set(posCheck);
                        LightMapper.castRay(house, room, meshes, ray);
                        if (ray.isCollision() && ray.getDistance() < aoDistance) {
                            shadow2 += Math.min(255, Math.max(aoDistance - ray.getDistance(), 0) * 255 / aoDistance);
                        }
                        skydomelight += shadow2 * lit / 255;
                    }
                }
            }
        }
        int ao = Math.min(255, Math.max(255 - skydomelight / rays * aoIntensity / 255, 0));
        return Math.max(0, Math.min(ao, 255));
    }

    private static Vector3D lightCalcMini(House house, Room room, Mesh[] meshes, Vertex vert, int nx, int ny, int nz, Vertex polCentre) {
        Vector3D posCheck = new Vector3D(0, 0, 0);
        Vector3D norm = new Vector3D(nx, ny, nz);
        Vector3D norm2 = new Vector3D(nx, ny, nz);
        posCheck.set(0, 0, 0);
        int polys = LightMapper.calculateNormal(meshes, posCheck, nx, ny, nz, vert, 6000, 3, false);
        norm2.set(posCheck);
        if (polys > 1) {
            int mz;
            int my;
            norm2.div(polys, polys, polys);
            posCheck.setLength(4096);
            int r = 6;
            Vector3D ps = new Vector3D(0, 0, 0);
            ps.set(posCheck);
            posCheck.div(polys, polys, polys);
            int mx = posCheck.x / 256;
            if (mx > -6 && mx < 6 && ps.x != 0) {
                mx = ps.x * 6 / Math.abs(ps.x);
            }
            if ((my = posCheck.y / 256) > -6 && my < 6 && ps.y != 0) {
                my = ps.y * 6 / Math.abs(ps.y);
            }
            if ((mz = posCheck.z / 256) > -6 && mz < 6 && ps.z != 0) {
                mz = ps.z * 6 / Math.abs(ps.z);
            }
            posCheck.set(vert.x - mx, vert.y - my, vert.z - mz);
        } else {
            posCheck.set((vert.x * 3 + polCentre.x) / 4 - nx / 256, (vert.y * 3 + polCentre.y) / 4 - ny / 256, (vert.z * 3 + polCentre.z) / 4 - nz / 256);
        }
        Vector3D lit = new Vector3D(0, 0, 0);
        LightMapper.calculateNormal(meshes, norm, nx, ny, nz, vert, smoothMax, 1, true);
        Light[] lightsMassive = lights;
        if (!allRooms) {
            lightsMassive = room.lights;
            if (lightsMassive == null) {
                return lit;
            }
            if (lightsMassive.length == 0) {
                return lit;
            }
        }
        for (int i = 0; i < lightsMassive.length; ++i) {
            Light light = lightsMassive[i];
            int[] clampedColor = new int[3];
            System.arraycopy(light.color, 0, clampedColor, 0, 3);
            while (Math.abs(clampedColor[0]) > 30000 || Math.abs(clampedColor[1]) > 30000 || Math.abs(clampedColor[2]) > 30000) {
                nx /= 2;
                ny /= 2;
                nz /= 2;
            }
            double nw = Math.sqrt(clampedColor[0] * clampedColor[0] + clampedColor[1] * clampedColor[1] + clampedColor[2] * clampedColor[2]);
            if (nw < 1.0) {
                nw = 1.0;
            }
            clampedColor[0] = clampedColor[0] * 255;
            clampedColor[1] = clampedColor[1] * 255;
            clampedColor[2] = clampedColor[2] * 255;
            clampedColor[0] = (int)((double)clampedColor[0] / nw);
            clampedColor[1] = (int)((double)clampedColor[1] / nw);
            clampedColor[2] = (int)((double)clampedColor[2] / nw);
            long distSqr = LightMapper.distanceSqr(vert, light.pos);
            long intensity = 199722375L / Math.max(1L, distSqr) * 8L;
            short fix = 0;
            if (norm.y < -4090) {
                fix = light.floorFix;
            } else if (norm.y > 4090) {
                fix = light.ceilingFix;
            }
            if (distSqr < 0L) {
                intensity = 0L;
            }
            if (intensity > 1L) {
                if (light.direction == null) {
                    intensity = intensity * (long)MathUtils.calcLight(norm.x, norm.y, norm.z, vert.x - light.pos.x, vert.y - light.pos.y, vert.z - light.pos.z, fix) / 255L;
                } else {
                    Vector3D direction = light.direction;
                    intensity = intensity * (long)MathUtils.calcLight(direction.x, direction.y, direction.z, vert.x - light.pos.x, vert.y - light.pos.y, vert.z - light.pos.z) / 255L;
                    intensity = intensity * (long)MathUtils.calcLight(norm.x, norm.y, norm.z, vert.x - light.pos.x, vert.y - light.pos.y, vert.z - light.pos.z, fix) / 255L;
                }
                if (intensity > 1L) {
                    ray.reset();
                    ray.getDir().set(light.pos.x - posCheck.x, light.pos.y - posCheck.y, light.pos.z - posCheck.z);
                    ray.getStart().set(posCheck);
                    LightMapper.castRay(house, room, meshes, ray);
                    if (ray.isCollision() && (long)(ray.getDistance() * ray.getDistance()) <= distSqr && ray.getDistance() > 0) {
                        intensity = 0L;
                    }
                }
            }
            if (intensity <= 1L) continue;
            lit.add(Math.min(clampedColor[0], (int)intensity * light.color[0] / 255), Math.min(clampedColor[1], (int)intensity * light.color[1] / 255), Math.min(clampedColor[2], (int)intensity * light.color[2] / 255));
        }
        return lit;
    }

    private static Vector3D GI(House house, Mesh[] meshes, Mesh[] oldMeshes, Vertex vert, int nx, int ny, int nz, Vertex polCentre) {
        Vector3D posCheck = new Vector3D(0, 0, 0);
        Vector3D norm = new Vector3D(nx, ny, nz);
        Vector3D norm2 = new Vector3D(nx, ny, nz);
        posCheck.set(0, 0, 0);
        int polys = LightMapper.calculateNormal(meshes, posCheck, nx, ny, nz, vert, 6000, 3, false);
        norm2.set(posCheck);
        norm2.div(polys, polys, polys);
        posCheck.setLength(4096);
        if (polys > 1) {
            int mz;
            int my;
            int r = 6;
            Vector3D ps = new Vector3D(0, 0, 0);
            ps.set(posCheck);
            posCheck.div(polys, polys, polys);
            int mx = posCheck.x / 256;
            if (mx > -6 && mx < 6 && ps.x != 0) {
                mx = ps.x * 6 / Math.abs(ps.x);
            }
            if ((my = posCheck.y / 256) > -6 && my < 6 && ps.y != 0) {
                my = ps.y * 6 / Math.abs(ps.y);
            }
            if ((mz = posCheck.z / 256) > -6 && mz < 6 && ps.z != 0) {
                mz = ps.z * 6 / Math.abs(ps.z);
            }
            posCheck.set(vert.x - mx, vert.y - my, vert.z - mz);
        } else {
            posCheck.set((vert.x * 3 + polCentre.x) / 4 - nx / 256, (vert.y * 3 + polCentre.y) / 4 - ny / 256, (vert.z * 3 + polCentre.z) / 4 - nz / 256);
        }
        long gir = 0L;
        long gig = 0L;
        long gib = 0L;
        int rays = 0;
        LightMapper.calculateNormal(meshes, norm, nx, ny, nz, vert, smoothMax, 1, true);
        for (int x = -4096; x <= 4096; x += 2048) {
            for (int y = -4096; y <= 4096; y += 2048) {
                for (int z = -4096; z <= 4096; z += 2048) {
                    RenderObject p;
                    ++rays;
                    int lit = MathUtils.calcLight(-x, -y, -z, norm.x, norm.y, norm.z);
                    ray.reset();
                    ray.getDir().set(x, y, z);
                    ray.getDir().setLength(4096);
                    if (lit == 0) continue;
                    ray.getStart().set(posCheck);
                    for (int i = 0; i < oldMeshes.length; ++i) {
                        RayCast.rayCast(oldMeshes[i], ray);
                    }
                    if (!ray.isCollision() || ray.getDistance() <= 0 || !(ray.getTriangle() instanceof Polygon4V) && !(ray.getTriangle() instanceof Polygon3V)) continue;
                    int origLightR = 0;
                    int origLightG = 0;
                    int origLightB = 0;
                    Vector3D pNorm = new Vector3D(0, 0, 0);
                    byte tex = 0;
                    int u = 0;
                    int v = 0;
                    if (ray.getTriangle() instanceof LightedPolygon4V) {
                        p = (LightedPolygon4V)ray.getTriangle();
                        origLightG = origLightB = (p.la + p.lb + p.lc + p.ld) / 4 + 128;
                        origLightR = origLightB;
                        tex = p.tex;
                        u = ((p.au & 0xFF) + (p.bu & 0xFF) + (p.cu & 0xFF) + (p.du & 0xFF)) / 4;
                        v = ((p.av & 0xFF) + (p.bv & 0xFF) + (p.cv & 0xFF) + (p.dv & 0xFF)) / 4;
                        pNorm.set(p.nx, p.ny, p.nz);
                    } else if (ray.getTriangle() instanceof LightedPolygon3V) {
                        p = (LightedPolygon3V)ray.getTriangle();
                        origLightG = origLightB = (((LightedPolygon3V)p).la + ((LightedPolygon3V)p).lb + ((LightedPolygon3V)p).lc) / 3 + 128;
                        origLightR = origLightB;
                        tex = ((LightedPolygon3V)p).tex;
                        u = ((((LightedPolygon3V)p).au & 0xFF) + (((LightedPolygon3V)p).bu & 0xFF) + (((LightedPolygon3V)p).cu & 0xFF)) / 3;
                        v = ((((LightedPolygon3V)p).av & 0xFF) + (((LightedPolygon3V)p).bv & 0xFF) + (((LightedPolygon3V)p).cv & 0xFF)) / 3;
                        pNorm.set(((LightedPolygon3V)p).nx, ((LightedPolygon3V)p).ny, ((LightedPolygon3V)p).nz);
                    } else if (ray.getTriangle() instanceof ColorLightedPolygon4V) {
                        p = (ColorLightedPolygon4V)ray.getTriangle();
                        origLightR = (((ColorLightedPolygon4V)p).ar + ((ColorLightedPolygon4V)p).br + ((ColorLightedPolygon4V)p).cr + ((ColorLightedPolygon4V)p).dr) / 4 + 128;
                        origLightG = (((ColorLightedPolygon4V)p).ag + ((ColorLightedPolygon4V)p).bg + ((ColorLightedPolygon4V)p).cg + ((ColorLightedPolygon4V)p).dg) / 4 + 128;
                        origLightB = (((ColorLightedPolygon4V)p).ab + ((ColorLightedPolygon4V)p).bb + ((ColorLightedPolygon4V)p).cb + ((ColorLightedPolygon4V)p).db) / 4 + 128;
                        tex = ((ColorLightedPolygon4V)p).tex;
                        u = ((((ColorLightedPolygon4V)p).au & 0xFF) + (((ColorLightedPolygon4V)p).bu & 0xFF) + (((ColorLightedPolygon4V)p).cu & 0xFF) + (((ColorLightedPolygon4V)p).du & 0xFF)) / 4;
                        v = ((((ColorLightedPolygon4V)p).av & 0xFF) + (((ColorLightedPolygon4V)p).bv & 0xFF) + (((ColorLightedPolygon4V)p).cv & 0xFF) + (((ColorLightedPolygon4V)p).dv & 0xFF)) / 4;
                        pNorm.set(((ColorLightedPolygon4V)p).nx, ((ColorLightedPolygon4V)p).ny, ((ColorLightedPolygon4V)p).nz);
                    } else if (ray.getTriangle() instanceof ColorLightedPolygon3V) {
                        p = (ColorLightedPolygon3V)ray.getTriangle();
                        origLightR = (((ColorLightedPolygon3V)p).ar + ((ColorLightedPolygon3V)p).br + ((ColorLightedPolygon3V)p).cr) / 3 + 128;
                        origLightG = (((ColorLightedPolygon3V)p).ag + ((ColorLightedPolygon3V)p).bg + ((ColorLightedPolygon3V)p).cg) / 3 + 128;
                        origLightB = (((ColorLightedPolygon3V)p).ab + ((ColorLightedPolygon3V)p).bb + ((ColorLightedPolygon3V)p).cb) / 3 + 128;
                        tex = ((ColorLightedPolygon3V)p).tex;
                        u = ((((ColorLightedPolygon3V)p).au & 0xFF) + (((ColorLightedPolygon3V)p).bu & 0xFF) + (((ColorLightedPolygon3V)p).cu & 0xFF)) / 3;
                        v = ((((ColorLightedPolygon3V)p).av & 0xFF) + (((ColorLightedPolygon3V)p).bv & 0xFF) + (((ColorLightedPolygon3V)p).cv & 0xFF)) / 3;
                        pNorm.set(((ColorLightedPolygon3V)p).nx, ((ColorLightedPolygon3V)p).ny, ((ColorLightedPolygon3V)p).nz);
                    } else if (ray.getTriangle() instanceof Polygon4V) {
                        p = (LightedPolygon4V)ray.getTriangle();
                        origLightB = 255;
                        origLightG = 255;
                        origLightR = 255;
                        tex = p.tex;
                        u = ((p.au & 0xFF) + (p.bu & 0xFF) + (p.cu & 0xFF) + (p.du & 0xFF)) / 4;
                        v = ((p.av & 0xFF) + (p.bv & 0xFF) + (p.cv & 0xFF) + (p.dv & 0xFF)) / 4;
                        pNorm.set(p.nx, p.ny, p.nz);
                    } else if (ray.getTriangle() instanceof Polygon3V) {
                        p = (LightedPolygon3V)ray.getTriangle();
                        origLightB = 255;
                        origLightG = 255;
                        origLightR = 255;
                        tex = ((LightedPolygon3V)p).tex;
                        u = ((((LightedPolygon3V)p).au & 0xFF) + (((LightedPolygon3V)p).bu & 0xFF) + (((LightedPolygon3V)p).cu & 0xFF)) / 3;
                        v = ((((LightedPolygon3V)p).av & 0xFF) + (((LightedPolygon3V)p).bv & 0xFF) + (((LightedPolygon3V)p).cv & 0xFF)) / 3;
                        pNorm.set(((LightedPolygon3V)p).nx, ((LightedPolygon3V)p).ny, ((LightedPolygon3V)p).nz);
                    }
                    Texture te = meshes[0].getTexture().textures[tex];
                    if (te.drawmode != 9 && te.drawmode != 10 && te.drawmode != 13 && lumFromTextures) {
                        origLightB = 255;
                        origLightG = 255;
                        origLightR = 255;
                    }
                    if (origLightR + origLightG + origLightB <= 0) continue;
                    int tew = te.rImg.w;
                    int[] teimg = te.rImg.img;
                    if (te.mip != null) {
                        teimg = te.mip[2].img;
                        u = u * te.mip[2].w / te.rImg.w;
                        v = v * te.mip[2].h / te.rImg.h;
                    }
                    int col = te.rImg.img[(u + v * tew) % teimg.length];
                    int cr = col >> 16 & 0xFF;
                    int cg = col >> 8 & 0xFF;
                    int cb = col & 0xFF;
                    gir += (long)(origLightR * giFallOff[0] / 255 * cr / 255 * 4 * lit);
                    gig += (long)(origLightG * giFallOff[1] / 255 * cg / 255 * 4 * lit);
                    gib += (long)(origLightB * giFallOff[2] / 255 * cb / 255 * 4 * lit);
                }
            }
        }
        gir /= (long)(rays * 255);
        gig /= (long)(rays * 255);
        gib /= (long)(rays * 255);
        if (bwGI) {
            gig = gib = (gir + gib + gig) / 3L;
            gir = gib;
        }
        return new Vector3D((int)gir * giIntensity[0] / 255, (int)gig * giIntensity[1] / 255, (int)gib * giIntensity[2] / 255);
    }

    private static Vector3D skySunLight(House house, Room room, Mesh[] meshes, Vertex vert, int nx, int ny, int nz, Vertex polCentre) {
        int skyLitDirectional = 0;
        int shadow = 255;
        Vector3D posCheck = new Vector3D(0, 0, 0);
        int polys = LightMapper.calculateNormal(meshes, posCheck, nx, ny, nz, vert, smoothMax, 5, true);
        Vector3D norm = new Vector3D(nx, ny, nz);
        norm.setLength(4096);
        if (polys > 1) {
            norm.set(posCheck);
        }
        posCheck.set(0, 0, 0);
        polys = LightMapper.calculateNormal(meshes, posCheck, nx, ny, nz, vert, 6000, 1, false);
        posCheck.setLength(4096);
        if (polys > 1) {
            int mz;
            int my;
            int r = 6;
            Vector3D ps = new Vector3D(0, 0, 0);
            ps.set(posCheck);
            posCheck.div(polys, polys, polys);
            int mx = posCheck.x / 256;
            if (mx > -6 && mx < 6 && ps.x != 0) {
                mx = ps.x * 6 / Math.abs(ps.x);
            }
            if ((my = posCheck.y / 256) > -6 && my < 6 && ps.y != 0) {
                my = ps.y * 6 / Math.abs(ps.y);
            }
            if ((mz = posCheck.z / 256) > -6 && mz < 6 && ps.z != 0) {
                mz = ps.z * 6 / Math.abs(ps.z);
            }
            posCheck.set(vert.x - mx, vert.y - my, vert.z - mz);
        } else {
            posCheck.set((vert.x * 3 + polCentre.x) / 4 - nx / 256, (vert.y * 3 + polCentre.y) / 4 - ny / 256, (vert.z * 3 + polCentre.z) / 4 - nz / 256);
        }
        if (sunLightIntensity[0] != 0 || sunLightIntensity[1] != 0 || sunLightIntensity[2] != 0) {
            skyLitDirectional = MathUtils.calcLight(DirectX7.lightdirx, DirectX7.lightdiry, DirectX7.lightdirz, norm.x, norm.y, norm.z);
            ray.reset();
            ray.getStart().set(posCheck);
            ray.getDir().set(-DirectX7.lightdirx, -DirectX7.lightdiry, -DirectX7.lightdirz);
            ray.getDir().setLength(30000);
            LightMapper.castRay(house, room, meshes, ray);
            ray.getDir().setLength(4096);
            LightMapper.castRay(house, room, meshes, ray);
            if (ray.isCollision()) {
                shadow = 0;
            }
            ray.reset();
        }
        int skydomelight = 0;
        int rays = 0;
        if (skyLightIntensity[0] != 0 || skyLightIntensity[1] != 0 || skyLightIntensity[2] != 0) {
            LightMapper.calculateNormal(meshes, norm, nx, ny, nz, vert, smoothMax, 1, true);
            for (int x = -4096; x < 4096; x += 2048) {
                for (int y = 0; y < 4096; y += 1024) {
                    for (int z = -4096; z < 4096; z += 2048) {
                        ++rays;
                        int shadow2 = 255;
                        int lit = MathUtils.calcLight(-x, -y, -z, norm.x, norm.y, norm.z);
                        if (lit > 0) {
                            ray.reset();
                            ray.getDir().set(x, y, z);
                            ray.getDir().setLength(4096);
                            ray.getStart().set(posCheck);
                            LightMapper.castRay(house, room, meshes, ray);
                            if (ray.isCollision()) {
                                shadow2 = 0;
                            }
                        }
                        skydomelight += shadow2 * lit >> 8;
                    }
                }
            }
        }
        if (rays == 0) {
            rays = 1;
        }
        return new Vector3D(shadow * skyLitDirectional / 255 * sunLightIntensity[0] / 255 + skydomelight / rays * skyLightIntensity[0] / 255 + ambientLight[0], shadow * skyLitDirectional / 255 * sunLightIntensity[1] / 255 + skydomelight / rays * skyLightIntensity[1] / 255 + ambientLight[1], shadow * skyLitDirectional / 255 * sunLightIntensity[2] / 255 + skydomelight / rays * skyLightIntensity[2] / 255 + ambientLight[2]);
    }

    public static void saveLightMap(Mesh[] meshes, String lightdataFile) {
        try {
            OutputConnection con = (OutputConnection)Connector.open((String)"file:///root/lightmap.vla", (int)2);
            FileConnection fc = (FileConnection)con;
            if (!fc.exists()) {
                fc.create();
            } else {
                fc.delete();
                fc.create();
            }
            OutputStream out = con.openOutputStream();
            DataOutputStream dos = new DataOutputStream(out);
            for (int i = 0; i < meshes.length; ++i) {
                RenderObject[] objs = meshes[i].getPolygons();
                for (int x = 0; x < objs.length; ++x) {
                    boolean colored;
                    RenderObject pol;
                    if (objs[x] instanceof LightedPolygon3V) {
                        pol = (LightedPolygon3V)objs[x];
                        dos.writeByte(pol.la);
                        dos.writeByte(pol.lb);
                        dos.writeByte(pol.lc);
                        continue;
                    }
                    if (objs[x] instanceof LightedPolygon4V) {
                        pol = (LightedPolygon4V)objs[x];
                        dos.writeByte(((LightedPolygon4V)pol).la);
                        dos.writeByte(((LightedPolygon4V)pol).lb);
                        dos.writeByte(((LightedPolygon4V)pol).lc);
                        dos.writeByte(((LightedPolygon4V)pol).ld);
                        continue;
                    }
                    if (objs[x] instanceof ColorLightedPolygon3V) {
                        pol = (ColorLightedPolygon3V)objs[x];
                        colored = ((ColorLightedPolygon3V)pol).ar != ((ColorLightedPolygon3V)pol).ag || ((ColorLightedPolygon3V)pol).ag != ((ColorLightedPolygon3V)pol).ab || ((ColorLightedPolygon3V)pol).br != ((ColorLightedPolygon3V)pol).bg || ((ColorLightedPolygon3V)pol).bg != ((ColorLightedPolygon3V)pol).bb || ((ColorLightedPolygon3V)pol).cr != ((ColorLightedPolygon3V)pol).cg || ((ColorLightedPolygon3V)pol).cg != ((ColorLightedPolygon3V)pol).cb;
                        dos.writeByte(((ColorLightedPolygon3V)pol).ar);
                        dos.writeByte(((ColorLightedPolygon3V)pol).br);
                        dos.writeByte(((ColorLightedPolygon3V)pol).cr);
                        dos.writeBoolean(colored);
                        if (!colored) continue;
                        dos.writeByte(((ColorLightedPolygon3V)pol).ag);
                        dos.writeByte(((ColorLightedPolygon3V)pol).ab);
                        dos.writeByte(((ColorLightedPolygon3V)pol).bg);
                        dos.writeByte(((ColorLightedPolygon3V)pol).bb);
                        dos.writeByte(((ColorLightedPolygon3V)pol).cg);
                        dos.writeByte(((ColorLightedPolygon3V)pol).cb);
                        continue;
                    }
                    if (!(objs[x] instanceof ColorLightedPolygon4V)) continue;
                    pol = (ColorLightedPolygon4V)objs[x];
                    colored = ((ColorLightedPolygon4V)pol).ar != ((ColorLightedPolygon4V)pol).ag || ((ColorLightedPolygon4V)pol).ag != ((ColorLightedPolygon4V)pol).ab || ((ColorLightedPolygon4V)pol).br != ((ColorLightedPolygon4V)pol).bg || ((ColorLightedPolygon4V)pol).bg != ((ColorLightedPolygon4V)pol).bb || ((ColorLightedPolygon4V)pol).cr != ((ColorLightedPolygon4V)pol).cg || ((ColorLightedPolygon4V)pol).cg != ((ColorLightedPolygon4V)pol).cb || ((ColorLightedPolygon4V)pol).dr != ((ColorLightedPolygon4V)pol).dg || ((ColorLightedPolygon4V)pol).dg != ((ColorLightedPolygon4V)pol).db;
                    dos.writeByte(((ColorLightedPolygon4V)pol).ar);
                    dos.writeByte(((ColorLightedPolygon4V)pol).br);
                    dos.writeByte(((ColorLightedPolygon4V)pol).cr);
                    dos.writeByte(((ColorLightedPolygon4V)pol).dr);
                    dos.writeBoolean(colored);
                    if (!colored) continue;
                    dos.writeByte(((ColorLightedPolygon4V)pol).ag);
                    dos.writeByte(((ColorLightedPolygon4V)pol).ab);
                    dos.writeByte(((ColorLightedPolygon4V)pol).bg);
                    dos.writeByte(((ColorLightedPolygon4V)pol).bb);
                    dos.writeByte(((ColorLightedPolygon4V)pol).cg);
                    dos.writeByte(((ColorLightedPolygon4V)pol).cb);
                    dos.writeByte(((ColorLightedPolygon4V)pol).dg);
                    dos.writeByte(((ColorLightedPolygon4V)pol).db);
                }
            }
            dos.close();
            con.close();
        }
        catch (Exception exc) {
            System.out.println("Lightmap save error: " + exc.getMessage());
        }
    }

    public static void loadLightMap(Mesh[] meshes, String lightdataFile) {
        try {
            InputStream is = new Object().getClass().getResourceAsStream(lightdataFile);
            DataInputStream dis = new DataInputStream(is);
            for (int i = 0; i < meshes.length; ++i) {
                RenderObject[] objs = meshes[i].getPolygons();
                for (int x = 0; x < objs.length; ++x) {
                    RenderObject pol;
                    if (objs[x] instanceof LightedPolygon3V) {
                        pol = (LightedPolygon3V)objs[x];
                        pol.la = dis.readByte();
                        pol.lb = dis.readByte();
                        pol.lc = dis.readByte();
                        continue;
                    }
                    if (objs[x] instanceof LightedPolygon4V) {
                        pol = (LightedPolygon4V)objs[x];
                        ((LightedPolygon4V)pol).la = dis.readByte();
                        ((LightedPolygon4V)pol).lb = dis.readByte();
                        ((LightedPolygon4V)pol).lc = dis.readByte();
                        ((LightedPolygon4V)pol).ld = dis.readByte();
                        continue;
                    }
                    if (objs[x] instanceof ColorLightedPolygon3V) {
                        pol = (ColorLightedPolygon3V)objs[x];
                        ((ColorLightedPolygon3V)pol).ar = dis.readByte();
                        ((ColorLightedPolygon3V)pol).br = dis.readByte();
                        ((ColorLightedPolygon3V)pol).cr = dis.readByte();
                        if (dis.readBoolean()) {
                            ((ColorLightedPolygon3V)pol).ag = dis.readByte();
                            ((ColorLightedPolygon3V)pol).ab = dis.readByte();
                            ((ColorLightedPolygon3V)pol).bg = dis.readByte();
                            ((ColorLightedPolygon3V)pol).bb = dis.readByte();
                            ((ColorLightedPolygon3V)pol).cg = dis.readByte();
                            ((ColorLightedPolygon3V)pol).cb = dis.readByte();
                            if (Main.fogQ != 1) continue;
                            objs[x] = new LightedPolygon3V((ColorLightedPolygon3V)pol);
                            continue;
                        }
                        ((ColorLightedPolygon3V)pol).ag = ((ColorLightedPolygon3V)pol).ab = ((ColorLightedPolygon3V)pol).ar;
                        ((ColorLightedPolygon3V)pol).bg = ((ColorLightedPolygon3V)pol).bb = ((ColorLightedPolygon3V)pol).br;
                        ((ColorLightedPolygon3V)pol).cg = ((ColorLightedPolygon3V)pol).cb = ((ColorLightedPolygon3V)pol).cr;
                        objs[x] = new LightedPolygon3V((ColorLightedPolygon3V)pol);
                        continue;
                    }
                    if (!(objs[x] instanceof ColorLightedPolygon4V)) continue;
                    pol = (ColorLightedPolygon4V)objs[x];
                    ((ColorLightedPolygon4V)pol).ar = dis.readByte();
                    ((ColorLightedPolygon4V)pol).br = dis.readByte();
                    ((ColorLightedPolygon4V)pol).cr = dis.readByte();
                    ((ColorLightedPolygon4V)pol).dr = dis.readByte();
                    if (dis.readBoolean()) {
                        ((ColorLightedPolygon4V)pol).ag = dis.readByte();
                        ((ColorLightedPolygon4V)pol).ab = dis.readByte();
                        ((ColorLightedPolygon4V)pol).bg = dis.readByte();
                        ((ColorLightedPolygon4V)pol).bb = dis.readByte();
                        ((ColorLightedPolygon4V)pol).cg = dis.readByte();
                        ((ColorLightedPolygon4V)pol).cb = dis.readByte();
                        ((ColorLightedPolygon4V)pol).dg = dis.readByte();
                        ((ColorLightedPolygon4V)pol).db = dis.readByte();
                        if (Main.fogQ != 1) continue;
                        objs[x] = new LightedPolygon4V((ColorLightedPolygon4V)pol);
                        continue;
                    }
                    ((ColorLightedPolygon4V)pol).ag = ((ColorLightedPolygon4V)pol).ab = ((ColorLightedPolygon4V)pol).ar;
                    ((ColorLightedPolygon4V)pol).bg = ((ColorLightedPolygon4V)pol).bb = ((ColorLightedPolygon4V)pol).br;
                    ((ColorLightedPolygon4V)pol).cg = ((ColorLightedPolygon4V)pol).cb = ((ColorLightedPolygon4V)pol).cr;
                    ((ColorLightedPolygon4V)pol).dg = ((ColorLightedPolygon4V)pol).db = ((ColorLightedPolygon4V)pol).dr;
                    objs[x] = new LightedPolygon4V((ColorLightedPolygon4V)pol);
                }
            }
            dis.close();
            is.close();
            System.gc();
        }
        catch (Exception exc) {
            System.out.println("Lightmap load error: " + exc.getMessage());
        }
    }

    public void run() {
        if (!this.run) {
            return;
        }
        LightMapper.generateLightMap(thouse, tmeshes);
        LightMapper.saveLightMap(tmeshes, tpath);
        System.out.println("lightmap saved!");
        this.stop();
        thouse = null;
        tmeshes = null;
        tpath = null;
    }

    static {
        smoothMax = 2700;
        LightMapper.reset();
    }
}

