/*
 * Decompiled with CFR 0.152.
 */
package com.Gameplay.Map;

import com.AI.Player;
import com.Gameplay.Map.Room;
import com.Math.Matrix;
import com.Rendering.DirectX7;
import com.Rendering.Meshes.M3GParser;
import com.Rendering.Meshes.Mesh;
import com.Rendering.MultyTexture;
import com.Rendering.Texture;
import javax.microedition.lcdui.Graphics;
import javax.microedition.m3g.Appearance;

public class Skybox {
    private Matrix matrix;
    public MultyTexture texture;
    private Texture sky360;
    private int color;
    private byte mode = 0;
    private Mesh mesh;
    private int frame;
    private float x;
    private float y;
    public int x1;
    public int y1;
    public int x2;
    public int y2;
    private boolean resetViewport;
    public boolean skyboxAlways = false;
    public boolean draw = true;
    public boolean m3gRender = false;
    private M3GParser parser;
    private Appearance skyAppearance;

    public Skybox() {
    }

    public Skybox(String modelPath, String texturePath, boolean m3gRender2, int xx, int yy) {
        this.matrix = new Matrix();
        this.frame = 0;
        this.resetViewport = false;
        if (!m3gRender2) {
            this.texture = new MultyTexture(texturePath, false);
        }
        this.mesh = Room.loadMeshes(modelPath, 7.0f, 7.0f, 7.0f, this.texture)[0];
        this.mode = 0;
        this.skyboxAlways = false;
        this.m3gRender = m3gRender2;
        if (this.m3gRender) {
            this.parser = new M3GParser(xx, yy);
            this.skyAppearance = M3GParser.appearanceGenerator(texturePath);
        }
    }

    public Skybox(int colors) {
        this.frame = 0;
        this.resetViewport = false;
        this.color = colors;
        this.mode = 1;
        this.skyboxAlways = false;
    }

    public Skybox(Texture colors, float xx, float yy) {
        this.frame = 0;
        this.resetViewport = false;
        this.sky360 = colors;
        this.x = xx;
        this.y = yy;
        this.mode = (byte)2;
        this.skyboxAlways = false;
    }

    public Skybox(Texture colors, int lowestDegree, float horizonScale) {
        this.frame = 0;
        this.resetViewport = false;
        this.sky360 = colors;
        this.y = lowestDegree;
        this.x = horizonScale;
        this.mode = (byte)3;
        this.skyboxAlways = false;
    }

    public void destroy() {
        this.matrix = null;
        this.texture = null;
        if (this.mesh != null) {
            this.mesh.destroy();
        }
        this.mesh = null;
        this.sky360 = null;
    }

    public void resetViewport() {
        this.resetViewport = true;
        this.draw = false;
    }

    public void addViewport(int ax1, int ay1, int ax2, int ay2) {
        if (this.resetViewport) {
            this.resetViewport = false;
            this.x1 = ax1;
            this.y1 = ay1;
            this.x2 = ax2;
            this.y2 = ay2;
        } else {
            if (ax1 < this.x1) {
                this.x1 = ax1;
            }
            if (ay1 < this.y1) {
                this.y1 = ay1;
            }
            if (ax2 > this.x2) {
                this.x2 = ax2;
            }
            if (ay2 > this.y2) {
                this.y2 = ay2;
            }
        }
    }

    public final void render(Graphics g, DirectX7 g3d) {
        if (this.skyboxAlways) {
            this.x1 = 0;
            this.y1 = 0;
            this.x2 = g3d.width;
            this.y2 = g3d.height;
        }
        if (this.mode == 0 && this.m3gRender) {
            this.renderM3G(g, g3d);
        } else if (this.mode == 0) {
            this.matrix.setIdentity();
            this.matrix.setPosition(g3d.getCamera().m03, g3d.getCamera().m13, g3d.getCamera().m23);
            Matrix fm = g3d.computeFinalMatrix(this.matrix);
            this.mesh.getTexture().updateAnimation();
            g3d.transformAndProjectVertices(this.mesh, fm);
            g3d.addMesh(this.mesh, this.x1, this.y1, this.x2, this.y2);
        } else if (this.mode == 1) {
            g3d.clearDisplay(this.color);
        } else if (this.mode == 2) {
            if (this.x2 - this.x1 == 0 || this.y2 - this.y1 == 0) {
                return;
            }
            this.render2DSkybox(g3d);
        } else if (this.mode == 3) {
            if (this.x2 - this.x1 == 0 || this.y2 - this.y1 == 0) {
                return;
            }
            int horizonY = (int)((float)(g3d.height / 2) + Player.rotateX * (float)g3d.height / (float)g3d.fovY);
            horizonY = (horizonY - g3d.centreY) * g3d.distY / (11 + g3d.distY) + g3d.centreY;
            int ySize = (int)(90.0f * this.x * (float)g3d.height / (float)g3d.fovY);
            this.renderGradient(g3d, horizonY, ySize);
        }
    }

    void renderGradient(DirectX7 g3d, int horizonY, int ySize) {
        int col;
        int gradientBegin;
        int rx1 = this.y1 * g3d.width;
        int yy2 = this.y2;
        if (this.y != -91.0f) {
            int horCrop = (int)((float)(g3d.height / 2) - this.y * (float)g3d.height / (float)g3d.fovY + Player.rotateX * (float)g3d.height / (float)g3d.fovY);
            if (this.y2 > (horCrop = (horCrop - g3d.centreY) * g3d.distY / (11 + g3d.distY) + g3d.centreY)) {
                this.y2 = horCrop;
            }
        }
        int rx2 = this.y2 * g3d.width;
        int[] rgb = g3d.display;
        int[] tex = this.sky360.rImg.img;
        int step = ySize / this.sky360.rImg.h;
        if (step == 0) {
            step = 1;
        }
        if ((gradientBegin = horizonY - ySize) >= g3d.height) {
            return;
        }
        if (gradientBegin > 0 && gradientBegin < this.y2) {
            int rx3 = gradientBegin * g3d.width;
            col = ((tex[0] & 0xFF00FF) * 255 & 0xFF00FF00 | (tex[0] & 0xFF00) * 255 & 0xFF0000) >>> 8;
            while (rx3 - rx1 > 6) {
                int n = col;
                rgb[rx1 + 5] = n;
                rgb[rx1 + 4] = n;
                rgb[rx1 + 3] = n;
                rgb[rx1 + 2] = n;
                rgb[rx1 + 1] = n;
                rgb[rx1] = n;
                rx1 += 6;
            }
            while (rx1 < rx3) {
                rgb[rx1] = col;
                ++rx1;
            }
        }
        if ((gradientBegin = horizonY + ySize) > 0 && gradientBegin < this.y2) {
            rx2 = gradientBegin * g3d.width;
        }
        while (rx1 < rx2) {
            int yy = rx1 / g3d.width;
            int mix2 = yy - horizonY;
            if (mix2 < 0) {
                mix2 = -mix2;
            }
            int yp = this.sky360.rImg.h - mix2 / step;
            int yp2 = yp - 1;
            if (yp >= this.sky360.rImg.h) {
                yp = this.sky360.rImg.h - 1;
            }
            if (yp2 >= this.sky360.rImg.h) {
                yp2 = yp;
            }
            if (yp < 0) {
                yp = 0;
            }
            if (yp2 < 0) {
                yp2 = 0;
            }
            mix2 = mix2 % step * 255 / step;
            int mix = 255 - mix2;
            col = ((tex[yp] & 0xFF00FF) * mix + (tex[yp2] & 0xFF00FF) * mix2 & 0xFF00FF00 | (tex[yp] & 0xFF00) * mix + (tex[yp2] & 0xFF00) * mix2 & 0xFF0000) >>> 8;
            int rx3 = rx1 + g3d.width;
            while (rx3 - rx1 <= 6) {
                rgb[rx1] = col;
                rgb[rx1 + 1] = col;
                rgb[rx1 + 2] = col;
                rgb[rx1 + 3] = col;
                rgb[rx1 + 4] = col;
                rgb[rx1 + 5] = col;
                rx1 += 6;
            }
            while (rx1 < rx3) {
                rgb[rx1] = col;
                ++rx1;
            }
        }
        if (gradientBegin > 0 && gradientBegin < this.y2) {
            rx2 = this.y2 * g3d.width;
            col = ((tex[0] & 0xFF00FF) * 255 & 0xFF00FF00 | (tex[0] & 0xFF00) * 255 & 0xFF0000) >>> 8;
            while (rx2 - rx1 <= 6) {
                int n = col;
                rgb[rx1 + 5] = n;
                rgb[rx1 + 4] = n;
                rgb[rx1 + 3] = n;
                rgb[rx1 + 2] = n;
                rgb[rx1 + 1] = n;
                rgb[rx1] = n;
                rx1 += 6;
            }
            while (rx1 < rx2) {
                rgb[rx1] = col;
                ++rx1;
            }
        }
    }

    void render2DSkybox(DirectX7 g3d) {
        int direction = DirectX7.camera.getRotZHQ();
        int sizex = g3d.fovX * 1024 / 180;
        int sizey = g3d.fovY * 1024 / 180;
        int beginx = (int)((float)((direction - sizex / 2) * this.sky360.rImg.w) * this.x / 2048.0f);
        int endx = (int)((float)((direction + sizex / 2) * this.sky360.rImg.w) * this.x / 2048.0f);
        int directiony = Math.min(Math.max(2048 - (1024 - DirectX7.camera.m12 * 1024 / 16384), sizey / 2), 2048 - sizey / 2);
        int beginy = (int)((float)((directiony - sizey / 2) * this.sky360.rImg.h / 2048));
        int endy = (int)((float)((directiony + sizey / 2) * this.sky360.rImg.h) * this.y / 2048.0f);
        int fp = 12;
        int sx = beginx << 12;
        int sy = beginy << 12;
        int width = g3d.width;
        int height = g3d.height;
        int xstep = ((endx << 12) - sx) / width;
        int ystep = ((endy << 12) - sy) / height;
        this.render2D(g3d, sx, sy, xstep, ystep);
    }

    void renderM3G(Graphics g, DirectX7 g3d) {
        g3d.clearDisplay(0);
        g3d.flushAlpha = true;
        this.matrix.setIdentity();
        this.matrix.setPosition(g3d.getCamera().m03, g3d.getCamera().m13, g3d.getCamera().m23);
        Matrix fm = g3d.computeFinalMatrix(this.matrix);
        g3d.transformAndProjectVertices(this.mesh, fm);
        this.parser.meshRender(this.mesh, this.x1, this.y1, this.x2, this.y2, this.skyAppearance, g3d, g);
    }

    void render2D(DirectX7 g3d, int sx, int sy, int xstep, int ystep) {
        int texw = this.sky360.rImg.w;
        int texh = this.sky360.rImg.h;
        int texs = this.sky360.getPixels().length - 1;
        int fp = 12;
        while (sy < 0) {
            sy += texh << 12;
        }
        sy += ystep * this.y1;
        while (sx < 0) {
            sx += texw << 12;
        }
        int sxx = sx;
        int width = g3d.width;
        int height = g3d.height;
        int[] rgb = g3d.display;
        int[] tex = this.sky360.rImg.img;
        for (int scry = this.y1; scry < this.y2; ++scry) {
            int rx1 = width * scry;
            int rx2 = width + rx1;
            sx = sxx - xstep;
            int ysa = (sy >>> 12) % texh * texw;
            if (this.x1 > 0) {
                rx1 += this.x1;
                sx += xstep * this.x1;
            }
            if (this.x2 < width) {
                rx2 -= width - this.x2;
            }
            while (rx2 - rx1 >= 4) {
                rgb[rx1] = tex[(((sx += xstep) >>> 12) % texw + ysa) % texs];
                rgb[rx1 + 1] = tex[(((sx += xstep) >>> 12) % texw + ysa) % texs];
                rgb[rx1 + 2] = tex[(((sx += xstep) >>> 12) % texw + ysa) % texs];
                rgb[rx1 + 3] = tex[(((sx += xstep) >>> 12) % texw + ysa) % texs];
                rx1 += 4;
            }
            while (rx1 < rx2) {
                rgb[rx1] = tex[(((sx += xstep) >>> 12) % texw + ysa) % texs];
                ++rx1;
            }
            sy += ystep;
        }
    }

    public Mesh getMesh() {
        return this.mesh;
    }
}

