/*
 * Decompiled with CFR 0.152.
 */
package com.Gameplay.Objects;

import com.AI.Player;
import com.Gameplay.GameScreen;
import com.Gameplay.Map.House;
import com.Gameplay.Map.RoomObject;
import com.Math.Vector3D;
import com.Rendering.DirectX7;
import com.misc.Asset;
import com.misc.Main;

public final class KeyObject
extends RoomObject {
    public Vector3D pos = new Vector3D(0, 0, 0);

    public KeyObject(Vector3D pos2) {
        this.activable = true;
        this.pos.set(pos2);
    }

    public final void destroy() {
    }

    public final void render(DirectX7 g3d, int x1, int y1, int x2, int y2) {
    }

    public final int getPosX() {
        return this.pos.x;
    }

    public final int getPosZ() {
        return this.pos.z;
    }

    public final int getPosY() {
        return this.pos.y;
    }

    public final void setPos(int x, int y, int z) {
        this.pos.set(x, y, z);
    }

    public void activate(House house, Player player, GameScreen gs) {
        if (this.lastActivate > 0L && this.lastActivate + this.timeToReset > GameScreen.time) {
            return;
        }
        if (!this.isAllCollected(Player.usedPoints, player, house, gs)) {
            if (this.errMessage != null) {
                this.errMsg(gs);
            }
            return;
        }
        if (this.sound != null && Main.isSounds && Main.sounds != 0) {
            Asset.getSound(this.sound).start(Main.sounds);
        }
        if (!(this.singleUse && this.activated || this.message == null)) {
            this.prMsg(gs);
        }
        if (!this.singleUse || !this.activated) {
            this.give(this.additional, player, house, gs);
        }
        if (!this.contains(Player.usedPoints, this.name)) {
            this.give(this.name, player);
            this.activated = true;
            if (this.lastActivate >= 0L) {
                this.lastActivate = GameScreen.time;
            }
        }
        if (this.destroyOnUse) {
            house.removeObject(this);
        }
    }
}

