/*
 * Decompiled with CFR 0.152.
 */
package com.HUD;

import com.HUD.GUIScreen;
import com.HUD.Menu;
import com.Rendering.DirectX7;
import com.Rendering.Texture;
import com.Rendering.TexturingAffine;
import com.Rendering.TexturingPers;
import com.Rendering.Vertex;
import com.misc.Main;
import javax.microedition.lcdui.Graphics;

final class Benchmark
extends GUIScreen {
    private int y0;
    private Main main;
    private Menu menu;
    private DirectX7 g3d;
    private Texture tex;
    private Vertex a;
    private Vertex b;
    private Vertex c;
    private long AffTime = 0L;
    private long PersTime = 0L;
    private long PersTimeFloor = 0L;
    private byte rendermode = (byte)9;

    public Benchmark(Main main, Menu menu) {
        this.main = main;
        this.menu = menu;
        this.setFont(Main.getFont());
        this.setSoftKeysNames("Change Render Mode", "Back");
        this.g3d = new DirectX7(256, 256, main);
        this.tex = Texture.createTexture("/images/icon.png");
        this.a = new Vertex(0, 0, 0);
        this.a.sy = 0;
        this.a.sx = 0;
        this.a.rz = 0;
        this.b = new Vertex(0, 0, 0);
        this.b.sy = 0;
        this.b.sx = 255;
        this.b.rz = -100;
        this.c = new Vertex(0, 0, 0);
        this.c.sy = 255;
        this.c.sx = 0;
        this.c.rz = -25;
        this.test(true);
    }

    protected final void paint(Graphics g) {
        this.menu.drawBackground(g);
        g.setColor(0xFFFFFF);
        g.translate(this.getWidth() / 2, this.getHeight() / 2);
        g.drawString("Render Mode: " + this.rendermode, 0, -50, 65);
        g.drawString("Affine Time: " + Long.toString(this.AffTime) + " ms", 0, -20, 65);
        g.drawString("Perspective Time: " + Long.toString(this.PersTime) + " ms", 0, 20, 65);
        g.drawString("Perspective Time Floors: " + Long.toString(this.PersTimeFloor) + " ms", 0, 60, 65);
        g.translate(-this.getWidth() / 2, -this.getHeight() / 2);
        this.drawSoftKeys(g);
    }

    protected final void onLeftSoftKey() {
        this.rendermode = (byte)(this.rendermode + 1);
        if (this.rendermode > 13) {
            this.rendermode = 0;
        }
        this.onKey5();
    }

    protected final void onRightSoftKey() {
        this.g3d.destroy();
        this.a = null;
        this.b = null;
        this.c = null;
        this.rendermode = this.rendermode;
        System.gc();
        Main.setCurrent(this.menu);
    }

    protected final void onKey2() {
        this.repaint();
    }

    protected final void onKey5() {
        this.a.sy = 0;
        this.a.sx = 0;
        this.a.rz = 0;
        this.b.sy = 0;
        this.b.sx = 256;
        this.b.rz = -100;
        this.c.sy = 256;
        this.c.sx = 0;
        this.c.rz = -25;
        this.test(true);
        this.repaint();
    }

    protected final void onKey8() {
        this.repaint();
    }

    protected final void pointerPressed(int x, int y) {
        super.pointerPressed(x, y);
        this.y0 = y;
    }

    protected final void pointerDragged(int x, int y) {
        x = y - this.y0;
        this.y0 = y;
        this.serviceRepaints();
        this.repaint();
    }

    private void test(boolean tp) {
        int i;
        int count = 200;
        if (!tp) {
            count = 2000;
        }
        long bTime = System.currentTimeMillis();
        for (i = 0; i < count; ++i) {
            TexturingPers.paint(this.g3d, this.tex, this.a, 0, 0, this.b, 255, 0, this.c, 0, 255, 0, this.rendermode, 0, 24, 128, 192, 128, 128, 128, 192, 128, 128, 128, (short)128, (short)128, (short)128);
        }
        this.PersTime = System.currentTimeMillis() - bTime;
        bTime = System.currentTimeMillis();
        for (i = 0; i < count; ++i) {
            TexturingPers.paint(this.g3d, this.tex, this.a, 0, 0, this.b, 255, 0, this.c, 0, 255, 0, this.rendermode, 0, 9999, 128, 192, 128, 128, 128, 192, 128, 128, 128, (short)0, (short)4096, (short)0);
        }
        this.PersTimeFloor = System.currentTimeMillis() - bTime;
        bTime = System.currentTimeMillis();
        for (i = 0; i < count; ++i) {
            TexturingAffine.paint(this.g3d, this.tex, this.a, 0, 0, this.b, 255, 0, this.c, 0, 255, 0, this.rendermode, 0, 128, 192, 128, 128, 128, 192, 128, 128, 128, (short)128, (short)128, (short)128);
        }
        this.AffTime = System.currentTimeMillis() - bTime;
    }
}

