/*
 * Decompiled with CFR 0.152.
 */
package com.Math;

import com.Math.Vector3D;
import com.Rendering.Vertex;

public class MathUtils2 {
    private static final Vector3D tVec = new Vector3D();

    public static float invSqrt(float val) {
        float xhalf = 0.5f * val;
        int i = Float.floatToIntBits(val);
        i = 1597463007 - (i >> 1);
        val = Float.intBitsToFloat(i);
        return val * (1.5f - xhalf * val * val);
    }

    public static Vector3D createNormal(Vector3D a, Vector3D b, Vector3D c) {
        Vector3D nor = new Vector3D();
        MathUtils2.calcNormal(nor, a.x, a.y, a.z, b.x, b.y, b.z, c.x, c.y, c.z);
        return nor;
    }

    public static void calcNormal(Vector3D nor, Vector3D a, Vector3D b, Vector3D c) {
        MathUtils2.calcNormal(nor, a.x, a.y, a.z, b.x, b.y, b.z, c.x, c.y, c.z);
    }

    public static Vector3D calcNormal(Vertex a, Vertex b, Vertex c) {
        return MathUtils2.calcNormal(a.x, a.y, a.z, b.x, b.y, b.z, c.x, c.y, c.z);
    }

    public static void calcNormal(Vector3D nor, int ax, int ay, int az, int bx, int by, int bz, int cx, int cy, int cz) {
        double x = (long)(ay - by) * (long)(az - cz) - (long)(az - bz) * (long)(ay - cy);
        double y = (long)(az - bz) * (long)(ax - cx) - (long)(ax - bx) * (long)(az - cz);
        double z = (long)(ax - bx) * (long)(ay - cy) - (long)(ay - by) * (long)(ax - cx);
        double sqrt = Math.sqrt(x * x + y * y + z * z) / 4096.0;
        nor.set((int)(x / sqrt), (int)(y / sqrt), (int)(z / sqrt));
    }

    public static Vector3D calcNormal(int ax, int ay, int az, int bx, int by, int bz, int cx, int cy, int cz) {
        Vector3D nor = new Vector3D(0, 0, 0);
        double x = (long)(ay - by) * (long)(az - cz) - (long)(az - bz) * (long)(ay - cy);
        double y = (long)(az - bz) * (long)(ax - cx) - (long)(ax - bx) * (long)(az - cz);
        double z = (long)(ax - bx) * (long)(ay - cy) - (long)(ay - by) * (long)(ax - cx);
        double sqrt = Math.sqrt(x * x + y * y + z * z) / 4096.0;
        nor.set((int)(x / sqrt), (int)(y / sqrt), (int)(z / sqrt));
        return nor;
    }

    public static long side(int px, int py, int ax, int ay, int bx, int by) {
        return (bx - ax) * (py - ay) - (px - ax) * (by - ay);
    }

    public static int distanceToFace(Vector3D a, Vector3D nor, int px, int py, int pz) {
        tVec.set(px - a.x, py - a.y, pz - a.z);
        return tVec.dot(nor) >> 12;
    }

    public static int distanceToLine(Vector3D point, Vector3D a, Vector3D b) {
        int dx = b.x - a.x;
        int dy = b.y - a.y;
        int dz = b.z - a.z;
        int wx = point.x - a.x;
        int wy = point.y - a.y;
        int wz = point.z - a.z;
        int fp = 14;
        long dp = (long)dx * (long)dx + (long)(dy * dy) + (long)(dz * dz);
        long dt = 0L;
        if (dp != 0L) {
            dt = ((long)wx * (long)dx + (long)(wy * dy) + (long)(wz * dz) << 14) / dp;
        }
        if (dt < 0L) {
            dt = 0L;
        }
        if (dt > 16384L) {
            dt = 16384L;
        }
        dx = a.x + (int)((long)dx * dt >> 14);
        dy = a.y + (int)((long)dy * dt >> 14);
        dz = a.z + (int)((long)dz * dt >> 14);
        return (dx -= point.x) * dx + (dy -= point.y) * dy + (dz -= point.z) * dz;
    }

    public static int distanceToRay(Vector3D point, Vector3D a, Vector3D dir) {
        int dx = dir.x;
        int dy = dir.y;
        int dz = dir.z;
        int wx = point.x - a.x;
        int wy = point.y - a.y;
        int wz = point.z - a.z;
        int fp = 14;
        long dp = dx * dx + dy * dy + dz * dz;
        long dt = 0L;
        if (dp != 0L) {
            dt = ((long)wx * (long)dx + (long)(wy * dy) + (long)(wz * dz) << 14) / dp;
        }
        if (dt < 0L) {
            dt = 0L;
        }
        if (dt > 16384L) {
            dt = 16384L;
        }
        dx = a.x + (int)((long)dx * dt >> 14);
        dy = a.y + (int)((long)dy * dt >> 14);
        dz = a.z + (int)((long)dz * dt >> 14);
        return (dx -= point.x) * dx + (dy -= point.y) * dy + (dz -= point.z) * dz;
    }

    public static boolean isPointOnPolygon(Vector3D point, Vector3D a, Vector3D b, Vector3D c, Vector3D d, Vector3D normal) {
        int nz;
        int nx = normal.x > 0 ? normal.x : -normal.x;
        int ny = normal.y > 0 ? normal.y : -normal.y;
        int n = nz = normal.z > 0 ? normal.z : -normal.z;
        if (nx >= ny && nx >= nz) {
            if (normal.x >= 0) {
                return MathUtils2.isPointOnPolygon(point.z, point.y, a.z, a.y, b.z, b.y, c.z, c.y, d.z, d.y);
            }
            return MathUtils2.isPointOnPolygon(point.z, point.y, d.z, d.y, c.z, c.y, b.z, b.y, a.z, a.y);
        }
        if (ny >= nx && ny >= nz) {
            if (normal.y >= 0) {
                return MathUtils2.isPointOnPolygon(point.x, point.z, a.x, a.z, b.x, b.z, c.x, c.z, d.x, d.z);
            }
            return MathUtils2.isPointOnPolygon(point.x, point.z, d.x, d.z, c.x, c.z, b.x, b.z, a.x, a.z);
        }
        if (nz >= nx && nz >= ny) {
            if (normal.z <= 0) {
                return MathUtils2.isPointOnPolygon(point.x, point.y, a.x, a.y, b.x, b.y, c.x, c.y, d.x, d.y);
            }
            return MathUtils2.isPointOnPolygon(point.x, point.y, d.x, d.y, c.x, c.y, b.x, b.y, a.x, a.y);
        }
        return true;
    }

    public static boolean isPointOnPolygon(Vector3D point, Vector3D a, Vector3D b, Vector3D c, Vector3D normal) {
        int nz;
        int nx = normal.x > 0 ? normal.x : -normal.x;
        int ny = normal.y > 0 ? normal.y : -normal.y;
        int n = nz = normal.z > 0 ? normal.z : -normal.z;
        if (nx >= ny && nx >= nz) {
            if (normal.x >= 0) {
                return MathUtils2.isPointOnPolygon(point.z, point.y, a.z, a.y, b.z, b.y, c.z, c.y);
            }
            return MathUtils2.isPointOnPolygon(point.z, point.y, c.z, c.y, b.z, b.y, a.z, a.y);
        }
        if (ny >= nx && ny >= nz) {
            if (normal.y >= 0) {
                return MathUtils2.isPointOnPolygon(point.x, point.z, a.x, a.z, b.x, b.z, c.x, c.z);
            }
            return MathUtils2.isPointOnPolygon(point.x, point.z, c.x, c.z, b.x, b.z, a.x, a.z);
        }
        if (nz >= nx && nz >= ny) {
            if (normal.z <= 0) {
                return MathUtils2.isPointOnPolygon(point.x, point.y, a.x, a.y, b.x, b.y, c.x, c.y);
            }
            return MathUtils2.isPointOnPolygon(point.x, point.y, c.x, c.y, b.x, b.y, a.x, a.y);
        }
        return true;
    }

    public static boolean isPointOnPolygon(int px, int pz, int ax, int az, int bx, int bz, int cx, int cz, int dx, int dz, int norY) {
        if (norY >= 0) {
            return MathUtils2.isPointOnPolygon(px, pz, ax, az, bx, bz, cx, cz, dx, dz);
        }
        if (norY < 0) {
            return MathUtils2.isPointOnPolygon(px, pz, dx, dz, cx, cz, bx, bz, ax, az);
        }
        return false;
    }

    public static boolean isPointOnPolygon(int px, int pz, int ax, int az, int bx, int bz, int cx, int cz, int norY) {
        if (norY >= 0) {
            return MathUtils2.isPointOnPolygon(px, pz, ax, az, bx, bz, cx, cz);
        }
        if (norY < 0) {
            return MathUtils2.isPointOnPolygon(px, pz, cx, cz, bx, bz, ax, az);
        }
        return false;
    }

    public static boolean isPointOnPolygon(int px, int py, int x1, int y1, int x2, int y2, int x3, int y3, int x4, int y4) {
        return (x2 - x1) * (py - y1) <= (px - x1) * (y2 - y1) && (x3 - x2) * (py - y2) <= (px - x2) * (y3 - y2) && (x4 - x3) * (py - y3) <= (px - x3) * (y4 - y3) && (x1 - x4) * (py - y4) <= (px - x4) * (y1 - y4);
    }

    public static boolean isPointOnPolygon(int px, int py, int x1, int y1, int x2, int y2, int x3, int y3) {
        return (x2 - x1) * (py - y1) <= (px - x1) * (y2 - y1) && (x3 - x2) * (py - y2) <= (px - x2) * (y3 - y2) && (x1 - x3) * (py - y3) <= (px - x3) * (y1 - y3);
    }
}

