/*
 * Decompiled with CFR 0.152.
 */
package com.Rendering;

import com.misc.Asset;
import com.misc.ImageResize;
import com.misc.Main;
import javax.microedition.lcdui.Image;

public class RawImage {
    public int[] img;
    public int w;
    public int h;
    public byte scale = (byte)2;
    public boolean isPalette = false;
    public int widthBIT;
    public int widthBITmode10;
    public int W_UNIT;
    public boolean alphaMixing = false;
    static RawImage error = new RawImage(new int[]{0xFF0000, 0xFF0000, 0xFF0000, 0xFF0000}, 2, 2);

    public RawImage(int[] rgb, int w2, int h2) {
        this.img = rgb;
        this.w = w2;
        this.h = h2;
        this.widthBIT = RawImage.widthToBIT(this.w);
        this.widthBITmode10 = RawImage.widthToBIT(this.w * this.w);
        this.W_UNIT = RawImage.wUnitGen(Math.max(this.w, this.h));
        this.alphaMixing = RawImage.prepareAlpha(rgb);
    }

    private static RawImage imageToRawImage(Image img) throws Throwable {
        return RawImage.imageToRawImage(img, 2);
    }

    private static RawImage imageToRawImage(Image image, int size) {
        try {
            int w = image.getWidth();
            int h = image.getHeight();
            int[] img = new int[w * h];
            image.getRGB(img, 0, w, 0, 0, w, h);
            int scale = size;
            if (scale > Main.pixelsQ) {
                scale = Main.pixelsQ;
            }
            if (Main.pixelsQ == 0) {
                img = ImageResize.cubic2XDesize(img, w, h);
                w /= 2;
                h /= 2;
                scale = 0;
            }
            if (Main.pixelsQ == 1) {
                img = ImageResize.cubic2XVertDesize(img, w, h);
                h /= 2;
                scale = 1;
            }
            RawImage ri = new RawImage(img, w, h);
            ri.scale = (byte)scale;
            return ri;
        }
        catch (Throwable ex) {
            boolean desized;
            if (ex instanceof OutOfMemoryError && (desized = Asset.desizeSomething())) {
                return RawImage.imageToRawImage(image, size - 1);
            }
            System.err.println("ERROR in imageToRawImage: " + ex);
            return error;
        }
    }

    public static RawImage createRawImage(String file) {
        try {
            String format = file;
            format = format.substring(format.indexOf(46) - 3, format.indexOf(46)).trim();
            return RawImage.imageToRawImage(Image.createImage((String)file));
        }
        catch (Throwable ex) {
            if (ex instanceof OutOfMemoryError) {
                return error;
            }
            System.err.println("ERROR in createRawImage " + file + ": " + ex);
            return null;
        }
    }

    public static RawImage createMipRawImage(RawImage base) {
        if (base.w < 2 || base.h < 2) {
            return null;
        }
        try {
            int[] img = ImageResize.mipMap(base.img, base.w, base.h);
            return new RawImage(img, base.w / 2, base.h / 2);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static int widthToBIT(int w) {
        for (int var1 = 0; var1 < 32; ++var1) {
            if (w >> var1 != 1 || 1 << var1 != w) continue;
            return var1;
        }
        return 0;
    }

    private static int wUnitGen(int w) {
        if (w <= 256) {
            return 0x40000000;
        }
        if (w <= 512) {
            return 0x20000000;
        }
        if (w <= 1024) {
            return 0x10000000;
        }
        if (w <= 2048) {
            return 0x8000000;
        }
        if (w <= 4096) {
            return 0x4000000;
        }
        if (w <= 8192) {
            return 0x2000000;
        }
        return 0x1000000;
    }

    private static final boolean prepareAlpha(int[] pix) {
        boolean alphaMixing = false;
        for (int i = 0; i < pix.length; ++i) {
            int col = pix[i];
            int alpha = pix[i] >> 24 & 0xFF;
            if (alpha > 1 && alpha < 255) {
                alphaMixing = true;
            }
            if (alpha > 1) continue;
            pix[i] = 0;
        }
        return alphaMixing;
    }
}

