/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mid.sound;

import com.nokia.mid.sound.SoundListener;
import java.io.ByteArrayInputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;
import javax.microedition.media.control.VolumeControl;

public class Sound {
    public static final int FORMAT_TONE = 1;
    public static final int FORMAT_WAV = 5;
    public static final int SOUND_PLAYING = 0;
    public static final int SOUND_STOPPED = 1;
    public static final int SOUND_UNINITIALIZED = 3;
    private static boolean formatToneNotImplementedNotified;
    private static final byte[] EMPTY_MIDI;
    private int state;
    private Player implement;
    private VolumeControl volume;
    private SoundListener listener;
    private final PlayerListener gate = this.createGate();

    static {
        byte[] byArray = new byte[34];
        byArray[0] = 77;
        byArray[1] = 84;
        byArray[2] = 104;
        byArray[3] = 100;
        byArray[7] = 6;
        byArray[11] = 1;
        byArray[13] = 100;
        byArray[14] = 77;
        byArray[15] = 84;
        byArray[16] = 114;
        byArray[17] = 107;
        byArray[21] = 12;
        byArray[23] = -1;
        byArray[24] = 81;
        byArray[25] = 3;
        byArray[26] = 1;
        byArray[27] = -122;
        byArray[28] = -96;
        byArray[29] = -121;
        byArray[30] = 104;
        byArray[31] = -1;
        byArray[32] = 47;
        EMPTY_MIDI = byArray;
    }

    public static int getConcurrentSoundCount(int format) {
        switch (format) {
            default: {
                throw new IllegalArgumentException("Sound.getConcurrentSoundCount: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 format \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
            }
            case 1: 
            case 5: 
        }
        return 255;
    }

    public static int[] getSupportedFormats() {
        return new int[]{1, 5};
    }

    public Sound(int frequency, long duration) {
        this.recreate(frequency, duration);
    }

    public Sound(byte[] data, int format) {
        this.recreate(data, format);
    }

    public void init(int frequency, long duration) {
        this.recreate(frequency, duration);
    }

    public void init(byte[] data, int format) {
        this.recreate(data, format);
    }

    public void release() {
        Player implement = this.implement;
        if (implement != null) {
            this.state = 3;
            this.implement = null;
            this.volume = null;
            implement.close();
        }
    }

    public void resume() {
        Player implement = this.implement;
        if (implement != null) {
            this.state = 0;
            try {
                implement.start();
            }
            catch (MediaException e) {
                e.printRealStackTrace();
            }
        }
    }

    public void play(int loopCount) {
        Player implement;
        if (loopCount < 0) {
            throw new IllegalArgumentException("Sound.play: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 loopCount \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043e\u0442\u0440\u0438\u0446\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u043c.");
        }
        if (loopCount >= 255) {
            return;
        }
        if (loopCount == 0) {
            loopCount = -1;
        }
        if ((implement = this.implement) != null) {
            this.state = 0;
            try {
                implement.stop();
                implement.setLoopCount(loopCount);
                implement.start();
            }
            catch (MediaException e) {
                e.printRealStackTrace();
            }
        }
    }

    public void stop() {
        Player implement = this.implement;
        if (implement != null) {
            this.state = 1;
            try {
                implement.stop();
            }
            catch (MediaException e) {
                e.printRealStackTrace();
            }
        }
    }

    public void setSoundListener(SoundListener listener) {
        this.listener = listener;
    }

    public void setGain(int volumeLevel) {
        VolumeControl volume;
        if (volumeLevel < 0) {
            volumeLevel = 0;
        }
        if (volumeLevel > 255) {
            volumeLevel = 255;
        }
        if (volumeLevel > 0) {
            volumeLevel = (volumeLevel - 1) * 99 / 254 + 1;
        }
        if ((volume = this.volume) != null) {
            try {
                volume.setLevel(volumeLevel);
            }
            catch (Exception e) {
                e.printRealStackTrace();
            }
        }
    }

    public int getGain() {
        VolumeControl volume = this.volume;
        if (volume == null) {
            return -1;
        }
        int result = volume.getLevel();
        if (result > 0) {
            result = (result - 1) * 254 / 99 + 1;
        }
        return result;
    }

    public int getState() {
        return this.state;
    }

    final void notify(int state) {
        this.state = state;
        SoundListener listener = this.listener;
        if (listener != null) {
            listener.soundStateChanged(this, state);
        }
    }

    private strictfp void recreate(int frequency, long duration) {
        if (frequency < 0) {
            throw new IllegalArgumentException("Sound.init: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 frequency \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043e\u0442\u0440\u0438\u0446\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u043c.");
        }
        if (duration <= 0L) {
            throw new IllegalArgumentException("Sound.init: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 duration \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u043f\u043e\u043b\u043e\u0436\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u043c.");
        }
        int time = duration > 10000L ? 10000 : (int)duration;
        int note = frequency <= 0 ? 0 : (int)Math.round(12.0 * Math.log2((double)frequency) + -36.37631656229591);
        if (note < 0) {
            note = 0;
        } else if (note > 127) {
            note = 127;
        }
        byte[] byArray = new byte[42];
        byArray[0] = 77;
        byArray[1] = 84;
        byArray[2] = 104;
        byArray[3] = 100;
        byArray[7] = 6;
        byArray[11] = 1;
        byArray[13] = 100;
        byArray[14] = 77;
        byArray[15] = 84;
        byArray[16] = 114;
        byArray[17] = 107;
        byArray[21] = 20;
        byArray[23] = -1;
        byArray[24] = 81;
        byArray[25] = 3;
        byArray[26] = 1;
        byArray[27] = -122;
        byArray[28] = -96;
        byArray[30] = -112;
        byArray[31] = (byte)note;
        byArray[32] = 127;
        byArray[33] = (byte)(0x80 | time >> 7);
        byArray[34] = (byte)(time & 0x7F);
        byArray[35] = (byte)note;
        byArray[37] = (byte)(0x80 | time >> 7);
        byArray[38] = (byte)(time & 0x7F);
        byArray[39] = -1;
        byArray[40] = 47;
        byte[] midi = byArray;
        Player implement = this.implement;
        if (implement != null) {
            implement.close();
        }
        try {
            this.init(Manager.createPlayer(new ByteArrayInputStream(midi), "audio/midi"));
        }
        catch (Exception e) {
            e.printRealStackTrace();
        }
    }

    private void recreate(byte[] data, int format) {
        if (data == null) {
            throw new NullPointerException("Sound.init: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 data \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        switch (format) {
            case 1: {
                Player implement;
                if (!formatToneNotImplementedNotified) {
                    formatToneNotImplementedNotified = true;
                    System.out.println("/!\\ Sound.init: \u0444\u043e\u0440\u043c\u0430\u0442 TONE \u0443\u0441\u0442\u0430\u0440\u0435\u043b \u0438 \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f \u044d\u0442\u043e\u0439 \u0440\u0435\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0435\u0439.");
                }
                if ((implement = this.implement) != null) {
                    implement.close();
                }
                try {
                    this.init(Manager.createPlayer(new ByteArrayInputStream(EMPTY_MIDI), "audio/midi"));
                    break;
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(e.getMessage());
                }
            }
            case 5: {
                Player implement = this.implement;
                if (implement != null) {
                    implement.close();
                }
                try {
                    this.init(Manager.createPlayer(new ByteArrayInputStream(data), "audio/x-wav"));
                    break;
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(e.getMessage());
                }
            }
            default: {
                throw new IllegalArgumentException("Sound.init: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 format \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
            }
        }
    }

    private void init(Player implement) throws MediaException {
        implement.addPlayerListener(this.gate);
        implement.prefetch();
        VolumeControl volume = (VolumeControl)implement.getControl("VolumeControl");
        this.state = 1;
        this.implement = implement;
        this.volume = volume;
    }

    private PlayerListener createGate() {
        return new PlayerListener(){

            public void playerUpdate(Player player, String event, Object data) {
                Sound parent = Sound.this;
                if ("closed".equals(event)) {
                    parent.notify(3);
                    return;
                }
                if ("started".equals(event)) {
                    parent.notify(0);
                    return;
                }
                if ("stopped".equals(event) || "endOfMedia".equals(event)) {
                    parent.notify(1);
                }
            }
        };
    }
}

