/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import javax.microedition.lcdui.CustomScrollBar;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.Screen;
import javax.microedition.lcdui.ScreenGraphics;
import javax.microedition.lcdui.ScrollBar;
import malik.emulator.application.KeyboardEvent;
import malik.emulator.application.PointerEvent;
import malik.emulator.media.graphics.RasterCanvas;
import malik.emulator.microedition.lcdui.ScreenScrollBarStyle;
import malik.emulator.microedition.lcdui.ScrollBarStyle;

public abstract class SurfaceScreen
extends Screen {
    private static final int INNER_MARGIN = 5;
    private static final int OUTER_MARGIN = 8;
    private static final int WHEEL_SCROLL = 16;
    private int focused;
    private final int size;
    private final int[] rect;
    final CustomScrollBar scroll;
    private final ScrollBarStyle style;

    SurfaceScreen(String title, int verticalRange, boolean scrollbarVisibility, ScrollBarStyle style) {
        super(title, null, true);
        if (style == null) {
            style = new ScreenScrollBarStyle();
        }
        this.size = style.size();
        this.rect = new int[4];
        this.scroll = new VertScrollBar(scrollbarVisibility, verticalRange, null);
        this.style = style;
    }

    public final ScrollBar getScrollBar() {
        return this.scroll;
    }

    abstract void paint(ScreenGraphics var1);

    void paintBackground(ScreenGraphics render, int width, int height, byte visibleElements, byte drawingElements) {
        Displayable active;
        Display parent = this.getParentDisplay();
        if (parent != null && (active = parent.getActiveBackground()) != null) {
            Displayable.Helper helper = active.helper;
            helper.justPaint();
            helper.execute();
            render.reset();
            render.setARGBColor(-1073741824);
        } else {
            render.setARGBColor(-16777216);
        }
        render.fillRect(0, 0, width, height);
        int base = height - this.getPanelHeight();
        int elementHeight = (visibleElements & 1) != 0 ? base : height;
        int rectLeft = 8;
        int rectTop = base >> 2;
        int rectWidth = width - 16;
        int rectHeight = elementHeight - (base >> 2 << 1);
        render.setARGBColor(0x60000000);
        render.fillRect(rectLeft - 6, rectTop - 6, rectWidth + 12, rectHeight + 12);
        render.fillRect(rectLeft - 4, rectTop - 4, rectWidth + 8, rectHeight + 8);
        render.fillRect(rectLeft - 2, rectTop - 2, rectWidth + 4, rectHeight + 4);
        render.setColor(RasterCanvas.getSystemColor((int)4));
        render.fillRect(rectLeft, rectTop, rectWidth, rectHeight);
    }

    void paintClient(ScreenGraphics render, int width, int height, int clipLeft, int clipTop, int clipWidth, int clipHeight, Image clipBuffer) {
        int base = this.getTotalHeight() - this.getPanelHeight();
        int size = this.size;
        int left = 13;
        int top = (base >> 2) + 5;
        int right = left;
        int bottom = top;
        int tx = left + render.getTranslateX();
        int ty = top + render.getTranslateY();
        CustomScrollBar scroll = this.scroll;
        ScrollBarStyle style = this.style;
        boolean svisible = scroll.visibility;
        int spos = scroll.position;
        width -= left + right + (svisible ? size : 0);
        height -= top + bottom;
        if (svisible) {
            render.reset();
            render.translate(tx + width, ty);
            style.verticalScrollBarPaintEvent(scroll, render, size, height);
        }
        render.reset();
        render.restricts(tx, ty, width, height);
        render.setStartPoint(tx, ty - spos);
        render.setClip(tx, ty, width, height);
        render.clipRect(tx + clipLeft, ty + clipTop, clipWidth, clipHeight);
        render.translate(tx, ty - spos);
        this.paint(render);
    }

    void onPaint(ScreenGraphics render, byte drawingElements, int clipLeft, int clipTop, int clipWidth, int clipHeight, Image clipBuffer) {
        super.onPaint(render, (byte)3, clipLeft, clipTop, clipWidth, clipHeight, clipBuffer);
    }

    boolean onKeyboardEvent(KeyboardEvent event) {
        if (!super.onKeyboardEvent(event)) {
            this.onClientKeyboardEvent(event);
        }
        return true;
    }

    boolean onPointerEvent(PointerEvent event) {
        if (super.onPointerEvent(event)) {
            return true;
        }
        switch (event.getAction()) {
            case 10: {
                int b = event.getButton();
                boolean down = b == 15;
                if (down || b == 14) {
                    this.scroll.scroll(down ? 16 : -16);
                    return true;
                }
                this.focused = this.getFocusedElement(event.getX(), event.getY(), b);
                return this.handlePointerEvent(this.focused, event);
            }
            case 14: {
                int b = event.getButton();
                boolean down = b == 15;
                if (down || b == 14) {
                    this.scroll.scroll(down ? 16 : -16);
                    return true;
                }
            }
            case 9: {
                return this.handlePointerEvent(this.focused, event);
            }
            case 15: {
                int b = event.getButton();
                return b == 15 || b == 14 || this.handlePointerEvent(this.focused, event);
            }
            case 11: {
                int f = this.focused;
                this.focused = 0;
                int b = event.getButton();
                return b == 15 || b == 14 || this.handlePointerEvent(f, event);
            }
        }
        return false;
    }

    Displayable.Helper createHelper() {
        return new Helper();
    }

    void onClientScroll(int position, int clientWidth, int clientHeight) {
    }

    final void setFullScreenMode(boolean fullScreen) {
    }

    final boolean isFullScreenMode() {
        return false;
    }

    final int getMarginLeft() {
        return 13;
    }

    final int getMarginTop() {
        return (this.getTotalHeight() - this.getPanelHeight() >> 2) + 5;
    }

    final int getMarginRight() {
        return 13 + (this.scroll.visibility ? this.size : 0);
    }

    final int getMarginBottom() {
        return (this.getTotalHeight() - this.getPanelHeight() >> 2) + 5;
    }

    private boolean handlePointerEvent(int focused, PointerEvent event) {
        int[] r = this.rect;
        switch (focused) {
            case 2: {
                event.translate(r[0], r[1]);
                this.style.verticalScrollBarPointerEvent(this.scroll, event, r[2], r[3]);
                return true;
            }
            case 3: {
                event.translate(r[0], r[1] - this.scroll.position);
                this.onClientPointerEvent(event);
                return true;
            }
            case 4: {
                int a = event.getAction();
                if (a == 9 || a == 15 || a == 11) {
                    event.translate(r[0], r[1]);
                    this.scroll.scroll(event.historicalY(1) - event.getY());
                }
                return true;
            }
        }
        return false;
    }

    private int getFocusedElement(int x, int y, int button) {
        int sl;
        boolean svisible = this.scroll.visibility;
        byte e = this.getElements();
        int height = this.getTotalHeight();
        int base = height - this.getPanelHeight();
        int l = 13;
        int t = (base >> 2) + 5;
        int w = this.getTotalWidth() - 26;
        int h = height - (t << 1) - ((e & 1) != 0 ? height - base : 0);
        int s = this.size;
        int[] r = this.rect;
        if (svisible && x >= (sl = l + w - s) && x < sl + s && y >= t && y < t + h) {
            r[0] = sl;
            r[1] = t;
            r[2] = s;
            r[3] = h;
            return 2;
        }
        if (x >= l && x < l + w && y >= t && y < t + h) {
            r[0] = l;
            r[1] = t;
            r[2] = w;
            r[3] = h;
            return button == 13 ? 4 : 3;
        }
        return 0;
    }

    class Helper
    extends Displayable.Helper {
        private int scrollPos = -1;

        protected void execute() {
            this.serviceSizeChanged();
            this.serviceScroll();
            this.servicePaint();
        }

        protected final void serviceScroll() {
            SurfaceScreen owner = SurfaceScreen.this;
            if (owner.getParentDisplay() == null) {
                return;
            }
            int pos = owner.scroll.invalidatePosition();
            if (this.scrollPos == pos) {
                return;
            }
            try {
                this.scrollPos = pos;
                owner.onClientScroll(this.scrollPos, this.availableWidth(), this.availableHeight());
            }
            catch (RuntimeException e) {
                e.printRealStackTrace();
            }
        }

        protected final int position() {
            return this.scrollPos;
        }
    }

    private final class VertScrollBar
    extends CustomScrollBar {
        public VertScrollBar(boolean visibility, int range, Object monitor) {
            super(visibility, range, monitor);
        }

        public void repaint() {
            SurfaceScreen.this.requestPaintAll();
        }

        public int getPage() {
            return SurfaceScreen.this.getApplicationHeight();
        }

        protected void notifyFieldsChanged(int fields) {
            SurfaceScreen.this.requestPaintAll();
        }
    }
}

