/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui.game;

import javax.microedition.lcdui.CustomCanvas;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import malik.emulator.application.KeyboardEvent;
import malik.emulator.media.graphics.RasterCanvas;
import malik.emulator.microedition.DeviceManager;
import malik.emulator.microedition.DeviceSettings;

public abstract class GameCanvas
extends CustomCanvas {
    public static final int UP_PRESSED = 2;
    public static final int LEFT_PRESSED = 4;
    public static final int RIGHT_PRESSED = 32;
    public static final int DOWN_PRESSED = 64;
    public static final int FIRE_PRESSED = 256;
    public static final int GAME_A_PRESSED = 512;
    public static final int GAME_B_PRESSED = 1024;
    public static final int GAME_C_PRESSED = 2048;
    public static final int GAME_D_PRESSED = 4096;
    private final boolean suppressKeyEvents;
    private int keyStates;
    private final Image buffer;

    protected GameCanvas(boolean suppressKeyEvents) {
        RasterCanvas screen = RasterCanvas.screen;
        this.suppressKeyEvents = suppressKeyEvents;
        this.buffer = Image.createImage(screen.getWidth(), screen.getHeight());
    }

    public void paint(Graphics render) {
        if (render == null) {
            throw new NullPointerException("GameCanvas.paint: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 render \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        render.drawImage(this.buffer, 0, 0, 0);
    }

    public void flushGraphics() {
        this.flushBuffer(this.buffer);
    }

    public void flushGraphics(int left, int top, int width, int height) {
        this.flushBuffer(left, top, width, height, this.buffer);
    }

    public int getKeyStates() {
        return this.keyStates;
    }

    protected Graphics getGraphics() {
        return this.buffer.getGraphics();
    }

    protected final void show() {
        this.showNotify();
    }

    protected final void hide() {
        this.keyStates = 0;
        this.hideNotify();
    }

    protected final void keyboardEvent(KeyboardEvent event) {
        DeviceSettings settings = DeviceManager.getInstance().getSettings();
        switch (event.getAction()) {
            case 6: {
                int keyCode = settings.getKeyCode(event.getKey());
                if (keyCode == 0) break;
                int gameAction = settings.keyCodeToGameAction(keyCode) & 0x1F;
                if (gameAction != 0) {
                    this.keyStates |= 1 << gameAction;
                }
                if (gameAction != 0 && this.suppressKeyEvents) break;
                this.keyPressed(keyCode);
                break;
            }
            case 5: {
                int keyCode;
                if (!settings.isKeyRepeatedEvent() || (keyCode = settings.getKeyCode(event.getKey())) == 0) break;
                int gameAction = settings.keyCodeToGameAction(keyCode) & 0x1F;
                if (gameAction != 0) {
                    this.keyStates |= 1 << gameAction;
                }
                if (gameAction != 0 && this.suppressKeyEvents) break;
                this.keyRepeated(keyCode);
                break;
            }
            case 7: {
                int keyCode = settings.getKeyCode(event.getKey());
                if (keyCode == 0) break;
                int gameAction = settings.keyCodeToGameAction(keyCode) & 0x1F;
                if (gameAction != 0) {
                    this.keyStates &= ~(1 << gameAction);
                }
                if (gameAction != 0 && this.suppressKeyEvents) break;
                this.keyReleased(keyCode);
            }
        }
    }
}

