/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.microedition;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import malik.emulator.fileformats.text.mapped.AttributedTextDecoder;
import malik.emulator.fileformats.text.mapped.ManifestDecoder;
import malik.emulator.fileformats.text.mapped.MappedTextDecoder;
import malik.emulator.fileformats.text.mapped.PropertiesDecoder;
import malik.emulator.io.cloud.CloudFileSystem;
import malik.emulator.io.cloud.FileOutputStream;
import malik.emulator.io.cloud.HandleInputStream;
import malik.emulator.media.graphics.SystemFont;
import malik.emulator.util.StringBuilder;
import malik.emulator.util.ThrowableStackTrace;

public class DeviceSettings {
    public static final int DEVICE_KEY_1 = 49;
    public static final int DEVICE_KEY_2 = 50;
    public static final int DEVICE_KEY_3 = 51;
    public static final int DEVICE_KEY_4 = 52;
    public static final int DEVICE_KEY_5 = 53;
    public static final int DEVICE_KEY_6 = 54;
    public static final int DEVICE_KEY_7 = 55;
    public static final int DEVICE_KEY_8 = 56;
    public static final int DEVICE_KEY_9 = 57;
    public static final int DEVICE_KEY_STAR = 42;
    public static final int DEVICE_KEY_0 = 48;
    public static final int DEVICE_KEY_POUND = 35;
    public static final int DEVICE_KEY_UP = 38;
    public static final int DEVICE_KEY_DOWN = 36;
    public static final int DEVICE_KEY_LEFT = 40;
    public static final int DEVICE_KEY_RIGHT = 41;
    public static final int DEVICE_KEY_SELECT = 43;
    public static final int DEVICE_KEY_SOFT1 = 37;
    public static final int DEVICE_KEY_SOFT2 = 39;
    public static final int DEVICE_KEY_CONSOLE = 44;
    public static final int DEVICE_KEY_EXITAPP = 46;
    public static final int FONT_STYLE_PLAIN = 0;
    public static final int FONT_STYLE_BOLD = 1;
    public static final int FONT_STYLE_ITALIC = 2;
    public static final int FONT_STYLE_BOLD_ITALIC = 3;
    public static final int FONT_SIZE_MEDIUM = 0;
    public static final int FONT_SIZE_SMALL = 1;
    public static final int FONT_SIZE_LARGE = 2;
    private static final String MIDLET_PROPERTIES = "/midlet.properties";
    private static final String MIDLET_DESCRIPTOR = "/res/META-INF/MANIFEST.MF";
    private static final String[] FONT_KEYS = new String[]{"font.medium.plain", "font.medium.bold", "font.medium.italic", "font.medium.bold.italic", "font.small.plain", "font.small.bold", "font.small.italic", "font.small.bold.italic", "font.large.plain", "font.large.bold", "font.large.italic", "font.large.bold.italic"};
    private boolean keyRepeatedEvent;
    private int keyUsedAs1;
    private int keyUsedAs2;
    private int keyUsedAs3;
    private int keyUsedAs4;
    private int keyUsedAs5;
    private int keyUsedAs6;
    private int keyUsedAs7;
    private int keyUsedAs8;
    private int keyUsedAs9;
    private int keyUsedAsStar;
    private int keyUsedAs0;
    private int keyUsedAsPound;
    private int keyUsedAsUp;
    private int keyUsedAsDown;
    private int keyUsedAsLeft;
    private int keyUsedAsRight;
    private int keyUsedAsSelect;
    private int keyUsedAsSoft1;
    private int keyUsedAsSoft2;
    private int keyUsedAsConsole;
    private int keyUsedAsExitApp;
    private int keyCodeForUp;
    private int keyCodeForDown;
    private int keyCodeForLeft;
    private int keyCodeForRight;
    private int keyCodeForSelect;
    private int keyCodeForSoft1;
    private int keyCodeForSoft2;
    private int maximumFrequency;
    private int minimumPeriod;
    private final SystemFont[] fonts = new SystemFont[FONT_KEYS.length];
    private final MappedTextDecoder midletProperties = new PropertiesDecoder();
    private final AttributedTextDecoder midletDescriptor = new ManifestDecoder();

    public static int stringToKey(String keyName) {
        if (keyName == null) {
            return 0;
        }
        if ("BACKSPACE".equals(keyName)) {
            return 8;
        }
        if ("TAB".equals(keyName)) {
            return 9;
        }
        if ("ENTER".equals(keyName)) {
            return 13;
        }
        if ("SHIFT".equals(keyName)) {
            return 16;
        }
        if ("CTRL".equals(keyName)) {
            return 17;
        }
        if ("ALT".equals(keyName)) {
            return 18;
        }
        if ("PAUSE_BREAK".equals(keyName)) {
            return 19;
        }
        if ("CAPS_LOCK".equals(keyName)) {
            return 20;
        }
        if ("ESCAPE".equals(keyName)) {
            return 27;
        }
        if ("SPACE".equals(keyName)) {
            return 32;
        }
        if ("PAGE_UP".equals(keyName)) {
            return 33;
        }
        if ("PAGE_DOWN".equals(keyName)) {
            return 34;
        }
        if ("END".equals(keyName)) {
            return 35;
        }
        if ("HOME".equals(keyName)) {
            return 36;
        }
        if ("LEFT".equals(keyName)) {
            return 37;
        }
        if ("UP".equals(keyName)) {
            return 38;
        }
        if ("RIGHT".equals(keyName)) {
            return 39;
        }
        if ("DOWN".equals(keyName)) {
            return 40;
        }
        if ("INSERT".equals(keyName)) {
            return 45;
        }
        if ("DELETE".equals(keyName)) {
            return 46;
        }
        if ("0".equals(keyName)) {
            return 48;
        }
        if ("1".equals(keyName)) {
            return 49;
        }
        if ("2".equals(keyName)) {
            return 50;
        }
        if ("3".equals(keyName)) {
            return 51;
        }
        if ("4".equals(keyName)) {
            return 52;
        }
        if ("5".equals(keyName)) {
            return 53;
        }
        if ("6".equals(keyName)) {
            return 54;
        }
        if ("7".equals(keyName)) {
            return 55;
        }
        if ("8".equals(keyName)) {
            return 56;
        }
        if ("9".equals(keyName)) {
            return 57;
        }
        if ("A".equals(keyName)) {
            return 65;
        }
        if ("B".equals(keyName)) {
            return 66;
        }
        if ("C".equals(keyName)) {
            return 67;
        }
        if ("D".equals(keyName)) {
            return 68;
        }
        if ("E".equals(keyName)) {
            return 69;
        }
        if ("F".equals(keyName)) {
            return 70;
        }
        if ("G".equals(keyName)) {
            return 71;
        }
        if ("H".equals(keyName)) {
            return 72;
        }
        if ("I".equals(keyName)) {
            return 73;
        }
        if ("J".equals(keyName)) {
            return 74;
        }
        if ("K".equals(keyName)) {
            return 75;
        }
        if ("L".equals(keyName)) {
            return 76;
        }
        if ("M".equals(keyName)) {
            return 77;
        }
        if ("N".equals(keyName)) {
            return 78;
        }
        if ("O".equals(keyName)) {
            return 79;
        }
        if ("P".equals(keyName)) {
            return 80;
        }
        if ("Q".equals(keyName)) {
            return 81;
        }
        if ("R".equals(keyName)) {
            return 82;
        }
        if ("S".equals(keyName)) {
            return 83;
        }
        if ("T".equals(keyName)) {
            return 84;
        }
        if ("U".equals(keyName)) {
            return 85;
        }
        if ("V".equals(keyName)) {
            return 86;
        }
        if ("W".equals(keyName)) {
            return 87;
        }
        if ("X".equals(keyName)) {
            return 88;
        }
        if ("Y".equals(keyName)) {
            return 89;
        }
        if ("Z".equals(keyName)) {
            return 90;
        }
        if ("CONTEXT".equals(keyName)) {
            return 93;
        }
        if ("NUM_0".equals(keyName)) {
            return 96;
        }
        if ("NUM_1".equals(keyName)) {
            return 97;
        }
        if ("NUM_2".equals(keyName)) {
            return 98;
        }
        if ("NUM_3".equals(keyName)) {
            return 99;
        }
        if ("NUM_4".equals(keyName)) {
            return 100;
        }
        if ("NUM_5".equals(keyName)) {
            return 101;
        }
        if ("NUM_6".equals(keyName)) {
            return 102;
        }
        if ("NUM_7".equals(keyName)) {
            return 103;
        }
        if ("NUM_8".equals(keyName)) {
            return 104;
        }
        if ("NUM_9".equals(keyName)) {
            return 105;
        }
        if ("NUM_STAR".equals(keyName)) {
            return 106;
        }
        if ("NUM_PLUS".equals(keyName)) {
            return 107;
        }
        if ("NUM_SEPARATOR".equals(keyName)) {
            return 108;
        }
        if ("NUM_MINUS".equals(keyName)) {
            return 109;
        }
        if ("NUM_DECIMAL".equals(keyName)) {
            return 110;
        }
        if ("NUM_DIVIDE".equals(keyName)) {
            return 111;
        }
        if ("F1".equals(keyName)) {
            return 112;
        }
        if ("F2".equals(keyName)) {
            return 113;
        }
        if ("F3".equals(keyName)) {
            return 114;
        }
        if ("F4".equals(keyName)) {
            return 115;
        }
        if ("F5".equals(keyName)) {
            return 116;
        }
        if ("F6".equals(keyName)) {
            return 117;
        }
        if ("F7".equals(keyName)) {
            return 118;
        }
        if ("F8".equals(keyName)) {
            return 119;
        }
        if ("F9".equals(keyName)) {
            return 120;
        }
        if ("F10".equals(keyName)) {
            return 121;
        }
        if ("F11".equals(keyName)) {
            return 122;
        }
        if ("F12".equals(keyName)) {
            return 123;
        }
        if ("F13".equals(keyName)) {
            return 124;
        }
        if ("F14".equals(keyName)) {
            return 125;
        }
        if ("F15".equals(keyName)) {
            return 126;
        }
        if ("F16".equals(keyName)) {
            return 127;
        }
        if ("F17".equals(keyName)) {
            return 128;
        }
        if ("F18".equals(keyName)) {
            return 129;
        }
        if ("F19".equals(keyName)) {
            return 130;
        }
        if ("F20".equals(keyName)) {
            return 131;
        }
        if ("F21".equals(keyName)) {
            return 132;
        }
        if ("F22".equals(keyName)) {
            return 133;
        }
        if ("F23".equals(keyName)) {
            return 134;
        }
        if ("F24".equals(keyName)) {
            return 135;
        }
        if ("NUM_LOCK".equals(keyName)) {
            return 144;
        }
        if ("SCROLL_LOCK".equals(keyName)) {
            return 145;
        }
        if ("LSHIFT".equals(keyName)) {
            return 160;
        }
        if ("RSHIFT".equals(keyName)) {
            return 161;
        }
        if ("LCTRL".equals(keyName)) {
            return 162;
        }
        if ("RCTRL".equals(keyName)) {
            return 163;
        }
        if ("LALT".equals(keyName)) {
            return 164;
        }
        if ("RALT".equals(keyName)) {
            return 165;
        }
        if ("SEMICOLON".equals(keyName)) {
            return 186;
        }
        if ("EQUAL".equals(keyName)) {
            return 187;
        }
        if ("COMMA".equals(keyName)) {
            return 188;
        }
        if ("MINUS".equals(keyName)) {
            return 189;
        }
        if ("PERIOD".equals(keyName)) {
            return 190;
        }
        if ("SLASH".equals(keyName)) {
            return 191;
        }
        if ("GRAVE".equals(keyName)) {
            return 192;
        }
        if ("LBRACKET".equals(keyName)) {
            return 219;
        }
        if ("BACKSLASH".equals(keyName)) {
            return 220;
        }
        if ("RBRACKET".equals(keyName)) {
            return 221;
        }
        if ("APOSTROPHE".equals(keyName)) {
            return 222;
        }
        return 0;
    }

    public static String keyToString(int key) {
        switch (key) {
            default: {
                return null;
            }
            case 8: {
                return "BACKSPACE";
            }
            case 9: {
                return "TAB";
            }
            case 13: {
                return "ENTER";
            }
            case 16: {
                return "SHIFT";
            }
            case 17: {
                return "CTRL";
            }
            case 18: {
                return "ALT";
            }
            case 19: {
                return "PAUSE_BREAK";
            }
            case 20: {
                return "CAPS_LOCK";
            }
            case 27: {
                return "ESCAPE";
            }
            case 32: {
                return "SPACE";
            }
            case 33: {
                return "PAGE_UP";
            }
            case 34: {
                return "PAGE_DOWN";
            }
            case 35: {
                return "END";
            }
            case 36: {
                return "HOME";
            }
            case 37: {
                return "LEFT";
            }
            case 38: {
                return "UP";
            }
            case 39: {
                return "RIGHT";
            }
            case 40: {
                return "DOWN";
            }
            case 45: {
                return "INSERT";
            }
            case 46: {
                return "DELETE";
            }
            case 48: {
                return "0";
            }
            case 49: {
                return "1";
            }
            case 50: {
                return "2";
            }
            case 51: {
                return "3";
            }
            case 52: {
                return "4";
            }
            case 53: {
                return "5";
            }
            case 54: {
                return "6";
            }
            case 55: {
                return "7";
            }
            case 56: {
                return "8";
            }
            case 57: {
                return "9";
            }
            case 65: {
                return "A";
            }
            case 66: {
                return "B";
            }
            case 67: {
                return "C";
            }
            case 68: {
                return "D";
            }
            case 69: {
                return "E";
            }
            case 70: {
                return "F";
            }
            case 71: {
                return "G";
            }
            case 72: {
                return "H";
            }
            case 73: {
                return "I";
            }
            case 74: {
                return "J";
            }
            case 75: {
                return "K";
            }
            case 76: {
                return "L";
            }
            case 77: {
                return "M";
            }
            case 78: {
                return "N";
            }
            case 79: {
                return "O";
            }
            case 80: {
                return "P";
            }
            case 81: {
                return "Q";
            }
            case 82: {
                return "R";
            }
            case 83: {
                return "S";
            }
            case 84: {
                return "T";
            }
            case 85: {
                return "U";
            }
            case 86: {
                return "V";
            }
            case 87: {
                return "W";
            }
            case 88: {
                return "X";
            }
            case 89: {
                return "Y";
            }
            case 90: {
                return "Z";
            }
            case 93: {
                return "CONTEXT";
            }
            case 96: {
                return "NUM_0";
            }
            case 97: {
                return "NUM_1";
            }
            case 98: {
                return "NUM_2";
            }
            case 99: {
                return "NUM_3";
            }
            case 100: {
                return "NUM_4";
            }
            case 101: {
                return "NUM_5";
            }
            case 102: {
                return "NUM_6";
            }
            case 103: {
                return "NUM_7";
            }
            case 104: {
                return "NUM_8";
            }
            case 105: {
                return "NUM_9";
            }
            case 106: {
                return "NUM_STAR";
            }
            case 107: {
                return "NUM_PLUS";
            }
            case 108: {
                return "NUM_SEPARATOR";
            }
            case 109: {
                return "NUM_MINUS";
            }
            case 110: {
                return "NUM_DECIMAL";
            }
            case 111: {
                return "NUM_DIVIDE";
            }
            case 112: {
                return "F1";
            }
            case 113: {
                return "F2";
            }
            case 114: {
                return "F3";
            }
            case 115: {
                return "F4";
            }
            case 116: {
                return "F5";
            }
            case 117: {
                return "F6";
            }
            case 118: {
                return "F7";
            }
            case 119: {
                return "F8";
            }
            case 120: {
                return "F9";
            }
            case 121: {
                return "F10";
            }
            case 122: {
                return "F11";
            }
            case 123: {
                return "F12";
            }
            case 124: {
                return "F13";
            }
            case 125: {
                return "F14";
            }
            case 126: {
                return "F15";
            }
            case 127: {
                return "F16";
            }
            case 128: {
                return "F17";
            }
            case 129: {
                return "F18";
            }
            case 130: {
                return "F19";
            }
            case 131: {
                return "F20";
            }
            case 132: {
                return "F21";
            }
            case 133: {
                return "F22";
            }
            case 134: {
                return "F23";
            }
            case 135: {
                return "F24";
            }
            case 144: {
                return "NUM_LOCK";
            }
            case 145: {
                return "SCROLL_LOCK";
            }
            case 160: {
                return "LSHIFT";
            }
            case 161: {
                return "RSHIFT";
            }
            case 162: {
                return "LCTRL";
            }
            case 163: {
                return "RCTRL";
            }
            case 164: {
                return "LALT";
            }
            case 165: {
                return "RALT";
            }
            case 186: {
                return "SEMICOLON";
            }
            case 187: {
                return "EQUAL";
            }
            case 188: {
                return "COMMA";
            }
            case 189: {
                return "MINUS";
            }
            case 190: {
                return "PERIOD";
            }
            case 191: {
                return "SLASH";
            }
            case 192: {
                return "GRAVE";
            }
            case 219: {
                return "LBRACKET";
            }
            case 220: {
                return "BACKSLASH";
            }
            case 221: {
                return "RBRACKET";
            }
            case 222: 
        }
        return "APOSTROPHE";
    }

    protected static boolean readPropertyAsBoolean(MappedTextDecoder source, String key, boolean defaultValue) {
        if (source == null) {
            throw new NullPointerException("DeviceSettings.readPropertyAsBoolean: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 source \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (key == null) {
            throw new NullPointerException("DeviceSettings.readPropertyAsBoolean: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 key \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        String value = source.get(key);
        return "false".equalsIgnoreCase(value) ? false : ("true".equalsIgnoreCase(value) ? true : defaultValue);
    }

    protected static double readPropertyAsDouble(MappedTextDecoder source, String key, double defaultValue) {
        double result;
        if (source == null) {
            throw new NullPointerException("DeviceSettings.readPropertyAsDouble: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 source \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (key == null) {
            throw new NullPointerException("DeviceSettings.readPropertyAsDouble: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 key \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        try {
            String value = source.get(key);
            result = value == null ? defaultValue : Double.parseDouble(value);
        }
        catch (NumberFormatException numberFormatException) {
            result = defaultValue;
        }
        return result;
    }

    protected static int readPropertyAsInt(MappedTextDecoder source, String key, int defaultValue) {
        int result;
        if (source == null) {
            throw new NullPointerException("DeviceSettings.readPropertyAsInt: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 source \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (key == null) {
            throw new NullPointerException("DeviceSettings.readPropertyAsInt: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 key \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        try {
            String value = source.get(key);
            result = value == null ? defaultValue : (value.regionMatches(true, 0, "0x", 0, 2) ? Integer.parseInt(value.substring(2), 16) : (value.regionMatches(true, 0, "+0x", 0, 3) ? Integer.parseInt(value.substring(3), 16) : (value.regionMatches(true, 0, "-0x", 0, 3) ? Integer.parseInt("-".concat(value.substring(3)), 16) : Integer.parseInt(value, 10))));
        }
        catch (NumberFormatException numberFormatException) {
            result = defaultValue;
        }
        return result;
    }

    protected static int readPropertyAsKey(MappedTextDecoder source, String key, int defaultKey) {
        if (source == null) {
            throw new NullPointerException("DeviceSettings.readPropertyAsKey: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 source \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (key == null) {
            throw new NullPointerException("DeviceSettings.readPropertyAsKey: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 key \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        int result = DeviceSettings.stringToKey(source.get(key));
        return result == 0 ? defaultKey : result;
    }

    protected static long readPropertyAsLong(MappedTextDecoder source, String key, long defaultValue) {
        long result;
        if (source == null) {
            throw new NullPointerException("DeviceSettings.readPropertyAsLong: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 source \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (key == null) {
            throw new NullPointerException("DeviceSettings.readPropertyAsLong: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 key \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        try {
            String value = source.get(key);
            result = value == null ? defaultValue : (value.regionMatches(true, 0, "0x", 0, 2) ? Long.parseLong(value.substring(2), 16) : (value.regionMatches(true, 0, "+0x", 0, 3) ? Long.parseLong(value.substring(3), 16) : (value.regionMatches(true, 0, "-0x", 0, 3) ? Long.parseLong("-".concat(value.substring(3)), 16) : Long.parseLong(value, 10))));
        }
        catch (NumberFormatException numberFormatException) {
            result = defaultValue;
        }
        return result;
    }

    protected static String readPropertyAsString(MappedTextDecoder source, String key, String defaultValue) {
        if (source == null) {
            throw new NullPointerException("DeviceSettings.readPropertyAsString: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 source \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (key == null) {
            throw new NullPointerException("DeviceSettings.readPropertyAsString: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 key \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        String value = source.get(key);
        return value == null ? defaultValue : value;
    }

    protected static SystemFont readPropertyAsRasterFont(MappedTextDecoder source, String key, SystemFont defaultFont) {
        if (source == null) {
            throw new NullPointerException("DeviceSettings.readPropertyAsRasterFont: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 source \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (key == null) {
            throw new NullPointerException("DeviceSettings.readPropertyAsRasterFont: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 key \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        String value = source.get(key);
        return value == null ? defaultFont : SystemFont.get((String)value);
    }

    public void setKeyUsedAs(int deviceKey, int key) {
        switch (deviceKey) {
            case 49: {
                this.keyUsedAs1 = key;
                break;
            }
            case 50: {
                this.keyUsedAs2 = key;
                break;
            }
            case 51: {
                this.keyUsedAs3 = key;
                break;
            }
            case 52: {
                this.keyUsedAs4 = key;
                break;
            }
            case 53: {
                this.keyUsedAs5 = key;
                break;
            }
            case 54: {
                this.keyUsedAs6 = key;
                break;
            }
            case 55: {
                this.keyUsedAs7 = key;
                break;
            }
            case 56: {
                this.keyUsedAs8 = key;
                break;
            }
            case 57: {
                this.keyUsedAs9 = key;
                break;
            }
            case 42: {
                this.keyUsedAsStar = key;
                break;
            }
            case 48: {
                this.keyUsedAs0 = key;
                break;
            }
            case 35: {
                this.keyUsedAsPound = key;
                break;
            }
            case 38: {
                this.keyUsedAsUp = key;
                break;
            }
            case 36: {
                this.keyUsedAsDown = key;
                break;
            }
            case 40: {
                this.keyUsedAsLeft = key;
                break;
            }
            case 41: {
                this.keyUsedAsRight = key;
                break;
            }
            case 43: {
                this.keyUsedAsSelect = key;
                break;
            }
            case 37: {
                this.keyUsedAsSoft1 = key;
                break;
            }
            case 39: {
                this.keyUsedAsSoft2 = key;
                break;
            }
            case 44: {
                this.keyUsedAsConsole = key;
                break;
            }
            case 46: {
                this.keyUsedAsExitApp = key;
                break;
            }
            default: {
                throw new IllegalArgumentException("DeviceSettings.setKeyUsedAs: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 deviceKey \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
            }
        }
    }

    public void setKeyCodeFor(int deviceKey, int keyCode) {
        switch (deviceKey) {
            case 38: {
                this.keyCodeForUp = keyCode;
                break;
            }
            case 36: {
                this.keyCodeForDown = keyCode;
                break;
            }
            case 40: {
                this.keyCodeForLeft = keyCode;
                break;
            }
            case 41: {
                this.keyCodeForRight = keyCode;
                break;
            }
            case 43: {
                this.keyCodeForSelect = keyCode;
                break;
            }
            case 37: {
                this.keyCodeForSoft1 = keyCode;
                break;
            }
            case 39: {
                this.keyCodeForSoft2 = keyCode;
                break;
            }
            case 35: 
            case 42: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                throw new IllegalStateException("DeviceSettings.setKeyCodeFor: \u0434\u043b\u044f \u0446\u0438\u0444\u0440\u043e\u0432\u044b\u0445 \u043a\u043d\u043e\u043f\u043e\u043a, \u0437\u0432\u0451\u0437\u0434\u043e\u0447\u043a\u0438 \u0438 \u0440\u0435\u0448\u0451\u0442\u043a\u0438 \u043d\u0435\u043b\u044c\u0437\u044f \u0438\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u043a\u043e\u0434 \u043a\u043b\u0430\u0432\u0438\u0448\u0438.");
            }
            case 44: 
            case 46: {
                throw new IllegalStateException("DeviceSettings.setKeyCodeFor: \u0434\u043b\u044f \u0441\u0438\u0441\u0442\u0435\u043c\u043d\u044b\u0445 \u043a\u043d\u043e\u043f\u043e\u043a \u043d\u0435\u043b\u044c\u0437\u044f \u0438\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u043a\u043e\u0434 \u043a\u043b\u0430\u0432\u0438\u0448\u0438.");
            }
            default: {
                throw new IllegalArgumentException("DeviceSettings.setKeyCodeFor: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 deviceKey \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
            }
        }
    }

    public void setFont(int style, int size, SystemFont font) {
        if (style < 0 || style > 3) {
            throw new IllegalArgumentException("DeviceSettings.setFont: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 style \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
        }
        if (size < 0 || size > 2) {
            throw new IllegalArgumentException("DeviceSettings.setFont: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 size \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
        }
        this.fonts[size << 2 | style] = font;
    }

    public void setUserSetting(String settingName, Object settingValue) {
        throw new IllegalArgumentException(new StringBuilder().append("DeviceSettings.setUserSetting: \u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u0430\u044f \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0430 ").append(settingName).append('.').toString());
    }

    public int keyCodeToGameAction(int keyCode) {
        if (keyCode == this.keyCodeForUp) {
            return 1;
        }
        if (keyCode == this.keyCodeForDown) {
            return 6;
        }
        if (keyCode == this.keyCodeForLeft) {
            return 2;
        }
        if (keyCode == this.keyCodeForRight) {
            return 5;
        }
        if (keyCode == this.keyCodeForSelect) {
            return 8;
        }
        if (keyCode == this.keyCodeForSoft1) {
            return 0;
        }
        if (keyCode == this.keyCodeForSoft2) {
            return 0;
        }
        switch (keyCode) {
            case 49: {
                return 9;
            }
            case 50: {
                return 1;
            }
            case 51: {
                return 10;
            }
            case 52: {
                return 2;
            }
            case 53: {
                return 8;
            }
            case 54: {
                return 5;
            }
            case 55: {
                return 11;
            }
            case 56: {
                return 6;
            }
            case 57: {
                return 12;
            }
            case 35: 
            case 42: 
            case 48: {
                return 0;
            }
        }
        throw new IllegalArgumentException(new StringBuilder().append("DeviceSettings.keyCodeToGameAction: \u043d\u0435\u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u044e\u0449\u0438\u0439 \u043a\u043e\u0434 \u043a\u043b\u0430\u0432\u0438\u0448\u0438 ").append(keyCode).append('.').toString());
    }

    public int gameActionToKeyCode(int gameAction) {
        switch (gameAction) {
            case 1: {
                return 50;
            }
            case 6: {
                return 56;
            }
            case 2: {
                return 52;
            }
            case 5: {
                return 54;
            }
            case 8: {
                return 53;
            }
            case 9: {
                return 49;
            }
            case 10: {
                return 51;
            }
            case 11: {
                return 55;
            }
            case 12: {
                return 57;
            }
        }
        throw new IllegalArgumentException(new StringBuilder().append("DeviceSettings.gameActionToKeyCode: \u043d\u0435\u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u044e\u0449\u0435\u0435 \u0438\u0433\u0440\u043e\u0432\u043e\u0435 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0435 ").append(gameAction).append('.').toString());
    }

    public int getKeyUsedAs(int deviceKey) {
        switch (deviceKey) {
            case 49: {
                return this.keyUsedAs1;
            }
            case 50: {
                return this.keyUsedAs2;
            }
            case 51: {
                return this.keyUsedAs3;
            }
            case 52: {
                return this.keyUsedAs4;
            }
            case 53: {
                return this.keyUsedAs5;
            }
            case 54: {
                return this.keyUsedAs6;
            }
            case 55: {
                return this.keyUsedAs7;
            }
            case 56: {
                return this.keyUsedAs8;
            }
            case 57: {
                return this.keyUsedAs9;
            }
            case 42: {
                return this.keyUsedAsStar;
            }
            case 48: {
                return this.keyUsedAs0;
            }
            case 35: {
                return this.keyUsedAsPound;
            }
            case 38: {
                return this.keyUsedAsUp;
            }
            case 36: {
                return this.keyUsedAsDown;
            }
            case 40: {
                return this.keyUsedAsLeft;
            }
            case 41: {
                return this.keyUsedAsRight;
            }
            case 43: {
                return this.keyUsedAsSelect;
            }
            case 37: {
                return this.keyUsedAsSoft1;
            }
            case 39: {
                return this.keyUsedAsSoft2;
            }
            case 44: {
                return this.keyUsedAsConsole;
            }
            case 46: {
                return this.keyUsedAsExitApp;
            }
        }
        throw new IllegalArgumentException("DeviceSettings.getKeyUsedAs: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 deviceKey \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
    }

    public int getKeyCodeFor(int deviceKey) {
        switch (deviceKey) {
            case 35: 
            case 42: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                return deviceKey;
            }
            case 38: {
                return this.keyCodeForUp;
            }
            case 36: {
                return this.keyCodeForDown;
            }
            case 40: {
                return this.keyCodeForLeft;
            }
            case 41: {
                return this.keyCodeForRight;
            }
            case 43: {
                return this.keyCodeForSelect;
            }
            case 37: {
                return this.keyCodeForSoft1;
            }
            case 39: {
                return this.keyCodeForSoft2;
            }
            case 44: 
            case 46: {
                throw new IllegalStateException("DeviceSettings.getKeyCodeFor: \u0434\u043b\u044f \u0441\u0438\u0441\u0442\u0435\u043c\u043d\u044b\u0445 \u043a\u043d\u043e\u043f\u043e\u043a \u043d\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442 \u043a\u043e\u0434 \u043a\u043b\u0430\u0432\u0438\u0448\u0438.");
            }
        }
        throw new IllegalArgumentException("DeviceSettings.getKeyCodeFor: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 deviceKey \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
    }

    public int getKeyCode(int key) {
        if (key == this.keyUsedAs1) {
            return 49;
        }
        if (key == this.keyUsedAs2) {
            return 50;
        }
        if (key == this.keyUsedAs3) {
            return 51;
        }
        if (key == this.keyUsedAs4) {
            return 52;
        }
        if (key == this.keyUsedAs5) {
            return 53;
        }
        if (key == this.keyUsedAs6) {
            return 54;
        }
        if (key == this.keyUsedAs7) {
            return 55;
        }
        if (key == this.keyUsedAs8) {
            return 56;
        }
        if (key == this.keyUsedAs9) {
            return 57;
        }
        if (key == this.keyUsedAsStar) {
            return 42;
        }
        if (key == this.keyUsedAs0) {
            return 48;
        }
        if (key == this.keyUsedAsPound) {
            return 35;
        }
        if (key == this.keyUsedAsUp) {
            return this.keyCodeForUp;
        }
        if (key == this.keyUsedAsDown) {
            return this.keyCodeForDown;
        }
        if (key == this.keyUsedAsLeft) {
            return this.keyCodeForLeft;
        }
        if (key == this.keyUsedAsRight) {
            return this.keyCodeForRight;
        }
        if (key == this.keyUsedAsSelect) {
            return this.keyCodeForSelect;
        }
        if (key == this.keyUsedAsSoft1) {
            return this.keyCodeForSoft1;
        }
        if (key == this.keyUsedAsSoft2) {
            return this.keyCodeForSoft2;
        }
        return 0;
    }

    public String getKeyName(int keyCode) {
        if (keyCode == this.keyCodeForUp) {
            return "\u2191";
        }
        if (keyCode == this.keyCodeForDown) {
            return "\u2193";
        }
        if (keyCode == this.keyCodeForLeft) {
            return "\u2190";
        }
        if (keyCode == this.keyCodeForRight) {
            return "\u2192";
        }
        if (keyCode == this.keyCodeForSelect) {
            return "\u0426\u0435\u043d\u0442\u0440\u0430\u043b\u044c\u043d\u0430\u044f \u043a\u043b\u0430\u0432\u0438\u0448\u0430 \u0432\u044b\u0431\u043e\u0440\u0430";
        }
        if (keyCode == this.keyCodeForSoft1) {
            return "\u041b\u0435\u0432\u0430\u044f \u043a\u043b\u0430\u0432\u0438\u0448\u0430 \u0432\u044b\u0431\u043e\u0440\u0430";
        }
        if (keyCode == this.keyCodeForSoft2) {
            return "\u041f\u0440\u0430\u0432\u0430\u044f \u043a\u043b\u0430\u0432\u0438\u0448\u0430 \u0432\u044b\u0431\u043e\u0440\u0430";
        }
        switch (keyCode) {
            case 49: {
                return "1";
            }
            case 50: {
                return "2";
            }
            case 51: {
                return "3";
            }
            case 52: {
                return "4";
            }
            case 53: {
                return "5";
            }
            case 54: {
                return "6";
            }
            case 55: {
                return "7";
            }
            case 56: {
                return "8";
            }
            case 57: {
                return "9";
            }
            case 42: {
                return "*";
            }
            case 48: {
                return "0";
            }
            case 35: {
                return "#";
            }
        }
        throw new IllegalArgumentException(new StringBuilder().append("DeviceSettings.getKeyName: \u043d\u0435\u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u044e\u0449\u0438\u0439 \u043a\u043e\u0434 \u043a\u043b\u0430\u0432\u0438\u0448\u0438 ").append(keyCode).append('.').toString());
    }

    public SystemFont getFont(int style, int size) {
        if (style < 0 || style > 3) {
            throw new IllegalArgumentException("DeviceSettings.getFont: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 style \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
        }
        if (size < 0 || size > 2) {
            throw new IllegalArgumentException("DeviceSettings.getFont: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 size \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
        }
        return this.fonts[size << 2 | style];
    }

    public Object getUserSetting(String settingName) {
        throw new IllegalArgumentException(new StringBuilder().append("DeviceSettings.getUserSetting: \u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u0430\u044f \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0430 ").append(settingName).append('.').toString());
    }

    public final void loadMIDletDescriptor() {
        try {
            InputStream stream = CloudFileSystem.instance.openFileForRead(MIDLET_DESCRIPTOR);
            try {
                this.midletDescriptor.loadFromInputStream(stream);
            }
            finally {
                stream.close();
            }
        }
        catch (IOException e) {
            System.err.println("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u0434\u0435\u0441\u043a\u0440\u0438\u043f\u0442\u043e\u0440 \u043c\u0438\u0434\u043b\u0435\u0442\u0430 \u0438\u0437 /res/META-INF/MANIFEST.MF. \u041f\u043e\u0434\u0440\u043e\u0431\u043d\u043e\u0441\u0442\u0438 \u0441\u043b\u0435\u0434\u0443\u044e\u0442 \u043d\u0438\u0436\u0435.");
            e.printRealStackTrace();
        }
    }

    public final void loadMIDletDescriptor(InputStream stream) {
        if (stream == null) {
            throw new NullPointerException("DeviceSettings.loadMIDletDescriptor: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 stream \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        try {
            this.midletDescriptor.loadFromInputStream(stream);
        }
        catch (IOException e) {
            System.err.println(new StringBuilder().append("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u0434\u0435\u0441\u043a\u0440\u0438\u043f\u0442\u043e\u0440 \u043c\u0438\u0434\u043b\u0435\u0442\u0430 \u0438\u0437 ").append(stream instanceof HandleInputStream ? ((HandleInputStream)stream).getFileName() : stream.getClass().getCanonicalName()).append(". \u041f\u043e\u0434\u0440\u043e\u0431\u043d\u043e\u0441\u0442\u0438 \u0441\u043b\u0435\u0434\u0443\u044e\u0442 \u043d\u0438\u0436\u0435.").toString());
            e.printRealStackTrace();
        }
    }

    public final void loadMIDletProperties() {
        MappedTextDecoder source = this.midletProperties;
        try {
            InputStream stream = CloudFileSystem.instance.openFileForRead(MIDLET_PROPERTIES);
            try {
                source.loadFromInputStream(stream);
            }
            finally {
                stream.close();
            }
            this.loadFrom(source);
        }
        catch (IOException e) {
            System.err.println("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u043c\u0438\u0434\u043b\u0435\u0442\u0430 \u0438\u0437 /midlet.properties. \u0418\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u044b \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e. \u041f\u043e\u0434\u0440\u043e\u0431\u043d\u043e\u0441\u0442\u0438 \u0441\u043b\u0435\u0434\u0443\u044e\u0442 \u043d\u0438\u0436\u0435.");
            e.printRealStackTrace();
            this.loadDefaults();
        }
    }

    public final void loadMIDletProperties(InputStream stream) {
        if (stream == null) {
            throw new NullPointerException("DeviceSettings.loadMIDletProperties: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 stream \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        try {
            MappedTextDecoder source = this.midletProperties;
            source.loadFromInputStream(stream);
            this.loadFrom(source);
        }
        catch (IOException e) {
            System.err.println(new StringBuilder().append("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u043c\u0438\u0434\u043b\u0435\u0442\u0430 \u0438\u0437 ").append(stream instanceof HandleInputStream ? ((HandleInputStream)stream).getFileName() : stream.getClass().getCanonicalName()).append(". \u0418\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u044b \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e. \u041f\u043e\u0434\u0440\u043e\u0431\u043d\u043e\u0441\u0442\u0438 \u0441\u043b\u0435\u0434\u0443\u044e\u0442 \u043d\u0438\u0436\u0435.").toString());
            e.printRealStackTrace();
            this.loadDefaults();
        }
    }

    public final void loadMIDletProperties(MappedTextDecoder source) {
        if (source == null) {
            throw new NullPointerException("DeviceSettings.loadMIDletProperties: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 source \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        this.loadFrom(source);
    }

    public final void saveMIDletProperties() {
        PrintStream printer = new PrintStream((OutputStream)new FileOutputStream(MIDLET_PROPERTIES));
        try {
            this.saveTo(printer);
        }
        finally {
            printer.close();
        }
    }

    public final void saveMIDletProperties(OutputStream stream) {
        if (stream == null) {
            throw new NullPointerException("DeviceSettings.saveMIDletProperties: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 stream \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        this.saveTo(stream instanceof PrintStream ? (PrintStream)stream : new PrintStream(stream));
    }

    public final void saveMIDletProperties(PrintStream printer) {
        if (printer == null) {
            throw new NullPointerException("DeviceSettings.saveMIDletProperties: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 printer \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        this.saveTo(printer);
    }

    public final void setEnableStackTrace(boolean enableStackTrace) {
        ThrowableStackTrace.enable((boolean)enableStackTrace);
    }

    public final void setKeyRepeatedEvent(boolean keyRepeatedEvent) {
        this.keyRepeatedEvent = keyRepeatedEvent;
    }

    public final void setMaximumFrequency(int maximumFrequency) {
        if (maximumFrequency < 1) {
            maximumFrequency = 1;
        }
        if (maximumFrequency > 99) {
            maximumFrequency = 99;
        }
        this.maximumFrequency = maximumFrequency;
        this.minimumPeriod = 1000 / maximumFrequency + (1000 % maximumFrequency > 0 ? 1 : 0);
    }

    public final boolean isEnableStackTrace() {
        return ThrowableStackTrace.enabled();
    }

    public final boolean isKeyRepeatedEvent() {
        return this.keyRepeatedEvent;
    }

    public final int getMaximumFrequency() {
        return this.maximumFrequency;
    }

    public final int getMinimumPeriod() {
        return this.minimumPeriod;
    }

    public final String[] getMIDletAttributes(String key) {
        return this.midletDescriptor.getAttributes(key);
    }

    public final String getMIDletProperty(String key) {
        return this.midletDescriptor.get(key);
    }

    protected void defaultMIDletProperties() {
    }

    protected void readMIDletProperties(MappedTextDecoder source) {
    }

    protected void writeMIDletProperties(PrintStream printer) {
    }

    private void loadDefaults() {
        Object[] f = this.fonts;
        Array.fill((Object[])this.fonts, (int)0, (int)f.length, (Object)SystemFont.getDefault());
        this.setEnableStackTrace(true);
        this.setKeyRepeatedEvent(true);
        this.setMaximumFrequency(25);
        this.keyUsedAs1 = 103;
        this.keyUsedAs2 = 104;
        this.keyUsedAs3 = 105;
        this.keyUsedAs4 = 100;
        this.keyUsedAs5 = 101;
        this.keyUsedAs6 = 102;
        this.keyUsedAs7 = 97;
        this.keyUsedAs8 = 98;
        this.keyUsedAs9 = 99;
        this.keyUsedAsStar = 106;
        this.keyUsedAs0 = 96;
        this.keyUsedAsPound = 111;
        this.keyUsedAsUp = 38;
        this.keyUsedAsDown = 40;
        this.keyUsedAsLeft = 37;
        this.keyUsedAsRight = 39;
        this.keyUsedAsSelect = 13;
        this.keyUsedAsSoft1 = 112;
        this.keyUsedAsSoft2 = 113;
        this.keyUsedAsConsole = 114;
        this.keyUsedAsExitApp = 115;
        this.keyCodeForUp = -1;
        this.keyCodeForDown = -2;
        this.keyCodeForLeft = -3;
        this.keyCodeForRight = -4;
        this.keyCodeForSelect = -5;
        this.keyCodeForSoft1 = -6;
        this.keyCodeForSoft2 = -7;
        this.defaultMIDletProperties();
    }

    private void loadFrom(MappedTextDecoder source) {
        SystemFont[] f = this.fonts;
        SystemFont d = SystemFont.getDefault();
        int i = f.length;
        while (i-- > 0) {
            f[i] = DeviceSettings.readPropertyAsRasterFont(source, FONT_KEYS[i], d);
        }
        this.setEnableStackTrace(DeviceSettings.readPropertyAsBoolean(source, "system.ENABLE_STACK_TRACE", true));
        this.setKeyRepeatedEvent(DeviceSettings.readPropertyAsBoolean(source, "system.KEY_REPEATED_EVENT", true));
        this.setMaximumFrequency(DeviceSettings.readPropertyAsInt(source, "system.MAXIMUM_FREQUENCY", 25));
        this.keyUsedAs1 = DeviceSettings.readPropertyAsKey(source, "key.1", 103);
        this.keyUsedAs2 = DeviceSettings.readPropertyAsKey(source, "key.2", 104);
        this.keyUsedAs3 = DeviceSettings.readPropertyAsKey(source, "key.3", 105);
        this.keyUsedAs4 = DeviceSettings.readPropertyAsKey(source, "key.4", 100);
        this.keyUsedAs5 = DeviceSettings.readPropertyAsKey(source, "key.5", 101);
        this.keyUsedAs6 = DeviceSettings.readPropertyAsKey(source, "key.6", 102);
        this.keyUsedAs7 = DeviceSettings.readPropertyAsKey(source, "key.7", 97);
        this.keyUsedAs8 = DeviceSettings.readPropertyAsKey(source, "key.8", 98);
        this.keyUsedAs9 = DeviceSettings.readPropertyAsKey(source, "key.9", 99);
        this.keyUsedAsStar = DeviceSettings.readPropertyAsKey(source, "key.ASTERISK", 106);
        this.keyUsedAs0 = DeviceSettings.readPropertyAsKey(source, "key.0", 96);
        this.keyUsedAsPound = DeviceSettings.readPropertyAsKey(source, "key.POUND", 111);
        this.keyUsedAsUp = DeviceSettings.readPropertyAsKey(source, "key.UP", 38);
        this.keyUsedAsDown = DeviceSettings.readPropertyAsKey(source, "key.DOWN", 40);
        this.keyUsedAsLeft = DeviceSettings.readPropertyAsKey(source, "key.LEFT", 37);
        this.keyUsedAsRight = DeviceSettings.readPropertyAsKey(source, "key.RIGHT", 39);
        this.keyUsedAsSelect = DeviceSettings.readPropertyAsKey(source, "key.SELECT", 13);
        this.keyUsedAsSoft1 = DeviceSettings.readPropertyAsKey(source, "key.SOFT1", 112);
        this.keyUsedAsSoft2 = DeviceSettings.readPropertyAsKey(source, "key.SOFT2", 113);
        this.keyUsedAsConsole = DeviceSettings.readPropertyAsKey(source, "key.CONSOLE", 114);
        this.keyUsedAsExitApp = DeviceSettings.readPropertyAsKey(source, "key.EXITAPP", 115);
        this.keyCodeForUp = DeviceSettings.readPropertyAsInt(source, "key.code.UP", -1);
        this.keyCodeForDown = DeviceSettings.readPropertyAsInt(source, "key.code.DOWN", -2);
        this.keyCodeForLeft = DeviceSettings.readPropertyAsInt(source, "key.code.LEFT", -3);
        this.keyCodeForRight = DeviceSettings.readPropertyAsInt(source, "key.code.RIGHT", -4);
        this.keyCodeForSelect = DeviceSettings.readPropertyAsInt(source, "key.code.SELECT", -5);
        this.keyCodeForSoft1 = DeviceSettings.readPropertyAsInt(source, "key.code.SOFT1", -6);
        this.keyCodeForSoft2 = DeviceSettings.readPropertyAsInt(source, "key.code.SOFT2", -7);
        this.readMIDletProperties(source);
    }

    private void saveTo(PrintStream printer) {
        printer.println();
        printer.println("# \u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u043c\u0438\u0434\u043b\u0435\u0442\u0430 (\u043c\u043e\u0436\u043d\u043e \u043c\u0435\u043d\u044f\u0442\u044c, \u043d\u0435 \u0437\u0430\u043f\u0443\u0441\u043a\u0430\u044f \u0441\u0430\u043c \u043c\u0438\u0434\u043b\u0435\u0442)");
        printer.println("# \u042d\u0442\u043e\u0442 \u0444\u0430\u0439\u043b \u043f\u0435\u0440\u0435\u0437\u0430\u043f\u0438\u0441\u044b\u0432\u0430\u0435\u0442\u0441\u044f \u043a\u0430\u0436\u0434\u044b\u0439 \u0440\u0430\u0437, \u043a\u043e\u0433\u0434\u0430 \u0432\u044b \u0441\u043e\u0445\u0440\u0430\u043d\u044f\u0435\u0442\u0435");
        printer.println("# \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438, \u043f\u043e\u044d\u0442\u043e\u043c\u0443 \u041d\u0415 \u0434\u043e\u043f\u0438\u0441\u044b\u0432\u0430\u0439\u0442\u0435 \u0432 \u043d\u0435\u0433\u043e \u043a\u0430\u043a\u0443\u044e-\u043b\u0438\u0431\u043e \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044e.");
        printer.println();
        printer.println("system.ENABLE_STACK_TRACE = ".concat(this.isEnableStackTrace() ? "true" : "false"));
        printer.println("system.KEY_REPEATED_EVENT = ".concat(this.isKeyRepeatedEvent() ? "true" : "false"));
        printer.println("system.MAXIMUM_FREQUENCY = ".concat(Integer.toString(this.getMaximumFrequency())));
        printer.println();
        printer.println("key.1 = ".concat(DeviceSettings.keyToString(this.keyUsedAs1)));
        printer.println("key.2 = ".concat(DeviceSettings.keyToString(this.keyUsedAs2)));
        printer.println("key.3 = ".concat(DeviceSettings.keyToString(this.keyUsedAs3)));
        printer.println("key.4 = ".concat(DeviceSettings.keyToString(this.keyUsedAs4)));
        printer.println("key.5 = ".concat(DeviceSettings.keyToString(this.keyUsedAs5)));
        printer.println("key.6 = ".concat(DeviceSettings.keyToString(this.keyUsedAs6)));
        printer.println("key.7 = ".concat(DeviceSettings.keyToString(this.keyUsedAs7)));
        printer.println("key.8 = ".concat(DeviceSettings.keyToString(this.keyUsedAs8)));
        printer.println("key.9 = ".concat(DeviceSettings.keyToString(this.keyUsedAs9)));
        printer.println("key.ASTERISK = ".concat(DeviceSettings.keyToString(this.keyUsedAsStar)));
        printer.println("key.0 = ".concat(DeviceSettings.keyToString(this.keyUsedAs0)));
        printer.println("key.POUND = ".concat(DeviceSettings.keyToString(this.keyUsedAsPound)));
        printer.println("key.UP = ".concat(DeviceSettings.keyToString(this.keyUsedAsUp)));
        printer.println("key.DOWN = ".concat(DeviceSettings.keyToString(this.keyUsedAsDown)));
        printer.println("key.LEFT = ".concat(DeviceSettings.keyToString(this.keyUsedAsLeft)));
        printer.println("key.RIGHT = ".concat(DeviceSettings.keyToString(this.keyUsedAsRight)));
        printer.println("key.SELECT = ".concat(DeviceSettings.keyToString(this.keyUsedAsSelect)));
        printer.println("key.SOFT1 = ".concat(DeviceSettings.keyToString(this.keyUsedAsSoft1)));
        printer.println("key.SOFT2 = ".concat(DeviceSettings.keyToString(this.keyUsedAsSoft2)));
        printer.println("key.CONSOLE = ".concat(DeviceSettings.keyToString(this.keyUsedAsConsole)));
        printer.println("key.EXITAPP = ".concat(DeviceSettings.keyToString(this.keyUsedAsExitApp)));
        printer.println();
        printer.println("key.code.UP = ".concat(Integer.toString(this.keyCodeForUp)));
        printer.println("key.code.DOWN = ".concat(Integer.toString(this.keyCodeForDown)));
        printer.println("key.code.LEFT = ".concat(Integer.toString(this.keyCodeForLeft)));
        printer.println("key.code.RIGHT = ".concat(Integer.toString(this.keyCodeForRight)));
        printer.println("key.code.SELECT = ".concat(Integer.toString(this.keyCodeForSelect)));
        printer.println("key.code.SOFT1 = ".concat(Integer.toString(this.keyCodeForSoft1)));
        printer.println("key.code.SOFT2 = ".concat(Integer.toString(this.keyCodeForSoft2)));
        printer.println();
        SystemFont[] f = this.fonts;
        SystemFont def = SystemFont.getDefault();
        StringBuilder b = new StringBuilder();
        int len = f.length;
        int i = 0;
        while (i < len) {
            SystemFont cur = f[i];
            printer.println(b.append(FONT_KEYS[i]).append(" = ").append((cur == null ? def : cur).getName()).toString());
            b.clear();
            ++i;
        }
        printer.println();
        printer.println("# \u0414\u0430\u043b\u0435\u0435 \u0438\u0434\u0443\u0442 \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438, \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0451\u043d\u043d\u044b\u0435 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0435\u043c");
        printer.println();
        this.writeMIDletProperties(printer);
    }
}

