/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;

public abstract class Writer {
    private static final int WRITE_BUFFER_SIZE = 1024;
    protected Object lock;
    private char[] writeBuffer;

    protected Writer() {
        this.lock = this;
    }

    protected Writer(Object lock) {
        if (lock == null) {
            throw new NullPointerException("Writer: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 lock \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        this.lock = lock;
    }

    public abstract void close() throws IOException;

    public abstract void flush() throws IOException;

    public abstract void write(char[] var1, int var2, int var3) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(int src) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            char[] c = this.writeBuffer;
            if (this.writeBuffer == null) {
                this.writeBuffer = c = new char[1024];
            }
            c[0] = (char)src;
            this.write(c, 0, 1);
        }
    }

    public void write(char[] src) throws IOException {
        if (src == null) {
            throw new NullPointerException("Writer.write: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 src \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        this.write(src, 0, src.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String src) throws IOException {
        if (src == null) {
            throw new NullPointerException("Writer.write: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 src \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        Object object = this.lock;
        synchronized (object) {
            char[] cArray;
            int length = src.length();
            if (length <= 1024) {
                char[] c = this.writeBuffer;
                if (this.writeBuffer == null) {
                    this.writeBuffer = new char[1024];
                    cArray = this.writeBuffer;
                } else {
                    cArray = c;
                }
            } else {
                cArray = new char[length];
            }
            char[] cbuf = cArray;
            src.getChars(0, length, cArray, 0);
            this.write(cbuf, 0, length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String src, int offset, int length) throws IOException {
        if (src == null) {
            throw new NullPointerException("Writer.write: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 src \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        int lim = offset + length;
        int len = src.length();
        if (lim > len || lim < offset || offset > len || offset < 0) {
            throw new StringIndexOutOfBoundsException("Writer.write: \u0438\u043d\u0434\u0435\u043a\u0441 \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        Object object = this.lock;
        synchronized (object) {
            char[] cArray;
            if (length <= 1024) {
                char[] c = this.writeBuffer;
                if (this.writeBuffer == null) {
                    this.writeBuffer = new char[1024];
                    cArray = this.writeBuffer;
                } else {
                    cArray = c;
                }
            } else {
                cArray = new char[length];
            }
            char[] cbuf = cArray;
            src.getChars(offset, lim, cArray, 0);
            this.write(cbuf, 0, length);
        }
    }
}

