/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.application;

import java.util.Hashtable;
import java.util.QueueOfObjects;
import malik.emulator.application.AppProxy;
import malik.emulator.application.AppProxyNotFoundException;
import malik.emulator.application.ImmediatelyRunnable;
import malik.emulator.application.InterruptHandlerForKeyboard;
import malik.emulator.application.InterruptHandlerForPlayerMIDI;
import malik.emulator.application.InterruptHandlerForPlayerPCM;
import malik.emulator.application.InterruptHandlerForPointer;
import malik.emulator.application.InterruptHandlerForWindowResize;
import malik.emulator.application.InterruptHandlerForWindowShowHide;
import malik.emulator.application.PlayerMIDIEndTrackHandler;
import malik.emulator.application.PlayerPCMLoadBlockHandler;
import malik.emulator.application.QueueOfMalikAppEvents;
import malik.emulator.application.StretchDrawDescriptor;
import malik.emulator.application.StringDrawDescriptor;
import malik.emulator.application.ThreadTerminationHandler;
import malik.emulator.application.ThreadTerminationRecord;
import malik.emulator.util.ThreadTerminationListener;
import malik.emulator.util.ThreadTerminationListenerCollection;
import malik.emulator.util.ThrowableStackTrace;

public final class Run
implements ThreadTerminationListener {
    static final int EVENT_APP_LAUNCH = 0;
    static final int EVENT_APP_TERMINATE = 1;
    static final int EVENT_KEY_PRESSED = 4;
    static final int EVENT_KEY_RELEASED = 6;
    static final int EVENT_POINTER_PRESSED = 8;
    static final int EVENT_POINTER_DRAGGED = 9;
    static final int EVENT_POINTER_RELEASED = 10;
    static final int EVENT_WINDOW_RESIZE = 12;
    static final int EVENT_WINDOW_SHOW = 13;
    static final int EVENT_WINDOW_HIDE = 14;
    private static final Run INSTANCE = new Run();
    private boolean terminated = false;
    private boolean[] keyPressed = new boolean[256];
    private String errorMessage = "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u044f";
    private Hashtable playerHandlers = new Hashtable();
    private QueueOfObjects threadTerminations = new QueueOfObjects();
    private QueueOfMalikAppEvents mainEvents = new QueueOfMalikAppEvents();
    private StretchDrawDescriptor stretchDescriptor = new StretchDrawDescriptor();
    private StringDrawDescriptor stringDescriptor = new StringDrawDescriptor();
    private ThreadTerminationListener threadProxy;
    private AppProxy eventsProxy;

    public static Run getInstance() {
        return INSTANCE;
    }

    static void main() {
        ThreadTerminationListenerCollection.instance.addListener(new ThreadTerminationHandler(INSTANCE));
        INSTANCE.execute();
    }

    private static AppProxy getStartAppProxyInstance() throws AppProxyNotFoundException {
        AppProxy result;
        String className = System.getSystemProperty("malik.emulator.application.run.proxy.class");
        try {
            result = (AppProxy)Class.forName(className).newInstance();
        }
        catch (NullPointerException nullPointerException) {
            throw new AppProxyNotFoundException("\u041e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0432\u0430\u0436\u043d\u043e\u0435 \u0441\u0438\u0441\u0442\u0435\u043c\u043d\u043e\u0435 \u0441\u0432\u043e\u0439\u0441\u0442\u0432\u043e: malik.emulator.application.run.proxy.class. \u041f\u0440\u043e\u0432\u0435\u0440\u044c\u0442\u0435 \u0444\u0430\u0439\u043b config.properties \u0438 \u0438\u0441\u0445\u043e\u0434\u043d\u044b\u0439 \u043a\u043e\u0434 \u0441\u0438\u0441\u0442\u0435\u043c\u043d\u044b\u0445 \u0431\u0438\u0431\u043b\u0438\u043e\u0442\u0435\u043a.");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new AppProxyNotFoundException("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043d\u0430\u0439\u0442\u0438 \u043a\u043b\u0430\u0441\u0441 \u0434\u043b\u044f \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438 \u0441\u043e\u0431\u044b\u0442\u0438\u0439: " + className + ".");
        }
        catch (InstantiationException instantiationException) {
            throw new AppProxyNotFoundException("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u043e\u0437\u0434\u0430\u0442\u044c \u0438\u043d\u0441\u0442\u0430\u043d\u0446\u0438\u044e \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a\u0430 \u0441\u043e\u0431\u044b\u0442\u0438\u0439 " + className + ".");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AppProxyNotFoundException("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0434\u043e\u0441\u0442\u0443\u043f \u043a \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a\u0443 \u0441\u043e\u0431\u044b\u0442\u0438\u0439 " + className + ".");
        }
        catch (ClassCastException classCastException) {
            throw new AppProxyNotFoundException("\u041d\u0435\u043f\u043e\u0434\u0445\u043e\u0434\u044f\u0449\u0438\u0439 \u043a\u043b\u0430\u0441\u0441 \u0434\u043b\u044f \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438 \u0441\u043e\u0431\u044b\u0442\u0438\u0439: " + className + ".");
        }
        return result;
    }

    private Run() {
    }

    public void threadTerminated(Thread terminatedThread, Throwable exitThrowable) {
        if (exitThrowable == null) {
            return;
        }
        this.showMessage(this.errorMessage);
        exitThrowable.printRealStackTrace();
        this.terminate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void serviceImmediately(Object argument) {
        QueueOfMalikAppEvents events = this.mainEvents;
        boolean[] monitor = this.keyPressed;
        while (true) {
            boolean[] blArray = monitor;
            // MONITORENTER : monitor
            Runnable event = events.findImmediatelyRunnable(argument);
            // MONITOREXIT : blArray
            if (event == null) {
                return;
            }
            try {
                event.run();
            }
            catch (RuntimeException e) {
                e.printRealStackTrace();
                continue;
            }
            break;
        }
    }

    public void setPlayerPCMLoadBlockHandler(int playerPCMHandle, PlayerPCMLoadBlockHandler handler) {
        Integer key = new Integer(playerPCMHandle);
        if (handler == null) {
            this.playerHandlers.remove(key);
            return;
        }
        this.playerHandlers.put(key, handler);
    }

    public void setPlayerMIDIEndTrackHandler(int playerMIDIHandle, PlayerMIDIEndTrackHandler handler) {
        Integer key = new Integer(playerMIDIHandle);
        if (handler == null) {
            this.playerHandlers.remove(key);
            return;
        }
        this.playerHandlers.put(key, handler);
    }

    public void setThreadProxy(ThreadTerminationListener threadProxy) {
        this.threadProxy = threadProxy;
    }

    public void setEventsProxy(AppProxy eventsProxy) {
        this.eventsProxy = eventsProxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEvent(Runnable event) {
        if (event == null) {
            return;
        }
        boolean[] monitor = this.keyPressed;
        boolean[] blArray = this.keyPressed;
        synchronized (blArray) {
            this.mainEvents.push(-1L, event);
            monitor.notify();
        }
    }

    public void showMessage(String message) {
        if (message == null) {
            throw new NullPointerException("Run.showMessage: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 message \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        int fontHandle = (int)MalikSystem.syscall(0L, 40);
        int i = (int)MalikSystem.syscall((long)fontHandle, 42);
        int fontHeight = i >> 8 & 0xFF;
        int fontBaseline = i >> 16 & 0xFF;
        int bkcolor = -1073741824;
        StretchDrawDescriptor s = this.stretchDescriptor;
        StringDrawDescriptor t = this.stringDescriptor;
        MalikSystem.syscall((long)t.getDescriptorAddress() << 32, 34);
        int top = 865 * (t.sizes >>> 16) >> 10;
        int left = 0;
        int width = t.sizes & 0xFFFF;
        int height = fontHeight;
        s.dstBase = t.base;
        s.dstScan = t.scan;
        s.dstSizes = t.sizes;
        s.dstAlpha = 0;
        s.origins = top << 16 | left & 0xFFFF;
        s.sizes = height << 16 | width & 0xFFFF;
        s.srcBase = MalikSystem.getLocalVariableAddress(bkcolor);
        s.srcScan = 1;
        s.srcSizes = 65537;
        s.srcAlpha = 1;
        s.transform = 0;
        MalikSystem.syscall((long)s.getDescriptorAddress(), 39);
        t.alpha = 0;
        t.handle = fontHandle;
        t.style = Integer.MIN_VALUE;
        t.color = -1;
        t.length = message.length();
        t.chars = Array.getFirstElementAddress(message);
        int textWidth = (int)MalikSystem.syscall((long)t.getDescriptorAddress(), 44);
        int x = width - textWidth >> 1;
        int y = top + fontHeight - fontBaseline;
        t.coords = y << 16 | x & 0xFFFF;
        MalikSystem.syscall((long)t.getDescriptorAddress(), 45);
        MalikSystem.syscall(0L, 32);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() {
        boolean[] monitor = this.keyPressed;
        boolean[] blArray = this.keyPressed;
        synchronized (blArray) {
            this.terminated = true;
            this.mainEvents.push(0x1000000000000000L, null);
            monitor.notify();
        }
    }

    public boolean terminated() {
        return this.terminated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public Runnable[] getImmediatelyServices(Object argument) {
        int len = 0;
        Object[] result = new ImmediatelyRunnable[15];
        QueueOfMalikAppEvents events = this.mainEvents;
        boolean[] monitor = this.keyPressed;
        while (true) {
            boolean[] blArray = monitor;
            // MONITORENTER : monitor
            Runnable event = events.findImmediatelyRunnable(argument);
            // MONITOREXIT : blArray
            if (event == null) {
                if (len >= result.length) return result;
                Object[] objectArray = result;
                result = new ImmediatelyRunnable[len];
                Array.copy(objectArray, 0, result, 0, len);
                return result;
            }
            if (len == result.length) {
                Object[] objectArray = result;
                result = new ImmediatelyRunnable[(len << 1) + 1];
                Array.copy(objectArray, 0, result, 0, len);
            }
            result[len++] = event;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setEvent(long event) {
        boolean[] monitor = this.keyPressed;
        boolean[] blArray = this.keyPressed;
        synchronized (blArray) {
            this.mainEvents.push(event, null);
            monitor.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setEvent(Thread terminatedThread, Throwable exitThrowable) {
        boolean[] monitor = this.keyPressed;
        boolean[] blArray = this.keyPressed;
        synchronized (blArray) {
            this.threadTerminations.push(new ThreadTerminationRecord(this, terminatedThread, exitThrowable));
            monitor.notify();
        }
    }

    void handlePlayerPCMLoadBlock(int playerPCMHandle, int blockIndex) {
        ((PlayerPCMLoadBlockHandler)this.playerHandlers.get(new Integer(playerPCMHandle))).loadPCMBlock(playerPCMHandle, blockIndex);
    }

    void handlePlayerMIDILoadBlock(int playerMIDIHandle) {
        ((PlayerMIDIEndTrackHandler)this.playerHandlers.get(new Integer(playerMIDIHandle))).endMIDITrack(playerMIDIHandle);
    }

    private void execute() {
        Throwable exitThrowable;
        try {
            ThrowableStackTrace.enable(true);
            this.showMessage("\u041f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430, \u043f\u043e\u0434\u043e\u0436\u0434\u0438\u0442\u0435\u2026");
            this.findAppProxy();
            this.registerInterruptHandlers();
            this.lifecycle();
            exitThrowable = null;
        }
        catch (Throwable t) {
            exitThrowable = t;
        }
        MalikInterrupt.disable();
        try {
            ThreadTerminationListener listener = this.threadProxy;
            (listener != null ? listener : this).threadTerminated(Thread.currentThread(), exitThrowable);
        }
        catch (Throwable throwable) {}
        System.out.close();
        System.err.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void lifecycle() {
        QueueOfObjects queueOfTerminations = this.threadTerminations;
        QueueOfMalikAppEvents queueOfEvents = this.mainEvents;
        boolean[] monitor = this.keyPressed;
        while (true) {
            this.waitEvent();
            try {
                boolean[] blArray;
                if (!queueOfTerminations.isEmpty()) {
                    blArray = monitor;
                    // MONITORENTER : monitor
                    ThreadTerminationRecord eventTermination = (ThreadTerminationRecord)queueOfTerminations.peek();
                    queueOfTerminations.removeTailElement();
                    // MONITOREXIT : blArray
                    eventTermination.invokeListener(this.threadProxy);
                    continue;
                }
                if (queueOfEvents.isEmpty()) continue;
                blArray = monitor;
                // MONITORENTER : monitor
                Runnable eventFromApp = queueOfEvents.peekEventFromApp();
                long eventFromUser = queueOfEvents.peekEventFromUser();
                queueOfEvents.removeTailElement();
                // MONITOREXIT : blArray
                if (eventFromApp == null) {
                    if (!this.handleEventMustTerminated(eventFromUser)) continue;
                    return;
                }
                eventFromApp.run();
            }
            catch (RuntimeException e) {
                e.printRealStackTrace();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitEvent() {
        boolean[] monitor = this.keyPressed;
        boolean[] blArray = this.keyPressed;
        synchronized (blArray) {
            while (true) {
                try {
                    monitor.wait();
                }
                catch (InterruptedException e) {
                    e.printRealStackTrace();
                    continue;
                }
                break;
            }
        }
    }

    private void findAppProxy() throws AppProxyNotFoundException {
        this.eventsProxy = Run.getStartAppProxyInstance();
        this.setEvent(0L);
    }

    private void registerInterruptHandlers() {
        MalikInterrupt.register(16, new InterruptHandlerForKeyboard(this));
        MalikInterrupt.register(17, new InterruptHandlerForPointer(this));
        MalikInterrupt.register(18, new InterruptHandlerForWindowShowHide(this));
        MalikInterrupt.register(19, new InterruptHandlerForWindowResize(this));
        MalikInterrupt.register(30, new InterruptHandlerForPlayerPCM(this));
        MalikInterrupt.register(31, new InterruptHandlerForPlayerMIDI(this));
        Runtime.getRuntime().startInterruptHandling();
    }

    private boolean handleEventMustTerminated(long event) {
        int e = (int)(event >>> 60);
        AppProxy p = this.eventsProxy;
        if (p == null) {
            return e == 1;
        }
        switch (e) {
            default: {
                return false;
            }
            case 0: {
                p.appLaunch();
                return false;
            }
            case 1: {
                p.appTerminate();
                return true;
            }
            case 4: {
                boolean[] k = this.keyPressed;
                int i = (int)event;
                if (!this.keyPressed[i]) {
                    k[i] = true;
                    p.keyPressed(i, (int)(event >> 32) & 0xFFFFFF);
                    return false;
                }
                p.keyRepeated(i, (int)(event >> 32) & 0xFFFFFF);
                return false;
            }
            case 6: {
                int i = (int)event;
                this.keyPressed[i] = false;
                p.keyReleased(i);
                return false;
            }
            case 8: {
                p.pointerPressed((short)event, (int)event >> 16, (int)(event >> 32) & 7);
                return false;
            }
            case 9: {
                p.pointerDragged((short)event, (int)event >> 16);
                return false;
            }
            case 10: {
                p.pointerReleased((short)event, (int)event >> 16, (int)(event >> 32) & 7);
                return false;
            }
            case 12: {
                p.windowResize((short)event, (int)event >> 16);
                return false;
            }
            case 13: {
                p.windowShow();
                return false;
            }
            case 14: 
        }
        p.windowHide();
        return false;
    }
}

