/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.i18n;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import malik.emulator.i18n.Codec;
import malik.emulator.i18n.StreamReader;
import malik.emulator.i18n.StreamWriter;
import malik.emulator.i18n.encoding.system.UTF_8_Codec;
import malik.emulator.i18n.encoding.system.UTF_8_Reader;
import malik.emulator.i18n.encoding.system.UTF_8_Writer;

public final class Helper {
    private static final String ENCODING_INTERNAL_NAME_UTF_8 = "system.UTF_8";
    private static final String ENCODING_INTERNAL_NAME_ISO8859_1 = "ISO8859_1";
    private static final String ENCODING_INTERNAL_NAME_ISO8859_5 = "ISO8859_5";
    private static final Codec SYSTEM_CODEC = new UTF_8_Codec();

    public static char[] byteToCharArray(byte[] src, int offset, int length) {
        return SYSTEM_CODEC.decode(src, offset, length);
    }

    public static char[] byteToCharArray(byte[] src, int offset, int length, String encoding) throws UnsupportedEncodingException {
        return Helper.getCodec(encoding).decode(src, offset, length);
    }

    public static byte[] charToByteArray(char[] src, int offset, int length) {
        return SYSTEM_CODEC.encode(src, offset, length);
    }

    public static byte[] charToByteArray(char[] src, int offset, int length, String encoding) throws UnsupportedEncodingException {
        return Helper.getCodec(encoding).encode(src, offset, length);
    }

    public static Reader getStreamReader(InputStream stream) {
        return new UTF_8_Reader().open(stream);
    }

    public static Reader getStreamReader(InputStream stream, String encoding) throws UnsupportedEncodingException {
        return Helper.getReader(encoding).open(stream);
    }

    public static Writer getStreamWriter(OutputStream stream) {
        return new UTF_8_Writer().open(stream);
    }

    public static Writer getStreamWriter(OutputStream stream, String encoding) throws UnsupportedEncodingException {
        return Helper.getWriter(encoding).open(stream);
    }

    private static char normalizeEncodingChar(char c) {
        return c == '-' || c == ':' || c == ' ' ? (char)'_' : Character.toUpperCase(c);
    }

    private static String normalizeEncodingName(String encoding) {
        char c;
        if (encoding == null || encoding.length() == 0) {
            encoding = "UTF_8";
        }
        String val = encoding.trim();
        int len = val.length();
        int i = 0;
        while (i < len && (c = val.charAt(i)) == Helper.normalizeEncodingChar(c)) {
            ++i;
        }
        if (i < len) {
            char[] buf = val.toCharArray();
            while (i < len) {
                buf[i] = Helper.normalizeEncodingChar(buf[i]);
                ++i;
            }
            return new String(buf);
        }
        return val;
    }

    private static String getInternalName(String encoding) {
        String result = Helper.normalizeEncodingName(encoding);
        if ("US_ASCII".equals(result) || "ISO_8859_1".equals(result) || "CP1252".equals(result) || "CP_1252".equals(result) || "WINDOWS_1252".equals(result)) {
            return ENCODING_INTERNAL_NAME_ISO8859_1;
        }
        if ("ISO_8859_5".equals(result)) {
            return ENCODING_INTERNAL_NAME_ISO8859_5;
        }
        if ("UTF8".equals(result) || "UTF_8".equals(result)) {
            return ENCODING_INTERNAL_NAME_UTF_8;
        }
        if (result.startsWith("CP_")) {
            return "CP".concat(result.substring(3));
        }
        if (result.startsWith("WINDOWS_")) {
            return "CP".concat(result.substring(8));
        }
        if (result.startsWith("WINDOWS")) {
            return "CP".concat(result.substring(7));
        }
        String prop = System.getSystemProperty(result.concat("_InternalEncodingName"));
        return prop != null ? prop : result;
    }

    private static Codec getCodec(String encoding) throws UnsupportedEncodingException {
        Codec result;
        encoding = Helper.getInternalName(encoding);
        String className = "malik.emulator.i18n.encoding." + encoding + "_Codec";
        try {
            result = (Codec)Class.forName(className).newInstance();
        }
        catch (Exception exception) {
            throw new UnsupportedEncodingException("\u041a\u043e\u0434\u0438\u0440\u043e\u0432\u043a\u0430 " + encoding + " \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f.");
        }
        return result;
    }

    private static StreamReader getReader(String encoding) throws UnsupportedEncodingException {
        StreamReader result;
        encoding = Helper.getInternalName(encoding);
        String className = "malik.emulator.i18n.encoding." + encoding + "_Reader";
        try {
            result = (StreamReader)Class.forName(className).newInstance();
        }
        catch (Exception exception) {
            throw new UnsupportedEncodingException("\u041a\u043e\u0434\u0438\u0440\u043e\u0432\u043a\u0430 " + encoding + " \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f.");
        }
        return result;
    }

    private static StreamWriter getWriter(String encoding) throws UnsupportedEncodingException {
        StreamWriter result;
        encoding = Helper.getInternalName(encoding);
        String className = "malik.emulator.i18n.encoding." + encoding + "_Writer";
        try {
            result = (StreamWriter)Class.forName(className).newInstance();
        }
        catch (Exception exception) {
            throw new UnsupportedEncodingException("\u041a\u043e\u0434\u0438\u0440\u043e\u0432\u043a\u0430 " + encoding + " \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f.");
        }
        return result;
    }

    private Helper() {
    }
}

