/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.i18n.encoding.system;

import java.io.IOException;
import java.io.OutputStream;
import malik.emulator.i18n.StreamWriter;

public class UTF_8_Writer
extends StreamWriter {
    public void write(char[] src, int offset, int length) throws IOException {
        byte[] output = new byte[3];
        OutputStream stream = this.ensureOpen();
        int i = 0;
        while (i < length) {
            int outputSize;
            char inputChar;
            if ((inputChar = src[offset++]) > '\u0000' && inputChar < '\u0080') {
                output[0] = (byte)inputChar;
                outputSize = 1;
            } else if (inputChar < '\u0800') {
                output[0] = (byte)(0xC0 | inputChar >> 6 & 0x1F);
                output[1] = (byte)(0x80 | inputChar & 0x3F);
                outputSize = 2;
            } else {
                output[0] = (byte)(0xE0 | inputChar >> 12 & 0xF);
                output[1] = (byte)(0x80 | inputChar >> 6 & 0x3F);
                output[2] = (byte)(0x80 | inputChar & 0x3F);
                outputSize = 3;
            }
            stream.write(output, 0, outputSize);
            ++i;
        }
    }

    public int sizeOf(char[] src, int offset, int length) {
        int result = 0;
        while (offset < length) {
            char inputChar;
            result += (inputChar = src[offset++]) > '\u0000' && inputChar < '\u0080' ? 1 : (inputChar < '\u0800' ? 2 : 3);
        }
        return result;
    }
}

