/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.io.cloud;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import malik.emulator.io.cloud.AttributesDescriptor;
import malik.emulator.io.cloud.CloudFileEnumerator;
import malik.emulator.io.cloud.FileInfoDescriptor;
import malik.emulator.io.cloud.FileInputStream;
import malik.emulator.io.cloud.FileOutputStream;
import malik.emulator.io.vfs.DirectoryNotExistsException;
import malik.emulator.io.vfs.FileAttributes;
import malik.emulator.io.vfs.FileEnumerator;
import malik.emulator.io.vfs.FileNotExistsException;
import malik.emulator.io.vfs.VirtualFileSystemReadOnly;
import malik.emulator.io.vfs.VirtualFileSystemReadWrite;
import malik.emulator.time.GregorianCalendar;

public final class CloudFileSystem
implements VirtualFileSystemReadOnly,
VirtualFileSystemReadWrite {
    private static final VirtualFileSystemReadWrite INSTANCE = new CloudFileSystem();

    public static VirtualFileSystemReadWrite getInstance() {
        return INSTANCE;
    }

    static long computeFields(long time) {
        return GregorianCalendar.computeFields(time, 0);
    }

    static long computeTime(long fields) {
        return GregorianCalendar.computeTime(fields, 0);
    }

    private CloudFileSystem() {
    }

    public String toString() {
        return "\u0424\u0430\u0439\u043b\u043e\u0432\u0430\u044f \u0441\u0438\u0441\u0442\u0435\u043c\u0430 \u0442\u0435\u043a\u0443\u0449\u0435\u0433\u043e \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u044f";
    }

    public void readAttributes(String fileName, FileAttributes attr) throws FileNotExistsException {
        if (fileName == null) {
            throw new NullPointerException("CloudFileSystem.readAttributes: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 fileName \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (attr == null) {
            throw new NullPointerException("CloudFileSystem.readAttributes: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 attr \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        int len = fileName.length();
        char[] fn = new char[len + 1];
        fileName.getChars(0, len, fn, 0);
        AttributesDescriptor descriptor = new AttributesDescriptor();
        if ((int)MalikSystem.syscall(Array.getFirstElementAddress(fn), descriptor.getDescriptorAddress(), 28) == 0) {
            throw new FileNotExistsException("CloudFileSystem.readAttributes: \u0444\u0430\u0439\u043b " + fileName + " \u043d\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442.");
        }
        attr.setAttributes(CloudFileSystem.computeTime(descriptor.creationTime), CloudFileSystem.computeTime(descriptor.lastAccessTime), CloudFileSystem.computeTime(descriptor.lastWriteTime), descriptor.attributes);
    }

    public int getFileNameMaxLength() {
        return (int)MalikSystem.syscall(0L, 22);
    }

    public FileEnumerator findFirst() {
        char[] cArray = new char[2];
        cArray[0] = 47;
        char[] directory = cArray;
        FileInfoDescriptor descriptor = new FileInfoDescriptor();
        char[] fileName = new char[this.getFileNameMaxLength() + 1];
        new FileInfoDescriptor().length = fileName.length;
        descriptor.chars = Array.getFirstElementAddress(fileName);
        return new CloudFileEnumerator((int)MalikSystem.syscall(Array.getFirstElementAddress(directory), descriptor.getDescriptorAddress(), 24), fileName, descriptor);
    }

    public FileEnumerator findFirst(String dirName) throws DirectoryNotExistsException {
        char[] directory;
        if (dirName == null) {
            throw new NullPointerException("CloudFileSystem.findFirst: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 dirName \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        int lim = dirName.length();
        if (lim > 0) {
            if (dirName.charAt(0) == '/') {
                if (dirName.charAt(lim - 1) == '/') {
                    directory = new char[lim + 1];
                    dirName.getChars(0, lim, directory, 0);
                } else {
                    directory = new char[lim + 2];
                    dirName.getChars(0, lim, directory, 0);
                    directory[lim] = 47;
                }
            } else {
                if (dirName.charAt(lim - 1) == '/') {
                    directory = new char[lim + 2];
                    dirName.getChars(0, lim, directory, 1);
                } else {
                    directory = new char[lim + 3];
                    dirName.getChars(0, lim, directory, 1);
                    directory[lim + 1] = 47;
                }
                directory[0] = 47;
            }
        } else {
            char[] cArray = new char[2];
            cArray[0] = 47;
            directory = cArray;
        }
        FileInfoDescriptor descriptor = new FileInfoDescriptor();
        char[] fileName = new char[this.getFileNameMaxLength() + 1];
        new FileInfoDescriptor().length = fileName.length;
        descriptor.chars = Array.getFirstElementAddress(fileName);
        int handle = (int)MalikSystem.syscall(Array.getFirstElementAddress(directory), descriptor.getDescriptorAddress(), 24);
        if (handle == 0) {
            throw new DirectoryNotExistsException("CloudFileSystem.findFirst: \u043f\u0430\u043f\u043a\u0430 " + dirName + " \u043d\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442.");
        }
        return handle > 0 ? new CloudFileEnumerator(handle, fileName, descriptor) : null;
    }

    public InputStream openFileForRead(String fileName) throws IOException {
        FileInputStream result = new FileInputStream(fileName);
        result.checkOpenError();
        return result;
    }

    public void writeAttributes(String fileName, FileAttributes attr) throws FileNotExistsException {
        if (fileName == null) {
            throw new NullPointerException("CloudFileSystem.writeAttributes: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 fileName \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (attr == null) {
            throw new NullPointerException("CloudFileSystem.writeAttributes: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 attr \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        int len = fileName.length();
        char[] fn = new char[len + 1];
        fileName.getChars(0, len, fn, 0);
        AttributesDescriptor descriptor = new AttributesDescriptor();
        new AttributesDescriptor().attributes = attr.getAttributes() & 0xFFFFFFEF;
        descriptor.creationTime = CloudFileSystem.computeFields(attr.getCreationTime());
        descriptor.lastAccessTime = CloudFileSystem.computeFields(attr.getLastAccessTime());
        descriptor.lastWriteTime = CloudFileSystem.computeFields(attr.getLastWriteTime());
        if ((int)MalikSystem.syscall(Array.getFirstElementAddress(fn), descriptor.getDescriptorAddress(), 29) == 0) {
            throw new FileNotExistsException("CloudFileSystem.writeAttributes: \u0444\u0430\u0439\u043b " + fileName + " \u0437\u0430\u043d\u044f\u0442 \u0438\u043b\u0438 \u043d\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442.");
        }
    }

    public void move(String oldFileName, String newFileName) throws IOException {
        if (oldFileName == null) {
            throw new NullPointerException("CloudFileSystem.move: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 oldFileName \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (newFileName == null) {
            throw new NullPointerException("CloudFileSystem.move: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 newFileName \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        int len = oldFileName.length();
        char[] ofn = new char[len + 1];
        oldFileName.getChars(0, len, ofn, 0);
        len = newFileName.length();
        char[] nfn = new char[len + 1];
        newFileName.getChars(0, len, nfn, 0);
        if ((int)MalikSystem.syscall(Array.getFirstElementAddress(ofn), Array.getFirstElementAddress(nfn), 27) == 0) {
            throw new IOException("CloudFileSystem.move: \u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u0435\u0440\u0435\u043c\u0435\u0441\u0442\u0438\u0442\u044c \u0444\u0430\u0439\u043b " + oldFileName + " \u043d\u0430 \u043d\u043e\u0432\u043e\u0435 \u043c\u0435\u0441\u0442\u043e " + newFileName + ".");
        }
    }

    public void deleteDirectory(String dirName) throws IOException {
        if (dirName == null) {
            throw new NullPointerException("CloudFileSystem.deleteDirectory: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 dirName \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        int len = dirName.length();
        char[] dn = new char[len + 1];
        dirName.getChars(0, len, dn, 0);
        if ((int)MalikSystem.syscall((long)Array.getFirstElementAddress(dn), 31) == 0) {
            throw new IOException("CloudFileSystem.deleteDirectory: \u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u043f\u0430\u043f\u043a\u0443 " + dirName + ".");
        }
    }

    public void deleteFile(String fileName) throws IOException {
        if (fileName == null) {
            throw new NullPointerException("CloudFileSystem.deleteFile: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 fileName \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        int len = fileName.length();
        char[] fn = new char[len + 1];
        fileName.getChars(0, len, fn, 0);
        if ((int)MalikSystem.syscall((long)Array.getFirstElementAddress(fn), 23) == 0) {
            throw new IOException("CloudFileSystem.deleteFile: \u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u0444\u0430\u0439\u043b " + fileName + ".");
        }
    }

    public void createDirectory(String dirName) throws IOException {
        if (dirName == null) {
            throw new NullPointerException("CloudFileSystem.createDirectory: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 dirName \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        int len = dirName.length();
        char[] dn = new char[len + 1];
        dirName.getChars(0, len, dn, 0);
        if ((int)MalikSystem.syscall((long)Array.getFirstElementAddress(dn), 30) == 0) {
            throw new IOException("CloudFileSystem.createDirectory: \u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u043e\u0437\u0434\u0430\u0442\u044c \u043f\u0430\u043f\u043a\u0443 " + dirName + ".");
        }
    }

    public OutputStream createFile(String fileName) throws IOException {
        FileOutputStream result = new FileOutputStream(fileName, false);
        result.checkOpenError();
        return result;
    }

    public OutputStream openFileForAppending(String fileName) throws IOException {
        FileOutputStream result = new FileOutputStream(fileName, true);
        result.checkOpenError();
        return result;
    }
}

