/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import javax.microedition.lcdui.Font;
import malik.emulator.microedition.lcdui.MultilinedStringBuilder;

public class Command {
    public static final int SCREEN = 1;
    public static final int BACK = 2;
    public static final int CANCEL = 3;
    public static final int OK = 4;
    public static final int HELP = 5;
    public static final int STOP = 6;
    public static final int EXIT = 7;
    public static final int ITEM = 8;
    static final Object MONITOR = new Object();
    final int type;
    final int priority;
    private int truncatedWidth;
    private Font truncatedFont;
    private String truncatedLabel;
    private final String longLabel;
    private final String label;

    public Command(String label, int type, int priority) {
        this(label, null, type, priority);
    }

    public Command(String label, String longLabel, int type, int priority) {
        if (label == null) {
            throw new NullPointerException("Command: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 label \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (type < 1 || type > 8) {
            throw new IllegalArgumentException("Command: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 type \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
        }
        this.type = type;
        this.priority = priority;
        this.longLabel = longLabel;
        this.label = label;
    }

    public int getCommandType() {
        return this.type;
    }

    public int getPriority() {
        return this.priority;
    }

    public String getLabel() {
        return this.label;
    }

    public String getLongLabel() {
        return this.longLabel;
    }

    public final String getTruncatedLabel(int width, Font font) {
        String result;
        if (font == this.truncatedFont && width == this.truncatedWidth) {
            return this.truncatedLabel;
        }
        this.truncatedFont = font;
        this.truncatedWidth = width;
        this.truncatedLabel = result = MultilinedStringBuilder.truncate(this.label, font, width);
        return result;
    }

    static interface Enumeration {
        public int size();

        public Command commandAt(int var1);

        public Command defaultCommand();
    }

    static interface Owner
    extends Enumeration {
        public boolean isMyOwnedCommand(Command var1);
    }
}

