/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import java.util.Date;
import java.util.TimeZone;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.FocusItem;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.InteractiveItem;
import javax.microedition.lcdui.Screen;
import malik.emulator.application.KeyboardEvent;
import malik.emulator.application.PointerEvent;
import malik.emulator.media.graphics.RasterCanvas;
import malik.emulator.microedition.lcdui.StringList;
import malik.emulator.time.CalendarSystem;

public class DateField
extends InteractiveItem {
    public static final int DATE = 1;
    public static final int TIME = 2;
    public static final int DATE_TIME = 3;
    private static final int FIELD_YEAR = 0x20FFFF;
    private static final int FIELD_MONTH = 1573119;
    private static final int FIELD_DAY = 0x1000FF;
    private static final int FIELD_HOUR = 524543;
    private static final int FIELD_MINUTE = 255;
    private static final int OFFSET_ZERO_INDEX;
    private static final int[] OFFSET_VALUE;
    static final String[] OFFSET_NAMES;
    static final String[] DAY_NAMES;
    static final Command SELECT;
    static final Command BACK;
    static final Font FONT;
    private boolean needPlaceComponents;
    private int mode;
    private int width;
    private int height;
    private int current;
    private int focused;
    private int pressed;
    private int ofsindex;
    private long fieldset;
    private final Component[] components;
    private final StringList timeZoneList;
    private final Object monitor;

    static {
        String[] offsetNames = new String[]{"UTC-12:00", "UTC-11:00", "UTC-10:00", "UTC-09:30", "UTC-09:00", "UTC-08:30", "UTC-08:00", "UTC-07:00", "UTC-06:00", "UTC-05:00", "UTC-04:30", "UTC-04:00", "UTC-03:30", "UTC-03:00", "UTC-02:30", "UTC-02:00", "UTC-01:00", "UTC-00:44", "UTC-00:25", "UTC+00:00", "UTC+00:20", "UTC+00:30", "UTC+01:00", "UTC+02:00", "UTC+03:00", "UTC+03:30", "UTC+04:00", "UTC+04:30", "UTC+04:51", "UTC+05:00", "UTC+05:30", "UTC+05:40", "UTC+05:45", "UTC+06:00", "UTC+06:30", "UTC+07:00", "UTC+07:20", "UTC+07:30", "UTC+08:00", "UTC+08:30", "UTC+08:45", "UTC+09:00", "UTC+09:30", "UTC+10:00", "UTC+10:30", "UTC+11:00", "UTC+11:30", "UTC+12:00", "UTC+12:45", "UTC+13:00", "UTC+13:45", "UTC+14:00"};
        int zeroOffsetIndex = -1;
        int len = offsetNames.length;
        int[] offsetValue = new int[len];
        int i = len;
        while (i-- > 0) {
            String s = offsetNames[i];
            if (s == null || s.length() < 9) continue;
            int offset = (s.charAt(4) - 48) * 36000000 + (s.charAt(5) - 48) * 3600000 + (s.charAt(7) - 48) * 600000 + (s.charAt(8) - 48) * 60000;
            if (s.charAt(3) == '-') {
                offset = -offset;
            }
            if (offset == 0 && zeroOffsetIndex < 0) {
                zeroOffsetIndex = i;
            }
            offsetValue[i] = offset;
        }
        OFFSET_ZERO_INDEX = zeroOffsetIndex;
        OFFSET_VALUE = offsetValue;
        OFFSET_NAMES = offsetNames;
        DAY_NAMES = new String[]{"\u043f\u043d", "\u0432\u0442", "\u0441\u0440", "\u0447\u0442", "\u043f\u0442", "\u0441\u0431", "\u0432\u0441"};
        SELECT = new Command("\u0412\u044b\u0431\u0440\u0430\u0442\u044c", 4, Integer.MIN_VALUE);
        BACK = new Command("\u041d\u0430\u0437\u0430\u0434", 2, 0);
        FONT = Font.getFont(0, 0, 8);
    }

    private static void setLeft(Component[] list, int offset, int length, int startLeft) {
        int lim = offset + length;
        int i = offset;
        while (i < lim) {
            Component cmp = list[i];
            list[i].left = startLeft;
            startLeft += cmp.width;
            ++i;
        }
    }

    private static void setTop(Component[] list, int offset, int length, int rowHeight, int baseTop) {
        int i = offset + length;
        while (i-- > offset) {
            Component cmp = list[i];
            list[i].top = baseTop + (rowHeight - cmp.height >> 1);
        }
    }

    private static int indexOf(int offset) {
        int[] offsetValue = OFFSET_VALUE;
        int i = OFFSET_VALUE.length;
        while (i-- > 0) {
            if (offsetValue[i] != offset) continue;
            return i;
        }
        return OFFSET_ZERO_INDEX;
    }

    private static int getOffset(int index) {
        return OFFSET_VALUE[index];
    }

    private static int getWidth(Component[] list, int offset, int length) {
        int result = 0;
        int i = offset + length;
        while (i-- > offset) {
            result += list[i].width;
        }
        return result;
    }

    private static int getHeight(Component[] list, int offset, int length) {
        int result = 0;
        int i = offset + length;
        while (i-- > offset) {
            int height = list[i].height;
            if (result >= height) continue;
            result = height;
        }
        return result;
    }

    private static int getField(long fieldset, int field) {
        return (int)(fieldset >> (field >> 16)) & field & 0xFFFF;
    }

    private static long setField(long fieldset, int field, int value) {
        int shift = field >> 16;
        int mask = field & 0xFFFF;
        return fieldset & ((long)mask << shift ^ 0xFFFFFFFFFFFFFFFFL) | ((long)value & (long)mask) << shift;
    }

    public DateField(String label, int mode) {
        this(label, mode, null);
    }

    public DateField(String label, int mode, TimeZone zone) {
        super(label);
        if (mode < 1 || mode > 3) {
            throw new IllegalArgumentException("DateField: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 mode \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
        }
        int index = DateField.indexOf((zone == null ? TimeZone.getDefault() : zone).getRawOffset());
        CalendarSystem system = CalendarSystem.gregorian;
        long fields = system.computeFields(System.currentTimeMillis(), DateField.getOffset(index));
        long fieldset = DateField.setField(0L, 0x20FFFF, system.getYear(fields));
        fieldset = DateField.setField(fieldset, 1573119, system.getMonth(fields));
        fieldset = DateField.setField(fieldset, 0x1000FF, system.getDay(fields));
        fieldset = DateField.setField(fieldset, 524543, system.getHour(fields));
        fieldset = DateField.setField(fieldset, 255, system.getMinute(fields));
        Component[] componentArray = new Component[9];
        DateField dateField = this;
        dateField.getClass();
        componentArray[0] = new TextNumericComponent(dateField, 1573119, 1, new String[]{"\u042f\u043d\u0432\u0430\u0440\u044c\u2195", "\u0424\u0435\u0432\u0440\u0430\u043b\u044c\u2195", "\u041c\u0430\u0440\u0442\u2195", "\u0410\u043f\u0440\u0435\u043b\u044c\u2195", "\u041c\u0430\u0439\u2195", "\u0418\u044e\u043d\u044c\u2195", "\u0418\u044e\u043b\u044c\u2195", "\u0410\u0432\u0433\u0443\u0441\u0442\u2195", "\u0421\u0435\u043d\u0442\u044f\u0431\u0440\u044c\u2195", "\u041e\u043a\u0442\u044f\u0431\u0440\u044c\u2195", "\u041d\u043e\u044f\u0431\u0440\u044c\u2195", "\u0414\u0435\u043a\u0430\u0431\u0440\u044c\u2195"});
        DateField dateField2 = this;
        dateField2.getClass();
        componentArray[1] = dateField2.new StringComponent(" ", FONT);
        DateField dateField3 = this;
        dateField3.getClass();
        componentArray[2] = new NumericComponent(dateField3, 0x20FFFF, 1, 65535);
        componentArray[3] = new DaySelectComponent(this);
        DateField dateField4 = this;
        dateField4.getClass();
        componentArray[4] = new NumericComponent(dateField4, 524543, 0, 23);
        DateField dateField5 = this;
        dateField5.getClass();
        componentArray[5] = dateField5.new StringComponent(" : ", FONT);
        DateField dateField6 = this;
        dateField6.getClass();
        componentArray[6] = new NumericComponent(dateField6, 255, 0, 59);
        DateField dateField7 = this;
        dateField7.getClass();
        componentArray[7] = dateField7.new StringComponent(" ", FONT);
        componentArray[8] = new TimeZoneComponent();
        Component[] list = componentArray;
        StringList timeZoneList = new StringList(null, null, OFFSET_NAMES);
        timeZoneList.setCommandListener(new CommandListener(){

            public void commandAction(Command command, Displayable screen) {
                Display parent;
                if (command == SELECT) {
                    DateField.this.setOffsetIndex(((StringList)screen).getSelectedIndex());
                }
                if ((parent = screen.getParentDisplay()) != null) {
                    parent.hideSurfaceScreen();
                }
            }
        });
        timeZoneList.addCommand(SELECT);
        timeZoneList.addCommand(BACK);
        this.needPlaceComponents = true;
        this.mode = mode;
        this.focused = -1;
        this.pressed = -1;
        this.ofsindex = index;
        this.fieldset = fieldset;
        this.components = list;
        this.timeZoneList = timeZoneList;
        this.monitor = list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInputMode(int mode) {
        if (mode < 1 || mode > 3) {
            throw new IllegalArgumentException("DateField.setInputMode: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 mode \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
        }
        boolean needed = false;
        Object object = this.monitor;
        synchronized (object) {
            this.mode = mode;
            if (this.mode != this.mode) {
                needed = true;
                this.needPlaceComponents = true;
            }
        }
        if (needed) {
            this.requestInvalidate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDate(Date date) {
        if (date == null) {
            return;
        }
        boolean needed = false;
        long time = date.getTime();
        Object object = this.monitor;
        synchronized (object) {
            CalendarSystem system = CalendarSystem.gregorian;
            long fields = system.computeFields(time, DateField.getOffset(this.ofsindex));
            long fieldset = DateField.setField(0L, 0x20FFFF, system.getYear(fields));
            fieldset = DateField.setField(fieldset, 1573119, system.getMonth(fields));
            fieldset = DateField.setField(fieldset, 0x1000FF, system.getDay(fields));
            fieldset = DateField.setField(fieldset, 524543, system.getHour(fields));
            this.fieldset = fieldset = DateField.setField(fieldset, 255, system.getMinute(fields));
            if (this.fieldset != this.fieldset) {
                needed = true;
            }
        }
        if (needed) {
            this.requestPaint();
        }
    }

    public int getInputMode() {
        return this.mode;
    }

    public Date getDate() {
        int index = this.ofsindex;
        long fieldset = this.fieldset;
        int year = DateField.getField(fieldset, 0x20FFFF);
        int month = DateField.getField(fieldset, 1573119);
        int day = DateField.getField(fieldset, 0x1000FF);
        int hour = DateField.getField(fieldset, 524543);
        int minute = DateField.getField(fieldset, 255);
        return new Date(CalendarSystem.gregorian.computeTime(year, month, day, hour, minute, 0, 0, DateField.getOffset(index)));
    }

    void paint(Graphics render, int contentWidth, int contentHeight) {
        int l = render.getClipX();
        int t = render.getClipY();
        int w = render.getClipWidth();
        int h = render.getClipHeight();
        int c = this.placeComponents();
        int p = this.pressed;
        long fieldset = this.fieldset;
        Component[] list = this.components;
        String ofs = OFFSET_NAMES[this.ofsindex];
        if (!((FocusItem)this).focused) {
            c = -1;
            p = -1;
        }
        int i = list.length;
        while (i-- > 0) {
            int ch;
            int cw;
            int ct;
            int cl;
            Component cmp = list[i];
            if (!cmp.visible || (cl = cmp.left) >= l + w || (ct = cmp.top) >= t + h || cl + (cw = cmp.width) <= l || ct + (ch = cmp.height) <= t) continue;
            render.translate(cl - render.getTranslateX(), ct - render.getTranslateY());
            cmp.paint(render, cw, ch, i == c, i == p, DateField.getField(fieldset, cmp.field), ofs);
        }
    }

    void onCommandAction(Command command) {
        if (command == SELECT) {
            this.components[this.current].selectEvent();
            return;
        }
        super.onCommandAction(command);
    }

    void onKeyboardEvent(KeyboardEvent event) {
        this.components[this.current].keyboardEvent(event);
    }

    void onPointerEvent(PointerEvent event) {
        Component[] list = this.components;
        block0 : switch (event.getAction()) {
            case 10: {
                int x = event.getX();
                int y = event.getY();
                int len = list.length;
                int i = 0;
                while (i < len) {
                    int ct;
                    int cl;
                    Component cmp = list[i];
                    if (cmp.visible && x >= (cl = cmp.left) && x < cl + cmp.width && y >= (ct = cmp.top) && y < ct + cmp.height && cmp.focusMove(0, this.current == i)) {
                        this.setCurrent(i);
                        this.focused = this.pressed = i;
                        event.translate(cl, ct);
                        cmp.pointerEvent(event);
                        this.requestPaint();
                        break block0;
                    }
                    ++i;
                }
                break;
            }
            case 11: {
                int f = this.focused;
                if (f < 0) break;
                Component cmp = list[f];
                this.pressed = -1;
                this.focused = -1;
                event.translate(cmp.left, cmp.top);
                cmp.pointerEvent(event);
                this.requestPaint();
                break;
            }
            default: {
                int f = this.focused;
                if (f < 0) break;
                Component cmp = list[f];
                int x = event.getX();
                int y = event.getY();
                int cl = cmp.left;
                int ct = cmp.top;
                event.translate(cl, ct);
                cmp.pointerEvent(event);
                this.pressed = x >= cl && x < cl + cmp.width && y >= ct && y < ct + cmp.height ? f : -1;
                if (this.pressed == this.pressed) break;
                this.requestPaint();
            }
        }
    }

    void onFocusLost() {
        this.focused = -1;
        this.pressed = -1;
        super.onFocusLost();
    }

    boolean onFocusMove(int direction, int viewportWidth, int viewportHeight, int[] visibleRectangle) {
        Component[] list = this.components;
        if (!super.onFocusMove(direction, viewportWidth, viewportHeight, visibleRectangle)) {
            Component cmp = null;
            block0 : switch (direction) {
                default: {
                    int len = list.length;
                    int i = 0;
                    while (i < len) {
                        cmp = list[i];
                        if (cmp.visible && cmp.focusMove(direction, false)) {
                            this.setCurrent(i);
                            break block0;
                        }
                        ++i;
                    }
                    break;
                }
                case 1: 
                case 2: {
                    int i = list.length;
                    while (i-- > 0) {
                        cmp = list[i];
                        if (!cmp.visible || !cmp.focusMove(direction, false)) continue;
                        this.setCurrent(i);
                        break block0;
                    }
                    break block0;
                }
            }
            cmp.writeRectangle(visibleRectangle);
            return true;
        }
        int c = this.current;
        Component cmp = list[c];
        if (cmp.focusMove(direction, true)) {
            cmp.writeRectangle(visibleRectangle);
            return true;
        }
        switch (direction) {
            case 5: 
            case 6: {
                int len = list.length;
                int i = c + 1;
                while (i < len) {
                    cmp = list[i];
                    if (cmp.visible && cmp.focusMove(direction, false)) {
                        this.setCurrent(i);
                        cmp.writeRectangle(visibleRectangle);
                        return true;
                    }
                    ++i;
                }
                break;
            }
            case 1: 
            case 2: {
                int i = c;
                while (i-- > 0) {
                    cmp = list[i];
                    if (!cmp.visible || !cmp.focusMove(direction, false)) continue;
                    this.setCurrent(i);
                    cmp.writeRectangle(visibleRectangle);
                    return true;
                }
                break;
            }
            default: {
                cmp.writeRectangle(visibleRectangle);
                return true;
            }
        }
        return false;
    }

    int getMinimumContentWidth() {
        this.placeComponents();
        return this.width;
    }

    int getMinimumContentHeight() {
        this.placeComponents();
        return this.height;
    }

    final void showTimeZoneList() {
        Display parent;
        Screen owner = this.owner;
        if (owner != null && (parent = owner.getParentDisplay()) != null) {
            StringList list = this.timeZoneList;
            list.setSelectedIndex(this.ofsindex);
            parent.setCurrent(list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void setOffsetIndex(int offsetIndex) {
        boolean needed;
        Object object = this.monitor;
        synchronized (object) {
            this.ofsindex = offsetIndex;
            needed = this.ofsindex != this.ofsindex;
        }
        if (needed) {
            super.notifyStateChanged();
            super.requestPaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void setFieldValue(int field, int value) {
        boolean needed;
        Object object = this.monitor;
        synchronized (object) {
            long fieldsetOld;
            long fieldsetNew = fieldsetOld = this.fieldset;
            if (field == 0x20FFFF) {
                int numberOfDays = CalendarSystem.gregorian.computeNumberOfDays(value, DateField.getField(fieldsetNew, 1573119));
                if (DateField.getField(fieldsetNew, 0x1000FF) > numberOfDays) {
                    fieldsetNew = DateField.setField(fieldsetNew, 0x1000FF, numberOfDays);
                }
            } else if (field == 1573119) {
                int numberOfDays = CalendarSystem.gregorian.computeNumberOfDays(DateField.getField(fieldsetNew, 0x20FFFF), value);
                if (DateField.getField(fieldsetNew, 0x1000FF) > numberOfDays) {
                    fieldsetNew = DateField.setField(fieldsetNew, 0x1000FF, numberOfDays);
                }
            }
            needed = fieldsetOld != (this.fieldset = (fieldsetNew = DateField.setField(fieldsetNew, field, value)));
        }
        if (needed) {
            super.notifyStateChanged();
            super.requestPaint();
        }
    }

    final int getOffsetIndex() {
        return this.ofsindex;
    }

    final int getFieldValue(int field) {
        return DateField.getField(this.fieldset, field);
    }

    private void setCurrent(int current) {
        this.current = current;
        super.removeCommand(SELECT);
        if (this.components[current].hasSelectCommand()) {
            super.setDefaultCommand(SELECT);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int placeComponents() {
        int itemWidth;
        int row3Height;
        int row3Width;
        boolean time;
        int row2Height;
        int row2Width;
        int row1Height;
        int row1Width;
        boolean needed;
        Object object = this.monitor;
        synchronized (object) {
            needed = this.needPlaceComponents;
            if (needed) {
                this.needPlaceComponents = false;
            }
        }
        if (!needed) {
            return this.current;
        }
        int mode = this.mode;
        Component[] list = this.components;
        int i = this.components.length;
        while (i-- > 0) {
            Component cmp = list[i];
            list[i].visible = (mode & (i < 4 ? 1 : 2)) != 0;
            if (!list[i].visible) continue;
            cmp.width = cmp.getWidth();
            cmp.height = cmp.getHeight();
        }
        boolean date = (mode & 1) != 0;
        if (date) {
            Component cmp = list[3];
            row1Width = DateField.getWidth(list, 0, 3);
            row1Height = DateField.getHeight(list, 0, 3);
            row2Width = cmp.width;
            row2Height = cmp.height;
        } else {
            row2Height = 0;
            row2Width = 0;
            row1Height = 0;
            row1Width = 0;
        }
        if (time = (mode & 2) != 0) {
            row3Width = DateField.getWidth(list, 4, 5);
            row3Height = DateField.getHeight(list, 4, 5);
        } else {
            row3Height = 0;
            row3Width = 0;
        }
        this.width = itemWidth = Math.max(Math.max(row1Width, row2Width), row3Width);
        this.height = row1Height + row2Height + row3Height;
        if (date) {
            DateField.setLeft(list, 0, 3, itemWidth - row1Width >> 1);
            DateField.setLeft(list, 3, 1, itemWidth - row2Width >> 1);
            DateField.setTop(list, 0, 3, row1Height, 0);
            DateField.setTop(list, 3, 1, row2Height, row1Height);
        }
        if (time) {
            DateField.setLeft(list, 4, 5, itemWidth - row3Width >> 1);
            DateField.setTop(list, 4, 5, row3Height, row1Height + row2Height);
        }
        int result = this.current;
        if (!list[result].visible) {
            result = date ? 0 : 4;
            this.setCurrent(result);
        }
        return result;
    }

    private abstract class Component {
        boolean visible;
        int left;
        int top;
        int width;
        int height;
        final int field;

        protected Component() {
            this.field = 0;
        }

        protected Component(int field) {
            this.field = field;
        }

        public abstract void paint(Graphics var1, int var2, int var3, boolean var4, boolean var5, int var6, String var7);

        public abstract int getWidth();

        public abstract int getHeight();

        public void keyboardEvent(KeyboardEvent event) {
        }

        public void pointerEvent(PointerEvent event) {
        }

        public void selectEvent() {
        }

        public boolean hasSelectCommand() {
            return false;
        }

        public boolean focusMove(int direction, boolean focused) {
            return false;
        }

        public final void writeRectangle(int[] rect) {
            rect[0] = this.left;
            rect[1] = this.top;
            rect[2] = this.width;
            rect[3] = this.height;
        }

        public final void showTimeZoneList() {
            DateField.this.showTimeZoneList();
        }

        public final void repaint() {
            DateField.this.requestPaint();
        }

        public final void setFieldValue(int value) {
            DateField.this.setFieldValue(this.field, value);
        }

        public final int getFieldValue() {
            return DateField.this.getFieldValue(this.field);
        }

        public final int getFieldValue(int field) {
            return DateField.this.getFieldValue(field);
        }
    }

    private class DaySelectComponent
    extends Component {
        private int selectedDay;
        final /* synthetic */ DateField this$0;

        public DaySelectComponent(DateField dateField) {
            DateField dateField2 = dateField;
            dateField2.getClass();
            super(0x1000FF);
            this.this$0 = dateField;
        }

        public void paint(Graphics render, int width, int height, boolean focused, boolean pressed, int day, String offset) {
            int dx = width / 7;
            int dy = height / 7;
            int daySelected = focused ? this.selectedDay : 0;
            int year = this.getFieldValue(0x20FFFF);
            int month = this.getFieldValue(1573119);
            int firstWeekDay = CalendarSystem.gregorian.computeDayOfWeek(year, month, 1);
            int numberOfDays = CalendarSystem.gregorian.computeNumberOfDays(year, month);
            String[] days = DAY_NAMES;
            Font font = FONT;
            render.setFont(font);
            render.setColor(RasterCanvas.getSystemColor((int)40));
            int x = dx >> 1;
            int i = 0;
            while (i < 7) {
                render.drawString(days[i], x, 3, 17);
                x += dx;
                ++i;
            }
            if (firstWeekDay == 0) {
                firstWeekDay = 7;
            }
            int dayCurrent = 2 - firstWeekDay;
            int y = dy;
            int i2 = 0;
            while (i2 < 6) {
                int x2 = 0;
                int j = 0;
                while (j < 7) {
                    if (dayCurrent >= 1 && dayCurrent <= numberOfDays) {
                        if (dayCurrent == daySelected) {
                            render.setColor(RasterCanvas.getSystemColor((int)(focused ? (pressed ? 37 : 39) : 36)));
                            render.drawElement(4, focused ? (pressed ? 1 : 3) : 0, 0, x2, y, dx, dy);
                            render.drawString(Integer.toString(dayCurrent), x2 + (dx >> 1) + (focused && pressed ? 1 : 0), y + (focused && pressed ? 4 : 3), 17);
                        } else {
                            if (dayCurrent == day) {
                                render.drawElement(4, 0, 0, x2, y, dx, dy);
                                render.setColor(RasterCanvas.getSystemColor((int)36));
                            } else {
                                render.setColor(RasterCanvas.getSystemColor((int)40));
                            }
                            render.drawString(Integer.toString(dayCurrent), x2 + (dx >> 1), y + 3, 17);
                        }
                    }
                    ++dayCurrent;
                    x2 += dx;
                    ++j;
                }
                y += dy;
                ++i2;
            }
        }

        public void pointerEvent(PointerEvent event) {
            int x = event.getX();
            int y = event.getY();
            int dx = this.width;
            int dy = this.height;
            if (x >= 0 && x < dx && y >= 0 && y < dy) {
                int col = x / (dx /= 7);
                int row = y / (dy /= 7);
                if (row-- > 0) {
                    int day;
                    int year = this.getFieldValue(0x20FFFF);
                    int month = this.getFieldValue(1573119);
                    int firstWeekDay = CalendarSystem.gregorian.computeDayOfWeek(year, month, 1);
                    int numberOfDays = CalendarSystem.gregorian.computeNumberOfDays(year, month);
                    if (firstWeekDay == 0) {
                        firstWeekDay = 7;
                    }
                    if ((day = 2 - firstWeekDay + row * 7 + col) < 1) {
                        this.selectedDay = 1;
                        this.repaint();
                    } else if (day > numberOfDays) {
                        this.selectedDay = numberOfDays;
                        this.repaint();
                    } else {
                        this.selectedDay = day;
                        if (event.getAction() == 11) {
                            this.setFieldValue(day);
                        } else {
                            this.repaint();
                        }
                    }
                }
            }
        }

        public void selectEvent() {
            this.setFieldValue(this.selectedDay);
        }

        public boolean hasSelectCommand() {
            return true;
        }

        public boolean focusMove(int direction, boolean focused) {
            int daySelected = this.selectedDay;
            int year = this.getFieldValue(0x20FFFF);
            int month = this.getFieldValue(1573119);
            int numberOfDays = CalendarSystem.gregorian.computeNumberOfDays(year, month);
            if (!focused) {
                switch (direction) {
                    default: {
                        this.selectedDay = 1;
                        break;
                    }
                    case 1: 
                    case 2: {
                        this.selectedDay = numberOfDays;
                    }
                }
                return true;
            }
            switch (direction) {
                default: {
                    return true;
                }
                case 2: {
                    if (--daySelected >= 1) break;
                    return false;
                }
                case 5: {
                    if (++daySelected <= numberOfDays) break;
                    return false;
                }
                case 1: {
                    if ((daySelected -= 7) >= 1) break;
                    return false;
                }
                case 6: {
                    if ((daySelected += 7) <= numberOfDays) break;
                    return false;
                }
            }
            this.selectedDay = daySelected;
            this.repaint();
            return true;
        }

        public int getWidth() {
            int result = 0;
            Font font = FONT;
            char digit = '0';
            while (digit <= '9') {
                int width = font.charWidth(digit);
                if (result < width) {
                    result = width;
                }
                digit = (char)(digit + '\u0001');
            }
            return (2 * result + 6) * 7;
        }

        public int getHeight() {
            return (FONT.getHeight() + 6) * 7;
        }
    }

    private class NumericComponent
    extends Component {
        private boolean newInput;
        protected final int minValue;
        protected final int maxValue;
        final /* synthetic */ DateField this$0;

        public NumericComponent(DateField dateField, int field, int minValue, int maxValue) {
            DateField dateField2 = dateField;
            dateField2.getClass();
            super(field);
            this.this$0 = dateField;
            this.newInput = true;
            this.minValue = minValue;
            this.maxValue = maxValue;
        }

        public void paint(Graphics render, int width, int height, boolean focused, boolean pressed, int value, String offset) {
            int x = focused && pressed ? width - 2 : width - 3;
            int y = focused && pressed ? 4 : 3;
            render.setFont(FONT);
            render.setColor(RasterCanvas.getSystemColor((int)(focused ? (pressed ? 37 : 39) : 36)));
            render.drawElement(4, focused ? (pressed ? 1 : 3) : 0, 0, 0, 0, width, height);
            render.drawString(Integer.toString(value).concat("\u2195"), x, y, 24);
        }

        public void keyboardEvent(KeyboardEvent event) {
            int digit = event.getCharCode() - 48;
            if (digit >= 0 && digit <= 9) {
                long newValue;
                long minValue = this.minValue;
                long maxValue = this.maxValue;
                if (this.newInput) {
                    this.newInput = false;
                    newValue = digit;
                    if (newValue < minValue) {
                        newValue = minValue;
                    }
                    if (newValue > maxValue) {
                        newValue = maxValue;
                    }
                } else {
                    newValue = (long)this.getFieldValue() * 10L + (long)digit;
                    if (newValue > maxValue) {
                        this.newInput = true;
                        newValue = maxValue;
                    }
                }
                this.setFieldValue((int)newValue);
            }
        }

        public void pointerEvent(PointerEvent event) {
            int h;
            int y;
            int x;
            if (event.getAction() == 11 && (x = event.getX()) >= 0 && x < this.width && (y = event.getY()) >= 0 && y < (h = this.height)) {
                if (y >= h >> 1) {
                    this.decreaseFieldValue();
                } else {
                    this.increaseFieldValue();
                }
            }
        }

        public boolean focusMove(int direction, boolean focused) {
            if (!focused) {
                this.newInput = true;
                return true;
            }
            switch (direction) {
                case 0: {
                    break;
                }
                case 1: {
                    this.newInput = true;
                    this.increaseFieldValue();
                    break;
                }
                case 6: {
                    this.newInput = true;
                    this.decreaseFieldValue();
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        }

        public int getWidth() {
            int result = 0;
            int digits = 1;
            Font font = FONT;
            int val = this.maxValue;
            while (val > 9) {
                ++digits;
                val /= 10;
            }
            char digit = '0';
            while (digit <= '9') {
                int width = font.charWidth(digit);
                if (result < width) {
                    result = width;
                }
                digit = (char)(digit + '\u0001');
            }
            return result * digits + font.charWidth('\u2195') + 6;
        }

        public int getHeight() {
            return FONT.getHeight() + 6;
        }

        public final void increaseFieldValue() {
            int curValue = this.getFieldValue();
            this.setFieldValue(curValue >= this.maxValue ? this.minValue : curValue + 1);
        }

        public final void decreaseFieldValue() {
            int curValue = this.getFieldValue();
            this.setFieldValue(curValue <= this.minValue ? this.maxValue : curValue - 1);
        }
    }

    private class StringComponent
    extends Component {
        private final Font font;
        private final String text;

        public StringComponent(String text, Font font) {
            this.font = font == null ? Font.getDefaultFont() : font;
            this.text = text == null ? "" : text;
        }

        public void paint(Graphics render, int width, int height, boolean focused, boolean pressed, int value, String offset) {
            render.setFont(this.font);
            render.setColor(RasterCanvas.getSystemColor((int)40));
            render.drawString(this.text, 0, 0, 20);
        }

        public int getWidth() {
            return this.font.stringWidth(this.text);
        }

        public int getHeight() {
            return this.font.getHeight();
        }
    }

    private class TextNumericComponent
    extends NumericComponent {
        private final String[] strings;
        final /* synthetic */ DateField this$0;

        public TextNumericComponent(DateField dateField, int field, int minValue, String[] strings) {
            DateField dateField2 = dateField;
            dateField2.getClass();
            super(dateField2, field, minValue, minValue + strings.length - 1);
            this.this$0 = dateField;
            this.strings = strings;
        }

        public void paint(Graphics render, int width, int height, boolean focused, boolean pressed, int value, String offset) {
            int x = focused && pressed ? width - 2 : width - 3;
            int y = focused && pressed ? 4 : 3;
            render.setFont(FONT);
            render.setColor(RasterCanvas.getSystemColor((int)(focused ? (pressed ? 37 : 39) : 36)));
            render.drawElement(4, focused ? (pressed ? 1 : 3) : 0, 0, 0, 0, width, height);
            render.drawString(this.strings[value - this.minValue], x, y, 24);
        }

        public int getWidth() {
            int result = 0;
            String[] strings = this.strings;
            Font font = FONT;
            int i = strings.length;
            while (i-- > 0) {
                int width = font.stringWidth(strings[i]);
                if (result >= width) continue;
                result = width;
            }
            return result + 6;
        }
    }

    private class TimeZoneComponent
    extends Component {
        public void paint(Graphics render, int width, int height, boolean focused, boolean pressed, int value, String offset) {
            int x = focused && pressed ? (width >> 1) + 1 : width >> 1;
            int y = focused && pressed ? 4 : 3;
            render.setFont(FONT);
            render.setColor(RasterCanvas.getSystemColor((int)(focused ? (pressed ? 37 : 39) : 36)));
            render.drawElement(4, focused ? (pressed ? 1 : 3) : 0, 0, 0, 0, width, height);
            render.drawString(offset, x, y, 17);
        }

        public void pointerEvent(PointerEvent event) {
            int y;
            int x;
            if (event.getAction() == 11 && (x = event.getX()) >= 0 && x < this.width && (y = event.getY()) >= 0 && y < this.height) {
                this.showTimeZoneList();
            }
        }

        public void selectEvent() {
            this.showTimeZoneList();
        }

        public boolean hasSelectCommand() {
            return true;
        }

        public boolean focusMove(int direction, boolean focused) {
            return !focused || direction == 0;
        }

        public int getWidth() {
            int result = 0;
            String[] names = OFFSET_NAMES;
            Font font = FONT;
            int i = names.length;
            while (i-- > 0) {
                int width = font.stringWidth(names[i]);
                if (result >= width) continue;
                result = width;
            }
            return result + 6;
        }

        public int getHeight() {
            return FONT.getHeight() + 6;
        }
    }
}

