/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import malik.emulator.media.graphics.SystemFont;
import malik.emulator.microedition.DeviceManager;

public final class Font {
    public static final int FONT_STATIC_TEXT = 0;
    public static final int FONT_INPUT_TEXT = 1;
    public static final int FACE_SYSTEM = 0;
    public static final int FACE_MONOSPACE = 32;
    public static final int FACE_PROPORTIONAL = 64;
    public static final int STYLE_PLAIN = 0;
    public static final int STYLE_BOLD = 1;
    public static final int STYLE_ITALIC = 2;
    public static final int STYLE_UNDERLINED = 4;
    public static final int SIZE_MEDIUM = 0;
    public static final int SIZE_SMALL = 8;
    public static final int SIZE_LARGE = 16;
    private static final Info[] fonts = new Info[72];
    private final int face;
    private final int style;
    private final int size;
    private final SystemFont systemFont;

    public static Font getDefaultFont() {
        return Font.getFont(0, 0, 0);
    }

    public static Font getFont(int fontSpecifier) {
        switch (fontSpecifier) {
            case 0: {
                return Font.getFont(0, 1, 8);
            }
            case 1: {
                return Font.getFont(0, 0, 8);
            }
        }
        throw new IllegalArgumentException("Font.getFont: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 fontSpecifier \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
    }

    public static Font getFont(int face, int style, int size) {
        int settingsSize = size >> 3 & 3;
        if (settingsSize == 3) {
            settingsSize = 0;
        }
        return Font.getFont(DeviceManager.getInstance().getSettings().getFont(style & 3, settingsSize), face, style, size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Font getFont(SystemFont systemFont, int face, int style, int size) {
        Info[] fonts;
        if (face != 0 && face != 32 && face != 64) {
            throw new IllegalArgumentException("Font.getFont: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 face \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
        }
        if (style < 0 || style > 7) {
            throw new IllegalArgumentException("Font.getFont: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 style \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
        }
        if (size != 0 && size != 8 && size != 16) {
            throw new IllegalArgumentException("Font.getFont: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 size \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
        }
        if (systemFont == null) {
            systemFont = SystemFont.getDefault();
        }
        int index = style + (size >> 3) * 8 + (face >> 5) * 24;
        Info[] infoArray = fonts = Font.fonts;
        synchronized (fonts) {
            Font result;
            block11: {
                Info last = fonts[index];
                if (last == null) {
                    result = new Font(systemFont, face, style, size);
                    fonts[index] = new Info(systemFont, result);
                } else {
                    while (true) {
                        if (last.emulatorFont == systemFont) {
                            result = last.microeditionFont;
                            break block11;
                        }
                        Info next = last.next;
                        if (next == null) break;
                        last = next;
                    }
                    result = new Font(systemFont, face, style, size);
                    last.next = new Info(systemFont, result);
                }
            }
            // ** MonitorExit[var7_6] (shouldn't be in output)
            return result;
        }
    }

    private Font(SystemFont systemFont, int face, int style, int size) {
        this.face = face;
        this.style = style;
        this.size = size;
        this.systemFont = systemFont;
    }

    public boolean isPlain() {
        return this.style == 0;
    }

    public boolean isBold() {
        return (this.style & 1) != 0;
    }

    public boolean isItalic() {
        return (this.style & 2) != 0;
    }

    public boolean isUnderlined() {
        return (this.style & 4) != 0;
    }

    public int charWidth(char character) {
        return this.systemFont.characterWidth((int)character);
    }

    public int charsWidth(char[] src, int offset, int length) {
        return this.systemFont.charactersWidth(src, offset, length);
    }

    public int stringWidth(String string) {
        return this.systemFont.stringWidth(string);
    }

    public int substringWidth(String string, int offset, int length) {
        return this.systemFont.substringWidth(string, offset, length);
    }

    public int getHeight() {
        return this.systemFont.getHeight();
    }

    public int getBaselinePosition() {
        return this.systemFont.getBaselinePosition();
    }

    public int getFace() {
        return this.face;
    }

    public int getStyle() {
        return this.style;
    }

    public int getSize() {
        return this.size;
    }

    SystemFont getSystemFont() {
        return this.systemFont;
    }

    private static final class Info {
        public final SystemFont emulatorFont;
        public final Font microeditionFont;
        public Info next;

        public Info(SystemFont emulatorFont, Font microeditionFont) {
            this.emulatorFont = emulatorFont;
            this.microeditionFont = microeditionFont;
        }
    }
}

