/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import javax.microedition.lcdui.AppearanceModeItem;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import malik.emulator.media.graphics.RasterCanvas;

public class ImageItem
extends AppearanceModeItem {
    public static final int LAYOUT_DEFAULT = 0;
    public static final int LAYOUT_LEFT = 1;
    public static final int LAYOUT_RIGHT = 2;
    public static final int LAYOUT_CENTER = 3;
    public static final int LAYOUT_NEWLINE_BEFORE = 256;
    public static final int LAYOUT_NEWLINE_AFTER = 512;
    private String altText;
    private Image image;

    public ImageItem(String label, Image image, int layout, String altText) {
        this(label, image, layout, altText, 0);
    }

    public ImageItem(String label, Image image, int layout, String altText, int appearanceMode) {
        super(label, layout, appearanceMode);
        this.altText = altText;
        this.image = image;
    }

    public void setLayout(int layout) {
        super.setLayout(layout);
    }

    public int getLayout() {
        return super.getLayout();
    }

    public void setImage(Image image) {
        this.image = image == null ? null : Image.createImage(image);
        this.requestInvalidate();
    }

    public void setAltText(String altText) {
        this.altText = altText;
    }

    public Image getImage() {
        return this.image;
    }

    public String getAltText() {
        return this.altText;
    }

    void paint(Graphics render, int contentWidth, int contentHeight) {
        int h;
        int w;
        int l;
        int t;
        Image content = this.image;
        if (content == null) {
            return;
        }
        switch (this.appearanceMode) {
            default: {
                t = 0;
                l = 0;
                w = contentWidth;
                h = contentHeight;
                break;
            }
            case 1: {
                boolean p = this.pressed;
                t = p ? 5 : 4;
                l = t;
                w = contentWidth > 8 ? contentWidth - 8 : 0;
                int n = h = contentHeight > 8 ? contentHeight - 8 : 0;
                render.setColor(RasterCanvas.getSystemColor((int)(this.focused ? (p ? 37 : 39) : 36)));
                render.drawRect(0, 0, contentWidth - 1, contentHeight - 1);
                render.drawRect(1, 1, contentWidth - 3, contentHeight - 3);
                break;
            }
            case 2: {
                boolean p = this.pressed;
                t = p ? 5 : 4;
                l = t;
                w = contentWidth > 8 ? contentWidth - 8 : 0;
                int n = h = contentHeight > 8 ? contentHeight - 8 : 0;
                render.drawElement(4, this.focused ? (p ? 1 : 3) : 0, 0, 0, 0, contentWidth, contentHeight);
            }
        }
        render.drawImage(content, l + (w - content.width >> 1), t + (h - content.height >> 1), 0);
    }

    boolean onFocusMove(int direction, int viewportWidth, int viewportHeight, int[] visibleRectangle) {
        if (!super.onFocusMove(direction, viewportWidth, viewportHeight, visibleRectangle)) {
            this.pressed = false;
            return true;
        }
        switch (direction) {
            default: {
                break;
            }
            case 2: {
                int pos1 = visibleRectangle[0];
                if (pos1 <= 0) {
                    return false;
                }
                int delta = viewportWidth >> 1;
                visibleRectangle[0] = pos1 > delta ? pos1 - delta : 0;
                break;
            }
            case 5: {
                int pos1 = visibleRectangle[0];
                int size = visibleRectangle[2];
                int pos2 = pos1 + size;
                int max = this.contentWidth;
                if (pos2 >= max) {
                    return false;
                }
                int delta = viewportWidth >> 1;
                visibleRectangle[0] = pos2 < max - delta ? pos1 + delta : max - size;
                break;
            }
            case 1: {
                int pos1 = visibleRectangle[1];
                if (pos1 <= 0) {
                    return false;
                }
                int delta = viewportHeight >> 1;
                visibleRectangle[1] = pos1 > delta ? pos1 - delta : 0;
                break;
            }
            case 6: {
                int pos1 = visibleRectangle[1];
                int size = visibleRectangle[3];
                int pos2 = pos1 + size;
                int max = this.contentHeight;
                if (pos2 >= max) {
                    return false;
                }
                int delta = viewportHeight >> 1;
                visibleRectangle[1] = pos2 < max - delta ? pos1 + delta : max - size;
            }
        }
        return true;
    }

    int getMinimumContentWidth() {
        Image content = this.image;
        return content == null ? 0 : content.width + this.sizeAppendix();
    }

    int getMinimumContentHeight() {
        Image content = this.image;
        return content == null ? 0 : content.height + this.sizeAppendix();
    }

    private int sizeAppendix() {
        switch (this.appearanceMode) {
            default: {
                return 0;
            }
            case 1: 
            case 2: 
        }
        return 8;
    }
}

