/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import javax.microedition.lcdui.Choice;
import javax.microedition.lcdui.ChoiceElement;
import javax.microedition.lcdui.ChoiceElementViewer;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CustomScrollBar;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.ScreenGraphics;
import javax.microedition.lcdui.ScrollBar;
import javax.microedition.lcdui.ScrollingScreen;
import javax.microedition.lcdui.Ticker;
import malik.emulator.application.KeyboardEvent;
import malik.emulator.application.PointerEvent;
import malik.emulator.media.graphics.RasterCanvas;
import malik.emulator.microedition.DeviceManager;
import malik.emulator.microedition.DeviceSettings;
import malik.emulator.microedition.lcdui.MultilinedStringBuilder;
import malik.emulator.microedition.lcdui.ScrollBarStyle;

public class List
extends ScrollingScreen
implements Choice {
    static final int ICON_WIDTH = 32;
    static final int ICON_HEIGHT = 32;
    private static final int MARGIN = 3;
    private static final int ELEMENT_HEIGHT = 38;
    private static final String DEFAULT_EMPTY_LABEL = "(\u043f\u0443\u0441\u0442\u043e)";
    private static final int MARGIN1;
    private static final int MARGIN2;
    private static final int MARGIN3;
    private static final int CHECKBOX_TOP;
    private static final int CHECKBOX_WIDTH;
    private static final int CHECKBOX_HEIGHT;
    private static final Command[] MULTIPLE_ACTIONS;
    private static final Command CHECK_COMMAND;
    public static final Command SELECT_COMMAND;
    private final byte type;
    private int fitPolicy;
    private int selected;
    private int checked;
    private int focused;
    private int pressed;
    private int count;
    private ChoiceElement[] elements;
    private Command selectCommand;
    private final String emptyLabel;
    private final ChoiceElementViewer monitor;

    static {
        int s = RasterCanvas.getGUIElementSize((int)15, (int)0, (int)0);
        int i = s;
        int w = i <= 0 ? 16 : (i > 32 ? 32 : (int)i);
        i = s >> 16;
        int h = i <= 0 ? 16 : (i > 32 ? 32 : i);
        MARGIN1 = 6 + w;
        MARGIN2 = 35 + MARGIN1;
        MARGIN3 = 38;
        CHECKBOX_TOP = 38 - h >> 1;
        CHECKBOX_WIDTH = w;
        CHECKBOX_HEIGHT = h;
        MULTIPLE_ACTIONS = new Command[]{new Command("\u041e\u0442\u043c\u0435\u0442\u0438\u0442\u044c \u0432\u0441\u0435", 1, Integer.MIN_VALUE), new Command("\u0421\u043d\u044f\u0442\u044c \u0432\u0441\u0435", 1, Integer.MIN_VALUE), new Command("\u041f\u0435\u0440\u0435\u043a\u043b\u044e\u0447\u0438\u0442\u044c \u0432\u0441\u0435", 1, Integer.MIN_VALUE)};
        CHECK_COMMAND = new Command("\u2713", 4, 0);
        SELECT_COMMAND = Displayable.createScreenCommand("\u0412\u044b\u0431\u0440\u0430\u0442\u044c", 4, Integer.MIN_VALUE);
    }

    public List(String title, int type) {
        this(title, null, false, null, type, null, new String[0], null);
    }

    public List(String title, int type, String[] elements, Image[] icons) {
        this(title, null, false, null, type, null, elements, icons);
    }

    public List(String title, Ticker ticker, boolean fullScreen, ScrollBarStyle style, int type, String emptyLabel, String[] elements, Image[] icons) {
        super(title, ticker, fullScreen, 0, elements == null ? 0 : 38 * elements.length, (byte)32, style);
        if (type != 3 && type != 1 && type != 2) {
            throw new IllegalArgumentException("List: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 type \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
        }
        if (elements == null) {
            throw new NullPointerException("List: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 elements \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        int count = elements.length;
        Object[] copyElements = new String[count];
        Array.copy((Object[])elements, (int)0, (Object[])copyElements, (int)0, (int)count);
        if (Array.findf((Object[])copyElements, (int)0, null) < count) {
            throw new NullPointerException("List: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 elements \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u044b, \u0440\u0430\u0432\u043d\u044b\u0435 \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (icons != null && icons.length != count) {
            throw new IllegalArgumentException("List: \u0434\u043b\u0438\u043d\u0430 \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442\u0430 icons \u043e\u0442\u043b\u0438\u0447\u0430\u0435\u0442\u0441\u044f \u043e\u0442 \u0434\u043b\u0438\u043d\u044b \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442\u0430 elements.");
        }
        ChoiceElement[] choiceElements = new ChoiceElement[Displayable.getOptimalLength(count)];
        int i = count;
        while (i-- > 0) {
            choiceElements[i] = new ChoiceElement(type == 1 && i == 0, (String)copyElements[i], icons != null ? icons[i] : null);
        }
        int len = type == 2 ? MULTIPLE_ACTIONS.length : 0;
        int i2 = 0;
        while (i2 < len) {
            super.addCommand(MULTIPLE_ACTIONS[i2]);
            ++i2;
        }
        if (count > 0) {
            super.setDefaultCommand(type == 3 ? SELECT_COMMAND : CHECK_COMMAND);
        }
        this.type = (byte)type;
        this.fitPolicy = 0;
        this.focused = -1;
        this.pressed = -1;
        this.count = count;
        this.elements = choiceElements;
        this.selectCommand = type == 3 ? SELECT_COMMAND : null;
        this.emptyLabel = emptyLabel == null ? DEFAULT_EMPTY_LABEL : emptyLabel;
        this.monitor = new ChoiceElementViewer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCommand(Command command) {
        ChoiceElementViewer choiceElementViewer = this.monitor;
        synchronized (choiceElementViewer) {
            if (this.selectCommand == command) {
                this.selectCommand = null;
            }
        }
        super.removeCommand(command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(int elementIndex, String text, Image icon) {
        if (text == null) {
            throw new NullPointerException("List.insert: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 text \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        boolean error = false;
        ChoiceElementViewer choiceElementViewer = this.monitor;
        synchronized (choiceElementViewer) {
            int len;
            if (elementIndex < 0 || elementIndex > (len = this.count)) {
                error = true;
            } else {
                byte t;
                Object[] list = this.elements;
                if (len == list.length) {
                    Object[] objectArray = list;
                    this.elements = new ChoiceElement[(len << 1) + 1];
                    list = this.elements;
                    Array.copy((Object[])objectArray, (int)0, (Object[])this.elements, (int)0, (int)len);
                }
                if (elementIndex < len) {
                    Array.copy((Object[])list, (int)elementIndex, (Object[])list, (int)(elementIndex + 1), (int)(len - elementIndex));
                }
                list[elementIndex] = new ChoiceElement((t = this.type) == 1 && len == 0, text, icon);
                this.focused = -1;
                this.pressed = -1;
                this.count = ++len;
                if (len > 1) {
                    int activeIndex;
                    if (t == 1 && (activeIndex = this.checked) >= elementIndex) {
                        this.checked = activeIndex + 1;
                    }
                    if ((activeIndex = this.selected) >= elementIndex) {
                        this.selected = activeIndex + 1;
                    }
                } else {
                    super.setDefaultCommand(t == 3 ? this.selectCommand : CHECK_COMMAND);
                }
                this.vert.setRange(38 * len);
            }
        }
        if (error) {
            throw new IndexOutOfBoundsException("List.insert: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 elementIndex \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(int elementIndex) {
        boolean error = false;
        ChoiceElementViewer choiceElementViewer = this.monitor;
        synchronized (choiceElementViewer) {
            int len;
            if (elementIndex < 0 || elementIndex > (len = this.count - 1)) {
                error = true;
            } else {
                Object[] list = this.elements;
                if (elementIndex < len) {
                    Array.copy((Object[])list, (int)(elementIndex + 1), (Object[])list, (int)elementIndex, (int)(len - elementIndex));
                }
                list[len] = null;
                this.focused = -1;
                this.pressed = -1;
                this.count = len;
                if (len > 0) {
                    int activeIndex;
                    if (this.type == 1) {
                        activeIndex = this.checked;
                        if (activeIndex == elementIndex) {
                            if (activeIndex >= len) {
                                activeIndex = len - 1;
                            }
                            ((ChoiceElement)list[activeIndex]).selected = true;
                            this.checked = activeIndex;
                        } else if (activeIndex > elementIndex) {
                            this.checked = activeIndex - 1;
                        }
                    }
                    if ((activeIndex = this.selected) == elementIndex) {
                        if (activeIndex >= len) {
                            activeIndex = len - 1;
                        }
                        this.selected = activeIndex;
                    } else if (activeIndex > elementIndex) {
                        this.selected = activeIndex - 1;
                    }
                } else {
                    super.removeCommand(this.type == 3 ? this.selectCommand : CHECK_COMMAND);
                }
                this.vert.setRange(38 * len);
            }
        }
        if (error) {
            throw new IndexOutOfBoundsException("List.delete: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 elementIndex \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAll() {
        ChoiceElementViewer choiceElementViewer = this.monitor;
        synchronized (choiceElementViewer) {
            int len = this.count;
            if (len > 0) {
                this.selected = 0;
                this.checked = 0;
                this.focused = -1;
                this.pressed = -1;
                this.count = 0;
                Array.fill((Object[])this.elements, (int)0, (int)len, null);
                super.removeCommand(this.type == 3 ? this.selectCommand : CHECK_COMMAND);
                this.vert.setRange(0);
            }
        }
    }

    public void setFitPolicy(int fitPolicy) {
        if (fitPolicy != 0 && fitPolicy != 1 && fitPolicy != 2) {
            throw new IllegalArgumentException("List.setFitPolicy: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 fitPolicy \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
        }
        this.fitPolicy = fitPolicy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectedIndex(int elementIndex, boolean selected) {
        boolean error = false;
        ChoiceElementViewer choiceElementViewer = this.monitor;
        synchronized (choiceElementViewer) {
            if (elementIndex < 0 || elementIndex >= this.count) {
                error = true;
            } else {
                ChoiceElement[] list = this.elements;
                switch (this.type) {
                    case 1: {
                        int activeIndex;
                        if (!selected || (activeIndex = this.checked) == elementIndex) break;
                        list[activeIndex].selected = false;
                        list[elementIndex].selected = true;
                        this.checked = elementIndex;
                        this.requestPaint((byte)2);
                        break;
                    }
                    case 2: {
                        ChoiceElement item = list[elementIndex];
                        if (item.selected == selected) break;
                        item.selected = selected;
                        this.requestPaint((byte)2);
                        break;
                    }
                    default: {
                        if (!selected) break;
                        this.selected = elementIndex;
                        this.correctScrollBarPosition(this.selected);
                    }
                }
            }
        }
        if (error) {
            throw new IndexOutOfBoundsException("List.setSelectedIndex: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 elementIndex \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectedFlags(boolean[] src) {
        if (src == null) {
            throw new NullPointerException("List.setSelectedFlags: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 src \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        boolean error = false;
        ChoiceElementViewer choiceElementViewer = this.monitor;
        synchronized (choiceElementViewer) {
            int len = this.count;
            if (src.length < len) {
                error = true;
            } else {
                ChoiceElement[] list = this.elements;
                switch (this.type) {
                    case 1: {
                        int activeIndex;
                        int elementIndex = Array.findf((boolean[])src, (int)0, (boolean)true);
                        if (elementIndex >= len || (activeIndex = this.checked) == elementIndex) break;
                        list[activeIndex].selected = false;
                        list[elementIndex].selected = true;
                        this.checked = elementIndex;
                        this.requestPaint((byte)2);
                        break;
                    }
                    case 2: {
                        boolean needRepaint = false;
                        int i = len;
                        while (i-- > 0) {
                            ChoiceElement item = list[i];
                            boolean selected = src[i];
                            if (item.selected == selected) continue;
                            item.selected = selected;
                            needRepaint = true;
                        }
                        if (!needRepaint) break;
                        this.requestPaint((byte)2);
                        break;
                    }
                    default: {
                        int elementIndex = Array.findf((boolean[])src, (int)0, (boolean)true);
                        if (elementIndex >= len) break;
                        this.selected = elementIndex;
                        this.correctScrollBarPosition(this.selected);
                    }
                }
            }
        }
        if (error) {
            throw new IllegalArgumentException("List.setSelectedFlags: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 src \u043a\u043e\u0440\u043e\u0447\u0435 \u0441\u043f\u0438\u0441\u043a\u0430.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFont(int elementIndex, Font font) {
        boolean error = false;
        if (font == null) {
            font = Font.getDefaultFont();
        }
        ChoiceElementViewer choiceElementViewer = this.monitor;
        synchronized (choiceElementViewer) {
            if (elementIndex < 0 || elementIndex >= this.count) {
                error = true;
            } else {
                this.elements[elementIndex].font = font;
                this.requestPaint((byte)2);
            }
        }
        if (error) {
            throw new IndexOutOfBoundsException("List.setFont: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 elementIndex \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(int elementIndex, String text, Image icon) {
        if (text == null) {
            throw new NullPointerException("List.set: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 text \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        boolean error = false;
        ChoiceElementViewer choiceElementViewer = this.monitor;
        synchronized (choiceElementViewer) {
            if (elementIndex < 0 || elementIndex >= this.count) {
                error = true;
            } else {
                ChoiceElement item = this.elements[elementIndex];
                this.elements[elementIndex].text = text;
                item.icon = icon;
                this.requestPaint((byte)2);
            }
        }
        if (error) {
            throw new IndexOutOfBoundsException("List.set: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 elementIndex \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSelected(int elementIndex) {
        boolean result;
        boolean error = false;
        ChoiceElementViewer choiceElementViewer = this.monitor;
        synchronized (choiceElementViewer) {
            if (elementIndex < 0 || elementIndex >= this.count) {
                error = true;
                result = false;
            } else {
                result = this.type != 3 ? this.elements[elementIndex].selected : elementIndex == this.selected;
            }
        }
        if (error) {
            throw new IndexOutOfBoundsException("List.isSelected: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 elementIndex \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int append(String text, Image icon) {
        int result;
        if (text == null) {
            throw new NullPointerException("List.append: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 text \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        ChoiceElementViewer choiceElementViewer = this.monitor;
        synchronized (choiceElementViewer) {
            byte t;
            int len;
            result = len = this.count;
            Object[] list = this.elements;
            if (len == this.elements.length) {
                Object[] objectArray = list;
                this.elements = new ChoiceElement[(len << 1) + 1];
                list = this.elements;
                Array.copy((Object[])objectArray, (int)0, (Object[])this.elements, (int)0, (int)len);
            }
            list[len] = new ChoiceElement((t = this.type) == 1 && len == 0, text, icon);
            this.focused = -1;
            this.pressed = -1;
            this.count = ++len;
            if (len == 1) {
                super.setDefaultCommand(t == 3 ? this.selectCommand : CHECK_COMMAND);
            }
            this.vert.setRange(38 * len);
        }
        return result;
    }

    public int size() {
        return this.count;
    }

    public int getFitPolicy() {
        return this.fitPolicy;
    }

    public int getSelectedIndex() {
        switch (this.type) {
            case 1: {
                return this.count > 0 ? this.checked : -1;
            }
            case 2: {
                return -1;
            }
        }
        return this.count > 0 ? this.selected : -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSelectedFlags(boolean[] dst) {
        int result;
        if (dst == null) {
            throw new NullPointerException("List.getSelectedFlags: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 dst \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        boolean error = false;
        ChoiceElementViewer choiceElementViewer = this.monitor;
        synchronized (choiceElementViewer) {
            int dstlen = dst.length;
            int len = this.count;
            if (dstlen < len) {
                error = true;
                result = 0;
            } else {
                Array.fill((boolean[])dst, (int)0, (int)dstlen, (boolean)false);
                ChoiceElement[] list = this.elements;
                if (this.type != 3) {
                    result = 0;
                    int i = len;
                    while (i-- > 0) {
                        dst[i] = list[i].selected;
                        if (!dst[i]) continue;
                        ++result;
                    }
                } else {
                    result = 1;
                    dst[this.selected] = true;
                }
            }
        }
        if (error) {
            throw new IllegalArgumentException("List.getSelectedFlags: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 dst \u043a\u043e\u0440\u043e\u0447\u0435 \u0441\u043f\u0438\u0441\u043a\u0430.");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Font getFont(int elementIndex) {
        Font result;
        boolean error = false;
        ChoiceElementViewer choiceElementViewer = this.monitor;
        synchronized (choiceElementViewer) {
            if (elementIndex < 0 || elementIndex >= this.count) {
                error = true;
                result = null;
            } else {
                result = this.elements[elementIndex].font;
            }
        }
        if (error) {
            throw new IndexOutOfBoundsException("List.getFont: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 elementIndex \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image getImage(int elementIndex) {
        Image result;
        boolean error = false;
        ChoiceElementViewer choiceElementViewer = this.monitor;
        synchronized (choiceElementViewer) {
            if (elementIndex < 0 || elementIndex >= this.count) {
                error = true;
                result = null;
            } else {
                result = this.elements[elementIndex].icon;
            }
        }
        if (error) {
            throw new IndexOutOfBoundsException("List.getImage: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 elementIndex \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getString(int elementIndex) {
        String result;
        boolean error = false;
        ChoiceElementViewer choiceElementViewer = this.monitor;
        synchronized (choiceElementViewer) {
            if (elementIndex < 0 || elementIndex >= this.count) {
                error = true;
                result = null;
            } else {
                result = this.elements[elementIndex].text;
            }
        }
        if (error) {
            throw new IndexOutOfBoundsException("List.getString: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 elementIndex \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectCommand(Command command) {
        if (this.type != 3) {
            return;
        }
        ChoiceElementViewer choiceElementViewer = this.monitor;
        synchronized (choiceElementViewer) {
            if (this.selectCommand != command) {
                if (this.count > 0) {
                    super.setDefaultCommand(command);
                }
                this.selectCommand = command;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void paint(ScreenGraphics render) {
        byte type = this.type;
        int width = super.getApplicationWidth();
        int top1 = render.getClipY();
        int top2 = render.getClipHeight() + top1 - 1;
        int element1 = top1 / 38;
        int element2 = top2 / 38;
        render.setColor(RasterCanvas.getSystemColor((int)40));
        ChoiceElementViewer choiceElementViewer = this.monitor;
        synchronized (choiceElementViewer) {
            int count = this.count;
            if (count <= 0) {
                Font font = Font.getFont(0, 1, 8);
                render.setFont(font);
                render.drawString(MultilinedStringBuilder.truncate(this.emptyLabel, font, width), width >> 1, 0, 17);
            } else {
                int sel = this.selected;
                ChoiceElement[] list = this.elements;
                int press = this.pressed;
                render.translate(0, 38 * element1);
                int i = element1;
                while (i <= element2 && i < count) {
                    ChoiceElement item = list[i];
                    Font font = item.font;
                    Image icon = item.icon;
                    String text = item.text;
                    boolean check = item.selected;
                    int textTop = 38 - font.getHeight() >> 1;
                    if (i == sel) {
                        render.drawElement(1, 0, 0, 0, 0, width, 38);
                    }
                    render.setFont(font);
                    if (type == 3) {
                        if (icon != null) {
                            render.drawStretch(icon, 3, 3, 32, 32, 0);
                            render.drawString(MultilinedStringBuilder.truncate(text, font, width - (MARGIN3 + 3)), MARGIN3, textTop, 0);
                        } else {
                            render.drawString(MultilinedStringBuilder.truncate(text, font, width - 6), 3, textTop, 0);
                        }
                    } else {
                        render.drawElement(type == 1 ? 12 : 15, check ? 1 : 0, i == press ? 1 : 0, 3, CHECKBOX_TOP, CHECKBOX_WIDTH, CHECKBOX_HEIGHT);
                        if (icon != null) {
                            render.drawStretch(icon, MARGIN1, 3, 32, 32, 0);
                            render.drawString(MultilinedStringBuilder.truncate(text, font, width - (MARGIN2 + 3)), MARGIN2, textTop, 0);
                        } else {
                            render.drawString(MultilinedStringBuilder.truncate(text, font, width - (MARGIN1 + 3)), MARGIN1, textTop, 0);
                        }
                    }
                    render.translate(0, 38);
                    ++i;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onCommandAction(Command command) {
        if (command == CHECK_COMMAND) {
            ChoiceElementViewer choiceElementViewer = this.monitor;
            synchronized (choiceElementViewer) {
                switch (this.type) {
                    case 1: {
                        int activeIndex = this.selected;
                        if (activeIndex < 0 || activeIndex >= this.count) break;
                        ChoiceElement[] list = this.elements;
                        this.elements[this.checked].selected = false;
                        this.checked = activeIndex;
                        list[activeIndex].selected = true;
                        this.requestPaint((byte)2);
                        break;
                    }
                    case 2: {
                        int activeIndex = this.selected;
                        if (activeIndex < 0 || activeIndex >= this.count) break;
                        ChoiceElement item = this.elements[activeIndex];
                        this.elements[activeIndex].selected = !item.selected;
                        this.requestPaint((byte)2);
                    }
                }
            }
            return;
        }
        if (command == MULTIPLE_ACTIONS[0]) {
            ChoiceElementViewer choiceElementViewer = this.monitor;
            synchronized (choiceElementViewer) {
                ChoiceElement[] list = this.elements;
                int i = this.count;
                while (i-- > 0) {
                    list[i].selected = true;
                }
                this.requestPaint((byte)2);
            }
            return;
        }
        if (command == MULTIPLE_ACTIONS[1]) {
            ChoiceElementViewer choiceElementViewer = this.monitor;
            synchronized (choiceElementViewer) {
                ChoiceElement[] list = this.elements;
                int i = this.count;
                while (i-- > 0) {
                    list[i].selected = false;
                }
                this.requestPaint((byte)2);
            }
            return;
        }
        if (command == MULTIPLE_ACTIONS[2]) {
            ChoiceElementViewer choiceElementViewer = this.monitor;
            synchronized (choiceElementViewer) {
                ChoiceElement[] list = this.elements;
                int i = this.count;
                while (i-- > 0) {
                    ChoiceElement item = list[i];
                    boolean bl = list[i].selected = !item.selected;
                }
                this.requestPaint((byte)2);
            }
            return;
        }
        super.onCommandAction(command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void onClientKeyboardEvent(KeyboardEvent event) {
        int key = event.getKey();
        int action = event.getAction();
        DeviceSettings settings = DeviceManager.getInstance().getSettings();
        if (key == settings.getKeyUsedAs(38)) {
            if (action != 6) {
                if (action != 5) return;
            }
            ChoiceElementViewer choiceElementViewer = this.monitor;
            synchronized (choiceElementViewer) {
                int len = this.count;
                if (len <= 0) return;
                this.selected = (this.selected + len - 1) % len;
                this.correctScrollBarPosition(this.selected);
                return;
            }
        }
        if (key == settings.getKeyUsedAs(36)) {
            if (action != 6) {
                if (action != 5) return;
            }
            ChoiceElementViewer choiceElementViewer = this.monitor;
            synchronized (choiceElementViewer) {
                int len = this.count;
                if (len <= 0) return;
                this.selected = (this.selected + 1) % len;
                this.correctScrollBarPosition(this.selected);
                return;
            }
        }
        if (key == settings.getKeyUsedAs(35)) {
            ChoiceElementViewer screen;
            if (action != 6) return;
            ChoiceElementViewer choiceElementViewer = screen = this.monitor;
            synchronized (screen) {
                if (this.count <= 0) return;
                ChoiceElement element = this.elements[this.selected];
                String text = element.text;
                Font font = element.font;
                // ** MonitorExit[var9_16] (shouldn't be in output)
                if (text == null) return;
                Display parent = this.getParentDisplay();
                if (parent == null) return;
                screen.getScrollBar().setPosition(0);
                screen.setFont(font);
                screen.setText(text);
                parent.setCurrent(screen);
                return;
            }
        }
        if (key != 32) return;
        block10 : switch (action) {
            case 6: {
                if (this.type == 3) return;
                this.pressed = this.selected;
                this.requestPaint((byte)2);
                return;
            }
            case 7: {
                switch (this.type) {
                    case 1: {
                        ChoiceElementViewer choiceElementViewer = this.monitor;
                        synchronized (choiceElementViewer) {
                            int activeIndex = this.pressed;
                            if (activeIndex >= 0 && activeIndex < this.count) {
                                ChoiceElement[] list = this.elements;
                                this.elements[this.checked].selected = false;
                                this.checked = activeIndex;
                                list[activeIndex].selected = true;
                            }
                        }
                        this.pressed = -1;
                        this.requestPaint((byte)2);
                        break block10;
                    }
                    case 2: {
                        ChoiceElementViewer choiceElementViewer = this.monitor;
                        synchronized (choiceElementViewer) {
                            int activeIndex = this.pressed;
                            if (activeIndex >= 0 && activeIndex < this.count) {
                                ChoiceElement item = this.elements[activeIndex];
                                this.elements[activeIndex].selected = !item.selected;
                            }
                        }
                        this.pressed = -1;
                        this.requestPaint((byte)2);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onClientPointerEvent(PointerEvent event) {
        switch (event.getAction()) {
            case 10: 
            case 14: {
                int f;
                if (event.getButton() != 0) break;
                int y = event.getY();
                this.focused = f = this.getFocusedElement(event.getX(), y);
                if (f >= 0) {
                    this.pressed = f;
                    ChoiceElementViewer choiceElementViewer = this.monitor;
                    synchronized (choiceElementViewer) {
                        int c = this.count;
                        int i = f;
                        if (i >= c) {
                            i = c - 1;
                        }
                        if (i < 0) {
                            i = 0;
                        }
                        this.selected = i;
                        this.correctScrollBarPosition(this.selected);
                        break;
                    }
                }
                if (f != -2) break;
                ChoiceElementViewer choiceElementViewer = this.monitor;
                synchronized (choiceElementViewer) {
                    int c = this.count;
                    int i = y / 38;
                    if (i >= c) {
                        i = c - 1;
                    }
                    if (i < 0) {
                        i = 0;
                    }
                    if (this.selected != i) {
                        this.selected = i;
                        this.correctScrollBarPosition(this.selected);
                    }
                    break;
                }
            }
            case 9: {
                int f = this.focused;
                if (f >= 0) {
                    this.pressed = this.getFocusedElement(event.getX(), event.getY()) == f ? f : -1;
                    if (this.pressed == this.pressed) break;
                    this.requestPaint((byte)2);
                    break;
                }
                if (f != -2) break;
                ChoiceElementViewer choiceElementViewer = this.monitor;
                synchronized (choiceElementViewer) {
                    int c = this.count;
                    int i = event.getY() / 38;
                    if (i >= c) {
                        i = c - 1;
                    }
                    if (i < 0) {
                        i = 0;
                    }
                    if (this.selected != i) {
                        this.selected = i;
                        this.correctScrollBarPosition(this.selected);
                    }
                    break;
                }
            }
            case 11: 
            case 15: {
                int f;
                if (event.getButton() != 0 || (f = this.focused) == -1) break;
                int p = this.pressed;
                this.focused = -1;
                this.pressed = -1;
                ChoiceElementViewer choiceElementViewer = this.monitor;
                synchronized (choiceElementViewer) {
                    if (f == -2) {
                        int c = this.count;
                        int i = event.getY() / 38;
                        if (i >= c) {
                            i = c - 1;
                        }
                        if (i < 0) {
                            i = 0;
                        }
                        if (this.selected != i) {
                            this.selected = i;
                            this.correctScrollBarPosition(this.selected);
                        }
                    }
                    if (p >= 0) {
                        switch (this.type) {
                            case 1: {
                                if (p >= this.count) break;
                                ChoiceElement[] list = this.elements;
                                this.elements[this.checked].selected = false;
                                this.checked = p;
                                list[p].selected = true;
                                break;
                            }
                            case 2: {
                                if (p >= this.count) break;
                                ChoiceElement item = this.elements[p];
                                this.elements[p].selected = !item.selected;
                            }
                        }
                    }
                }
                this.requestPaint((byte)2);
            }
        }
    }

    private void correctScrollBarPosition(int selected) {
        int top1 = 38 * selected;
        int top2 = 38 + top1;
        CustomScrollBar scroll = this.vert;
        int pos = scroll.getPosition();
        if (top1 < pos) {
            scroll.setPosition(top1);
        } else {
            int page = ((ScrollBar)scroll).getPage();
            if (top2 > pos + page) {
                scroll.setPosition(top2 - page);
            } else {
                this.requestPaint((byte)2);
            }
        }
    }

    private int getFocusedElement(int x, int y) {
        return x >= 0 && x < this.getApplicationWidth() && y >= 0 ? (this.type != 3 && x < MARGIN1 ? y / 38 : -2) : -1;
    }
}

