/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import javax.microedition.lcdui.VisibleElement;

public abstract class ScrollBar
extends VisibleElement {
    protected static final int VISIBILITY = 1;
    protected static final int POSITION = 2;
    protected static final int RANGE = 4;
    protected int position;
    protected int range;
    protected final Object monitor;

    protected ScrollBar() {
        this.monitor = new Object();
    }

    protected ScrollBar(boolean visibility, int range, Object monitor) {
        super(visibility);
        this.range = range;
        this.monitor = monitor == null ? new Object() : monitor;
    }

    public abstract void repaint();

    public abstract int getPage();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVisibility(boolean visibility) {
        boolean exec = false;
        Object object = this.monitor;
        synchronized (object) {
            if (this.visibility != visibility) {
                this.visibility = visibility;
                exec = true;
            }
        }
        if (exec) {
            this.notifyFieldsChanged(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scroll(int delta) {
        boolean exec = false;
        int page = this.getPage();
        Object object = this.monitor;
        synchronized (object) {
            int oldPosition = this.position;
            int newPosition = delta + oldPosition;
            int maximum = this.range - page;
            if (newPosition > maximum) {
                newPosition = maximum;
            }
            if (newPosition < 0) {
                newPosition = 0;
            }
            if (oldPosition != newPosition) {
                this.position = newPosition;
                exec = true;
            }
        }
        if (exec) {
            this.notifyFieldsChanged(2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPosition(int position) {
        boolean exec = false;
        int page = this.getPage();
        Object object = this.monitor;
        synchronized (object) {
            int oldPosition = this.position;
            int newPosition = position;
            int maximum = this.range - page;
            if (newPosition > maximum) {
                newPosition = maximum;
            }
            if (newPosition < 0) {
                newPosition = 0;
            }
            if (oldPosition != newPosition) {
                this.position = newPosition;
                exec = true;
            }
        }
        if (exec) {
            this.notifyFieldsChanged(2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRange(int range) {
        int fields = 0;
        int page = this.getPage();
        Object object = this.monitor;
        synchronized (object) {
            if (this.range != range) {
                int oldPosition = this.position;
                int newPosition = oldPosition;
                int maximum = range - page;
                if (newPosition > maximum) {
                    newPosition = maximum;
                }
                if (newPosition < 0) {
                    newPosition = 0;
                }
                if (oldPosition != newPosition) {
                    this.position = newPosition;
                    fields |= 2;
                }
                this.range = range;
                fields |= 4;
            }
        }
        if (fields != 0) {
            this.notifyFieldsChanged(fields);
        }
    }

    public int getPosition() {
        return this.position;
    }

    public int getRange() {
        return this.range;
    }

    protected void notifyFieldsChanged(int fields) {
    }
}

