/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Input;
import javax.microedition.lcdui.InteractiveItem;
import javax.microedition.lcdui.Screen;
import malik.emulator.application.KeyboardEvent;
import malik.emulator.application.PointerEvent;
import malik.emulator.media.graphics.RasterCanvas;
import malik.emulator.microedition.lcdui.CommandOwner;
import malik.emulator.microedition.lcdui.InputStringBuilder;
import malik.emulator.util.StringBuilder;

public class TextField
extends InteractiveItem
implements Input {
    private static final Font EDITOR_FONT = Font.getFont(1);
    private int scroll;
    private char[] buffer;
    private final CommandOwner box;
    private final Input alternative;
    private final InputStringBuilder builder;
    private final Object monitor;

    public TextField(String label, String inputText, int maximumLength, int constraints) {
        super(label);
        InputStringBuilder builder;
        InputStringBuilder monitor = builder = new InputStringBuilder(inputText, maximumLength, constraints);
        InputStringBuilder inputStringBuilder = builder;
        inputStringBuilder.getClass();
        InputStringBuilder.AdditionalCapabilities box = new InputStringBuilder.AdditionalCapabilities(inputStringBuilder, false, monitor){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void commandAction(Command command, Displayable screen) {
                super.commandAction(command, screen);
                Object object = this.monitor;
                synchronized (object) {
                    if (this.parentBuilder().isModified()) {
                        TextField.this.onStateChanged();
                    }
                }
            }
        };
        this.box = box;
        this.alternative = builder.newInput();
        this.builder = builder;
        this.monitor = monitor;
        Command[] commands = box.getMyOwnedCommands();
        int len = commands == null ? 0 : commands.length;
        int i = 0;
        while (i < len) {
            Command command = commands[i];
            if (command != null) {
                super.addCommand(command);
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(char[] src, int offset, int length, int position) {
        if (src == null) {
            throw new NullPointerException("TextField.insert: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 src \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        Array.checkBound((String)"TextField.insert", (int)src.length, (int)offset, (int)length);
        if (length <= 0) {
            return;
        }
        int error = 0;
        Object object = this.monitor;
        synchronized (object) {
            InputStringBuilder builder = this.builder;
            int currentLength = builder.length();
            if (length + currentLength > builder.getMaximumLength()) {
                error = 1;
            } else {
                this.alternative.insert(src, offset, length, position);
                if (currentLength == builder.length()) {
                    error = 2;
                }
            }
        }
        switch (error) {
            case 1: {
                throw new IllegalArgumentException("TextField.insert: \u043f\u043e\u043f\u044b\u0442\u043a\u0430 \u043f\u0440\u0435\u0432\u044b\u0441\u0438\u0442\u044c \u043c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u0443\u044e \u0434\u043b\u0438\u043d\u0443.");
            }
            case 2: {
                throw new IllegalArgumentException("TextField.insert: \u0442\u0435\u043a\u0441\u0442 \u043d\u0435 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u044f\u043c.");
            }
        }
        this.requestPaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(String text, int position) {
        if (text == null) {
            throw new NullPointerException("TextField.insert: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 text \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        int length = text.length();
        if (length <= 0) {
            return;
        }
        int error = 0;
        Object object = this.monitor;
        synchronized (object) {
            InputStringBuilder builder = this.builder;
            int currentLength = builder.length();
            if (length + currentLength > builder.getMaximumLength()) {
                error = 1;
            } else {
                this.alternative.insert(text, position);
                if (currentLength == builder.length()) {
                    error = 2;
                }
            }
        }
        switch (error) {
            case 1: {
                throw new IllegalArgumentException("TextField.insert: \u043f\u043e\u043f\u044b\u0442\u043a\u0430 \u043f\u0440\u0435\u0432\u044b\u0441\u0438\u0442\u044c \u043c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u0443\u044e \u0434\u043b\u0438\u043d\u0443.");
            }
            case 2: {
                throw new IllegalArgumentException("TextField.insert: \u0442\u0435\u043a\u0441\u0442 \u043d\u0435 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u044f\u043c.");
            }
        }
        this.requestPaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(int offset, int length) {
        int error = 0;
        Object object = this.monitor;
        synchronized (object) {
            InputStringBuilder builder = this.builder;
            int currentLength = builder.length();
            if (!Array.isBoundValid((int)currentLength, (int)offset, (int)length)) {
                error = 1;
            } else {
                this.alternative.delete(offset, length);
                if (length > 0 && currentLength == builder.length()) {
                    error = 2;
                }
            }
        }
        switch (error) {
            case 1: {
                throw new StringIndexOutOfBoundsException("TextField.delete: \u0438\u043d\u0434\u0435\u043a\u0441 \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
            }
            case 2: {
                throw new IllegalArgumentException("TextField.delete: \u0442\u0435\u043a\u0441\u0442 \u043d\u0435 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u044f\u043c.");
            }
        }
        this.requestPaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConstraints(int constraints) {
        if (!InputStringBuilder.isConstraintsValid(constraints)) {
            throw new IllegalArgumentException("TextField.setConstraints: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 constraints \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
        }
        Object object = this.monitor;
        synchronized (object) {
            CommandOwner box = this.box;
            Command[] commands = box.getMyOwnedCommands();
            int i = commands == null ? 0 : commands.length;
            while (i-- > 0) {
                super.removeCommand(commands[i]);
            }
            this.alternative.setConstraints(constraints);
            commands = box.getMyOwnedCommands();
            int len = commands == null ? 0 : commands.length;
            int i2 = 0;
            while (i2 < len) {
                Command command = commands[i2];
                if (command != null) {
                    super.addCommand(command);
                }
                ++i2;
            }
        }
        this.requestPaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setChars(char[] src, int offset, int length) {
        if (src != null) {
            Array.checkBound((String)"TextField.setChars", (int)src.length, (int)offset, (int)length);
            char[] cArray = src;
            int n = offset;
            src = new char[length];
            offset = 0;
            Array.copy((char[])cArray, (int)n, (char[])src, (int)0, (int)length);
        } else {
            length = 0;
            offset = 0;
        }
        int error = 0;
        Object object = this.monitor;
        synchronized (object) {
            InputStringBuilder builder = this.builder;
            if (length > builder.getMaximumLength()) {
                error = 1;
            } else if (!InputStringBuilder.isConstraintsMatch(builder.getConstraints(), src, offset, length)) {
                error = 2;
            } else {
                this.alternative.setChars(src, offset, length);
            }
        }
        switch (error) {
            case 1: {
                throw new IllegalArgumentException("TextField.setChars: \u043f\u043e\u043f\u044b\u0442\u043a\u0430 \u043f\u0440\u0435\u0432\u044b\u0441\u0438\u0442\u044c \u043c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u0443\u044e \u0434\u043b\u0438\u043d\u0443.");
            }
            case 2: {
                throw new IllegalArgumentException("TextField.setChars: \u0442\u0435\u043a\u0441\u0442 \u043d\u0435 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u044f\u043c.");
            }
        }
        this.requestPaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setString(String inputText) {
        int error = 0;
        int length = inputText == null ? 0 : inputText.length();
        Object object = this.monitor;
        synchronized (object) {
            InputStringBuilder builder = this.builder;
            if (length > builder.getMaximumLength()) {
                error = 1;
            } else if (!InputStringBuilder.isConstraintsMatch(builder.getConstraints(), inputText)) {
                error = 2;
            } else {
                this.alternative.setString(inputText);
            }
        }
        switch (error) {
            case 1: {
                throw new IllegalArgumentException("TextField.setString: \u043f\u043e\u043f\u044b\u0442\u043a\u0430 \u043f\u0440\u0435\u0432\u044b\u0441\u0438\u0442\u044c \u043c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u0443\u044e \u0434\u043b\u0438\u043d\u0443.");
            }
            case 2: {
                throw new IllegalArgumentException("TextField.setString: \u0442\u0435\u043a\u0441\u0442 \u043d\u0435 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u044f\u043c.");
            }
        }
        this.requestPaint();
    }

    public void setInitialInputMode(String characterSubset) {
        this.alternative.setInitialInputMode(characterSubset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setMaxSize(int maximumSize) {
        int result;
        if (maximumSize <= 0) {
            throw new IllegalArgumentException("TextField.setMaxSize: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 maximumSize \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u043f\u043e\u043b\u043e\u0436\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u043c.");
        }
        Object object = this.monitor;
        synchronized (object) {
            result = this.alternative.setMaxSize(maximumSize);
        }
        this.requestPaint();
        return result;
    }

    public int size() {
        return this.alternative.size();
    }

    public int getConstraints() {
        return this.alternative.getConstraints();
    }

    public int getCaretPosition() {
        return this.alternative.getCaretPosition();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getChars(char[] dst) {
        int result;
        if (dst == null) {
            throw new NullPointerException("TextField.getChars: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 dst \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        boolean error = false;
        Object object = this.monitor;
        synchronized (object) {
            if (dst.length < this.builder.length()) {
                error = true;
                result = 0;
            } else {
                result = this.alternative.getChars(dst);
            }
        }
        if (error) {
            throw new ArrayIndexOutOfBoundsException("TextField.getChars: \u0438\u043d\u0434\u0435\u043a\u0441 \u043c\u0430\u0441\u0441\u0438\u0432\u0430 \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        return result;
    }

    public int getMaxSize() {
        return this.alternative.getMaxSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getString() {
        String result;
        Object object = this.monitor;
        synchronized (object) {
            result = this.alternative.getString();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void paint(Graphics render, int contentWidth, int contentHeight) {
        Object object = this.monitor;
        synchronized (object) {
            Font font = EDITOR_FONT;
            InputStringBuilder builder = this.builder;
            boolean f = this.focused;
            boolean r = (builder.getConstraints() & 0x20000) != 0;
            int bpos = builder.getCaretPosition();
            int blen = builder.length();
            char[] lbuf = this.buffer;
            if (this.buffer == null || lbuf.length < blen) {
                lbuf = this.buffer = new char[StringBuilder.optimalCapacity((int)(blen - 1)) + 1];
            }
            builder.copy(0, blen, lbuf, 0);
            int bwid = font.charsWidth(lbuf, 0, bpos);
            int bscr = this.scroll;
            if (bwid < bscr || bwid >= bscr + contentWidth - 8) {
                int nscr = bwid - (contentWidth - 8 >> 1);
                bscr = nscr < 0 ? 0 : nscr;
                this.scroll = bscr;
            }
            render.setFont(font);
            render.setColor(RasterCanvas.getSystemColor((int)(f ? (r ? 35 : 33) : 32)));
            render.drawElement(8, f ? (r ? 3 : 1) : 0, 0, 0, 0, contentWidth, contentHeight);
            render.clipRect(3, 2, contentWidth - 6, contentHeight - 4);
            render.drawChars(lbuf, 0, blen, 4 - bscr, 2, 0);
            if (f) {
                bscr = bwid - bscr + 3;
                render.drawLine(bscr, 2, bscr, font.getHeight() + 1);
            }
        }
    }

    void onCommandAction(Command command) {
        Screen owner;
        CommandOwner box = this.box;
        if (box.isMyOwnedCommand(command) && (owner = this.owner) != null) {
            box.commandAction(command, owner);
            return;
        }
        super.onCommandAction(command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onKeyboardEvent(KeyboardEvent event) {
        Object object = this.monitor;
        synchronized (object) {
            InputStringBuilder builder = this.builder;
            builder.keyboardEvent(event);
            if (builder.isModified()) {
                this.onStateChanged();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onPointerEvent(PointerEvent event) {
        int action = event.getAction();
        if (event.isButtonPressed(0) || (action == 15 || action == 11) && event.getButton() == 0) {
            Object object = this.monitor;
            synchronized (object) {
                this.moveCaret(this.builder, this.scroll + event.getX() - 4);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean onFocusMove(int direction, int viewportWidth, int viewportHeight, int[] visibleRectangle) {
        if (!super.onFocusMove(direction, viewportWidth, viewportHeight, visibleRectangle)) {
            switch (direction) {
                case 5: {
                    Object object = this.monitor;
                    synchronized (object) {
                        this.builder.setCaretPosition(0);
                        break;
                    }
                }
                case 2: {
                    Object object = this.monitor;
                    synchronized (object) {
                        InputStringBuilder builder = this.builder;
                        builder.setCaretPosition(builder.length());
                        break;
                    }
                }
            }
            this.requestPaint();
            return true;
        }
        switch (direction) {
            case 0: {
                return true;
            }
            case 1: 
            case 6: {
                return false;
            }
            case 5: {
                boolean result;
                Object object = this.monitor;
                synchronized (object) {
                    InputStringBuilder builder = this.builder;
                    int position = builder.getCaretPosition();
                    result = position < builder.length();
                    if (result) {
                        builder.setCaretPosition(position + 1);
                    }
                }
                if (result) break;
                return false;
            }
            case 2: {
                boolean result;
                Object object = this.monitor;
                synchronized (object) {
                    InputStringBuilder builder = this.builder;
                    int position = builder.getCaretPosition();
                    result = position > 0;
                    if (result) {
                        builder.setCaretPosition(position - 1);
                    }
                }
                if (result) break;
                return false;
            }
        }
        this.requestPaint();
        return true;
    }

    int getMinimumContentWidth() {
        return 100;
    }

    int getMinimumContentHeight() {
        return EDITOR_FONT.getHeight() + 4;
    }

    final void onStateChanged() {
        super.notifyStateChanged();
        super.requestPaint();
    }

    private void moveCaret(InputStringBuilder builder, int charsWidth) {
        int caretCol;
        block5: {
            int blen = builder.length();
            Font font = EDITOR_FONT;
            if (charsWidth < 0) {
                charsWidth = 0;
            }
            char[] lbuf = this.buffer;
            if (this.buffer == null || lbuf.length < blen) {
                lbuf = this.buffer = new char[StringBuilder.optimalCapacity((int)(blen - 1)) + 1];
            }
            builder.copy(0, blen, lbuf, 0);
            int w1 = 0;
            int i = 1;
            while (i <= blen) {
                int w2 = font.charsWidth(lbuf, 0, i);
                if (charsWidth >= w1 && charsWidth < w2) {
                    caretCol = charsWidth - w1 <= w2 - charsWidth ? i - 1 : i;
                    break block5;
                }
                w1 = w2;
                ++i;
            }
            caretCol = blen;
        }
        builder.setCaretPosition(caretCol);
        if (builder.isModified()) {
            this.requestPaint();
        }
    }
}

